<?php
/*

PPP SlideShow

Shared between plugin and PhotoPressPro Platinum3

*/ 

global $pppsss_version;
$pppsss_version = "0.1";
if (get_option('ppp_slideshow_version')  != $pppsss_version) {
    update_option('ppp_slideshow_version', $pppsss_version);}

/* Set the default slideshow width to the theme's content width. */
$pppsss_width_default = '960';

/* Defaults. Dey are de bomb. */
global $ss_options_defaults;
$ss_options_defaults = Array(
    'ppp_slideshow_size' => 'full',
    'ppp_slideshow_transition' => 'fade',
    'ppp_slideshow_transition_speed' => '.5',
    'ppp_slideshow_show_titles' => 'true',
    'ppp_slideshow_show_captions' => 'true',
    'ppp_slideshow_show_descriptions' => 'true',
    'ppp_slideshow_show_thumbs' => 'true',
    'ppp_slideshow_show_thumbs_hp' => 'true',
    'ppp_slideshow_nav_position' => 'bottom',
    'ppp_slideshow_timeout' => '3',
    'ppp_slideshow_width' => $pppsss_width_default,
    'ppp_slideshow_height' => '480',
    'ppp_slideshow_thumb_width' => '100',
    'ppp_slideshow_thumb_height' => '100',
    'ppp_slideshow_thumb_position' => 'below',
    'ppp_slideshow_thumb_fade' => 'true',
    'ppp_slideshow_nav_fade' => 'true',
    'ppp_slideshow_txt_fade' => 'true',
    'ppp_slideshow_nav_skin' => 'mnml'
);
add_option("ppp_slideshow_options", $ss_options_defaults); 

/* Get the current options. */
global $pppsss_size; 
global $pppsss_trans; 
global $pppsss_speed; 
global $pppsss_titles;
global $pppsss_captions;
global $pppsss_descriptions;
global $pppsss_thumbs;
global $pppsss_thumbs_hp;
global $pppsss_navpos;
global $pppsss_timeout;
global $pppsss_width;
global $pppsss_height;
global $pppsss_thumb_width;
global $pppsss_thumb_height;
global $pppsss_thumb_position;
global $pppsss_thumb_fade;
global $pppsss_nav_fade;
global $pppsss_txt_fade;
global $pppsss_nav_skin;

/* 
Get the global slideshow options from the passed-in option set.
*/
function ppp_slideshow_get_options($ppp_slideshow_options) {

global $pppsss_trans, $pppsss_speed, $pppsss_size, $pppsss_titles, $pppsss_captions, $pppsss_descriptions, $pppsss_thumbs, $pppsss_navpos, $pppsss_timeout, $pppsss_thumbs_hp, $pppsss_height, $pppsss_width, $pppsss_thumb_height, $pppsss_thumb_width, $pppsss_thumb_position, $pppsss_thumb_fade, $pppsss_nav_fade, $pppsss_txt_fade, $pppsss_nav_skin;

if (!isset($ppp_slideshow_options['ppp_slideshow_size'])) {
	global $ss_options_defaults;
	$ppp_slideshow_options = $ss_options_defaults;
}

$pppsss_size = $ppp_slideshow_options['ppp_slideshow_size']; 
$pppsss_trans = $ppp_slideshow_options['ppp_slideshow_transition']; 
$pppsss_speed = $ppp_slideshow_options['ppp_slideshow_transition_speed']; 
$pppsss_titles = $ppp_slideshow_options['ppp_slideshow_show_titles'];
$pppsss_captions = $ppp_slideshow_options['ppp_slideshow_show_captions'];
$pppsss_descriptions = $ppp_slideshow_options['ppp_slideshow_show_descriptions'];
$pppsss_thumbs = $ppp_slideshow_options['ppp_slideshow_show_thumbs'];
$pppsss_thumbs_hp = $ppp_slideshow_options['ppp_slideshow_show_thumbs_hp'];
$pppsss_navpos = $ppp_slideshow_options['ppp_slideshow_nav_position'];
$pppsss_timeout = $ppp_slideshow_options['ppp_slideshow_timeout'];
$pppsss_width = $ppp_slideshow_options['ppp_slideshow_width'];
$pppsss_height = $ppp_slideshow_options['ppp_slideshow_height'];
$pppsss_thumb_width = $ppp_slideshow_options['ppp_slideshow_thumb_width'];
$pppsss_thumb_height = $ppp_slideshow_options['ppp_slideshow_thumb_height'];
$pppsss_thumb_position = $ppp_slideshow_options['ppp_slideshow_thumb_position'];
$pppsss_thumb_fade = $ppp_slideshow_options['ppp_slideshow_thumb_fade'];
$pppsss_nav_fade = $ppp_slideshow_options['ppp_slideshow_nav_fade'];
$pppsss_txt_fade = $ppp_slideshow_options['ppp_slideshow_txt_fade'];
$pppsss_nav_skin = $ppp_slideshow_options['ppp_slideshow_nav_skin'];


/* Replace 'random' with list of allowed effects. */
if ($pppsss_trans == 'random') $pppsss_trans = pppsss_trans_random();
}

ppp_slideshow_get_options(get_option('ppp_slideshow_options'));

function pppsss_trans_random() {
	return 'fade,scrollLeft,scrollRight,scrollUp,scrollDown,toss,cover,slideX,turnUp,slideY,wipe,uncover,turnRight,blindX,blindY,blindZ,turnDown,curtainX,curtainY,growX,growY';
}

/* WordPress Mechanics */

/*
Enqueue jQuery and the Cycle plugin.
*/
add_action('init', 'ppp_slideshow_init');
function ppp_slideshow_init() {
  global $ppp_slideshow_url;
  global $ppp_slideshow_dir;

  if (!is_admin()) {
	wp_enqueue_script('jquery');

	//load the cycle and slideshow scripts
	$url = $ppp_slideshow_url . '/js/jquery.cycle.all.min.js';
	wp_register_script('cycle', $url, false, '2.7.3', true); 
	wp_enqueue_script('cycle');

	$url = $ppp_slideshow_url . '/js/slideshow.js';
	wp_register_script('pppSlideshowJs', $url, false, '0.1', true); 
	wp_enqueue_script('pppSlideshowJs');

  } else {
	//load the admin script
	$url = $ppp_slideshow_url . '/js/admin.js';
	wp_register_script('ppp-slideshow-admin', $url, false, '0.1', true); 
	wp_enqueue_script('ppp-slideshow-admin');
  }
}    

/*
Enqueue CSS styles.
*/
add_action('wp_print_styles', 'ppp_slideshow_wp_print_styles');
function ppp_slideshow_wp_print_styles() {
	global $ppp_slideshow_url;
	global $ppp_slideshow_dir;

	$myStyleUrl = $ppp_slideshow_url . '/style.css';
	$myStyleFile = $ppp_slideshow_dir . '/style.css';
	if ( file_exists($myStyleFile) ) {
		wp_register_style('pppSlideshowCss', $myStyleUrl);
		wp_enqueue_style('pppSlideshowCss');
	}

	/* Skin CSS */
	global $pppsss_nav_skin;
	if (!isset($pppsss_nav_skin)) {
		$pppsss_nav_skin = 'mnml';
	}
	$skinUrl = $ppp_slideshow_url . '/skins/'.$pppsss_nav_skin.'/'.$pppsss_nav_skin.'.css';
	$skinFile = $ppp_slideshow_dir . '/skins/'.$pppsss_nav_skin.'/'.$pppsss_nav_skin.'.css';
	if ( file_exists($skinFile) ) {
		wp_register_style('pppSlideshowSkinCss', $skinUrl);
		wp_enqueue_style('pppSlideshowSkinCss');
	}
}

/* Display the attachment ID on the Media Library page on hover. */
function display_attachment_id($content) { 
   $showlink = "Attachment ID:" . get_the_ID($post->ID, true);
    $content[] = $showlink;
    return $content;
}
add_filter ( 'media_row_actions', 'display_attachment_id');


/* Whip up a shortcode. Mmm, strawberry shortcode. */
add_shortcode('ppp_slideshow', 'ppp_slideshow_shortcode');

/* Consume said shortcode. Mmm. */
function ppp_slideshow_shortcode($atts) {

	$postid = get_the_ID();

	global $pppsss_trans, $pppsss_speed, $pppsss_size, $pppsss_titles, $pppsss_captions, $pppsss_descriptions, $pppsss_thumbs, $pppsss_navpos, $pppsss_timeout, $pppsss_thumbs_hp, $pppsss_height, $pppsss_width, $pppsss_thumb_height, $pppsss_thumb_width, $pppsss_thumb_position, $pppsss_thumb_fade, $pppsss_nav_fade, $pppsss_txt_fade, $pppsss_nav_skin;


	/* Get the attributes */
	extract(shortcode_atts(array(
		'size' => $pppsss_size,
		'timeout' => $pppsss_timeout,
		'thumbs' => $pppsss_thumbs,
		'nav' => $pppsss_navpos,
		'w' => $pppsss_width,
		'h' => $pppsss_height,
		'exclude' => '',
		'include' => ''
	), $atts));

	if ( !empty($include) ) {
		$include = preg_replace( '/[^0-9,]+/', '', $include );
		$attachments = get_posts( array('order'          => 'ASC',
		'orderby' 		 => 'menu_order ID',
		'post_type'      => 'attachment',
		'post_parent'    => get_the_ID(),
		'post_mime_type' => 'image',
		'post_status'    => null,
		'numberposts'    => -1,
		'size'			 => $size,
		'include'		 => $include) );
		
	} elseif ( !empty($exclude) ) {
		$exclude = preg_replace( '/[^0-9,]+/', '', $exclude );
		$attachments = get_posts( array('order'          => 'ASC',
		'orderby' 		 => 'menu_order ID',
		'post_type'      => 'attachment',
		'post_parent'    => get_the_ID(),
		'post_mime_type' => 'image',
		'post_status'    => null,
		'numberposts'    => -1,
		'size'			 => $size,
		'exclude'		 => $exclude) );
	} else {
		$attachments = get_posts( array('order'          => 'ASC',
		'orderby' 		 => 'menu_order ID',
		'post_type'      => 'attachment',
		'post_parent'    => get_the_ID(),
		'post_mime_type' => 'image',
		'post_status'    => null,
		'numberposts'    => -1,
		'size'			 => $size) );
	}

	if ( empty($attachments) )
		return '';

	/* 
	Navigational Math
	*/

	/* If thumbs have borders, account for them. */
	$pppsss_thumb_border_width = 0;
	$pppsss_border_width = 0;
	if (function_exists('ppp_get_option')) {
		if (ppp_get_option("border_slideshow_thumbs_size") != "") {
		if (ppp_get_option("border_slideshow_thumbs_style") != "") {
		if (ppp_get_option("border_slideshow_thumbs_color") != "") {
			$pppsss_thumb_border_width = ppp_get_option("border_slideshow_thumbs_size");
		}
		}
		}

		if (ppp_get_option("border_slideshow_size") != "") {
		if (ppp_get_option("border_slideshow_style") != "") {
		if (ppp_get_option("border_slideshow_color") != "") {
			$pppsss_border_width = ppp_get_option("border_slideshow_size");
		}
		}
		}
	}

	/* Heres whar tha fancy calcalashuns go. */

	/* Set the max slideshow width to the theme's content width. */
	global $content_width;
	if (isset($content_width)){
		if ($content_width > $pppsss_width_default) {
			$pppsss_width_default = $content_width;
		}
	}

	if ($w > $pppsss_width_default) $w = $pppsss_width_default;

	$ss_width = $w - ($pppsss_border_width * 2);
	$padding = 14;
	$thumb_width_inner = $pppsss_thumb_width + ($pppsss_thumb_border_width * 2);
	$thumb_width = ($thumb_width_inner + ($padding * 2));
	$thumbs_room = ($ss_width / $thumb_width);
	$thumbs_num = intval($thumbs_room);
	$thumbs_width = $thumbs_num * $thumb_width;
	while ($thumbs_width > $ss_width) {
		$thumbs_num--;
		$thumbs_width = $thumbs_num * $thumb_width;
	}
	$thumb_pages = 0;
	if ($thumbs_num > 0) {
	  /* Get the integer value for a base. If the real value is greater, there is a remainder so add a page. */
	  $thumb_pages = intval((count($attachments) / $thumbs_num));
	  if ((count($attachments) / $thumbs_num) > $thumb_pages) {
		  $thumb_pages++;
	  }
	}

	$thumb_h_plus = 34;
	echo '

	<style type="text/css">
	div#slideshow-thumbs'.$postid.' img {
	height: '.$pppsss_thumb_height.'px;
	width: auto;
	}

	#slides'.$postid.' a {
	width: '.$pppsss_thumb_width.'px;
	height: '.$pppsss_thumb_height.'px;
	overflow:hidden;
	display:block;
	}

	div#slideshow-thumbs-bg'.$postid.', div#slideshow-thumbs-wrapper'.$postid.', div#slideshow-thumbs-wrap'.$postid.', div#slideshow-thumbs'.$postid.',
	div#slideshow-thumbs-prev'.$postid.', div#slideshow-thumbs-next'.$postid.', div#slideshow-thumbs-prev'.$postid.' a, div#slideshow-thumbs-next'.$postid.' a {
	height:'.($pppsss_thumb_height+$thumb_h_plus).'px;
	}

	div#ppp-slideshow'.$postid.' {height:'.$h.'px;}
	div#slideshow-nav'.$postid.' a, div#slideshow-nav'.$postid.' a span, span#slideshow-pause-play'.$postid.' {height:'.($h-($pppsss_thumb_height+$thumb_h_plus)).'px;}
	'; 
/*
Center the navigation
*/
	$play_pause_w = 68;
	if ($pppsss_nav_skin == "none") {
		$play_pause_w = ($ss_width - 100);
	}
	
	$nav_width = (($ss_width-$play_pause_w)/2);

	echo '
	div#slideshow-nav'.$postid.' a.slideshow-prev, div#slideshow-nav'.$postid.' a.slideshow-next {width:'.$nav_width.'px;}
	span#slideshow-pause-play'.$postid.', div#slideshow-nav'.$postid.' a.pause, div#slideshow-nav'.$postid.' a.play {width:'.$play_pause_w.'px;}

	div#ppp-slideshow'.$postid.', div#slideshow-wrap'.$postid.', div#slideshow-thumbs-bg'.$postid.', div#slideshow-next'.$postid.' {width:'.$ss_width.'px;}
	div#slideshow-navigator'.$postid.' {width:'.($ss_width-56).'px;}

	.contenttext div#ppp-slideshow'.$postid.' img {
	  margin: 0 auto;
	  max-height: '.$h.'px;
	  width: auto;
	}
	.contenttext div#ppp-slideshow'.$postid.' img, div#ppp-slideshow'.$postid.' .wp-caption {
	  max-width:'.$ss_width.'px;
	}
	.contenttext div#ppp-slideshow'.$postid.' .slideshow-attachment-inner {
	  margin: 0 auto;
	  height: '.$h.'px;
	  width: '.$ss_width.'px;
	}
	
	';
    if ($pppsss_thumb_position == 'below') {
		echo '
		div#slideshow-wrap'.$postid.' {height:auto;}
		div#slideshow-thumbs-div'.$postid.' {
			height:'.($pppsss_thumb_height+$thumb_h_plus).'px;
		}
		div#slideshow-nav'.$postid.' a, div#slideshow-nav'.$postid.' a span, span#slideshow-pause-play'.$postid.' {height:'.$h.'px;}
		';
	}
	/* Reset slideshow height via NOSCRIPT so non-js clients get the full business */
	echo '
	</style>

	<noscript>
	<style type="text/css">
	div#ppp-slideshow'.$postid.', .contenttext div#ppp-slideshow'.$postid.' .slideshow-attachment-inner {height:auto;}
	.contenttext div#ppp-slideshow'.$postid.' img {max-height: none;}
	</style>
	</noscript>

';

	/* Start the jQuery cycle */
	echo '
<script type="text/javascript"> 
<!--
	jQuery(document).ready(function($) {
	$(window).load(function() {

		// Fade in/out the text, nav, and thumbs
		var fade_thumb = "'.$pppsss_thumb_fade.'";
		var fade_nav = "'.$pppsss_nav_fade.'";
		var fade_txt = "'.$pppsss_txt_fade.'";
		';

		if ($pppsss_thumb_position == 'below') {
			echo 'var thumbBgOpacity = 1;
			fade_thumb = "false";
			';
		} else {
			echo 'var thumbBgOpacity = \'0.5\';';
		}

		echo '
		var navOpacity = \'0.8\';

		function showThumbs() {
			$(\'div#slideshow-thumbs-bg'.$postid.'\').stop().fadeTo(400, thumbBgOpacity);
			$(\'div#slideshow-thumbs-wrapper'.$postid.'\').stop().fadeTo(400, 1);
		}
		function hideThumbs() {
		  if (fade_thumb == "true") {
			$(\'div#slideshow-thumbs-bg'.$postid.'\').stop().fadeTo(400, 0);
			$(\'div#slideshow-thumbs-wrapper'.$postid.'\').stop().fadeTo(400, 0);
		  }
		}

		function showNav() {
			$(\'div#slideshow-nav'.$postid.'\').stop().fadeTo(400, navOpacity);
		}
		function hideNav() {
		  if (fade_nav == "true") {
			$(\'div#slideshow-nav'.$postid.'\').stop().fadeTo(400, 0);
		  }
		}

		function showText() {
			$(\'div#ppp-slideshow-text'.$postid.'\').stop().fadeTo(400, \'0.5\');
		}
		function hideText() {
		  if (fade_txt == "true") {
			$(\'div#ppp-slideshow-text'.$postid.'\').stop().fadeTo(400, 0);
		  }
		}

		$(\'div.slideshow-thumbs-bg\').css(\'opacity\', thumbBgOpacity);
		$(\'div.ppp-slideshow-text\').css(\'opacity\', \'0.5\');

		$(\'div.ppp-slideshow-text\').fadeIn();
	';
	
	if ((is_page() || is_single() || $pppsss_thumbs_hp == "true") && ($thumbs=="true")) {
		echo '
		showThumbs();
		';
	} else {
		echo '
		hideThumbs();
		showNav();
		';
	}

	echo '
		showNav();
		$(\'div.ppp-slideshow\').fadeIn();
		$(\'div.slideshow-thumbs\').fadeIn();

		// Get the image index from the url hash
		$(function() {
			var index = pppGetStartingSlide();
			// Move the thumbs starting page if not on the first page.
			if ((index >= '.$thumbs_num.') && ('.count($attachments).' > '.$thumbs_num.')) {
				pppThumbsSetPage(index);
			}
		';

	$pppsss_speed_ms = ($pppsss_speed * 1000);
	$timeout_ms = ($timeout * 1000);
	echo '
		// Start the cycle on the slideshow div on this postid
		$(\'#ppp-slideshow'.$postid.'\').cycle({
				fx: \''. $pppsss_trans . '\',
				speed: '. $pppsss_speed_ms . ',
				timeout: '. $timeout_ms . ',
				next: \'.slideshow-nav'.$postid.' a.slideshow-next\',
				startingSlide: index,
				prev: \'.slideshow-nav'.$postid.' a.slideshow-prev\',
				before:    onBefore,
				after:     onAfter,
				pager:  \'#slides'.$postid.'\',
				manualTrump: false,
				sync:1,
				pagerAnchorBuilder: function(idx, slide) {
				// return sel string for existing anchor
				return \'#slides'.$postid.'  li:eq(\' + (idx) + \') a\'; }
		});


		// Hover effects
		$(\'div#ppp-slideshow'.$postid.',div#slideshow-nav'.$postid.',div#slideshow-thumbs-wrapper'.$postid.'\').hover(function() {
			showText();
			showNav();
			showThumbs();
		}, function() {
			hideText();
			hideNav();
			hideThumbs();
		});


		// Enable Pause/Play
		$(\'div#slideshow-nav'.$postid. ' a.pause\').click(function() { 
			$(\'#ppp-slideshow'.$postid.'\').cycle(\'pause\');
			$(\'div#slideshow-nav'.$postid. ' a.pause\').hide().stop();
			$(\'div#slideshow-nav'.$postid. ' a.play\').show().stop();
		});
		$(\'div#slideshow-nav'.$postid. ' a.play\').click(function() { 
			$(\'#ppp-slideshow'.$postid.'\').cycle(\'resume\');
			$(\'div#slideshow-nav'.$postid. ' a.play\').hide().stop();
			$(\'div#slideshow-nav'.$postid. ' a.pause\').show().stop();
		});


		// Whip up a carousel for the thumbnail navigation
		function pppThumbsFirst() {
			if ($(\'#slideshow-thumbs'.$postid.'\').css(\'margin-left\') != \'0px\') {
				$(\'#slideshow-thumbs'.$postid.'\').stop().animate({\'margin-left\':\'0px\'}, {duration:'. $pppsss_speed_ms . '});
			}
		}
		function pppThumbsPrev() {
			if ($(\'#slideshow-thumbs'.$postid.'\').css(\'margin-left\') != \'0px\') {

				// Figure out the reverse margin
				var offset = ('.$thumbs_width.' + parseInt($(\'#slideshow-thumbs'.$postid.'\').css(\'margin-left\')));
				offset += \'px\';

				$(\'#slideshow-thumbs'.$postid.'\').stop().animate({\'margin-left\':offset}, {duration:'. $pppsss_speed_ms . '});  
			} else {
				pppThumbsLast('.(count($attachments)-1).');
			}
		}
		function pppThumbsNext() {
			var mgnLeft = parseInt($(\'#slideshow-thumbs'.$postid.'\').css(\'margin-left\'));
			var page = (((mgnLeft * -1) / '.$thumbs_width.') + 1);
			if (page == '.$thumb_pages.') {
				pppThumbsFirst();
			} else {
				mgnLeft -= '.$thumbs_width.';
				$(\'#slideshow-thumbs'.$postid.'\').stop().animate({\'margin-left\':mgnLeft}, {duration:'. $pppsss_speed_ms . '});
			}
		}
		function pppThumbsLast(lastSlide) {
			var page = parseInt(lastSlide / '.$thumbs_num.');
			var offset = ((page * '.$thumbs_width.') * -1);
			$(\'#slideshow-thumbs'.$postid.'\').stop().animate({\'margin-left\':offset}, {duration:'. $pppsss_speed_ms . '});
		}
		function pppThumbsGetPage(lastSlide) {
			var page = parseInt(lastSlide / '.$thumbs_num.');
			var offset = ((page * '.$thumbs_width.') * -1);
			return offset;
		}
		function pppThumbsSetPage(lastSlide) {
			var offset = pppThumbsGetPage(lastSlide);
			$(\'#slideshow-thumbs'.$postid.'\').css(\'margin-left\', offset);
		}
		$(\'#slideshow-thumbs-prev'.$postid.' a\').click(function() { 
			pppThumbsPrev();
		});
		$(\'#slideshow-thumbs-next'.$postid.' a\').click(function() { 
			pppThumbsNext();
		});


		// Cycle plugin function callbacks
		// ===============================
		// jQuery cycle before callback

		var slideCounter = 0;

		function onBefore(curr,next,opts) {

			/* If this is the initialization run, slideCounter will be null. Update the text and skedaddle. */
			if (slideCounter == null) {
				// Update the slideshow text with the text we tucked away
				$(\'div#ppp-slideshow-text'.$postid.' div\').html($(\'div#ppp-slideshow-text'.$postid.'\'+opts.currSlide).html()).hide().fadeIn('. $pppsss_speed_ms . ');
				return;
			}

			/* Update the slideshow text with the text we tucked away. */
			$(\'div#ppp-slideshow-text'.$postid.' div\').html($(\'div#ppp-slideshow-text'.$postid.'\'+opts.nextSlide).html()).hide().fadeIn('. $pppsss_speed_ms . ');

			/* Update the thumbs for the next slide, if necessary. */

			// WRAP: nextSlide is 0 only when wrapping from the last thumbnail
			// REVERSE WRAP: When nextSlide is equal to the slideCount, and the currSlide = 0, page to the last page.
			// NEXT PAGE: When nextSlide is a multiple of $thumbs_num, and the nextSlide > currSlide, page forward.
			// PREV PAGE: When currSlide is a multiple of $thumbs_num, and the nextSlide < currSlide, page backward.
			if ((opts.currSlide == 0) || 
				(parseInt(opts.nextSlide) % '.$thumbs_num.' == 0) ||
				(parseInt(opts.currSlide) % '.$thumbs_num.' == 0)) {
				pppThumbsLast(opts.nextSlide);
			}
		}

		// jQuery cycle onafter callback
		function onAfter(curr,next,opts) {
		';
	/* Update the url hash for pages and posts */
	if (is_page() || is_single()) {
		echo 'window.location.hash = \'img-\' + (opts.currSlide + 1);
		';
	}
	echo 'var caption = (opts.currSlide + 1) + \' of \' + opts.slideCount;
		$(\'#slideshow-info'.$postid.'\').html(caption);
	} }); }); });
-->
	</script>
	'; 

	$slideshow = '<div id="slideshow-wrap'.$postid.'" class="slideshow-wrap">';

	$slideshow .= '<div id="ppp-slideshow'.$postid.'" class="ppp-slideshow">';
	$i=1;

	$slideshow_txt = '';
	if ($attachments) {
		foreach ($attachments as $attachment) {
		if ($i == "1") {
			$slideshow .= "<div class=\"slideshow-attachment-post".$postid." slideshow-attachment-post slideshow-attachment".$attachment->ID." slideshow-attachment first\">";} else {
			$slideshow .= "<div class=\"slideshow-attachment-post".$postid." slideshow-attachment-post slideshow-attachment".$attachment->ID." slideshow-attachment \">";}
			$slideshow .= "<div class=\"slideshow-attachment-inner".$postid." slideshow-attachment-inner \">";

			$slideshow .= '<a href="'.get_attachment_link($attachment->ID).'" class="slideshow-image">';
			$slideshow .= wp_get_attachment_image($attachment->ID, $size, false, false);
			$slideshow .= "</a>";

			$slideshow .= "</div></div>";

			$slideshow_txt .= "<div class=\"ppp-slideshow-text-hidden\" id=\"ppp-slideshow-text".$postid.($i-1)."\">";
			if ($pppsss_titles=="true") {
			$title = $attachment->post_title;
			if (isset($title) && $title != '') { 
				$slideshow_txt .= '<div class="slideshow-title slideshow-text-inner">'.$title.'</div>'; 
			}}

			if ($pppsss_captions=="true") {			
			$caption = $attachment->post_excerpt;
			if (isset($caption) && $caption != '') { 
				$slideshow_txt .= '<div class="slideshow-caption slideshow-text-inner">'.$caption.'</div>'; 
			}}
			
			if ($pppsss_descriptions=="true") {			
			$description = $attachment->post_content;
			if (isset($description) && $description != '') { 
				$slideshow_txt .= '<div class="slideshow-description slideshow-text-inner">'.$description.'</div>'; 
			}}
			$slideshow_txt .= "</div>";

			$i++;

		}  // end slideshow loop
	} // end if ($attachments)

	$slideshow .= "</div><!--//end ppp-slideshow div-->";
	
	/* Ensure the navigation has a higher z-index than the images. */
	$slideshow .= '
	<style type="text/css">
	div#ppp-slideshow-text'.$postid.', div#slideshow-thumbs-bg'.$postid.', div#slideshow-thumbs-wrapper'.$postid.' {z-index:'.($postid+$i+1).';}
	div#slideshow-nav'.$postid.' {z-index:'.($postid+$i+2).';}
	</style>
	';

	$slideshow .= "<div class=\"ppp-slideshow-text\" id=\"ppp-slideshow-text".$postid."\"><div></div></div>";
	$slideshow .= "<div class=\"ppp-slideshow-textoven\" id=\"ppp-slideshow-textoven".$postid."\">".$slideshow_txt."</div>";

	/*
	Thumbnails
	*/

	if (is_page() || is_single() || $pppsss_thumbs_hp == "true") {
		if ($thumbs=="true" && !is_feed()) {
	
		$slideshow .= '
		<div id="slideshow-thumbs-div'.$postid.'" class="slideshow-thumbs-div">
		<div id="slideshow-thumbs-bg'.$postid.'" class="slideshow-thumbs-bg"></div>
		<div id="slideshow-thumbs-wrapper'.$postid.'" class="slideshow-thumbs-wrapper">
		<div id="slideshow-thumbs-wrap'.$postid.'" class="slideshow-thumbs-wrap'.$postid.'">
		<div id="slideshow-thumbs-prev'.$postid.'" class="slideshow-thumbs-prev"><a href="javascript: void(0)"></a></div>
		<div id="slideshow-navigator'.$postid.'" class="slideshow-navigator">
		<div id="slideshow-thumbs'.$postid.'" class="slideshow-thumbs">
		<ul id="slides'.$postid.'" class="slides">';
		
		if ( !empty($include) ) {
			$include = preg_replace( '/[^0-9,]+/', '', $include );
			$attachments = get_posts( array('order'          => 'ASC',
			'orderby' 		 => 'menu_order ID',
			'post_type'      => 'attachment',
			'post_parent'    => get_the_ID(),
			'post_mime_type' => 'image',
			'post_status'    => null,
			'numberposts'    => -1,
			'size'			 => 'thumbnail',
			'include'		 => $include) );
			
		} elseif ( !empty($exclude) ) {
			$exclude = preg_replace( '/[^0-9,]+/', '', $exclude );
			$attachments = get_posts( array('order'          => 'ASC',
			'orderby' 		 => 'menu_order ID',
			'post_type'      => 'attachment',
			'post_parent'    => get_the_ID(),
			'post_mime_type' => 'image',
			'post_status'    => null,
			'numberposts'    => -1,
			'size'			 => 'thumbnail',
			'exclude'		 => $exclude) );
		} else {
			$attachments = get_posts( array('order'          => 'ASC',
			'orderby' 		 => 'menu_order ID',
			'post_type'      => 'attachment',
			'post_parent'    => get_the_ID(),
			'post_mime_type' => 'image',
			'post_status'    => null,
			'numberposts'    => -1,
			'size'			 => 'thumbnail') );
		}
	
		if ( empty($attachments) )
			return '';
		
		if ($attachments) {
			$att_count = 0;
			foreach ($attachments as $attachment) {
			$att_count++;
			$slideshow .="<li><a href=\"javascript: void(0)\">";
			$thumb = wp_get_attachment_image_src($attachment->ID, 'thumbnail');
			$slideshow .= '<img src="'.$thumb[0].'" class="attachment-thumbnail" alt="thumb-'.$att_count.'" />';
			$slideshow .= "</a></li>";		
			}
		}
		
		$slideshow .= '</ul>
		</div>
		</div>
		<div id="slideshow-thumbs-next'.$postid.'" class="slideshow-thumbs-next"><a href="javascript: void(0)"></a></div>
		</div>
		</div>
		</div><!--slideshow-thumbs-div-->
		<!-- end thumbs-->';
		}
	} //end thumbs

	/* Nav-i-ga-tion Time, come on! */
	if (!is_feed()) {
		$slideshow .= '<div id="slideshow-nav'.$postid.'" class="slideshow-nav'.$postid.' slideshow-nav">';
		$slideshow .= '<div class="slideshow-nav-button"><a id="slideshow-prev'.$postid.'" class="slideshow-prev" href="javascript: void(0)"><span></span><b>Prev</b></a></div>';
		$slideshow .= '<div class="slideshow-nav-button"><span id="slideshow-pause-play'.$postid.'" class="slideshow-pause-play">';
		if ($timeout!=0) { //if autoplay is set
			$slideshow .='<a id="pause'.$postid.'" class="pause" href="javascript: void(0)"><span></span><b>Pause</b></a><a class="play" style="display:none" href="javascript: void(0)"><span></span><b>Play</b></a>';
		}
		$slideshow .= '</span><!-- slideshow-pause-play --></div>';
		$slideshow .= '<div class="slideshow-nav-button"><a id="slideshow-next'.$postid.'" class="slideshow-next" href="javascript: void(0)"><span></span><b>Next</b></a></div>';
		$slideshow .= '<span id="slideshow-info'.$postid.'" class="slideshow-info"></span>';
		$slideshow .= '</div><!-- slideshow-nav -->';
	}
	
	$slideshow .= '</div><!-- slideshow-wrap -->';
	
	return $slideshow;	

} // ppp_slideshow_shortcode


/*
Options page wrapper.

Called only by the plugin.  The theme calls ppp_slideshow_options().
*/

function ppp_slideshow_options_page() {

global $pppsss_trans, $pppsss_speed, $pppsss_size, $pppsss_titles, $pppsss_captions, $pppsss_descriptions, $pppsss_timeout, $pppsss_navpos, $pppsss_thumbs, $pppsss_thumbs_hp, $pppsss_version, $ppp_slideshow_url, $pppsss_height, $pppsss_width, $pppsss_thumb_height, $pppsss_thumb_width, $pppsss_thumb_position, $pppsss_thumb_fade, $pppsss_nav_fade, $pppsss_txt_fade, $pppsss_nav_skin;


// Output the options page 
?>
<div class="wrap" style="width:640px">
<h2>PPP Slideshow Options</h2>

<div id="ppp_slideshow_header_message" style="
  -moz-box-shadow:rgba(0, 0, 0, 0.5) 0 1px 1px -1px;
  -webkit-box-shadow:rgba(0, 0, 0, 0.5) 0 1px 1px -1px;
  box-shadow:rgba(0, 0, 0, 0.5) 0 1px 1px -1px;
  background-color:#FFFFE0;
  border:1px solid #E6DB55;
  -moz-border-radius:7px;
  -webkit-border-radius:7px;
  border-radius:7px;
  clear:both;
  padding:10px;
  width:300px;
  float:right;">
<p>Thank you for using <strong>PhotoPressPro Slideshow</strong>!</p>
<p>The options below are the default values for all slideshows. Many options can be changed on each slideshow, by editing the <code>[ppp_slideshow]</code> shortcode attributes.</p>
<p id="ppp_slideshow_open_shortcodes"><a href="#" id="open_shortcodes_link">Click to view all shortcode attributes.</a></p>
<p id="ppp_slideshow_close_shortcodes" style="display:none;"><a href="#" id="close_shortcodes_link">Click to hide shortcode attributes.</a></p>

<div id="ppp_slideshow_shortcode_attributes" style="display:none;">

<p><strong>Slideshow width / height:</strong></p>

<code>[ppp_slideshow w=640 h=480]</code>

<p><strong>Display time for each image: (0 to turn off autoplay)</strong></p>

<code>[ppp_slideshow timeout=5]</code>

<p><strong>Show thumbnails (true or false)</strong></p>

<code>[ppp_slideshow thumbs=true]</code>

<p><strong>Include / exclude images by attachment ID.</strong></p>

<code>[ppp_slideshow include="1,2,3,4"]</code>

<code>[ppp_slideshow exclude="1,2,3,4"]</code>

<p>You can get the attachment ID by hovering your mouse over the image on the <a href="<?php echo admin_url('upload.php'); ?>">media library</a> page. Images must be attached to the current post or page.</p>

</div><!-- ppp_slideshow_shortcode_attributes -->
</div><!-- ppp_slideshow_header_message -->


<form method="post" action="options.php">


<?php 

ppp_slideshow_get_options(get_option('ppp_slideshow_options'));

ppp_slideshow_options();

wp_nonce_field('update-options'); 

?>

<p class="submit"><input type="submit" class="button-primary" value="<?php _e('Save Changes') ?>" /></p>

</form>

<p id="footer_version">PPP Slideshow <?php echo $pppsss_version;?> by <a href="http://photopresspro.com/slideshow">PhotoPressPro</a>.</p>

</div><!-- wrap -->

<?php

}

function ppp_slideshow_options() {

global $pppsss_trans, $pppsss_speed, $pppsss_size, $pppsss_titles, $pppsss_captions, $pppsss_descriptions, $pppsss_timeout, $pppsss_navpos, $pppsss_thumbs, $pppsss_thumbs_hp, $pppsss_version, $ppp_slideshow_url, $pppsss_height, $pppsss_width, $pppsss_thumb_height, $pppsss_thumb_width, $pppsss_thumb_position, $pppsss_thumb_fade, $pppsss_nav_fade, $pppsss_txt_fade, $pppsss_nav_skin;

?>

	<div id="slideshow_options" class="inside">

		<h3>Slideshow Options <span class="info-link-floater"><a class="more-info-link" href="#ppp_slideshow_intro">i</a></span></h3>

		<div class="ppp_tip" id="ppp_slideshow_intro">
        <a class="more-info-link-x" href="#ppp_slideshow_intro">X</a>
        <p>Post a slideshow by entering the <strong>[ppp_slideshow]</strong> shortcode in your post. Upload images to your post as usual; but instead of inserting them into the post, click Save and type the shortcode into the post body just like this: <code>[ppp_slideshow]</code>.<br />
        Many options can be changed on each slideshow, by editing the shortcode attributes.
        <span id="ppp_slideshow_open_shortcodes"><a href="#" id="open_shortcodes_link">View all shortcode attributes.</a></span>
        <span id="ppp_slideshow_close_shortcodes" style="display:none;"><a href="#" id="close_shortcodes_link">Hide shortcode attributes.</a></span>
		<br />
		<span id="ppp_slideshow_shortcode_attributes" style="display:none;">
        <strong>Slideshow width / height:</strong><br />
        <code>[ppp_slideshow w=640 h=480]</code><br />
        
        <strong>Display time for each image: (0 to turn off autoplay)</strong><br />
        <code>[ppp_slideshow timeout=5]</code><br />
        
        <strong>Show thumbnails (true or false)</strong><br />
        <code>[ppp_slideshow thumbs=true]</code><br />
        
        <strong>Include or exclude images by attachment ID.</strong><br />
        <code>[ppp_slideshow include="1,2,3,4"]</code><br />
        <code>[ppp_slideshow exclude="1,2,3,4"]</code><br />
        <small>(You can get the attachment ID by hovering your mouse over the image on the <a href="<?php echo admin_url('upload.php'); ?>">media library</a> page. Images must be attached to the current post or page.)</small>

        </span><!-- ppp_slideshow_shortcode_attributes -->
        </p></div><!-- ppp_tip -->

		<h4>Slideshow</h4>
		<div class="ppp_slideshow_size_div ppp_open_box">

		<h5>Slideshow size</h5>

		<div>Width: <input type="text" size="6" name="ppp_slideshow_width" value="<?php echo $pppsss_width;?>"/>
		Height: <input type="text" size="6" name="ppp_slideshow_height" value="<?php echo $pppsss_height;?>"/> pixels
        <a class="more-info-link" href="#ppp_slideshow_width_height_help">i</a>
        <div class="ppp_tip closed" id="ppp_slideshow_width_height_help">
        <a class="more-info-link-x" href="#ppp_slideshow_width_height_help">X</a>
		<p>Enter the default height and width, <strong>in pixels,</strong> of the slideshow viewing area. The maximum width allowed is 960 pixels.<br />
        If you usually crop by inches, you can figure out the pixels by multiplying the number in inches by the DPI (dots per inch) of your image.  For example, an 8&quot; by 10&quot; image at 72 DPI would measure 576 by 720 pixels. <br />
        You can override either or both values on an individual slideshow by editing the shortcode like this: <br />
        <code>[ppp_slideshow w=640 h=480]</code></p></div></div>

		<h5>Image size</h5>

        <div><label class="labelCheckbox" for="thumbnail" >
            <input name="ppp_slideshow_size" id="thumbnail" type="radio" class="crirHiddenJS" value="thumbnail" <?php if($pppsss_size == "thumbnail") echo " checked='checked'";?> />Thumbnail</label>
        <label class="labelCheckbox" for="medium" >
            <input name="ppp_slideshow_size" id="medium" type="radio" class="crirHiddenJS" value="medium" <?php if($pppsss_size == "medium") echo " checked='checked'";?> />Medium</label>
        <label class="labelCheckbox" for="large" >
            <input name="ppp_slideshow_size" id="large" type="radio" class="crirHiddenJS" value="large" <?php if($pppsss_size == "large") echo " checked='checked'";?> />Large</label>
        <label class="labelCheckbox" for="full" >
            <input name="ppp_slideshow_size" id="full" type="radio" class="crirHiddenJS" value="full" <?php if($pppsss_size == "full") echo " checked='checked'";?> />Full</label>
        </div>
        <p class="info-link-floater"><a class="more-info-link" href="#ppp_slideshow_image_size_help">i</a></p>
        <br clear="all" />
        <div class="ppp_tip closed" id="ppp_slideshow_image_size_help">
        <a class="more-info-link-x" href="#ppp_slideshow_image_size_help">X</a>
        <p>Choose Thumbnail, Medium, or Large to show images that were resized by WordPress, or choose Full to show the original image.  When you upload an image to post, WordPress makes several copies in different sizes: 
        <code>thumbnail</code>, <code>medium</code>, <code>large</code>, and <code>full</code> sizes.  Sizes can be updated on the <a href="<?php echo admin_url('options-media.php'); ?>">Media Settings</a> page. 
        You can override the image size on an individual slideshow by editing the shortcode like this: <br />
	    <code>[ppp_slideshow size=medium]</code></p>
        </div>

<?php 
/*
fade = Fade
blindX = Slide out right, slide in left
blindY = Slide out down, slide in up
blindZ = Slide out down/right, slide in up/left
cover = Slide in left, cover previous image
curtainX = Curtains closing left/right
curtainY = Curtains closing up/down
growX = Curtains opening left/right
growY = Curtains opening up/down
scrollUp = Scroll up
scrollDown = Scroll down
scrollLeft = Scroll left
scrollRight = Scroll right
slideX = Slide in left, Slide out right
slideY = Slide in Down, Slide out up
toss = Toss away
turnUp = Slide in up, cover previous image
turnDown = Slide out down, reveal next image
turnRight = Slide out right, reveal next image
uncover = Slide out left, reveal next image
wipe = Wipe down/right
*/

?>

		<h5>Transitions</h5>

        <div>Effect: <select name="ppp_slideshow_transition" id="ppp_slideshow_transition">
	<option value="fade" <?php if($pppsss_trans == "fade") echo " selected='selected'";?>>Fade</option>
	<option value="scrollLeft" <?php if($pppsss_trans == "scrollLeft") echo " selected='selected'";?>>Scroll left</option>
	<option value="scrollRight" <?php if($pppsss_trans == "scrollRight") echo " selected='selected'";?>>Scroll right</option>
	<option value="scrollUp" <?php if($pppsss_trans == "scrollUp") echo " selected='selected'";?>>Scroll up</option>
	<option value="scrollDown" <?php if($pppsss_trans == "scrollDown") echo " selected='selected'";?>>Scroll down</option>
	<option value="toss" <?php if($pppsss_trans == "toss") echo " selected='selected'";?>>Toss away</option>
	<option value="cover" <?php if($pppsss_trans == "cover") echo " selected='selected'";?>>Slide in left, cover previous image</option>
	<option value="slideX" <?php if($pppsss_trans == "slideX") echo " selected='selected'";?>>Slide in left, Slide out right</option>
	<option value="turnUp" <?php if($pppsss_trans == "turnUp") echo " selected='selected'";?>>Slide in up, cover previous image</option>
	<option value="slideY" <?php if($pppsss_trans == "slideY") echo " selected='selected'";?>>Slide in down, Slide out up</option>
	<option value="wipe" <?php if($pppsss_trans == "wipe") echo " selected='selected'";?>>Wipe down/right</option>
	<option value="uncover" <?php if($pppsss_trans == "uncover") echo " selected='selected'";?>>Slide out left, reveal next image</option>
	<option value="turnRight" <?php if($pppsss_trans == "turnRight") echo " selected='selected'";?>>Slide out right, reveal next image</option>
	<option value="blindX" <?php if($pppsss_trans == "blindX") echo " selected='selected'";?>>Slide out right, slide in left</option>
	<option value="blindY" <?php if($pppsss_trans == "blindY") echo " selected='selected'";?>>Slide out down, slide in up</option>
	<option value="blindZ" <?php if($pppsss_trans == "blindZ") echo " selected='selected'";?>>Slide out down/right, slide in up/left</option>
	<option value="turnDown" <?php if($pppsss_trans == "turnDown") echo " selected='selected'";?>>Slide out down, reveal next image</option>
	<option value="curtainX" <?php if($pppsss_trans == "curtainX") echo " selected='selected'";?>>Curtains closing left/right</option>
	<option value="curtainY" <?php if($pppsss_trans == "curtainY") echo " selected='selected'";?>>Curtains closing up/down</option>
	<option value="growX" <?php if($pppsss_trans == "growX") echo " selected='selected'";?>>Curtains opening left/right</option>
	<option value="growY" <?php if($pppsss_trans == "growY") echo " selected='selected'";?>>Curtains opening up/down</option>
	<option value="random" <?php if($pppsss_trans == pppsss_trans_random()) echo " selected='selected'";?>>Random</option>
	<option value="none" <?php if($pppsss_trans == "none") echo " selected='selected'";?>>None</option>
		</select> 
        <a class="more-info-link" href="#ppp_slideshow_transition_help">i</a>
        <div class="ppp_tip closed" id="ppp_slideshow_transition_help">
        <a class="more-info-link-x" href="#ppp_slideshow_transition_help">X</a>
        <p>Choose the transition effect between images. This cannot be overridden per slideshow at this time.</p></div></div>

        <div>Effect duration: <input type="text" size="6" name="ppp_slideshow_transition_speed" value="<?php echo $pppsss_speed;?>"/> seconds
        <a class="more-info-link" href="#ppp_slideshow_transition_speed_help">i</a>
        <div class="ppp_tip closed" id="ppp_slideshow_transition_speed_help">
        <a class="more-info-link-x" href="#ppp_slideshow_transition_speed_help">X</a>
        <p>Enter the number of seconds it takes to transition between images. Decimals like <strong>0.5</strong> are allowed. This cannot be overridden per slideshow at this time.</p></div></div>

        <div>Display time: <input type="text" size="6" name="ppp_slideshow_timeout" value="<?php echo $pppsss_timeout;?>"/> seconds
        <a class="more-info-link" href="#ppp_slideshow_timeout_help">i</a>
        <div class="ppp_tip closed" id="ppp_slideshow_timeout_help">
        <a class="more-info-link-x" href="#ppp_slideshow_timeout_help">X</a>
        <p>Enter the number of seconds to display each image before automatically transitioning to the next image. <strong>Enter &quot;0&quot; to turn off auto-play.</strong> You can override this per slideshow by entering the shortcode like this: <code>[ppp_slideshow timeout=0]</code></p></div></div>

		</div><!-- .ppp_slideshow_img_size_div -->

		<h4>Text</h4>
		<div class="ppp_slideshow_txt_div ppp_open_box">

        <p>
		<label class="labelCheckbox" for="ppp_slideshow_show_titles">
		<input type="checkbox" name="ppp_slideshow_show_titles" id="ppp_slideshow_show_titles" value="true" class="crirHiddenJS"<?php if ($pppsss_titles=="true") {echo' checked="checked"'; }?> />Title</label>
		<label class="labelCheckbox" for="ppp_slideshow_show_captions">
		<input type="checkbox" name="ppp_slideshow_show_captions" id="ppp_slideshow_show_captions" value="true" class="crirHiddenJS"<?php if ($pppsss_captions=="true") {echo' checked="checked"'; }?> />Caption</label>
		<label class="labelCheckbox" for="ppp_slideshow_show_descriptions">
		<input type="checkbox" name="ppp_slideshow_show_descriptions" id="ppp_slideshow_show_descriptions" value="true" class="crirHiddenJS"<?php if ($pppsss_descriptions=="true") {echo' checked="checked"'; }?> />Description</label>
        </p>
        <p class="info-link-floater"><a class="more-info-link" href="#ppp_slideshow_show_text_help">i</a></p>
		<br clear="all"/>
		<div class="ppp_tip closed" id="ppp_slideshow_show_text_help">
        <a class="more-info-link-x" href="#ppp_slideshow_show_text_help">X</a>
        <p>Choose which text fields to show, if any. Text fields can be edited in the <a href="<?php echo admin_url('upload.php'); ?>">Media Library</a>.</p></div>

        <p>
		<label class="labelCheckbox" for="ppp_slideshow_txt_fade">
		<input type="checkbox" name="ppp_slideshow_txt_fade" id="ppp_slideshow_txt_fade" value="true" class="crirHiddenJS" <?php if ($pppsss_txt_fade=="true") {echo' checked="checked"'; }?> />Fade on Mouseover?</label>
        </p>
        <p class="info-link-floater"><a class="more-info-link" href="#ppp_slideshow_txt_hover_help">i</a></p>
		<br clear="all"/>
        <div class="ppp_tip closed" id="ppp_slideshow_txt_hover_help">
        <a class="more-info-link-x" href="#ppp_slideshow_txt_hover_help">X</a>
        <p>Fade image text in and out on mouseover. Text will be displayed when the slideshow is first opened, but will fade away when the mouse is moved over, then away from the slideshow.</p></div>

		</div><!-- .ppp_slideshow_txt_div -->

		<h4>Navigation</h4>
		<div class="ppp_slideshow_icon_div ppp_open_box">

        <div>
        <label class="labelCheckbox" for="none">
            <input name="ppp_slideshow_nav_skin" id="none" type="radio" class="crirHiddenJS" value="none" <?php if($pppsss_nav_skin == "none") echo " checked='checked'";?> />None</label>
        <label class="labelCheckbox" for="mnml">
            <input name="ppp_slideshow_nav_skin" id="mnml" type="radio" class="crirHiddenJS" value="mnml" <?php if($pppsss_nav_skin == "mnml") echo " checked='checked'";?> />Minimal</label>
        <label class="labelCheckbox" for="icons-only">
            <input name="ppp_slideshow_nav_skin" id="icons-only" type="radio" class="crirHiddenJS" value="icons-only" <?php if($pppsss_nav_skin == "icons-only") echo " checked='checked'";?> />Icons Only</label>
        <label class="labelCheckbox" for="one-button">
            <input name="ppp_slideshow_nav_skin" id="one-button" type="radio" class="crirHiddenJS" value="one-button" <?php if($pppsss_nav_skin == "one-button") echo " checked='checked'";?> />One Button</label>
        <label class="labelCheckbox" for="button-bar">
            <input name="ppp_slideshow_nav_skin" id="button-bar" type="radio" class="crirHiddenJS" value="button-bar" <?php if($pppsss_nav_skin == "button-bar") echo " checked='checked'";?> />Button Bar</label>
        </div>
        <p class="info-link-floater"><a class="more-info-link" href="#ppp_slideshow_nav_skin_help">i</a></p>
        <br clear="all" />
		<div class="ppp_tip closed" id="ppp_slideshow_nav_skin_help">
        <a class="more-info-link-x" href="#ppp_slideshow_nav_skin_help">X</a>
        <p>Choose a style for the navigation icons, or hide them.</p></div>

        <p>
		<label class="labelCheckbox" for="ppp_slideshow_nav_fade">
		<input type="checkbox" name="ppp_slideshow_nav_fade" id="ppp_slideshow_nav_fade" value="true" class="crirHiddenJS" <?php if ($pppsss_nav_fade=="true") {echo' checked="checked"'; }?> />Fade on Mouseover?</label>
        </p>
        <p class="info-link-floater"><a class="more-info-link" href="#ppp_slideshow_hover_help">i</a></p>
		<br clear="all"/>
        <div class="ppp_tip closed" id="ppp_slideshow_hover_help">
        <a class="more-info-link-x" href="#ppp_slideshow_hover_help">X</a>
        <p>Fade navigation elements in and out on mouseover. Navigation will be displayed when the slideshow is first opened, but will fade away when the mouse is moved over, then away from the slideshow.</p></div>

		</div><!-- .ppp_slideshow_icon_div -->

		<h4>Thumbnails</h4>
		<div class="ppp_slideshow_thumbs_div ppp_open_box">
        <p>
		<label class="labelCheckbox" for="ppp_slideshow_show_thumbs">
		<input type="checkbox" name="ppp_slideshow_show_thumbs" id="ppp_slideshow_show_thumbs" value="true" class="crirHiddenJS" <?php if ($pppsss_thumbs=="true") {echo' checked="checked"'; }?> />Single Post or Page</label>
		<label class="labelCheckbox" for="ppp_slideshow_show_thumbs_hp">
		<input type="checkbox" name="ppp_slideshow_show_thumbs_hp" id="ppp_slideshow_show_thumbs_hp" value="true" class="crirHiddenJS" <?php if ($pppsss_thumbs_hp=="true") {echo' checked="checked"'; }?> />Home and Archive Pages</label>
        </p>
        <p class="info-link-floater"><a class="more-info-link" href="#ppp_slideshow_thumbs_help">i</a></p>
		<br clear="all"/>
		<div class="ppp_tip closed" id="ppp_slideshow_thumbs_help">
        <a class="more-info-link-x" href="#ppp_slideshow_thumbs_help">X</a>
        <p>Choose when to show thumbnails - on the actual post or page, on the home/category pages, or both.  You can override this per slideshow by entering the shortcode like this:<br />
        <code>[ppp_slideshow thumbs=false]</code></p></div>

        <p>
		<label class="labelCheckbox" for="ppp_slideshow_thumb_fade">
		<input type="checkbox" name="ppp_slideshow_thumb_fade" id="ppp_slideshow_thumb_fade" value="true" class="crirHiddenJS" <?php if ($pppsss_thumb_fade=="true") {echo' checked="checked"'; }?> />Fade on Mouseover?</label>
        </p>
        <p class="info-link-floater"><a class="more-info-link" href="#ppp_slideshow_thumb_hover_help">i</a></p>
		<br clear="all"/>
        <div class="ppp_tip closed" id="ppp_slideshow_thumb_hover_help">
        <a class="more-info-link-x" href="#ppp_slideshow_thumb_hover_help">X</a>
        <p>Fade thumbnails in and out on mouseover. Thumbnails will be displayed when the slideshow is first opened, but will fade away when the mouse is moved over, then away from the slideshow.</p></div>

		<h5>Thumbnail Size</h5>

		<div>Width: <input type="text" size="6" name="ppp_slideshow_thumb_width" value="<?php echo $pppsss_thumb_width;?>"/>
		Height: <input type="text" size="6" name="ppp_slideshow_thumb_height" value="<?php echo $pppsss_thumb_height;?>"/> pixels 
        <a class="more-info-link" href="#ppp_slideshow_thumb_width_height_help">i</a>
        <div class="ppp_tip closed" id="ppp_slideshow_thumb_width_height_help">
        <a class="more-info-link-x" href="#ppp_slideshow_thumb_width_height_help">X</a>
        <p>This is the height and width of each thumbnail. If the thumbnail sizes on the <a href="<?php echo admin_url('options-media.php'); ?>">Media Settings</a> page do not match, thumbnails will be resized to fit these dimensions.</p></div></div>


		<h5>Thumbnail Position</h5>

        <div><label class="labelCheckbox" for="bottom">
            <input name="ppp_slideshow_thumb_position" id="bottom" type="radio" class="crirHiddenJS" value="bottom" <?php if($pppsss_thumb_position == "bottom") echo " checked='checked'";?> />Overlay</label>
        <label class="labelCheckbox" for="below">
            <input name="ppp_slideshow_thumb_position" id="below" type="radio" class="crirHiddenJS" value="below" <?php if($pppsss_thumb_position == "below") echo " checked='checked'";?> />Underneath</label>
        </div>
        <p class="info-link-floater"><a class="more-info-link" href="#ppp_slideshow_thumb_pos_help">i</a></p>
        <br clear="all" />
		<div class="ppp_tip closed" id="ppp_slideshow_thumb_pos_help">
        <a class="more-info-link-x" href="#ppp_slideshow_thumb_pos_help">X</a>
        <p>Choose where to place the thumbnails. Show thumbnails as an Overlay on the bottom of the slideshow, or Underneath the slideshow.</p></div>

		</div><!-- .ppp_slideshow_thumbs_div -->
        <input type="hidden" name="page_options" value="ppp_slideshow_size, ppp_slideshow_transition, ppp_slideshow_transition_speed, ppp_slideshow_show_captions, ppp_slideshow_show_titles, ppp_slideshow_show_descriptions, ppp_slideshow_timeout, ppp_slideshow_nav_position, ppp_slideshow_show_thumbs, ppp_slideshow_show_thumbs_hp, ppp_slideshow_width, ppp_slideshow_height, ppp_slideshow_thumb_width, ppp_slideshow_thumb_height, ppp_slideshow_thumb_position, ppp_slideshow_thumb_fade, ppp_slideshow_nav_fade, ppp_slideshow_txt_fade, ppp_slideshow_nav_skin" />
		<input type="hidden" name="action" value="update" />	

	</div>

<?php

}

function ppp_slideshow_options_serialized() {
    $ss_options_new = Array();
	$ss_options = explode( ',', stripslashes( $_POST[ 'page_options' ] ) );
	if ( $ss_options ) {
		foreach ( $ss_options as $option ) {
			$option = trim($option);
			$value = null;
			if ( isset($_POST[$option]) )
				$value = $_POST[$option];
			if ( !is_array($value) )
				$value = trim($value);
			$value = stripslashes_deep($value);
			$ss_options_new[$option] = $value;
		}
	}
	return $ss_options_new;
}

?>