<?php $theme_options = ppp_get_options(); ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html <?php language_attributes(); ?> xmlns="http://www.w3.org/1999/xhtml">

<head>

<meta http-equiv="content-type" content="text/html; charset=<?php bloginfo('charset'); ?>" />

<meta name="description" content="<?php bloginfo('name'); ?> - <?php bloginfo('description'); echo (($theme_options["meta_desc"] != "") ? ' : '.$theme_options["meta_desc"] : ''); ?>" />

<meta name="keywords" content="<?php echo (($theme_options["meta_keywords"] != "") ? $theme_options["meta_keywords"] : ''); ?>" />

<link rel="stylesheet" type="text/css" href="<?php bloginfo('stylesheet_url'); ?>" />

<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/print.css" media="print" />

<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

<title><?php ppp_custom_title(); ?></title>

<?php if ($theme_options['img_ico'] != "") {
	echo'<link rel="Shortcut Icon" type="image/x-icon" href="'.$theme_options['img_ico'].'" />';
} ?>

<style type="text/css">
<!--
<?php 

/* CSS FONTS */

$font_css_h1_c=ppp_fontface('h1');
$font_css_sub_c=ppp_fontface('sub');
$font_css_content_c=ppp_fontface('content');
$font_css_menu_c=ppp_fontface('menu');
$font_css_footer_c=ppp_fontface('footer');
$font_css_slideshow_content=ppp_fontface('slideshow_content');
$font_css_sidebar_h1=ppp_fontface('sidebar_h1');
$font_css_sidebar_text=ppp_fontface('sidebar_text');
$font_css_footer_h1=ppp_fontface('footer_h1');

/* Menu bar position. "header_img_flash" is img, flash, js, img_js, or img_flash.
   Use the Height value from settings for Flashfader, Custom Image Header, or Simple Slideshow. */
$img_banner_height = "0";
$slide_banner_height = "0";
if ($theme_options["header_img_flash"] == 'flash' || $theme_options["header_img_flash"] == 'img_flash') {

	/* Open flashfader data file and populate $data with unserialized data */
	$data = unserialize(file_get_contents(ABSPATH.'wp-content/flashfader/data.txt'));	
	$slide_banner_height = $data['lynkff_height'];
	echo '#flash_header {height:'.$slide_banner_height.'px;} ';
}

if ($theme_options["header_img_flash"] == 'img' || $theme_options["header_img_flash"] == 'img_js' || $theme_options["header_img_flash"] == 'img_flash') {
	$img_banner_height = HEADER_IMAGE_HEIGHT;
	echo '
		#headerimg {height:'.$img_banner_height.'px;} 
		#headerimg {background: url('.$theme_options["img_header"].') center center no-repeat;}
		#headerimg h1, .description {left:-9000px; position:absolute;}
	';
}

if ($theme_options["header_img_flash"] == 'js' || $theme_options["header_img_flash"] == 'img_js') {
	$slide_banner_height = $theme_options["header_img_height"];
}


if ($theme_options["header_img_flash"] == 'img_js' || $theme_options["header_img_flash"] == 'img_flash') {
	if ($theme_options["header_layout"] == "l") {
		/* Reset to slideshow height */
		$sidebar_top = $slide_banner_height;
		echo '#headerimg {float:left; width:328px;} ';
		echo '.header_slide {float:right; width:656px;} ';
		echo '#wrap {clear:both;} ';
	} else if ($theme_options["header_layout"] == "r") {
		/* Reset to slideshow height */
		$sidebar_top = $slide_banner_height;
		echo '#headerimg {float:right; width:328px;} ';
		echo '.header_slide {float:left; width:656px;} ';
		echo '#wrap {clear:both;} ';
	}
}

if ($theme_options["menu_place"] == "top") {
  $sidebar_top = 0;
} else if (($theme_options["menu_place"] == "inbetween") && 
	       ($theme_options["header_img_flash"] == 'img_js' || $theme_options["header_img_flash"] == 'img_flash') &&
		   ($theme_options["header_layout"] == "t" || $theme_options["header_layout"] == "b")) {
	if ($theme_options["header_layout"] == "t") {
	  $sidebar_top = $img_banner_height;
	} else if ($theme_options["header_layout"] == "b") {
	  $sidebar_top = $slide_banner_height;
	}
} else if (($theme_options["header_img_flash"] == 'img_js' || $theme_options["header_img_flash"] == 'img_flash') && 
		   ($theme_options["header_layout"] == "l" || $theme_options["header_layout"] == "r")) {
	  $sidebar_top = $slide_banner_height;
} else {
	  $sidebar_top = $img_banner_height + $slide_banner_height;
}


if ($theme_options["display_image_bio"] != 1) {
  echo '#biopic {display:none} ';
}
if ($theme_options["content_bg_color"] != "") {
  echo '#wrap {background:#'.$theme_options["content_bg_color"].'} ';
}
if ($theme_options["footer_bg_color"] != "") {
  echo '#footer,.bottom {background:#'.$theme_options["footer_bg_color"].'} ';
}
if ($theme_options["content_color"] != "") {
  echo 'body {color:#'.$theme_options["content_color"].'} ';
}
if ($theme_options["footer_color"] != "") {
  echo '#footer,.bottom {color:#'.$theme_options["footer_color"].'} ';
}
if ($theme_options["footer_link_color"] != "") {
  echo '#footer a, .bottom li a, .bottom li a:hover {color:#'.$theme_options["footer_link_color"].'} ';
}
if ($theme_options["footer_link_bg_hover"] != "") {
  echo '.bottom li li:hover {background:#'.$theme_options["footer_link_bg_hover"].'} ';
}
if ($theme_options["a_color"] != "") {
  echo 'a {color:#'.$theme_options["a_color"].'} ';
  echo 'a[rel~="tag"] {border-bottom:1px dotted #'.$theme_options["a_color"].'} ';
}
if ($theme_options["h1_color"] != "") {
  echo 'h1,h2,h3,h4,h5,h6,h1 a,h2 a,h3 a,h4 a,h5 a,h6 a {color:#'.$theme_options["h1_color"].'} ';
}
if ($theme_options["footer_h1_color"] != "") {
  echo '.bottom h1,.bottom h2,.bottom h3,.bottom h4,.bottom h5,.bottom h6,.bottom h1 a,.bottom h2 a,.bottom h3 a,.bottom h4 a,.bottom h5 a,.bottom h6 a {color:#'.$theme_options["footer_h1_color"].'} ';
}
if ($theme_options["sub_color"] != "") {
  echo '#content p.subtitle {color:#'.$theme_options["sub_color"].'} ';
}

/* Slideshow */
if ($theme_options["slideshow_bg_color"] != "") {
  echo 'div.slideshow-wrap {background:#'.$theme_options["slideshow_bg_color"].'} ';
}
if ($theme_options["slideshow_content_bg_color"] != "") {
  echo 'div.ppp-slideshow-text {background:#'.$theme_options["slideshow_content_bg_color"].'} ';
}
if ($theme_options["slideshow_content_color"] != "") {
  echo 'div.ppp-slideshow-text {color:#'.$theme_options["slideshow_content_color"].'} ';
}
if ($theme_options["slideshow_thumbs_bg_color"] != "") {
  echo 'div.slideshow-thumbs-bg {background:#'.$theme_options["slideshow_thumbs_bg_color"].';} ';
}
if ($theme_options["slideshow_thumb_shadow"] == 1) {
  echo '
.slides a {
-webkit-box-shadow: 0px 0px 10px #000000;
-moz-box-shadow: 0px 0px 10px #000000;
box-shadow: 0px 0px 10px #000000;
}
';
}

if ($theme_options["content_bold"] == 1) {
  echo '#content {font-weight:bold} ';
} else {
  echo '#content {font-weight:normal} ';
}
if ($theme_options["content_ital"] == 1) {
  echo '#content {font-style:italic} ';
} else {
  echo '#content {font-style:normal} ';
}

if ($theme_options["footer_bold"] == 1) {
  echo '.bottom li {font-weight:bold} ';
} else {
  echo '.bottom li {font-weight:normal} ';
  echo '.bottom a {font-weight:normal} ';
}
if ($theme_options["footer_ital"] == 1) {
  echo '#footer, .bottom li {font-style:italic} ';
} else {
  echo '#footer, .bottom li {font-style:normal} ';
}

echo 'h1,h2,h3,h4,h5,h6,h1 a,h2 a,h3 a,h4 a,h5 a,h6 a, .description {font-weight:normal; font-style:normal} ';
if ($theme_options["h1_bold"] == 1) {
  echo 'h1,h2,h3,h4,h5,h6,h1 a,h2 a,h3 a,h4 a,h5 a,h6 a, .description {font-weight:bold} ';
} else {
  echo 'h1,h2,h3,h4,h5,h6,h1 a,h2 a,h3 a,h4 a,h5 a,h6 a, .description {font-weight:normal} ';
}
if ($theme_options["h1_ital"] == 1) {
  echo 'h1,h2,h3,h4,h5,h6,h1 a,h2 a,h3 a,h4 a,h5 a,h6 a, .description {font-style:italic} ';
} else {
  echo 'h1,h2,h3,h4,h5,h6,h1 a,h2 a,h3 a,h4 a,h5 a,h6 a, .description {font-style:normal} ';
}

if ($theme_options["menu_bold"] == 1) {
  echo '#sidebar ul {font-weight:bold} ';
} else {
  echo '#sidebar ul, #sidebar ul a {font-weight:normal} ';
}
if ($theme_options["menu_ital"] == 1) {
  echo '#sidebar ul {font-style:italic} ';
} else {
  echo '#sidebar ul {font-style:normal} ';
}


/* Slideshow */
if ($theme_options["slideshow_content_bold"] == 1) {
  echo 'div.ppp-slideshow-text {font-weight:bold} ';
} else {
  echo 'div.ppp-slideshow-text {font-weight:normal} ';
}
if ($theme_options["slideshow_content_ital"] == 1) {
  echo 'div.ppp-slideshow-text {font-style:italic} ';
} else {
  echo 'div.ppp-slideshow-text {font-style:normal} ';
}

/* Sidebar Text */
if ($theme_options["sidebar_text_bold"] == 1) {
  echo 'div.ppp_widget_sidebar {font-weight:bold} ';
} else {
  echo 'div.ppp_widget_sidebar {font-weight:normal} ';
}
if ($theme_options["sidebar_text_ital"] == 1) {
  echo 'div.ppp_widget_sidebar {font-style:italic} ';
} else {
  echo 'div.ppp_widget_sidebar {font-style:normal} ';
}

/* Sidebar Titles */
if ($theme_options["sidebar_h1_bold"] == 1) {
  echo 'div.ppp_widget_sidebar h2 {font-weight:bold} ';
} else {
  echo 'div.ppp_widget_sidebar h2 {font-weight:normal} ';
}
if ($theme_options["sidebar_h1_ital"] == 1) {
  echo 'div.ppp_widget_sidebar h2 {font-style:italic} ';
} else {
  echo 'div.ppp_widget_sidebar h2 {font-style:normal} ';
}

/* Footer Titles */
if ($theme_options["footer_h1_bold"] == 1) {
  echo '.bottom h2 {font-weight:bold} ';
} else {
  echo '.bottom h2 {font-weight:normal} ';
}
if ($theme_options["footer_h1_ital"] == 1) {
  echo '.bottom h2 {font-style:italic} ';
} else {
  echo '.bottom h2 {font-style:normal} ';
}


if ($theme_options["align_menu"] != "") {
  echo '#sidebar li {text-align:'.$theme_options["align_menu"].'; } ';
  echo '#sidebar li.LargeMenu ul li {text-align:'.$theme_options["align_menu"].'; } ';
}
if ($theme_options["align_content"] != "") {
  echo '.contenttext, .timestamp, .commentsection {text-align:'.$theme_options["align_content"].'; } ';
}
if ($theme_options["align_h1"] != "") {
  echo '#content h1.entry-title, #content h2.entry-title, #content h3.entry-title {text-align:'.$theme_options["align_h1"].'; } ';
  echo '#content h1.respond_head, #content h2.respond_head, #content h3.respond_head {text-align:'.$theme_options["align_h1"].'; } ';
  echo '#content h2.comments, #content h2#comments, #content h3.comments, #content h3#comments {text-align:'.$theme_options["align_h1"].'; } ';
  echo '#ppp_about h2 {text-align:'.$theme_options["align_h1"].'; } ';
}
if ($theme_options["align_footer"] != "") {
  echo '.bottom li {text-align:'.$theme_options["align_footer"].'; } ';

  if ($theme_options["align_footer"] == "right") {
	/* Normally centered, only right-align if footer text is too. */
    echo '#footer {text-align:'.$theme_options["align_footer"].'; } ';
  }
}
/* Slideshow */
if ($theme_options["align_slideshow_content"] != "") {
  echo 'div.ppp-slideshow-text {text-align:'.$theme_options["align_slideshow_content"].'; } ';
}
/* Sidebar Text */
if ($theme_options["align_sidebar_text"] != "") {
  echo 'div.ppp_widget_sidebar {text-align:'.$theme_options["align_sidebar_text"].'; } ';
}
/* Sidebar Titles */
if ($theme_options["align_sidebar_h1"] != "") {
  echo 'div.ppp_widget_sidebar h2 {text-align:'.$theme_options["align_sidebar_h1"].'; } ';
}
/* Footer Titles */
if ($theme_options["align_footer_h1"] != "") {
  echo '.bottom h1, .bottom h2, .bottom h3, .bottom h4, .bottom h5, .bottom h6 {text-align:'.$theme_options["align_footer_h1"].';} ';
}


/* Subtitles */
if ($theme_options["align_sub"] != "") {
  echo '#content p.subtitle {text-align:'.$theme_options["align_sub"].'; } ';
}
if ($theme_options["sub_bold"] == 1) {
  echo '#content p.subtitle {font-weight:bold} ';
} else {
  echo '#content p.subtitle {font-weight:normal} ';
  echo '#content p.subtitle a {font-weight:normal} ';
}
if ($theme_options["sub_ital"] == 1) {
  echo '#content p.subtitle {font-style:italic} ';
}


if ($theme_options["post_img_align"] != "") {
  echo '#content .caption, .wp-caption  {text-align:'.($theme_options["post_img_align"] == 'center' ? ' center' : ' left').'} ';
  if ($theme_options["post_img_align"] == 'right') {
	  echo '.contenttext img, .contenttext object, .contenttext embed, .contenttext div.slideshow-wrap {float:right;} ';
	  echo '#content .caption, .wp-caption  {text-align:right;} ';
  }
  if ($theme_options["post_img_align"] == 'center' || $theme_options["post_img_align"] == 'right') {
	  echo '.contenttext img, .contenttext object, .contenttext embed, .contenttext div.slideshow-wrap {display:block;} ';
  }
  if ($theme_options["post_img_align"] == 'center') {
	  echo '.contenttext img, .contenttext object, .contenttext embed, .contenttext div.slideshow-wrap {margin-left:auto; margin-right:auto; } ';
	  echo '.contenttext div.wp-caption {margin-left:auto; margin-right:auto; } ';
	  echo '.contenttext img.alignleft { margin: 0 24px 4px 0; } ';
	  echo '.contenttext img.alignright { margin: 0 0 14px 4px; } ';
  }
}

global $content_width_2col;
$max_w = ppp_get_content_width();

echo '.contenttext img, .wp-caption {max-width:'.$max_w.'px; height:auto;} ';

if ($theme_options["post_img_border_size"] != "") {
  echo '.contenttext img, .wp-caption {max-width:'.($max_w-($theme_options["post_img_border_size"]*2)).'px; height:auto;} ';
  echo '.contenttext img, .gallery img, img.attachment-thumbnail {border-width:'.$theme_options["post_img_border_size"].'px;} ';
  if ($theme_options["post_img_border_color"] != "") {
	echo '.contenttext img, .gallery img, img.attachment-thumbnail {border-color:#'.$theme_options["post_img_border_color"].';} ';
  }
  if ($theme_options["post_img_border_style"] != "") {
	echo '.contenttext img, .gallery img, img.attachment-thumbnail {border-style:'.$theme_options["post_img_border_style"].';} ';
  }
}

/* IMAGES */

		/* Support the default bio image before options are saved. */
$imgurl = ppp_get_img_url('bio', $theme_options);
if ($imgurl != '') {
  echo '#biopic { background: #FFFFFF url('.$imgurl.')  no-repeat bottom center} ';
}

/* Background Image */
if (($theme_options["img_bg"] != "") && ($theme_options["display_image_bg"] == 1)) {
  echo 'body { background-image: url('.$theme_options["img_bg"].'); } ';
}
if ($theme_options["bg_img_align"] != "") {
  if ($theme_options["bg_img_valign"] != "") {
	echo 'body { background-position: '.$theme_options["bg_img_align"].' '.$theme_options["bg_img_valign"].';} ';
  }
}
if ($theme_options["bg_img_repeat"] != "") {
  echo 'body { background-repeat:'.$theme_options["bg_img_repeat"].';} ';
}
if ($theme_options["bg_img_fixed"] == 1) {
  echo 'body { background-attachment:fixed;} ';
}

/* Borders and Whitespace */
if ($theme_options["side_border_img"] == 0) {
  echo '#outer_wrap {background:none;}';
  echo '#top-margin {background:none;} ';
  echo '#top-margin {height:0px} ';
  echo '#bottom-margin {background:none;} ';
  echo '#bottom-margin {height:0px} ';
}

if ($theme_options["hdr_margin"] != "") {
  echo '#outer_outer {margin-top:'.$theme_options["hdr_margin"].'px} ';
  $sidebar_top += $theme_options["hdr_margin"];
  /* Adjust menu position if drop shadow is switched on */
  if ($theme_options["side_border_img"] == 1) $sidebar_top += 19;
} else {
  echo '#top-margin {height:0px} ';
} 

/* Add the top border height and the drop shadow height */
if ($theme_options["border_header_top_size"] != "") {
  echo '#top-border {border-top-width:'.$theme_options["border_header_top_size"].'px} ';
  $sidebar_top += $theme_options["border_header_top_size"];
}
if ($theme_options["border_header_top_color"] != "") {
  echo '#top-border {border-top-color:#'.$theme_options["border_header_top_color"].'} ';
}
if ($theme_options["border_header_top_style"] != "") {
  echo '#top-border {border-top-style:'.$theme_options["border_header_top_style"].'} ';
}



if ($theme_options["ftr_margin"] != "") {
  echo '#outer_outer {margin-bottom:'.$theme_options["ftr_margin"].'px} ';
} else {
  echo '#bottom-margin {height:0px} ';
} 
if ($theme_options["border_footer_bottom_size"] != "") {
  echo '#bottom-border {border-bottom-width:'.$theme_options["border_footer_bottom_size"].'px} ';
}
if ($theme_options["border_footer_bottom_color"] != "") {
  echo '#bottom-border {border-bottom-color:#'.$theme_options["border_footer_bottom_color"].'} ';
}
if ($theme_options["border_footer_bottom_style"] != "") {
  echo '#bottom-border {border-bottom-style:'.$theme_options["border_footer_bottom_style"].'} ';
}


if ($theme_options["bg_color"] != "") {
  echo 'body {background-color:#'.$theme_options["bg_color"].'} ';
}
if (($theme_options["img_pb"] != "") && ($theme_options["display_image_pb"] == 1)) {
  $height = $theme_options["pb_image_height"];
  echo '.post {background: url('.$theme_options["img_pb"].') bottom center no-repeat; padding-bottom:'.($height+6).'px; } ';
} else {
	if ($theme_options["pb_border_size"] != "") {
	  echo '.post {border-bottom-width:'.$theme_options["pb_border_size"].'px} ';
	  if ($theme_options["pb_border_color"] != "") {
		echo '.post {border-bottom-color:#'.$theme_options["pb_border_color"].'} ';
	  }
	  if ($theme_options["pb_border_style"] != "") {
		echo '.post {border-bottom-style:'.$theme_options["pb_border_style"].'} ';
	  }
	}
}

/* Slideshow borders */
if ($theme_options["border_slideshow_size"] != "") {
if ($theme_options["border_slideshow_color"] != "") {
if ($theme_options["border_slideshow_style"] != "") {
  echo 'div.slideshow-wrap {border-width:'.$theme_options["border_slideshow_size"].'px} ';
  echo 'div.slideshow-wrap {border-color:#'.$theme_options["border_slideshow_color"].'} ';
  echo 'div.slideshow-wrap {border-style:'.$theme_options["border_slideshow_style"].'} ';
}
}
}

if ($theme_options["border_slideshow_thumbs_size"] != "") {
if ($theme_options["border_slideshow_thumbs_style"] != "") {
if ($theme_options["border_slideshow_thumbs_color"] != "") {
  echo 'div.slideshow-thumbs .slides a {border-width:'.$theme_options["border_slideshow_thumbs_size"].'px} ';
  echo 'div.slideshow-thumbs .slides a {border-color:#'.$theme_options["border_slideshow_thumbs_color"].'} ';
  echo 'div.slideshow-thumbs .slides a {border-style:'.$theme_options["border_slideshow_thumbs_style"].'} ';
}
}
}


if ($theme_options["font_footer"] != "") {
  if ($theme_options["font_footer"] == "trebuchet") {
	echo '#footer, .bottom, .bottom li, .bottom textarea, .bottom input {font-family: '.$font_css_footer_c.'"Trebuchet MS", "Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
  } else if ($theme_options["font_footer"] == "lucida") {
	echo '#footer, .bottom, .bottom li, .bottom textarea, .bottom input {font-family: '.$font_css_footer_c.'"Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
  } else if ($theme_options["font_footer"] == "sans") {
	echo '#footer, .bottom, .bottom li, .bottom textarea, .bottom input {font-family: '.$font_css_footer_c.'Arial, Helvetica, Verdana, Sans-Serif;} ';
  } else if ($theme_options["font_footer"] == "serif") {
	echo '#footer, .bottom, .bottom li, .bottom textarea, .bottom input {font-family: '.$font_css_footer_c.'"Georgia", "Garamond", "Times New Roman", Serif;} ';
  } else {
	echo '#footer, .bottom, .bottom li, .bottom textarea, .bottom input {font-family: '.$font_css_footer_c.$GLOBALS['ppp_fonts'][$theme_options["font_footer"]].';} ';
  }
}

echo '#footer, .bottom, .bottom li {font-variant:normal; text-transform:none;} ';
if ($theme_options["footer_text_style"] == "upper") {
  echo '#footer, .bottom, .bottom li {text-transform:uppercase;} ';
} else if ($theme_options["footer_text_style"] == "lower") {
  echo '#footer, .bottom, .bottom li {text-transform:lowercase;} ';
} else if ($theme_options["footer_text_style"] == "smallcaps") {
  echo '#footer, .bottom, .bottom li {font-variant: small-caps;} ';
}

echo '#footer, .bottom, .bottom li {text-shadow:none;} ';
if ($theme_options["footer_text_shadow"] == "soft") {
  echo '#footer, .bottom, .bottom li {'.ppp_textshadow_softshadow().'} ';
} else if ($theme_options["footer_text_shadow"] == "drop") {
  echo '#footer, .bottom, .bottom li {'.ppp_textshadow_dropshadow().'} ';
} else if ($theme_options["footer_text_shadow"] == "letter") {
  echo '#footer, .bottom, .bottom li {'.ppp_textshadow_letterpress().'} ';
} else if ($theme_options["footer_text_shadow"] == "letterdk") {
  echo '#footer, .bottom, .bottom li {'.ppp_textshadow_letterpress_dk().'} ';
}


if ($theme_options["font_content"] != "") {
  if ($theme_options["font_content"] == "trebuchet") {
	echo '#content, #content textarea, #content input, #colorbox {font-family: '.$font_css_content_c.'"Trebuchet MS", "Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
  } else if ($theme_options["font_content"] == "lucida") {
	echo '#content, #content textarea, #content input, #colorbox {font-family: '.$font_css_content_c.'"Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
  } else if ($theme_options["font_content"] == "sans") {
	echo '#content, #content textarea, #content input, #colorbox {font-family: '.$font_css_content_c.'Arial, Helvetica, Verdana, Sans-Serif;} ';
  } else if ($theme_options["font_content"] == "serif") {
	echo '#content, #content textarea, #content input, #colorbox {font-family: '.$font_css_content_c.'"Georgia", "Garamond", "Times New Roman", Serif;} ';
  } else {
	echo '#content, #content textarea, #content input, #colorbox {font-family: '.$font_css_content_c.$GLOBALS['ppp_fonts'][$theme_options["font_content"]].';} ';
  }
}
if ($theme_options["content_text_style"] != "") {
  echo '#content, #colorbox {font-variant: normal;} ';
  if ($theme_options["content_text_style"] == "upper") {
	echo '#content, #colorbox {text-transform:uppercase;} ';
  } else if ($theme_options["content_text_style"] == "lower") {
	echo '#content, #colorbox {text-transform:lowercase;} ';
  } else if ($theme_options["content_text_style"] == "smallcaps") {
	echo '#content, #colorbox {font-variant: small-caps;} ';
  }
}
echo '#content, #colorbox {text-shadow:none;} ';
if (isset($theme_options["content_text_shadow"])) {
  if ($theme_options["content_text_shadow"] == "soft") {
	echo '#content, #colorbox {'.ppp_textshadow_softshadow().'} ';
  } else if ($theme_options["content_text_shadow"] == "drop") {
	echo '#content, #colorbox {'.ppp_textshadow_dropshadow().'} ';
  } else if ($theme_options["content_text_shadow"] == "letter") {
	echo '#content, #colorbox {'.ppp_textshadow_letterpress().'} ';
  } else if ($theme_options["content_text_shadow"] == "letterdk") {
	echo '#content, #colorbox {'.ppp_textshadow_letterpress_dk().'} ';
  }
}



if ($theme_options["font_h1"] != "") {
  if ($theme_options["font_h1"] == "trebuchet") {
	echo 'h1, h2, h3, h4, h5, h6, .description {font-family: '.$font_css_h1_c.'"Trebuchet MS", "Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
  } else if ($theme_options["font_h1"] == "lucida") {
	echo 'h1, h2, h3, h4, h5, h6, .description {font-family: '.$font_css_h1_c.'"Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
  } else if ($theme_options["font_h1"] == "sans") {
	echo 'h1, h2, h3, h4, h5, h6, .description {font-family: '.$font_css_h1_c.'Arial, Helvetica, Verdana, Sans-Serif;} ';
  } else if ($theme_options["font_h1"] == "serif") {
	echo 'h1, h2, h3, h4, h5, h6, .description {font-family: '.$font_css_h1_c.'"Georgia", "Garamond", "Times New Roman", Serif;} ';
  } else {
	echo 'h1, h2, h3, h4, h5, h6, .description {font-family: '.$font_css_h1_c.$GLOBALS['ppp_fonts'][$theme_options["font_h1"]].';} ';
  }
}
if ($theme_options["h1_text_style"] != "") {
  echo 'h1, h2, h3, h4, h5, h6, .description {font-variant:normal; text-transform:none;} ';
  if ($theme_options["h1_text_style"] == "upper") {
	echo 'h1, h2, h3, h4, h5, h6, .description {text-transform:uppercase;} ';
  } else if ($theme_options["h1_text_style"] == "lower") {
	echo 'h1, h2, h3, h4, h5, h6, .description {text-transform:lowercase;} ';
  } else if ($theme_options["h1_text_style"] == "smallcaps") {
	echo 'h1, h2, h3, h4, h5, h6, .description {font-variant: small-caps;} ';
  }
}
echo 'h1, h2, h3, h4, h5, h6, .description {text-shadow:none;} ';
if (isset($theme_options["h1_text_shadow"])) {
  if ($theme_options["h1_text_shadow"] == "soft") {
	echo 'h1, h2, h3, h4, h5, h6, .description {'.ppp_textshadow_softshadow().'} ';
  } else if ($theme_options["h1_text_shadow"] == "drop") {
	echo 'h1, h2, h3, h4, h5, h6, .description {'.ppp_textshadow_dropshadow().'} ';
  } else if ($theme_options["h1_text_shadow"] == "letter") {
	echo 'h1, h2, h3, h4, h5, h6, .description {'.ppp_textshadow_letterpress().'} ';
  } else if ($theme_options["h1_text_shadow"] == "letterdk") {
	echo 'h1, h2, h3, h4, h5, h6, .description {'.ppp_textshadow_letterpress_dk().'} ';
  }
}


/* Subtitles */
if ($theme_options["sub_text_style"] != "") {
  echo '#content p.subtitle {font-variant: normal;} ';
  if ($theme_options["sub_text_style"] == "upper") {
	echo '#content p.subtitle {text-transform:uppercase;} ';
  } else if ($theme_options["sub_text_style"] == "lower") {
	echo '#content p.subtitle {text-transform:lowercase;} ';
  } else if ($theme_options["sub_text_style"] == "smallcaps") {
	echo '#content p.subtitle {font-variant: small-caps;} ';
  }
}
echo '#content p.subtitle {text-shadow:none;} ';
if (isset($theme_options["sub_text_shadow"])) {
  if ($theme_options["sub_text_shadow"] == "soft") {
	echo '#content p.subtitle {'.ppp_textshadow_softshadow().'} ';
  } else if ($theme_options["sub_text_shadow"] == "drop") {
	echo '#content p.subtitle {'.ppp_textshadow_dropshadow().'} ';
  } else if ($theme_options["sub_text_shadow"] == "letter") {
	echo '#content p.subtitle {'.ppp_textshadow_letterpress().'} ';
  } else if ($theme_options["sub_text_shadow"] == "letterdk") {
	echo '#content p.subtitle {'.ppp_textshadow_letterpress_dk().'} ';
  }
}


if ($theme_options["font_sub"] != "") {
  if ($theme_options["font_sub"] == "trebuchet") {
	echo '#content p.subtitle {font-family: '.$font_css_sub_c.'"Trebuchet MS", "Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
  } else if ($theme_options["font_sub"] == "lucida") {
	echo '#content p.subtitle {font-family: '.$font_css_sub_c.'"Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
  } else if ($theme_options["font_sub"] == "sans") {
	echo '#content p.subtitle {font-family: '.$font_css_sub_c.'Arial, Helvetica, Verdana, Sans-Serif;} ';
  } else if ($theme_options["font_sub"] == "serif") {
	echo '#content p.subtitle {font-family: '.$font_css_sub_c.'"Georgia", "Garamond", "Times New Roman", Serif;} ';
  } else {
	echo '#content p.subtitle {font-family: '.$font_css_sub_c.$GLOBALS['ppp_fonts'][$theme_options["font_sub"]].';} ';
  }  
}

/* Slideshow */
if ($theme_options["font_slideshow_content"] != "") {
  if ($theme_options["font_slideshow_content"] == "trebuchet") {
	echo 'div.ppp-slideshow-text {font-family: '.$font_css_slideshow_content.'"Trebuchet MS", "Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
  } else if ($theme_options["font_slideshow_content"] == "lucida") {
	echo 'div.ppp-slideshow-text {font-family: '.$font_css_slideshow_content.'"Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
  } else if ($theme_options["font_slideshow_content"] == "sans") {
	echo 'div.ppp-slideshow-text {font-family: '.$font_css_slideshow_content.'Arial, Helvetica, Verdana, Sans-Serif;} ';
  } else if ($theme_options["font_slideshow_content"] == "serif") {
	echo 'div.ppp-slideshow-text {font-family: '.$font_css_slideshow_content.'"Georgia", "Garamond", "Times New Roman", Serif;} ';
  } else {
	echo 'div.ppp-slideshow-text {font-family: '.$font_css_slideshow_content.$GLOBALS['ppp_fonts'][$theme_options["font_slideshow_content"]].';} ';
  }
}
if ($theme_options["slideshow_content_text_style"] != "") {
  echo 'div.ppp-slideshow-text {font-variant: normal;} ';
  if ($theme_options["slideshow_content_text_style"] == "upper") {
	echo 'div.ppp-slideshow-text {text-transform:uppercase;} ';
  } else if ($theme_options["slideshow_content_text_style"] == "lower") {
	echo 'div.ppp-slideshow-text {text-transform:lowercase;} ';
  } else if ($theme_options["slideshow_content_text_style"] == "smallcaps") {
	echo 'div.ppp-slideshow-text {font-variant: small-caps;} ';
  }
}

echo 'div.ppp-slideshow-text {text-shadow:none;} ';
if (isset($theme_options["slideshow_content_text_shadow"])) {
  if ($theme_options["slideshow_content_text_shadow"] == "soft") {
	echo 'div.ppp-slideshow-text {'.ppp_textshadow_softshadow().'} ';
  } else if ($theme_options["slideshow_content_text_shadow"] == "drop") {
	echo 'div.ppp-slideshow-text {'.ppp_textshadow_dropshadow().'} ';
  } else if ($theme_options["slideshow_content_text_shadow"] == "letter") {
	echo 'div.ppp-slideshow-text {'.ppp_textshadow_letterpress().'} ';
  } else if ($theme_options["slideshow_content_text_shadow"] == "letterdk") {
	echo 'div.ppp-slideshow-text {'.ppp_textshadow_letterpress_dk().'} ';
  }
}


if ($theme_options["fontsize_footer"] != "") {
  if ($theme_options["fontsize_footer"] == "small") {
	echo '.bottom {font-size:12px;} ';
  } else if ($theme_options["fontsize_footer"] == "large") {
	echo '.bottom {font-size:16px;} ';
  } else {
	echo '.bottom {font-size:14px;} ';
  }
}
if ($theme_options["fontsize_footer_user"] != "" && $theme_options["fontsize_footer"] == "custom") {
	echo '.bottom {font-size:'.$theme_options["fontsize_footer_user"].'px;} ';
}


if ($theme_options["fontsize_h1"] != "") {
  if ($theme_options["fontsize_h1"] == "small") {
	echo '#content h1 {font-size:21px;} h2 {font-size:18px;} h3 {font-size:16px;} h4 {font-size:14px;} h5 {font-size:12px;} ';
  } else if ($theme_options["fontsize_h1"] == "large") {
	echo '#content h1 {font-size:32px;} h2 {font-size:28px;} h3 {font-size:24px;} h4 {font-size:20px;} h5 {font-size:16px;} ';
  }
}
if ($theme_options["fontsize_h1_user"] != "" && $theme_options["fontsize_h1"] == "custom") {
	$f_h2 = $theme_options["fontsize_h1_user"];
	$f_h3 = intval(intval($theme_options["fontsize_h1_user"])*0.9);
	$f_h4 = intval(intval($theme_options["fontsize_h1_user"])*0.8);
	$f_h5 = intval(intval($theme_options["fontsize_h1_user"])*0.7);
	echo '#content h1 {font-size:'.$f_h2.'px;} h2 {font-size:'.$f_h2.'px;} h3 {font-size:'.$f_h3.'px;} h4 {font-size:'.$f_h4.'px;} h5 {font-size:'.$f_h5.'px;}
 ';
}

if ($theme_options["fontsize_content"] != "") {
  if ($theme_options["fontsize_content"] == "small") {
	echo '#content p {font-size: 12px;} #content .timestamp {font-size:12px;} ';
  } else if ($theme_options["fontsize_content"] == "large") {
	echo '#content p {font-size: 16px;} #content .timestamp {font-size:16px;} ';
  }
}
if ($theme_options["fontsize_content_user"] != "" && $theme_options["fontsize_content"] == "custom") {
	echo '#content p {font-size: '.$theme_options["fontsize_content_user"].'px;} #content .timestamp {font-size:'.$theme_options["fontsize_content_user"].'px;} ';
}


if ($theme_options["fontsize_sub"] != "") {
  if ($theme_options["fontsize_sub"] == "small") {
	echo '#content p.subtitle {font-size: 10px;} ';
  } else if ($theme_options["fontsize_sub"] == "large") {
	echo '#content p.subtitle {font-size: 14px;} ';
  }
}
if ($theme_options["fontsize_sub_user"] != "" && $theme_options["fontsize_sub"] == "custom") {
	echo '#content p.subtitle {font-size: '.$theme_options["fontsize_sub_user"].'px;} ';
}

/* Slideshow */
if ($theme_options["fontsize_slideshow_content"] != "") {
  if ($theme_options["fontsize_slideshow_content"] == "small") {
	echo 'div.slideshow-text-inner {font-size: 12px;} ';
  } else if ($theme_options["fontsize_slideshow_content"] == "large") {
	echo 'div.slideshow-text-inner {font-size: 16px;} ';
  }
}
if ($theme_options["fontsize_slideshow_content_user"] != "" && $theme_options["fontsize_slideshow_content"] == "custom") {
	echo 'div.slideshow-text-inner {font-size: '.$theme_options["fontsize_slideshow_content_user"].'px;} ';
}


/* Sidebar Text */
if ($theme_options["font_sidebar_text"] != "") {
  if ($theme_options["font_sidebar_text"] == "trebuchet") {
	echo 'div.ppp_widget_sidebar {font-family: '.$font_css_sidebar_text.'"Trebuchet MS", "Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
  } else if ($theme_options["font_sidebar_text"] == "lucida") {
	echo 'div.ppp_widget_sidebar {font-family: '.$font_css_sidebar_text.'"Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
  } else if ($theme_options["font_sidebar_text"] == "sans") {
	echo 'div.ppp_widget_sidebar {font-family: '.$font_css_sidebar_text.'Arial, Helvetica, Verdana, Sans-Serif;} ';
  } else if ($theme_options["font_sidebar_text"] == "serif") {
	echo 'div.ppp_widget_sidebar {font-family: '.$font_css_sidebar_text.'"Georgia", "Garamond", "Times New Roman", Serif;} ';
  } else {
	echo 'div.ppp_widget_sidebar {font-family: '.$font_css_sidebar_text.$GLOBALS['ppp_fonts'][$theme_options["font_sidebar_text"]].';} ';
  }
}
if ($theme_options["sidebar_text_text_style"] != "") {
  echo 'div.ppp_widget_sidebar {font-variant: normal;} ';
  if ($theme_options["sidebar_text_text_style"] == "upper") {
	echo 'div.ppp_widget_sidebar {text-transform:uppercase;} ';
  } else if ($theme_options["sidebar_text_text_style"] == "lower") {
	echo 'div.ppp_widget_sidebar {text-transform:lowercase;} ';
  } else if ($theme_options["sidebar_text_text_style"] == "smallcaps") {
	echo 'div.ppp_widget_sidebar {font-variant: small-caps;} ';
  }
}

echo 'div.ppp_widget_sidebar {text-shadow:none;} ';
if (isset($theme_options["sidebar_text_text_shadow"])) {
  if ($theme_options["sidebar_text_text_shadow"] == "soft") {
	echo 'div.ppp_widget_sidebar {'.ppp_textshadow_softshadow().'} ';
  } else if ($theme_options["sidebar_text_text_shadow"] == "drop") {
	echo 'div.ppp_widget_sidebar {'.ppp_textshadow_dropshadow().'} ';
  } else if ($theme_options["sidebar_text_text_shadow"] == "letter") {
	echo 'div.ppp_widget_sidebar {'.ppp_textshadow_letterpress().'} ';
  } else if ($theme_options["sidebar_text_text_shadow"] == "letterdk") {
	echo 'div.ppp_widget_sidebar {'.ppp_textshadow_letterpress_dk().'} ';
  }
}


if ($theme_options["fontsize_sidebar_text"] != "") {
  if ($theme_options["fontsize_sidebar_text"] == "small") {
	echo 'div.ppp_widget_sidebar {font-size: 12px;} ';
  } else if ($theme_options["fontsize_sidebar_text"] == "large") {
	echo 'div.ppp_widget_sidebar {font-size: 16px;} ';
  }
}
if ($theme_options["fontsize_sidebar_text_user"] != "" && $theme_options["fontsize_sidebar_text"] == "custom") {
	echo 'div.ppp_widget_sidebar {font-size: '.$theme_options["fontsize_sidebar_text_user"].'px;} ';
}


/* Sidebar Titles */
if ($theme_options["font_sidebar_h1"] != "") {
  if ($theme_options["font_sidebar_h1"] == "trebuchet") {
	echo 'div.ppp_widget_sidebar h2 {font-family: '.$font_css_sidebar_h1.'"Trebuchet MS", "Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
  } else if ($theme_options["font_sidebar_h1"] == "lucida") {
	echo 'div.ppp_widget_sidebar h2 {font-family: '.$font_css_sidebar_h1.'"Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
  } else if ($theme_options["font_sidebar_h1"] == "sans") {
	echo 'div.ppp_widget_sidebar h2 {font-family: '.$font_css_sidebar_h1.'Arial, Helvetica, Verdana, Sans-Serif;} ';
  } else if ($theme_options["font_sidebar_h1"] == "serif") {
	echo 'div.ppp_widget_sidebar h2 {font-family: '.$font_css_sidebar_h1.'"Georgia", "Garamond", "Times New Roman", Serif;} ';
  } else {
	echo 'div.ppp_widget_sidebar h2 {font-family: '.$font_css_sidebar_h1.$GLOBALS['ppp_fonts'][$theme_options["font_sidebar_h1"]].';} ';
  }
}
if ($theme_options["sidebar_h1_text_style"] != "") {
  echo 'div.ppp_widget_sidebar h2 {font-variant: normal;} ';
  if ($theme_options["sidebar_h1_text_style"] == "upper") {
	echo 'div.ppp_widget_sidebar h2 {text-transform:uppercase;} ';
  } else if ($theme_options["sidebar_h1_text_style"] == "lower") {
	echo 'div.ppp_widget_sidebar h2 {text-transform:lowercase;} ';
  } else if ($theme_options["sidebar_h1_text_style"] == "smallcaps") {
	echo 'div.ppp_widget_sidebar h2 {font-variant: small-caps;} ';
  }
}

echo 'div.ppp_widget_sidebar h2 {text-shadow:none;} ';
if (isset($theme_options["sidebar_h1_text_shadow"])) {
  if ($theme_options["sidebar_h1_text_shadow"] == "soft") {
	echo 'div.ppp_widget_sidebar h2 {'.ppp_textshadow_softshadow().'} ';
  } else if ($theme_options["sidebar_h1_text_shadow"] == "drop") {
	echo 'div.ppp_widget_sidebar h2 {'.ppp_textshadow_dropshadow().'} ';
  } else if ($theme_options["sidebar_h1_text_shadow"] == "letter") {
	echo 'div.ppp_widget_sidebar h2 {'.ppp_textshadow_letterpress().'} ';
  } else if ($theme_options["sidebar_h1_text_shadow"] == "letterdk") {
	echo 'div.ppp_widget_sidebar h2 {'.ppp_textshadow_letterpress_dk().'} ';
  }
}

if ($theme_options["fontsize_sidebar_h1"] != "") {
  if ($theme_options["fontsize_sidebar_h1"] == "small") {
	echo 'div.ppp_widget_sidebar h2 {font-size: 18px;} ';
  } else if ($theme_options["fontsize_sidebar_h1"] == "large") {
	echo 'div.ppp_widget_sidebar h2 {font-size: 28px;} ';
  }
}

if ($theme_options["fontsize_sidebar_h1_user"] != "" && $theme_options["fontsize_sidebar_h1"] == "custom") {
	echo 'div.ppp_widget_sidebar h2 {font-size: '.$theme_options["fontsize_sidebar_h1_user"].'px;} ';
}


/* Footer Titles */
if (isset($theme_options["font_footer_h1"])) {
  if ($theme_options["font_footer_h1"] == "trebuchet") {
	echo '.bottom h2 {font-family: '.$font_css_footer_h1.'"Trebuchet MS", "Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
  } else if ($theme_options["font_footer_h1"] == "lucida") {
	echo '.bottom h2 {font-family: '.$font_css_footer_h1.'"Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
  } else if ($theme_options["font_footer_h1"] == "sans") {
	echo '.bottom h2 {font-family: '.$font_css_footer_h1.'Arial, Helvetica, Verdana, Sans-Serif;} ';
  } else if ($theme_options["font_footer_h1"] == "serif") {
	echo '.bottom h2 {font-family: '.$font_css_footer_h1.'"Georgia", "Garamond", "Times New Roman", Serif;} ';
  } else {
	echo '.bottom h2 {font-family: '.$font_css_footer_h1.$GLOBALS['ppp_fonts'][$theme_options["font_footer_h1"]].';} ';
  }
}

echo '.bottom h2 {font-variant: normal;} ';
if ($theme_options["footer_h1_text_style"] == "upper") {
  echo '.bottom h2 {text-transform:uppercase;} ';
} else if ($theme_options["footer_h1_text_style"] == "lower") {
  echo '.bottom h2 {text-transform:lowercase;} ';
} else if ($theme_options["footer_h1_text_style"] == "smallcaps") {
  echo '.bottom h2 {font-variant: small-caps;} ';
}

echo '.bottom h2 {text-shadow:none;} ';
if ($theme_options["footer_h1_text_shadow"] == "soft") {
  echo '.bottom h2 {'.ppp_textshadow_softshadow().'} ';
} else if ($theme_options["footer_h1_text_shadow"] == "drop") {
  echo '.bottom h2 {'.ppp_textshadow_dropshadow().'} ';
} else if ($theme_options["footer_h1_text_shadow"] == "letter") {
  echo '.bottom h2 {'.ppp_textshadow_letterpress().'} ';
} else if ($theme_options["footer_h1_text_shadow"] == "letterdk") {
  echo '.bottom h2 {'.ppp_textshadow_letterpress_dk().'} ';
}

if ($theme_options["fontsize_footer_h1"] == "small") {
  echo '.bottom h2 {font-size: 18px;} ';
} else if ($theme_options["fontsize_footer_h1"] == "large") {
  echo '.bottom h2 {font-size: 28px;} ';
}
if (isset($theme_options["fontsize_footer_h1_user"]) && $theme_options["fontsize_footer_h1"] == "custom") {
	echo '.bottom h2 {font-size: '.$theme_options["fontsize_footer_h1_user"].'px;} ';
}


/* Comments */
if ($theme_options["comments_width"] != "") {

//	if (((is_page() && (is_page_template('page-2columns.php') || is_page_template('index-2columns.php')) 
//	|| (ppp_get_option("sidebar_hide_show")=='show')))
	if (intval($theme_options["comments_width"]) > $max_w) {
		$theme_options["comments_width"] = $max_w;
	}

	echo '
	.wp-comments, div.awpcomments ol.commentlist {width:'.$theme_options["comments_width"].'px}
	.respond textarea.comment {width:'.(($theme_options["comments_width"]-12)-($theme_options["border_commentform_size"]*2)).'px}
';

}

if ($theme_options["comments_height"] != "") {
	echo '.wp-comments ul.commentlist, .awpcomments ol.commentlist {max-height:'.$theme_options["comments_height"].'px; _height:'.$theme_options["comments_height"].'px; overflow-y:auto;} ';
}

if ($theme_options["comments_bg_color"] != "") {
  echo '.wp-comments ul.commentlist, .awpcomments ol.commentlist {background-color:#'.$theme_options["comments_bg_color"].'} ';
}
if ($theme_options["comment_bg_color"] != "") {
  echo '.wp-comments ul.commentlist li, .awpcomments ol.commentlist li {background-color:#'.$theme_options["comment_bg_color"].'} ';
}
if ($theme_options["comment_odd_bg_color"] != "") {
  echo '.wp-comments ul.commentlist li.alt, .awpcomments ol.commentlist li.alt {background-color:#'.$theme_options["comment_odd_bg_color"].'} ';
}
if ($theme_options["comment_author_bg_color"] != "") {
  echo '.wp-comments ul.commentlist li.bypostauthor, .awpcomments ol.commentlist li.bypostauthor {background-color:#'.$theme_options["comment_author_bg_color"].'} ';
}

if ($theme_options["comment_content_color"] != "") {
  echo '
  .wp-comments ul.commentlist li, .awpcomments ol.commentlist li {color:#'.$theme_options["comment_content_color"].'} ';
}
if ($theme_options["comment_odd_content_color"] != "") {
  echo '.wp-comments ul.commentlist li.alt, .awpcomments ol.commentlist li.alt {color:#'.$theme_options["comment_odd_content_color"].'} ';
}
if ($theme_options["comment_author_content_color"] != "") {
  echo '.wp-comments ul.commentlist li.bypostauthor, .awpcomments ol.commentlist li.bypostauthor {color:#'.$theme_options["comment_author_content_color"].'} ';
  echo '.wp-comments ul.commentlist li.bypostauthor.alt, .awpcomments ol.commentlist li.bypostauthor.alt {color:#'.$theme_options["comment_author_content_color"].'} ';
}

if ($theme_options["comment_a_color"] != "") {
  echo '.wp-comments ul.commentlist li a, .awpcomments ol.commentlist li a {color:#'.$theme_options["comment_a_color"].'} ';
}
if ($theme_options["comment_odd_a_color"] != "") {
  echo '.wp-comments ul.commentlist li.alt a, .awpcomments ol.commentlist li.alt a {color:#'.$theme_options["comment_odd_a_color"].'} ';
}
if ($theme_options["comment_author_a_color"] != "") {
  echo '.wp-comments ul.commentlist li.bypostauthor a, .awpcomments ol.commentlist li.bypostauthor a {color:#'.$theme_options["comment_author_a_color"].'} ';
  echo '.wp-comments ul.commentlist li.bypostauthor.alt a, .awpcomments ol.commentlist li.bypostauthor.alt a {color:#'.$theme_options["comment_author_a_color"].'} ';
}

if ($theme_options["comment_a_hover"] != "") {
  echo '.wp-comments ul.commentlist li a:hover, .wp-comments ul.commentlist li a:visited {color:#'.$theme_options["comment_a_hover"].'} ';
  echo '.awpcomments ol.commentlist li a:hover, .awpcomments ol.commentlist li a:visited {color:#'.$theme_options["comment_a_hover"].'} ';
}
if ($theme_options["comment_odd_a_hover"] != "") {
  echo '.wp-comments ul.commentlist li.alt a:hover, .wp-comments ul.commentlist li.odd a:visited {color:#'.$theme_options["comment_odd_a_hover"].'} ';
  echo '.awpcomments ol.commentlist li.alt a:hover, .awpcomments ol.commentlist li.alt a:visited {color:#'.$theme_options["comment_odd_a_hover"].'} ';
}
if ($theme_options["comment_author_a_hover"] != "") {
  echo '.wp-comments ul.commentlist li.bypostauthor a:hover, .wp-comments ul.commentlist li.bypostauthor a:visited {color:#'.$theme_options["comment_author_a_hover"].'} ';
  echo '.awpcomments ol.commentlist li.bypostauthor a:hover, .awpcomments ol.commentlist li.bypostauthor a:visited {color:#'.$theme_options["comment_author_a_hover"].'} ';
  echo '.wp-comments ul.commentlist li.bypostauthor.alt a:hover, .wp-comments ul.commentlist li.bypostauthor.alt a:visited {color:#'.$theme_options["comment_author_a_hover"].'} ';
  echo '.awpcomments ol.commentlist li.bypostauthor.alt a:hover, .awpcomments ol.commentlist li.bypostauthor.alt a:visited {color:#'.$theme_options["comment_author_a_hover"].'} ';
}

if ($theme_options["border_comments_size"] != "") {
  echo '.wp-comments ul.commentlist, .awpcomments ol.commentlist {border-width:'.$theme_options["border_comments_size"].'px } ';
}
if ($theme_options["border_comments_color"] != "") {
  echo '.wp-comments ul.commentlist, .awpcomments ol.commentlist {border-color:#'.$theme_options["border_comments_color"].'} ';
}
if ($theme_options["border_comments_style"] != "") {
  echo '.wp-comments ul.commentlist, .awpcomments ol.commentlist {border-style:'.$theme_options["border_comments_style"].'} ';
}

if ($theme_options["border_comment_size"] != "") {
  echo '.wp-comments ul.commentlist li, .awpcomments ol.commentlist li {border-width:'.$theme_options["border_comment_size"].'px } ';
}
if ($theme_options["border_comment_color"] != "") {
  echo '.wp-comments ul.commentlist li, .awpcomments ol.commentlist li {border-color:#'.$theme_options["border_comment_color"].'} ';
}
if ($theme_options["border_comment_style"] != "") {
  echo '.wp-comments ul.commentlist li, .awpcomments ol.commentlist li {border-style:'.$theme_options["border_comment_style"].'} ';
}

if ($theme_options["border_odd_comments_size"] != "") {
  echo '.wp-comments ul.commentlist li.alt, .awpcomments ol.commentlist li.alt {border-width:'.$theme_options["border_odd_comments_size"].'px } ';
}
if ($theme_options["border_odd_comments_color"] != "") {
  echo '.wp-comments ul.commentlist li.alt, .awpcomments ol.commentlist li.alt {border-color:#'.$theme_options["border_odd_comments_color"].'} ';
}
if ($theme_options["border_odd_comments_style"] != "") {
  echo '.wp-comments ul.commentlist li.alt, .awpcomments ol.commentlist li.alt {border-style:'.$theme_options["border_odd_comments_style"].'} ';
}

if ($theme_options["border_author_comments_size"] != "") {
  echo '.wp-comments ul.commentlist li.author, .awpcomments ol.commentlist li.author {border-width:'.$theme_options["border_author_comments_size"].'px } ';
}
if ($theme_options["border_author_comments_color"] != "") {
  echo '.wp-comments ul.commentlist li.author, .awpcomments ol.commentlist li.author {border-color:#'.$theme_options["border_author_comments_color"].'} ';
}
if ($theme_options["border_author_comments_style"] != "") {
  echo '.wp-comments ul.commentlist li.author, .awpcomments ol.commentlist li.author {border-style:'.$theme_options["border_author_comments_style"].'} ';
}

/* Comment form */
if ($theme_options["comment_form_height"] != "") {
  echo '.respond textarea.comment {height:'.$theme_options["comment_form_height"].'px; } ';
}
if ($theme_options["comment_form_placement"] != "" && $theme_options["comment_form_placement"] != "below") {
    echo '.wp-comments {width:'.($max_w-24).'px;} 
		  .respond textarea.comment {width:300px;} ';
    echo '.wp-comments div.wp-commentlist, div.awpcomments ol.commentlist {width:'.($max_w-360).'px;} ';
    echo '.commentsection_div, div.commentform { width:316px; float:left;} ';
  if ($theme_options["comment_form_placement"] == "left") {
    echo '.commentsection_div, div.commentform { margin:0 20px 20px 0; } ';
    echo '.wp-comments div.wp-commentlist, div.awpcomments ol.commentlist {float:right;} ';
  } else if ($theme_options["comment_form_placement"] == "right") {
    echo '.commentsection_div, div.commentform { margin:0 0 20px 20px; } ';
    echo '.wp-comments div.wp-commentlist, div.awpcomments ol.commentlist {float:left;} ';
  }
}

/*
 Comment form settings since 2.0+
*/
if ($theme_options["border_commentform_color"] != "" &&
    $theme_options["border_commentform_style"] != "" &&
	$theme_options["border_commentform_size"] != "") {
    echo '#content .respond input, #content .respond textarea, #content .respond input#submit {border:#'.$theme_options["border_commentform_color"].' '.$theme_options["border_commentform_style"].' '.$theme_options["border_commentform_size"].'px; } ';
}
if ($theme_options["commentform_bg_color"] != "") {
  echo '#content .respond input, #content .respond textarea, #content .respond input#submit {background:#'.$theme_options["commentform_bg_color"].'} ';
} else {
  echo '#content .respond textarea, #content .respond input, #content .respond input#submit {background:#'.$theme_options["content_bg_color"].'} ';
}
if ($theme_options["commentform_color"] != "") {
  echo '#content .respond textarea, #content .respond input, #content .respond input#submit {color:#'.$theme_options["commentform_color"].'} ';
}


if (!get_option('require_name_email')) {
 echo '.comment_author_req {display:none; } ';
 if ($theme_options["comments_name"] == 0) {
  echo '.comment_author {display:none; } ';
 }

 echo '.comment_email_req {display:none; } ';
 if ($theme_options["comments_email"] == 0) {
  echo '.comment_email {display:none; } ';
 }
}
if ($theme_options["comments_www"] == 0) {
 echo '.comment_www {display:none; } ';
}
if ($theme_options["comments_show_avatar"] == 0) {
 echo 'img.avatar {display:none; } ';
 echo '.comment-author {margin-left:10px; } ';
 echo '.comment-content {margin-left:10px; } ';
}
if ($theme_options["comments_hide_default_avatar"] == 1) {
 echo 'img.avatar-default {display:none; visibility:hidden;} ';
}

if ($theme_options["comments_inline"] == 1) {
 if ($theme_options["comments_open"] == "hidden") {
  echo '.wp-commentlist {display:none; } ';
 }
 if ($theme_options["comments_add_open"] == "hidden") {
  echo '.commentsection {display:none; } ';
 }
}


/* Navigation Menu */
if (function_exists('is_admin_bar_showing') && is_admin_bar_showing()) {
	$sidebar_top += 28;
}

echo '
#sidebar {top:'.$sidebar_top.'px} 
';

/* Transparency effects for the cool browsers on the block. */
if ($theme_options['menu_opacity'] != '') {
$menu_opacity = ($theme_options['menu_opacity'] * .01);
echo '
#sidebar>div{
	-moz-opacity: '.$menu_opacity.';/* for mozilla */
	opacity: '.$menu_opacity.'; /* for safari */
	khtml-opacity: '.$menu_opacity.' /* for konquerer and older safari */
}
#sidebar>ul{
	/* Attempts to fix IE results in broken sub-menus. Comment out for now. */
/*	-ms-filter:"progid:DXImageTransform.Microsoft.Alpha(Opacity='.$theme_options['menu_opacity'].')";
	filter: alpha(opacity='.$theme_options['menu_opacity'].');*/
}
';
}

if ($theme_options['font_menu'] == 'trebuchet') {
	echo '#sidebar ul, #sidebar ul textarea, #sidebar ul input {font-family: '.$font_css_menu_c.'"Trebuchet MS", "Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
} else if ($theme_options["font_menu"] == "lucida") {
	echo '#sidebar ul, #sidebar ul textarea, #sidebar ul input {font-family: '.$font_css_menu_c.'"Lucida Grande", "Lucida Sans Unicode", Tahoma, Verdana, Arial, Sans-Serif;} ';
} else if ($theme_options["font_menu"] == "sans") {
	echo '#sidebar ul, #sidebar ul textarea, #sidebar ul input {font-family: '.$font_css_menu_c.'Arial, Helvetica, Verdana, Sans-Serif;} ';
} else if ($theme_options["font_menu"] == "serif") {
	echo '#sidebar ul, #sidebar ul textarea, #sidebar ul input {font-family: '.$font_css_menu_c.'"Georgia", "Garamond", "Times New Roman", Serif;} ';
} else {
	echo '#sidebar ul, #sidebar ul textarea, #sidebar ul input {font-family: '.$font_css_menu_c.$GLOBALS['ppp_fonts'][$theme_options["font_menu"]].';} ';
}

if ($theme_options["fontsize_menu"] != "") {
  if ($theme_options["fontsize_menu"] == "small") {
	echo '#sidebar ul {font-size:12px; } ';
	echo '#sidebar li ul {font-size:11px; } ';
  } else if ($theme_options["fontsize_menu"] == "large") {
	echo '#sidebar ul {font-size:16px; line-height:16px;}';
	echo '#sidebar li ul {font-size:14px; } ';
  }
}
if ($theme_options["fontsize_menu_user"] != "" && $theme_options["fontsize_menu"] == "custom") {
	echo '#sidebar ul, #sidebar li ul {font-size:'.$theme_options["fontsize_menu_user"].'px; line-height:150%;}';
	echo '#sidebar ul {font-size:'.$theme_options["fontsize_menu_user"].'px; line-height:'.$theme_options["fontsize_menu_user"].'px;}';
	echo '#sidebar li ul {font-size:'.(intval($theme_options["fontsize_menu_user"])*0.8).'px; } ';
}


if ($theme_options["menutext_color"] != "") {
  echo '#sidebar, #sidebar h2, #sidebar a, .head_search input {color:#'.$theme_options["menutext_color"].'} #sidebar #wp-calendar a {color: #'.$theme_options["menutext_color"].'} ';
}

if ($theme_options["menu1_bg_color"] != "") {
  echo '#sidebar, #sidebar ul, #sidebar ul ul, #sidebar ul li, #sidebar #wp-calendar a, #sidebar ul li.menu_separator:hover, #sidebar ul li.head_right:hover, .head_search input {background:#'.$theme_options["menu1_bg_color"].'} ';
}
if ($theme_options["menu2_bg_color"] != "") {
  echo '#sidebar ul li:hover, #sidebar ul li ul li, #sidebar ul div {background:#'.$theme_options["menu2_bg_color"].'} .head_search input {border:solid 1px #'.$theme_options["menu2_bg_color"].'} ';
}
if ($theme_options["menu3_bg_color"] != "") {
  echo '#sidebar ul li ul li:hover, #sidebar ul li ul ul li, #sidebar ul ul div {background:#'.$theme_options["menu3_bg_color"].'} ';
}
if ($theme_options["menu4_bg_color"] != "") {
  echo '#sidebar ul li ul ul li:hover {background:#'.$theme_options["menu4_bg_color"].'} ';
}

if ($theme_options["menu_text_style"] != "") {
  echo '#sidebar ul {font-variant: normal;} ';
  if ($theme_options["menu_text_style"] == "upper") {
	echo '#sidebar ul {text-transform:uppercase;} ';
  } else if ($theme_options["menu_text_style"] == "lower") {
	echo '#sidebar ul {text-transform:lowercase;} ';
  } else if ($theme_options["menu_text_style"] == "smallcaps") {
	echo '#sidebar ul {font-variant: small-caps;} ';
  }
}

echo '#sidebar ul {text-shadow:none;} ';
if (isset($theme_options["menu_text_shadow"])) {
  if ($theme_options["menu_text_shadow"] == "soft") {
	echo '#sidebar ul {'.ppp_textshadow_softshadow().'} ';
  } else if ($theme_options["menu_text_shadow"] == "drop") {
	echo '#sidebar ul {'.ppp_textshadow_dropshadow().'} ';
  } else if ($theme_options["menu_text_shadow"] == "letter") {
	echo '#sidebar ul {'.ppp_textshadow_letterpress().'} ';
  } else if ($theme_options["menu_text_shadow"] == "letterdk") {
	echo '#sidebar ul {'.ppp_textshadow_letterpress_dk().'} ';
  }
}


if ($theme_options["menu_align"] != "") {
  if ($theme_options["menu_align"] == "left") {
	echo '
	#sidebar ul li.LargeMenu, #sidebar ul li.menu_separator {float:left; margin-top:0; top:0;} 
	';
  } else if ($theme_options["menu_align"] == "center") {
	echo '
	#sidebar {text-align:center;}
	#sidebar ul li.LargeMenu, #sidebar ul li.menu_separator {display:inline-block;}
	#sidebar li.LargeMenu, #sidebar li.menu_separator {line-height:24px;}
	';
  } else {
	echo '
	#sidebar {text-align:right;}
	#sidebar ul.Menu, #sidebar ul.menu {float:right;}
	#sidebar ul li.LargeMenu, #sidebar li.menu_separator {float:left; top:0;} 
	#sidebar li.LargeMenu ul, #sidebar li.LargeMenu div {left:auto; right:0;}
#sidebar li li:hover ul, #sidebar li li:hover ul div, #sidebar li li:hover ul form#searchform {
	left:-160px;
}	
	';
  }
}


if ($theme_options["menu_height"] == "") {
	$theme_options["menu_height"] = "28";
}
if ($theme_options["menu_item_height"] == "") {
	$theme_options["menu_item_height"] = $theme_options["menu_height"];
}
echo '
#sidebar {
	height:'.$theme_options["menu_height"].'px;
}
';

echo '
#sidebar li.LargeMenu, #sidebar ul.MenuLeft li {
	line-height:'.$theme_options["menu_item_height"].'px;
}
#sidebar li.menu_separator, #sidebar li.head_right {
	line-height:'.$theme_options["menu_item_height"].'px;
} 
#sidebar li.menu_separator img, #sidebar li.head_right img {
	max-height:'.(intval($theme_options["menu_item_height"])-4).'px; 
	max-width:auto;
	margin-top:-4px;
} 

#sidebar li ul li, #sidebar li div, #sidebar li p {line-height:150%;}
';

if ($theme_options["menu_place"] == "top") {
  echo '
  /* Push the rest of the site down by the menu height. */
  #header {padding-top:'.$theme_options["menu_height"].'px;}
  ';
} else if ($theme_options["menu_place"] == "inbetween" && 
	      ($theme_options["header_img_flash"] == 'img_js' || $theme_options["header_img_flash"] == 'img_flash') &&
		  ($theme_options["header_layout"] == "t" || $theme_options["header_layout"] == "b")) {

	if ($theme_options["header_layout"] == "t") {
	  echo '
  /* Push the slideshow down by the menu height. */
  .header_slide {margin-top:'.$theme_options["menu_height"].'px;}
  ';
	} else if ($theme_options["header_layout"] == "b") {
	  echo '
  /* Push the header image down by the menu height. */
  #headerimg {margin-top:'.$theme_options["menu_height"].'px;}
  ';
	}
} else {
	echo '
	#content {margin-top:'.($theme_options["menu_height"]+12).'px; }';
}

/* About Me */

if ($theme_options["bio_image_height"] != "") {
	echo '
	#biopic {
		height:'.$theme_options["bio_image_height"].'px;
	}';
}
if ($theme_options["bio_image_width"] != "") {
	echo '
	#biopic {
		width:'.$theme_options["bio_image_width"].'px;
	}';
}

if ($theme_options["bio_img_align"] == "right") {
	echo '
	#biopic {
		float:right;
		margin-left:12px;
	}';
}

if ($theme_options["about_bg_color"] != "") {
  echo '#ppp_about {background:#'.$theme_options["about_bg_color"].'} ';
}

if ($theme_options["about_color"] != "") {
  echo '#ppp_about {color:#'.$theme_options["about_color"].'} ';
}

if ($theme_options["about_link_color"] != "") {
  echo '#content #ppp_about a {color:#'.$theme_options["about_link_color"].'} ';
}

if ($theme_options["border_about_size"] != "") {
  echo '#ppp_about {border-width:'.$theme_options["border_about_size"].'px } ';
}
if ($theme_options["border_about_color"] != "") {
  echo '#ppp_about {border-color:#'.$theme_options["border_about_color"].'} ';
}
if ($theme_options["border_about_style"] != "") {
  echo '#ppp_about {border-style:'.$theme_options["border_about_style"].'} ';
}

if ($theme_options["border_footitem_size"] != "") {
  echo '.bottom li h2, .bottom li li, .bottom li>div {border-bottom-width:'.$theme_options["border_footitem_size"].'px } ';

  if ($theme_options["border_footitem_color"] != "") {
    echo '.bottom li h2, .bottom li li, .bottom li>div {border-bottom-color:#'.$theme_options["border_footitem_color"].'} ';
  }
  if ($theme_options["border_footitem_style"] != "") {
    echo '.bottom li h2, .bottom li li, .bottom li>div {border-bottom-style:'.$theme_options["border_footitem_style"].'} ';
  }
}


/* Sidebar */
if (isset($theme_options["sidebar_bg_color"])) {
  echo '#content .two-columns-sidebar {background:#'.$theme_options["sidebar_bg_color"].' } ';
}
if (isset($theme_options["sidebar_color"])) {
  echo '#content .two-columns-sidebar {color:#'.$theme_options["sidebar_color"].' } ';
}
if (isset($theme_options["sidebar_h1_color"])) {
  echo '#content .two-columns-sidebar h1, #content .two-columns-sidebar h2, #content .two-columns-sidebar h3, 
  #content .two-columns-sidebar h4, #content .two-columns-sidebar h5, #content .two-columns-sidebar h6 {color:#'.$theme_options["sidebar_h1_color"].' } ';
}
if (isset($theme_options["sidebar_a_color"])) {
  echo '#content .two-columns-sidebar a {color:#'.$theme_options["sidebar_a_color"].' } ';
}

if (isset($theme_options["border_sidebar_size"]) &&
    isset($theme_options["border_sidebar_color"]) &&
	isset($theme_options["border_sidebar_style"])) {
  echo '#content .two-columns-sidebar {border-left:'.$theme_options["border_sidebar_size"].'px #'.$theme_options["border_sidebar_color"].' '.$theme_options["border_sidebar_style"].' } ';
  echo '#content .two-columns-sidebar {width:'.(300 - intval($theme_options["border_sidebar_size"])).'px } ';
  echo '#content .ppp_widget_sidebar_half {width:'.(150 - intval($theme_options["border_sidebar_size"])).'px } ';
  echo '#content .two-columns-sidebar input[type="text"], #content .two-columns-sidebar textarea {width:'.(268  - intval($theme_options["border_sidebar_size"])).'px !important} ';
  echo '#content .ppp_widget_sidebar_full div.searchbox input[type="text"] {width:'.(201 - intval($theme_options["border_sidebar_size"])).'px !important} ';
  echo '#content .ppp_widget_sidebar_half div.searchbox input[type="text"] {width:'.(51  - intval($theme_options["border_sidebar_size"])).'px !important} ';
}


/* Post Title Images */
echo '.post { position:relative; } .entry-title-wrap {  } ';
echo '.entry-title-subtitle { margin:0 auto; } ';
$pad = 'left';
if ($theme_options["img_thumb_align"] == 'left') {
  $pad = 'right';
}

echo '.entry-title-subtitle .ppp-img-thumb { float:'.$theme_options["img_thumb_align"].'; min-height:'.$theme_options["thumb_image_height"].'px; min-width:'.$theme_options["thumb_image_width"].'px; padding:6px 0; padding-'.$pad.':12px;} ';
echo '.entry-title-subtitle .ppp-img-thumb img { max-height:'.$theme_options["thumb_image_height"].'px; max-width:'.$theme_options["thumb_image_width"].'px; } ';
echo '.entry-title { clear:none; } ';

/* Give post titles a centered look */
if ($theme_options["align_h1"] == 'center') {
echo '
.entry-title-subtitle {
display:table;
margin:0 auto;
}
.entry-title-subtitle-inner {
display:inline-table;
}
';
if (($theme_options["img_thumb"] != "") && ($theme_options["display_image_thumb"] == 1)) {
echo '
#content h1.entry-title, #content h2.entry-title, #content p.subtitle {
display:table;
}
';
}
}

?>

-->
</style>

<!--[if IE ]>
	<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/code/css/ie.css" />
<![endif]-->

<!--[if lt IE 8]>
	<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/code/css/ie_6_7.css" />
<![endif]-->

<!--[if lt IE 7]>
	<style type="text/css" media="screen, tv, projection">
		body { behavior: url("<?php echo get_template_directory_uri(); ?>/code/css/csshover3.htc"); }
	</style>
<![endif]-->
<?php

/* Special handling of centered nav menu */
if ($theme_options["menu_align"] == "center") { ?>
<!--[if lt IE 8]>
	<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/code/css/ie_c.css" />
<![endif]-->
<?php } ?>

<!-- Import user style overrides -->
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/my.css" />
<?php if ($theme_options["css"] != "") { ?>
<style type="text/css">
<!--
<?php echo $theme_options["css"]; ?>
-->
</style>
<?php } ?>

<?php

if ($theme_options["header_img_flash"] == 'js' || $theme_options["header_img_flash"] == 'img_js') {
	ppp_get_header_images_css($slide_banner_height);
}

/* Disable right-click */
if ($theme_options["stop_thief"] == 1) {
wp_enqueue_script( 'ppp-context-menu', get_template_directory_uri() . '/code/js/stopthief.js' );
}

/* Script for toggling comments. */
if (!is_single() && ($theme_options["comments_inline"] == 1) && (($theme_options["comments_open"] != 'always') || ($theme_options["comments_add_open"] != 'always')))
{ 
wp_enqueue_script( 'ppp-toggle', get_template_directory_uri() . '/code/js/toggle.js' );
}

wp_head();

/* Run after scripts are loaded. */
if ($theme_options["stop_thief"] == 1) {
echo '

<script type="text/javascript">
jQuery(document).ready( function() {
ppp_stop_thief("'.$theme_options["rt_clk_text"].'");
});
</script>

';
}

if ($theme_options["header_img_flash"] == 'flash' || $theme_options["header_img_flash"] == 'img_flash') { ?>
	<script src="<?php echo get_template_directory_uri(); ?>/code/flashfader.js" type="text/javascript"></script>
<?php } else if ($theme_options["header_img_flash"] == 'js' || $theme_options["header_img_flash"] == 'img_js') { ?>
	<script src="<?php echo get_template_directory_uri(); ?>/code/slideshow.js" type="text/javascript"></script>
<?php } ?>
</head>


<body <?php body_class(); ?>>

<div id="outer_outer">

<div id="top-margin"></div>

<div id="outer_wrap">

<div id="top-border"></div>

<div id="header">

<?php

/* Custom Image Header */
if ($theme_options["header_layout"] == 't' &&
($theme_options["header_img_flash"] == 'img' || $theme_options["header_img_flash"] == 'img_js' || $theme_options["header_img_flash"] == 'img_flash')) {
?>
  <a href="<?php echo home_url(); ?>">
    <div id="headerimg">
      <h1><?php bloginfo('name'); ?></h1>
      <div class="description"><?php bloginfo('description'); ?></div>
    </div>
  </a>
<?php 
} 

/* Flashfader */
if ($theme_options["header_img_flash"] == 'flash' || $theme_options["header_img_flash"] == 'img_flash') {
?>
    <div id="flash_header" class="header_slide">
		<script type="text/javascript">flashfader('<?php echo home_url(); ?>','<?php echo $slide_banner_height; ?>');</script>
        <noscript><div><?php include (ABSPATH.'wp-content/flashfader/flashfaderhtml.txt'); ?></div></noscript>
        <h1 style="display:none;"><?php bloginfo('name'); ?></h1>
        <p style="display:none;" id="slogan"><?php bloginfo('description'); ?></p>
    </div>
<?php
}
/* Thanks, http://jonraasch.com/blog/a-simple-jquery-slideshow */
if ($theme_options["header_img_flash"] == 'js' || $theme_options["header_img_flash"] == 'img_js') {
$ssfade=$theme_options["header_img_time_fade"];
$ssrnd=$theme_options["header_img_rnd"];
$ssdisp1=intval(($theme_options["header_img_time_disp"] + $ssfade) *1000);
$ssdisp=intval($theme_options["header_img_time_disp"]*1000);
?>
    <div class="header_slide">
	<script type="text/javascript">
function ppp_hdr_setInterval() {
clearInterval(hdr_int);
setInterval( "slideSwitch('<?php echo $ssfade; ?>','<?php echo $ssrnd; ?>','hdr')", <?php echo $ssdisp1; ?>);
}
jQuery(document).ready( function() {
hdr_int = setInterval( "slideSwitch('<?php echo $ssfade; ?>','<?php echo $ssrnd; ?>','hdr')", <?php echo $ssdisp; ?> );
setTimeout( ppp_hdr_setInterval, <?php echo $ssdisp; ?> );
});
	</script>
    <h1 style="display:none;"><?php bloginfo('name'); ?></h1>
    <p style="display:none;" id="slogan"><?php bloginfo('description'); ?></p>
	<?php echo ppp_get_header_images($theme_options); ?>
    </div>
<?php 
}

/* Custom Image Header */
if ($theme_options["header_layout"] != 't' &&
($theme_options["header_img_flash"] == 'img' || $theme_options["header_img_flash"] == 'img_js' || $theme_options["header_img_flash"] == 'img_flash')) {
?>
  <a href="<?php echo home_url(); ?>">
    <div id="headerimg">
      <h1><?php bloginfo('name'); ?></h1>
      <div class="description"><?php bloginfo('description'); ?></div>
    </div>
  </a>
<?php
} 
?>

</div><!-- header -->

<div id="wrap">

<div id="ppp_after_header"></div>
