<?php

if ( function_exists('register_sidebar') )
{
	register_sidebar(array('name' => 'Drop-down menu',
		'before_widget' => '<li class="LargeMenu menu-item %s %s">',
		'after_widget' => '</li>',
		'before_title' => '<a class="ppp_widget_title_a"><span class="ppp_widget ppp_widget_title">',
		'after_title' => '</span></a>'));
	register_sidebar(array('name' => 'Footer left', 
		'before_widget' => '<li class="ppp_widget">',
		'after_widget' => '</li>',
		'before_title' => '<h2>',
		'after_title' => '</h2>'));
	register_sidebar(array('name' => 'Footer center', 
		'before_widget' => '<li class="ppp_widget">',
		'after_widget' => '</li>',
		'before_title' => '<h2>',
		'after_title' => '</h2>'));
	register_sidebar(array('name' => 'Footer right', 
		'before_widget' => '<li class="ppp_widget">',
		'after_widget' => '</li>',
		'before_title' => '<h2>',
		'after_title' => '</h2>'));
	register_sidebar(array('name' => 'Sidebar Full Width Top', 
		'before_widget' => '<div class="ppp_widget ppp_widget_sidebar">',
		'after_widget' => '</div>',
		'before_title' => '<h2 class="ppp_widget_sidebar_title">',
		'after_title' => '</h2>'));
	register_sidebar(array('name' => 'Sidebar Half Width Left', 
		'before_widget' => '<div class="ppp_widget ppp_widget_sidebar">',
		'after_widget' => '</div>',
		'before_title' => '<h2 class="ppp_widget_sidebar_title">',
		'after_title' => '</h2>'));
	register_sidebar(array('name' => 'Sidebar Half Width Right', 
		'before_widget' => '<div class="ppp_widget ppp_widget_sidebar">',
		'after_widget' => '</div>',
		'before_title' => '<h2 class="ppp_widget_sidebar_title">',
		'after_title' => '</h2>'));
	register_sidebar(array('name' => 'Sidebar Full Width Bottom', 
		'before_widget' => '<div class="ppp_widget ppp_widget_sidebar">',
		'after_widget' => '</div>',
		'before_title' => '<h2 class="ppp_widget_sidebar_title">',
		'after_title' => '</h2>'));
}

define('PPP_UPLOADS_URL', site_url().'/wp-content/uploads/photopresspro/');
define('PPP_UPLOADS_DIR', ABSPATH.'wp-content/uploads/photopresspro/');
define('PPP_IMAGES_URL', get_template_directory_uri().'/images/');
define('PPP_IMAGES_DIR', TEMPLATEPATH . '/images/');

/* Remove the WP version number. */
remove_action('wp_head', 'wp_generator');

// Nonces for AJAX activities
//if(!defined(WP_PPP_NONCE)) define('WP_PPP_NONCE', 'WP_PPP_NONCE');
//if(!defined(WP_PPP_DOMAIN)) define('WP_PPP_DOMAIN', 'ppp');

/* Register current PPP options. */
$GLOBALS['ppp_platinum_settings'] = ppp_get_options();
global $ppp_platinum_settings;

/* Register the content width so WP doesn't resize images. */
$GLOBALS['content_width'] = 960;
global $content_width;
if ( ! isset( $content_width ) )
	$content_width = 960;
$GLOBALS['content_width_2col'] = 640;
global $content_width_2col;
if ( ! isset( $content_width_2col ) )
	$content_width_2col = 640;


/*
Enqueue javaScript.
*/
add_action('init', 'ppp_scripts_init');
function ppp_scripts_init() {
  if (!is_admin()) {
	wp_enqueue_script('jquery');

	$url = get_template_directory_uri() . '/code/js/ppp.js';
	wp_register_script('pppJs', $url, false, '0.1', true); 
	wp_enqueue_script('pppJs');

	if (!ppp_get_option('comments_noajax')) {
		$url = get_template_directory_uri() . '/code/js/comment-ajax.js';
		wp_register_script('pppCommentAjax', $url, false, '0.1', true); 
		wp_enqueue_script('pppCommentAjax');
	}

	/* Override default comment-reply script to leave the form in place. */	
	if (get_option('thread_comments') ) {
	  wp_deregister_script('comment-reply');
	  $url = get_template_directory_uri() . '/code/js/comment-reply.dev.js';
	  wp_register_script('comment-reply', $url, false, '0.1', true); 
	  wp_enqueue_script('comment-reply');
	};
	
  } else {
	$url = get_template_directory_uri() . '/code/js/pppAdmin.js';
	wp_register_script('pppAdminJs', $url, false, '0.1', true); 
	wp_enqueue_script('pppAdminJs');
  }
}    



/*
slideshow/slideshow.php shared by Platinum3 theme
*/
global $ppp_slideshow_url;
global $ppp_slideshow_dir;
$ppp_slideshow_url = get_template_directory_uri() . '/slideshow';
$ppp_slideshow_dir = TEMPLATEPATH . '/slideshow';
include($ppp_slideshow_dir . '/slideshow.php');



/* Custom functions */
include(TEMPLATEPATH . '/code/theme_functions.php');

/* JQuery header slideshow */
require_once(TEMPLATEPATH . '/code/slideshow.php');

/* Custom comment templates */
include(TEMPLATEPATH . '/code/comments.php');

/* Font definitions */
include(TEMPLATEPATH . '/code/fonts.php');

/* Custom Page Titles / SEO */
include(TEMPLATEPATH . '/code/meta-seo.php');

/* Add support for 2.9 Post Thumbnails, 3.0 nav menus */
if ( function_exists('add_theme_support') ) {
  add_theme_support('post-thumbnails');

  add_theme_support('nav-menus');
  add_action( 'init', 'register_my_menu' );

  add_theme_support('automatic-feed-links');
}
function register_my_menu() {
 if ( function_exists('register_nav_menu') ) {
  register_nav_menu( 'ppp-menu', __( 'PPP Navigation Menu' ) );
 }
}


/* Custom Header Image Settings */
$hdr_w = 984;
$hdr_h = 250;
if ($ppp_platinum_settings['header_img_h'] != "") {
    $hdr_h = intval($ppp_platinum_settings['header_img_h']);
}
if ($ppp_platinum_settings['header_img_flash'] == "img_js" || $ppp_platinum_settings['header_img_flash'] == "img_flash") {
  if ($ppp_platinum_settings['header_layout'] == "l" || $ppp_platinum_settings['header_layout'] == "r") {
    $hdr_w = 328;

	if ($ppp_platinum_settings['header_img_flash'] == "img_flash") {
	  /* Open flashfader data file and populate $data with unserialized data */
	  $data = unserialize(file_get_contents(ABSPATH.'wp-content/flashfader/data.txt'));	
	  $hdr_h = $data['lynkff_height'];
	} else {
	  /* Take slideshow height. */
	  $hdr_h = $ppp_platinum_settings["header_img_height"];
	}
  }
}
define('HEADER_IMAGE_WIDTH', $hdr_w);
define('HEADER_IMAGE_HEIGHT', $hdr_h);


include(TEMPLATEPATH . '/code/cp_functions.php');


/**
Called from sidebar.php in lieu of standard dynamic_sidebar.
To insert a separator character or image in between menu bar entries.
*/
function ppp_dynamic_sidebar_menubar($index = 1) {
	global $wp_registered_sidebars, $wp_registered_widgets;

	if ( is_int($index) ) {
		$index = "sidebar-$index";
	} else {
		$index = sanitize_title($index);
		foreach ( $wp_registered_sidebars as $key => $value ) {
			if ( sanitize_title($value['name']) == $index ) {
				$index = $key;
				break;
			}
		}
	}

	$sidebars_widgets = wp_get_sidebars_widgets();

	if ( empty($wp_registered_sidebars[$index]) || !array_key_exists($index, $sidebars_widgets) || !is_array($sidebars_widgets[$index]) || empty($sidebars_widgets[$index]) )
		return false;

	$sidebar = $wp_registered_sidebars[$index];

	//PPP menu

	$separator = ppp_get_separator_code();

	$first = true;
	
	$item_count = count($sidebars_widgets[$index]);
	$item_counter = 0;
	//end PPP menu
	$did_one = false;
	foreach ( $sidebars_widgets[$index] as $id ) {
		$params = array_merge(
			array( array_merge( $sidebar, array('widget_id' => $id, 'widget_name' => $wp_registered_widgets[$id]['name']) ) ),
			(array) $wp_registered_widgets[$id]['params']
		);

		// Substitute HTML id and class attributes into before_widget.
		$classname_ = '';
		foreach ( (array) $wp_registered_widgets[$id]['classname'] as $cn ) {
			if ( is_string($cn) )
				$classname_ .= '_' . $cn;
			elseif ( is_object($cn) )
				$classname_ .= '_' . get_class($cn);
		}
		$classname_ = ltrim($classname_, '_');

		//PPP - append menu_align class name to the menu item.
		$menu_align = ppp_get_option('menu_align');
		if ($menu_align != '') $menu_align = 'menu_' . $menu_align;
		$params[0]['before_widget'] = sprintf($params[0]['before_widget'], $id, $menu_align, $classname_);

		//PPP menu
		// If not the first widget, insert the separator before the widget.
		if ($separator != '') {
			if (!$first) {
				$params[0]['before_widget'] = $separator . $params[0]['before_widget'];
			} else {
				$first = false;
			}
		}
		// If the last widget, stick on the menu_right code for the after_widget arg.
		$item_counter++;
		if ($item_count == $item_counter) {
			$params[0]['after_widget'] = $params[0]['after_widget'] . ppp_get_menu_right();
		}

		//end PPP menu

		$params = apply_filters( 'dynamic_sidebar_params', $params );

		$callback = $wp_registered_widgets[$id]['callback'];

		if ( is_callable($callback) ) {
			call_user_func_array($callback, $params);
			$did_one = true;
		}
	}

	return $did_one;
}

function ppp_get_separator_code($close=true) {
	global $ppp_separator_code;

	if (isset($ppp_separator_code)) {
		return $ppp_separator_code;
	}

	global $ppp_platinum_settings;

	/* Apply Control Panel Settings. */
	$theme_options = $ppp_platinum_settings;

	// Separator
	$sep_char = '';
	$sep_char = $theme_options['menu_separator'];

	// Menu alignment
	$menu_align = '';
	$menu_align = $theme_options['menu_align'];
	if ($menu_align != '') $menu_align = 'menu_' . $menu_align;

	if ($sep_char != '') {
		if ($sep_char == 'bullet') $sep_char = '&bull;';
		if ($sep_char == 'bullet_s') $sep_char = '&middot;';
		if ($sep_char == 'dash') $sep_char = '&mdash;';
		$ppp_separator_code = '<li class="menu_separator '.$menu_align.'">&nbsp;'.$sep_char.'&nbsp;';
	}
	if (($theme_options["img_sep"] != "") && ($theme_options["display_image_sep"] == 1)) {
		$ppp_separator_code = '<li class="menu_separator '.$menu_align.'"><img src="'.$theme_options["img_sep"].'" alt=" " />';
	}
	if ($close) $ppp_separator_code .= '</li>';
	return $ppp_separator_code;
}

function ppp_get_menu_right() {
	global $ppp_menu_right;

	if (isset($ppp_menu_right)) {
		return $ppp_menu_right;
	}

	global $ppp_platinum_settings;

	/* Apply Control Panel Settings. */
	$theme_options = $ppp_platinum_settings;

	$menu_right = '';
	if ($theme_options['rss_when'] == 'show') :
		$rss_icon = $theme_options['rss_icon'];
		$rss_txt = $theme_options['rss_txt'];
		if ($rss_icon != "text") {
			if ($rss_txt == '') $rss_txt = 'Subscribe';
			$rss_icon = '<img alt="'.$rss_txt.'" title="'.$rss_txt.'" src="'. get_template_directory_uri() . '/images/rss/' . $rss_icon . '.png" />';
		} else {
			$rss_icon = $rss_txt;
		}
		$menu_right = ppp_get_separator_code().'<li class="LargeMenu head_right" id="ppp_rss"><a href="'.get_bloginfo('rss2_url') .'">'.$rss_icon.'</a></li>';
	endif;
	return $menu_right;
}


if (class_exists('Walker_Nav_Menu')) {
/**
 * Filter the WP menu items to insert separator <li>s
 *
 * @package WordPress
 * @since 3.0.0
 * @uses Walker_Nav_Menu
 */
class Walker_Nav_Menu_PPP extends Walker_Nav_Menu  {

	/**
	 * @see Walker::start_el()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param object $item Menu item data object.
	 * @param int $depth Depth of menu item. Used for padding.
	 * @param int $current_page Menu item ID.
	 * @param object $args
	 */
	function start_el(&$output, $item, $depth, $args) {
		global $wp_query;

		/* PPP: Add a separator before all but the first top-level menu item.
		   Must keep updated as Walker_Nav_Menu changes. */
		if (!isset($args->ppp_first_menu_item)) {
			$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
			$args->ppp_first_menu_item = 1;
		} else {
			$indent = ( $depth ) ? str_repeat( "\t", $depth ) : ppp_get_separator_code();
		}
		// END PPP

		$classes = $value = '';

		$classes = array( 'menu-item', 'menu-item-type-'. $item->type, $item->classes );

		if ( 'custom' == $item->object ) {
			$current_url = ( is_ssl() ? 'https://' : 'http://' ) . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
			$item_url = strpos( $item->url, '#' ) ? substr( $item->url, 0, strpos( $item->url, '#' ) ) : $item->url;
			if ( $item_url == $current_url )
				$classes[] = 'current-menu-item';
		} else {
			$classes[] = 'menu-item-object-'. $item->object;
			if ( $item->object_id == $wp_query->get_queried_object_id() )
				$classes[] = 'current-menu-item';
		}

		// @todo add classes for parent/child relationships
// BEGIN PPP
		if (!$depth) $classes[] = 'LargeMenu';
// END PPP

		$classes = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
		$classes = ' class="' . esc_attr( $classes ) . '"';

		$output .= $indent . '<li id="menu-item-'. $item->ID . '"' . $value . $classes .'>';

		$attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
		$attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
		$attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
		$attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';

		$item_output = $args->before;
		$item_output .= '<a'. $attributes .'>';
		$item_output .= $args->link_before . apply_filters( 'the_title', $item->title ) . $args->link_after;
		$item_output .= '</a>';
		$item_output .= $args->after;

		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
	}
}

/**
Catch the last top-level nav menu item and stick the menu_right after it.
*/
add_filter('wp_nav_menu_items', 'ppp_nav_menu_items', 10, 2);
function ppp_nav_menu_items($items, $args) {
	/* Make sure we are using the WP menu for PPP */
	if (ppp_get_option('menu_src') == 'wp' && $args->theme_location == 'ppp-menu') {
		/* And tack on menu_right */
		$items .= ppp_get_menu_right();
	}
	return $items;
}

} // if WalkerNavMenu present



/* Return the current theme options, or those of the selected snapshot. */
function ppp_get_options($setcookie = 0) {
	$theme_options = get_option('ppp_platinum3_settings');

	/* Check for Snapshot Chooser cookie or selection */
	if (isset($_GET['snap']) || isset($_COOKIE['ppp_snapshot_pref'])) {
		if ($_GET['snap'] != '') {
			$snap = $_GET['snap'];
		} else {
			$snap = $_COOKIE['ppp_snapshot_pref'];
		}
		$snaps = unserialize($theme_options['snapshots']);
		if (is_array($snaps[$snap])) {
			$theme_options = $snaps[$snap];
			if ($setcookie == 1) {
				setcookie("ppp_snapshot_pref", $snap, time()+3600, COOKIEPATH, COOKIE_DOMAIN);
			}
		}
	}
	return $theme_options;
}


/* Get a single PPP option */
function ppp_get_option($option) {
	global $ppp_platinum_settings;
	if (isset($ppp_platinum_settings[$option])) {
	   return $ppp_platinum_settings[$option];
	} else {
		return false;
	}
}


/* Add a Control Panel link to the Favorites dropdown (2.7+). Activated by Control Panel option "add_favorites_link */
function ppp_add_to_favorites( $favorites_array ) {
	$favorites_array['themes.php?page=platinum3'] = array('PPP Control Panel', 'edit_themes');
	return $favorites_array;
}
if ($ppp_platinum_settings["add_favorites_link"] == 1) {
	add_filter('favorite_actions', 'ppp_add_to_favorites');
}

/* Allow shortcodes in filters. Useful for contact forms, etc. */
if (!is_admin())
  add_filter('widget_text', 'do_shortcode', 11);


/* PhotoPressPro Platinum3 Theme Control Panel */
require_once(TEMPLATEPATH . '/code/controlpanel.php');
$cpanel = new ControlPanel();

require_once(TEMPLATEPATH . '/code/widgets.php');

/* Custom PHP */
if (!is_admin())
  if (file_exists(TEMPLATEPATH . '/my.php')) include(TEMPLATEPATH . '/my.php');

?>