<?php

/*
PhotoPressPro Platinum widgets for WP 2.8+
*/

if (class_exists('WP_Widget')) {

/**
 * PPPSearchWidget Class
 */
class PPPSearchWidget extends WP_Widget {
    /** constructor */
    function PPPSearchWidget() {
          $widget_ops = array( 'description' => __( "Simple search form designed for the PhotoPressPro Platinum3 Navigation Menu Bar.") );
          $this->WP_Widget('widget_ppp_search', __('PPP Simple Search'), $widget_ops);
    }

    /** @see WP_Widget::widget */
    function widget($args, $instance) {		
        extract( $args );
		echo $before_widget;
		echo $before_title
              . $instance['title']
              . $after_title; ?>
        <form class="head_search" method="get" action="<?php echo $_SERVER['PHP_SELF']; ?>">
            <input type="text" value="<?php if (get_search_query() != '') : the_search_query(); else : echo $instance['def']; endif; ?>" name="s" id="s" size="14" onfocus="this.value=''" />
            <input type="hidden" id="searchsubmit" value="Search" />
        </form>
      <?php echo $after_widget;
    }

    /** @see WP_Widget::update */
    function update($new_instance, $old_instance) {				
        return $new_instance;
    }

    /** @see WP_Widget::form */
    function form($instance) {				
        $title = esc_attr($instance['title']);
        $def = esc_attr($instance['def']);
        ?>
            <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?> <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>
            <p><label for="<?php echo $this->get_field_id('def'); ?>"><?php _e('Text inside search box:'); ?> <input class="widefat" id="<?php echo $this->get_field_id('def'); ?>" name="<?php echo $this->get_field_name('def'); ?>" type="text" value="<?php echo $def; ?>" /></label></p>
        <?php 
    }

} // class PPPSearchWidget



/**
 * PPPLinkWidget Class
 */
class PPPLinkWidget extends WP_Widget {
    /** constructor */
    function PPPLinkWidget() {
          $widget_ops = array( 'description' => __( "Simple text or image link to any URL you wish.") );
          $this->WP_Widget('widget_ppp_link', __('PPP Simple Link'), $widget_ops);

    }

    /** @see WP_Widget::widget */
    function widget($args, $instance) {		
        extract( $args );

		$target = '';
		if ($instance['new_window']==1) {
			$target = 'target="_blank"';
		}

		echo $before_widget;
		
		$before_title = '<span class="ppp_widget ppp_widget_title">';
		$after_title = '</span>';
		
		$widget = $before_title . $instance['title'] . $after_title;
		if ($instance['imgurl']) {
			$widget = $before_title . '<img src="'.$instance['imgurl'].'" alt="'.$instance['title'].'" title="'.$instance['title'].'" />' . $after_title;
		}
		?>
        <a class="widget_ppp_link" <?php echo $target; ?> href="<?php echo $instance['link']; ?>"><?php echo $widget; ?></a>
		<?php 
		echo $after_widget;
    }

    /** @see WP_Widget::update */
    function update($new_instance, $old_instance) {				
		/* Handle checkbox. */
		$instance = $new_instance;
	    $instance['new_window'] = $new_instance['new_window'] ? 1 : 0;

		/* Ensure valid URLs */
        $instance['link'] = esc_url($instance['link']);
        $instance['imgurl'] = esc_url($instance['imgurl']);

        return $instance;
    }

    /** @see WP_Widget::form */
    function form($instance) {				
        $title = esc_attr($instance['title']);
        $link = esc_attr($instance['link']);
        $imgurl = esc_attr($instance['imgurl']);
        $new_window = $instance['new_window'];
        ?>
            <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Link text'); ?> <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>
            <p><label for="<?php echo $this->get_field_id('link'); ?>"><?php _e('URL (web address)'); ?> <input class="widefat" id="<?php echo $this->get_field_id('link'); ?>" name="<?php echo $this->get_field_name('link'); ?>" type="text" value="<?php if ($link=='') {?><?php } echo $link; ?>" /></label></p>
            <p><label for="<?php echo $this->get_field_id('imgurl'); ?>"><?php _e('Image URL (optional)'); ?> <input class="widefat" id="<?php echo $this->get_field_id('imgurl'); ?>" name="<?php echo $this->get_field_name('imgurl'); ?>" type="text" value="<?php if ($imgurl=='') {?><?php } echo $imgurl; ?>" /></label></p>
            <p><label for="<?php echo $this->get_field_id('new_window'); ?>"><input id="<?php echo $this->get_field_id('new_window'); ?>" name="<?php echo $this->get_field_name('new_window'); ?>" type="checkbox" <?php if ($new_window==1){ echo"checked='checked'";} ?> /> <?php _e('Open link in a new window?'); ?> </label></p>

        <?php 
    }

} // class PPPLinkWidget




/* Register Widgets */
add_action('widgets_init', 'ppp_register_widgets');
function ppp_register_widgets() {
  register_widget("PPPSearchWidget");
  register_widget("PPPLinkWidget");
}

} /*if (class_exists(WP_Widget)) {*/

?>
