<?php

/* Return a dot, dash, umlaut, whatever you want. */
function ppp_get_text_separator() {
	return ' <span class="meta-sep">&middot;</span> ';
}

/* Custom functions for use by the PPP theme. */
function ppp_about_box($placement) {
  $theme_options = ppp_get_options();
  $show_me = false;
  if ($theme_options["bio_placement"] == $placement) {
    $show_me = true;
    if ($placement == "below_hdr" && !is_front_page() && !is_home()) {
      $show_me = false;
    }
  }
  if ($show_me) {
?>

	<div id="ppp_about" class="about">
<?php 
		if ($theme_options["about_title"] != "") {
		  echo '<h2>'.$theme_options["about_title"].'</h2>';
		}
?>
	    <div class="contenttext">
		<div id="biopic"></div>
		<div id="biotxt">
<?php 
		if ($theme_options["about_text"] != "") {
		  echo wpautop($theme_options["about_text"]);
		}
?>
        </div>
      </div>
	</div>
	<div class="clearer"></div>
<?php 
  }
}

/* Echo the afore-mentioned. */
function ppp_text_separator() {
	echo ppp_get_text_separator();
}

/* Echo a cobbled-together post title. */
function ppp_get_title() {
  global $post;

  /* Enforce the "_custom_heading" custom field. */
  $customHeading = get_post_meta($post->ID, '_custom_heading', true);
  if ($customHeading == "hide") return;
  if ($customHeading == "") $customHeading = the_title_attribute( 'echo=0' );

  $theme_options = ppp_get_options();
  $h = $theme_options["thumb_image_height"];
  $w = $theme_options["thumb_image_width"];

  $title = '<div class="entry-title-wrap">';
  $title .= '<div class="entry-title-subtitle">';

  if (function_exists('has_post_thumbnail') && has_post_thumbnail() ) {
	$title .= '<div class="ppp-img-thumb">';
	$title .= get_the_post_thumbnail($post->ID, array($w, $h));
	$title .= '</div>';
  } elseif (($theme_options["img_thumb"] != "") && ($theme_options["display_image_thumb"] == 1)) {
	$title .= '<div class="ppp-img-thumb"><img src="'.$theme_options["img_thumb"].'" alt="'.get_the_title().' Image" title="'.get_the_title().' Image" /></div>';
  } 

  $title .= '<div class="entry-title-subtitle-inner">';

  if ( is_attachment() ) {
	/* Post Title > attachment title */
	$customParentHeading = get_post_meta($post->post_parent, '_custom_heading', true);
	if ($customParentHeading == "") $customParentHeading = get_the_title($post->post_parent);
		$title .= '<h1 class="attachment-title entry-title"><a href="' . get_permalink($post->post_parent) . '" title="' . $customParentHeading . '" rel="bookmark">' . $customParentHeading . '</a> &raquo; <a href="' . get_permalink() . '" title="' . $customHeading . '" rel="attachment">' . $customHeading . '</a><span class="2"></span></h1>';
	}
	elseif( is_front_page() && !is_home() )
		$title .= '<h2 class="page-title entry-title"><a href="' . get_permalink() . '" title="' . $customHeading . '" rel="bookmark">' . $customHeading . '</a></h2>';

	elseif ( is_page() )
		$title .= '<h1 class="page-title entry-title"><a href="' . get_permalink() . '" title="' . $customHeading . '" rel="bookmark">' . $customHeading . '</a></h1>';

	elseif ( is_single() )
		$title .= '<h1 class="single-title entry-title"><a href="' . get_permalink() . '" title="' . $customHeading . '" rel="bookmark">' . $customHeading . '</a></h1>';

	elseif ( 'link_category' == get_query_var( 'taxonomy' ) )
		$title = false;

	else
		$title .= '<h2 class="post-title entry-title"><a href="' . get_permalink() . '" title="' . $customHeading . '" rel="bookmark">' . $customHeading . '</a></h2>';

  echo $title;
	
  ppp_subtitle();

  echo '</div><!-- .entry-title-subtitle-inner -->';

  echo '</div></div>';
}

/* Echo a cobbled-together subtitle. Called from ppp_get_title(). */
function ppp_subtitle() {
  global $post;

  $opts = ppp_get_options();

	/* Check for page preference */
  if (is_page() && $opts["ts_sub_onpage"] != 1) {
	return;
  }

	/* Don't show separator if no tags or categories */
  if (!get_the_tags() || is_page()) $opts["ts_sub_tags"] = 0;
  if (!get_the_category() || is_page()) $opts["ts_sub_cats"] = 0;


  if ($opts["ts_sub_author"] == 1 || $opts["ts_sub_date"] == 1 || $opts["ts_sub_time"] == 1 || $opts["ts_sub_cats"] == 1 || $opts["ts_sub_tags"] == 1) { ?>

  <p class="subtitle">
	<?php if ($opts["ts_sub_author"] == 1) {
		the_author_posts_link();
		if ($opts["ts_sub_date"] == 1 || $opts["ts_sub_time"] == 1 || $opts["ts_sub_cats"] == 1 || $opts["ts_sub_tags"] == 1) {
		  ppp_text_separator();
        }
	} 
	?>
	<?php if ($opts["ts_sub_date"] == 1) {
		the_time(get_option('date_format'));
		if ($opts["ts_sub_time"] == 1 || $opts["ts_sub_cats"] == 1 || $opts["ts_sub_tags"] == 1) {
		  ppp_text_separator();
        }
	}
	?>
	<?php if ($opts["ts_sub_time"] == 1) {
		the_time();
		if ($opts["ts_sub_cats"] == 1 || $opts["ts_sub_tags"] == 1) {
		  ppp_text_separator();
        }
	}
	?>
	<?php if ($opts["ts_sub_cats"] == 1) {
		if (the_category(', ')) the_category();
		if ($opts["ts_sub_tags"] == 1) {
			echo ', ';
        }
	}
	if ($opts["ts_sub_tags"] == 1 && !is_page()) custom_tags_link(0);?>
  </p>
<?php }

}

/* Return a cobbled-together postfooter. */
function ppp_get_postfooter() {
  global $post;
  $opts = ppp_get_options();

	/* Check for page preference */
  if (is_page() && $opts["ts_foot_onpage"] != 1) {
	return;
  }

	/* Don't show separator if no tags or categories */
  if (!get_the_tags() || is_page()) $opts["ts_foot_tags"] = 0;
  if (!get_the_category() || is_page()) $opts["ts_foot_cats"] = 0;
?>
  <div class="timestamp" id="timestamp-<?php echo $post->ID ?>">
<?php
  if ($opts["ts_foot_title"] == 1 || $opts["ts_foot_author"] == 1 || $opts["ts_foot_date"] == 1 || $opts["ts_foot_time"] == 1 || $opts["ts_foot_cats"] == 1 || $opts["ts_foot_tags"] == 1) { ?>

	<?php if ($opts["ts_foot_title"] == 1) { ?>
	<a href="<?php the_permalink() ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a><?php edit_post_link('[edit]',' ',''); ?>
	<?php
		if ($opts["ts_foot_author"] == 1 || $opts["ts_foot_date"] == 1 || $opts["ts_foot_time"] == 1 || $opts["ts_foot_cats"] == 1 || $opts["ts_foot_tags"] == 1) {
		  ppp_text_separator();
        }
	} 
	?>
	<?php if ($opts["ts_foot_author"] == 1) {
		the_author_posts_link();
		if ($opts["ts_foot_date"] == 1 || $opts["ts_foot_time"] == 1 || $opts["ts_foot_cats"] == 1 || $opts["ts_foot_tags"] == 1) {
		  ppp_text_separator();
        }
	} 
	?>
	<?php if ($opts["ts_foot_date"] == 1) {
		the_time(get_option('date_format'));
		if ($opts["ts_foot_time"] == 1 || $opts["ts_foot_cats"] == 1 || $opts["ts_foot_tags"] == 1) {
		  ppp_text_separator();
        }
	}
	?>
	<?php if ($opts["ts_foot_time"] == 1) {
		the_time();
		if ($opts["ts_foot_cats"] == 1 || $opts["ts_foot_tags"] == 1) {
		  ppp_text_separator();
        }
	}
	?>
	<?php if ($opts["ts_foot_cats"] == 1) {
		if (the_category(', ')) the_category();
		if ($opts["ts_foot_tags"] == 1) {
			echo ', ';
		}
	}
	if ($opts["ts_foot_tags"] == 1) custom_tags_link(0);
	/* Always show comments links */
    custom_comments_link();
  } else {
    custom_comments_link(0);
  } 
?>
  </div>
<?php
}

/* SoftShadow - Good for light to white Background */
function ppp_textshadow_softshadow() {
  return 'text-shadow:1px 1px rgba(0, 0, 0, 0.1);';
}

/* DropShadow - Any Background */
function ppp_textshadow_dropshadow() {
  return 'text-shadow:1px 1px #CCCCCC;';
}

/* LetterPress - Best for light-ish, non-white Background w/ low contrast Text */
function ppp_textshadow_letterpress() {
//  return 'text-shadow:1px 1px 0px #FFFFFF;';
  return 'text-shadow:0 1px 0 #FFFFFF;';
}

/* LetterPress Dark - Best for darker Background w/ low contrast Text */
function ppp_textshadow_letterpress_dk() {
  return 'text-shadow:0 -1px 0 #111111;';
}

function ppp_get_content_width() {
global $content_width;
$max_w=960;
if (is_page_template('page-fullwidth.php') || is_page_template('index-fullwidth.php')) {
  $max_w=960;
} else if (is_page_template('page-2columns.php') || is_page_template('index-2columns.php')) {
  $max_w=640;
} else if (ppp_get_option("sidebar_hide_show")=='show') {
  $max_w=640;
}
$content_width = $max_w;
return $max_w;
}

function ppp_content_class() {
	if (ppp_get_option("sidebar_hide_show")=='show') {
		echo('class="two-columns-content"');
	} else {
		echo('class="one-column-content"');
	}
}

function ppp_custom_title() {
	global $paged;
	if (have_posts()) : the_post();
	  $customTitle = get_post_meta(get_the_ID(), '_custom_title', true);
	  if ($customTitle && !is_home()) { // Added !is_home() so the blog page would not take the title of the 1st post
		echo $customTitle;
      } else {
	      if (is_tag()) {
	         single_tag_title("Tag Archive for &quot;"); echo '&quot; - '; }
	      elseif (is_archive()) {
	         wp_title(''); echo ' Archive - '; }
	      elseif ((is_single()) || (is_page()) && (!(is_front_page())) ) {
	         wp_title(''); echo ' - '; }
	      if (is_home()) {
	         bloginfo('name'); echo ' - '; bloginfo('description'); }
	      else {
	          bloginfo('name'); }
	      if ($paged>1) {
	         echo ' - page '. $paged; }
    }
    else :
      echo "Page Not Found";
	endif;
	rewind_posts();
}

?>
