<?php

function ppp_get_header_images($options) {
	return ppp_get_slideshow_markup($options, "hdr");
}

function ppp_get_header_images_css($height) {
	return ppp_get_slideshow_css("hdr", $height);
}


function ppp_get_slideshow_markup($theme_options, $name) {

	$img_hdr_num = ($theme_options['img_fn_'.$name.'_num'] != '') ? intval($theme_options['img_fn_'.$name.'_num']) : 1;

	$ids = ppp_sort_header_ids($theme_options, $img_hdr_num);

	$out = '<div id="ppp_slideshow_'.$name.'" class="ppp_slideshow_'.$name.' img_hdr_num_'.$img_hdr_num.'">';
	$active = ' class="active"';

	for ($i=1; $i<=$img_hdr_num; $i++) {
		/* Support the default slideshow before options are saved. */
	  if (isset($ids[$i])) {
		$imgurl = ppp_get_img_url($name.$ids[$i], $theme_options);
		if ($imgurl != '') {
			$out .= '<div'.$active.'><a href="'.home_url().'"><img src="'.$imgurl.'" alt="" /></a></div>';

			$active = '';
		}
	  }
	}
	$out .= '</div>';

	return $out;
}


function ppp_get_slideshow_css($name, $height) {
	echo '<style type="text/css">';
	echo '
<!--
#ppp_slideshow_'.$name.' {
    position:relative;
    height:'.$height.'px;
}

#ppp_slideshow_'.$name.' DIV {
    position:absolute;
    top:0;
    left:0;
    z-index:8;
    opacity:0.0;
}

#ppp_slideshow_'.$name.' DIV.active {
    z-index:10;
    opacity:1.0;
}

#ppp_slideshow_'.$name.' DIV.last-active {
    z-index:9;
}
-->
';
	echo '</style>';
}

/**
    DO NOT USE - might use for future development of a plugin.
	Save a slideshow.
	$name - name of slideshow
	$args - array of image urls
*/
function ppp_save_slideshow($name, $args) {
	$theme_options = ppp_get_options();

	$slide_options = $theme_options['ppp_slideshow_'.$name];

	if (is_array($slide_options) && is_array(unserialize($slide_options['divs']))) {
		$divs = unserialize($slide_options['divs']);
	} else {
		$divs = $args;
	}

	/* Save. */
	$slide_options['divs'] = serialize($divs);

	$theme_options['ppp_slideshow_'.$name] = $slide_options;

	update_option('ppp_platinum3_settings', $theme_options);
}

/**
  Sort the header image ids by the sequence number, in a semi-efficient manner.
  @since 3.0
*/
function ppp_sort_header_ids($options, $img_hdr_num, $public=true) {
	$ids = Array();
	$seqs = Array();

	for ($x=1; $x<=$img_hdr_num; $x++) {
		if (isset($options["image_hdr_seq".$x])) {
			$seqs[$x] = $options["image_hdr_seq".$x];
			$ids[$x] = $x;
		}
	}

	foreach ($ids as $x => $v) {
	  foreach ($ids as $y => $v) {
		if(isset($ids[$x]) && isset($ids[$y]) && isset($seqs[$ids[$x]]) && isset($seqs[$ids[$y]])) {
		  if(intval($seqs[$ids[$x]]) < intval($seqs[$ids[$y]])) {
			$hold = $ids[$x];
			$ids[$x] = $ids[$y];
			$ids[$y] = $hold;		  
		  }
		}
	  }
	}

	// shuffle ids if set to random and a public page
	if ($options["header_img_rnd"] == 1 && $public) {
		shuffle($ids);
	}
	return $ids;
}

?>
