<?php

// Custom Page Titles - implemented in theme_functions.php
add_action('admin_menu', 'custom_title');
add_action('save_post', 'save_custom_title');
function custom_title() {
	add_meta_box('custom_title', 'PPP: Change Title for Browsers', 'custom_title_input_function', 'post', 'normal', 'high');
	add_meta_box('custom_title', 'PPP: Change Title for Browsers', 'custom_title_input_function', 'page', 'normal', 'high');
}
function custom_title_input_function() {
	global $post;
	echo '<input type="hidden" name="custom_title_input_hidden" id="custom_title_input_hidden" value="'.wp_create_nonce('custom-title-nonce').'" />';
	echo '<p>This is the text in the title bar of your browser, and the stuff that search engines love! If you enter nothing here, the page title will default to &quot;Title - Blog Name&quot;.</p>';
	echo '<input type="text" name="custom_title_input" id="custom_title_input" style="width:100%;" value="'.get_post_meta($post->ID,'_custom_title',true).'" />';
}
function save_custom_title($post_id) {
	if (!wp_verify_nonce($_POST['custom_title_input_hidden'], 'custom-title-nonce')) return $post_id;
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return $post_id;
	$customTitle = $_POST['custom_title_input'];
	update_post_meta($post_id, '_custom_title', $customTitle);
}


// Custom Page Heading - implemented in theme_functions.php
add_action('admin_menu', 'custom_heading');
add_action('save_post', 'save_custom_heading');
function custom_heading() {
	add_meta_box('custom_heading', 'PPP: Change Title for Readers', 'custom_heading_input_function', 'post', 'normal', 'high');
	add_meta_box('custom_heading', 'PPP: Change Title for Readers', 'custom_heading_input_function', 'page', 'normal', 'high');
}
function custom_heading_input_function() {
	global $post;
	echo '<input type="hidden" name="custom_heading_input_hidden" id="custom_heading_input_hidden" value="'.wp_create_nonce('custom-heading-nonce').'" />';
	echo '<p>This is the heading that your readers will see above the post. If you want to hide the title (and subtitle and post thumbnail), enter <strong>hide</strong> here. This may be useful for galleries or your home page.</p>';
	// set initial value if not yet saved
	$val = get_post_meta($post->ID,'_custom_heading',true);
	if ($val == "") $val = the_title_attribute( 'echo=0' );
	echo '<input type="text" name="custom_heading_input" id="custom_heading_input" style="width:100%;" value="'.$val.'" />';
}
function save_custom_heading($post_id) {
	if (!wp_verify_nonce($_POST['custom_heading_input_hidden'], 'custom-heading-nonce')) return $post_id;
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return $post_id;
	$customHeading = $_POST['custom_heading_input'];
	update_post_meta($post_id, '_custom_heading', $customHeading);
}

?>
