jQuery(document).ready(function($) {

  /* Place the down arrow. */
  $("#ppp_panel h4").before('<div class="ppp_panel_h4"><div class="ppp_down_arrow_box"><div class="ppp_down_arrow"></div></div>');
  $("#ppp_panel h4").after('</div>');

  /* Use h4s to toggle the next div. */
  $("#ppp_panel h4").click(function() {
    toggle_h4($(this));
  });
  $(".ppp_panel_h4").click(function() {
    toggle_h4($(this).next());
  });


  function toggle_h4(box) {
    box.next().toggle("fast");
	if (box.hasClass("ppp_h4_closed")) {
	    box.removeClass("ppp_h4_closed");
	    box.addClass("ppp_h4_open");
	} else {
	    box.removeClass("ppp_h4_open");
	    box.addClass("ppp_h4_closed");
	}
  }


  /* Help notes */
  $("#toggle_border_note").click(function() {
    $("#border_note").toggle("fast");
  });
  $("#toggle_note_menu_1").click(function() {
    $("#note_menu_1").toggle("fast");
  });
  $("#toggle_note_menu_2").click(function() {
    $("#note_menu_2").toggle("fast");
  });
  $("#toggle_note_menu_3").click(function() {
    $("#note_menu_3").toggle("fast");
  });
  $("#toggle_note_menu_4").click(function() {
    $("#note_menu_4").toggle("fast");
  });
  $("#toggle_restore_defaults").click(function() {
    $("#restore_defaults").toggle("fast");
  });

  /* Generic "more info" tag. Open the ID specified by the link's hash tag. */
  $("a.more-info-link, a.more-info-link-x").click(function() {
	var anchorHrefValue = $(this).attr('href');
    $(anchorHrefValue).toggle("fast");
	return false;
  });


  /* Buttons */
  $("#header_img_flash_img").click(function() {
    $("#header_layout_div").hide();
    $(".header_div").show();
    $(".slide_div").hide();
  });
  $("#header_img_flash_js").click(function() {
    $("#header_layout_div").hide();
    $(".header_div").hide();
    $(".slide_div").show();
  });
  $("#header_img_flash_img_js").click(function() {
    $("#header_layout_div").show();
    $(".header_div").show();
    $(".slide_div").show();
  });

  $("#header_layout_top").click(function() {
    $("#header_img_height_div").show();
    $(".hdr_tb_div").show();
    $(".hdr_lr_div").hide();
  });
  $("#header_layout_bottom").click(function() {
    $("#header_img_height_div").show();
    $(".hdr_tb_div").show();
    $(".hdr_lr_div").hide();
  });
  $("#header_layout_left").click(function() {
    $("#header_img_height_div").hide();
    $(".hdr_tb_div").hide();
    $(".hdr_lr_div").show();
  });
  $("#header_layout_right").click(function() {
    $("#header_img_height_div").hide();
    $(".hdr_tb_div").hide();
    $(".hdr_lr_div").show();
  });

  $("#rss_show").click(function() {
    $("#rss_icon_div").show();
  });
  $("#rss_hide").click(function() {
    $("#rss_icon_div").hide();
  });


  /* Select options */
  $('#cp_comment_form_placement').change(function(){
	var lay = $(this).children(":selected").val();
	if (lay == 'below') {
		$("#comment_form_tr").show();
		$("#ppp_comment_box_width").show();
	} else if (lay == 'left' || lay == 'right') {
		$("#comment_form_tr").hide();
		$("#ppp_comment_box_width").hide();
	}
  });


  /* Menu Source buttons */

	/* Set tip to currently selected button */
  ppp_set_checked_menu_src();

	/* Button hover state - un-hover back to checked button */
  $('#menu_src_wp_lbl').hover(function() {
    $('#'+ppp_get_checked('menu_src')+'_note').hide();
    $('#menu_src_wp_note').show();
  },function(){
    $('#menu_src_wp_note').hide();
    $('#'+ppp_get_checked('menu_src')+'_note').show();
  });
  $('#menu_src_widget_lbl').hover(function() {
    $('#'+ppp_get_checked('menu_src')+'_note').hide();
    $('#menu_src_widget_note').show();
  },function(){
    $('#menu_src_widget_note').hide();
    $('#'+ppp_get_checked('menu_src')+'_note').show();
  });
  $('#menu_src_default_lbl').hover(function() {
    $('#'+ppp_get_checked('menu_src')+'_note').hide();
    $('#menu_src_default_note').show();
  },function(){
    $('#menu_src_default_note').hide();
    $('#'+ppp_get_checked('menu_src')+'_note').show();
  });


  /* Tabs */

  var lastTab = $("#ppp_last_tab").val();
  var lastTabFonts = $("#ppp_last_tab_fonts").val();
  var lastTabLayout = $("#ppp_last_tab_layout").val();
  var lastTabColors = $("#ppp_last_tab_colors").val();
  var lastTabImages = $("#ppp_last_tab_images").val();
  var lastTabOther = $("#ppp_last_tab_other").val();
  var lastTabSlideshow = $("#ppp_last_tab_slideshow").val();
  var lastTabSubComments = $("#ppp_last_tab_sub_comments").val();

  $("#ppp_last_tab").val(lastTab); 
  $("#ppp_last_tab_fonts").val(lastTabFonts); 
  $("#ppp_last_tab_layout").val(lastTabLayout); 
  $("#ppp_last_tab_colors").val(lastTabColors); 
  $("#ppp_last_tab_images").val(lastTabImages); 
  $("#ppp_last_tab_other").val(lastTabOther); 
  $("#ppp_last_tab_slideshow").val(lastTabSlideshow); 
  $("#ppp_last_tab_sub_comments").val(lastTabSubComments); 

  /* Set initial tab */
  var settings = { start:lastTab, click:function(id,list,set){ 
    $("#ppp_last_tab").val(id); 
    $(id).fadeIn("fast"); 
  } }; 
  $("#ppp_panel_menu").idTabs(settings);

  var settings_fonts = { start:lastTabFonts, click:function(id,list,set){ 
    $("#ppp_last_tab_fonts").val(id); 
    $(id).fadeIn("fast"); 
  } }; 
  $("#ppp_fonts_tab").idTabs(settings_fonts);

  var settings_layout = { start:lastTabLayout, click:function(id,list,set){ 
    $("#ppp_last_tab_layout").val(id); 
    $(id).fadeIn("fast"); 
  } }; 
  $("#ppp_layout_tab").idTabs(settings_layout);

  var settings_colors = { start:lastTabColors, click:function(id,list,set){ 
    $("#ppp_last_tab_colors").val(id); 
    $(id).fadeIn("fast"); 
  } }; 
  $("#ppp_colors_tab").idTabs(settings_colors);

  var settings_images = { start:lastTabImages, click:function(id,list,set){ 
    $("#ppp_last_tab_images").val(id); 
    $(id).fadeIn("fast"); 
  } }; 
  $("#ppp_images_tab").idTabs(settings_images);

  var settings_other = { start:lastTabOther, click:function(id,list,set){ 
    $("#ppp_last_tab_other").val(id); 
    $(id).fadeIn("fast"); 
  } }; 
  $("#ppp_other_tab").idTabs(settings_other);

  var settings_slideshow = { start:lastTabSlideshow, click:function(id,list,set){ 
    $("#ppp_last_tab_slideshow").val(id); 
    $(id).fadeIn("fast"); 
  } }; 
  $("#ppp_slideshow_tab").idTabs(settings_slideshow);

  var settings_sub_comments = { start:lastTabSubComments, click:function(id,list,set){ 
    $("#ppp_last_tab_sub_comments").val(id); 
    $(id).fadeIn("fast"); 
  } }; 
  $("#ppp_comments_tab").idTabs(settings_sub_comments);

  /* Select the last saved tab */
  $("a[href='"+lastTab+"']").addClass("selected"); 
  $("a[href='"+lastTabFonts+"']").addClass("selected"); 
  $("a[href='"+lastTabLayout+"']").addClass("selected"); 
  $("a[href='"+lastTabColors+"']").addClass("selected"); 
  $("a[href='"+lastTabImages+"']").addClass("selected"); 
  $("a[href='"+lastTabOther+"']").addClass("selected"); 
  $("a[href='"+lastTabSlideshow+"']").addClass("selected"); 
  $("a[href='"+lastTabSubComments+"']").addClass("selected"); 

  function ppp_get_checked(name) {
	/* Return the button id that's checked */
	var checkedId = name+'_default';
	$('input[name=cp_'+name+']:checked').each(function(){
	  checkedId = this.id;
	}); 
	return checkedId;
  }

  function ppp_set_checked_menu_src() {
	/* Set what should be checked */
	$('#menu_src_wp_note').hide();
	$('#menu_src_widget_note').hide();
	$('#menu_src_default_note').hide();
	$('#'+ppp_get_checked('menu_src')+'_note').show();
  }

  /* Add classes to all jscolor elements. */
  $('#ppp_panel_body input.color').addClass('{required:false,pickerPosition:\'right\'}');

  /* Work around PHP's new default limit of 20 max_file_uploads, even if they're empty.
     Thanks, Drew! http://allinthehead.com/retro/349/the-curse-of-max_file_uploads */
  $('form#ppp_panel input#ppp_save_changes, form#ppp_panel input.ppp_submit_upload, form#ppp_panel input#save_draft').click(function(){
    $('input:file[value=""]').attr('disabled', true);
//    $('input:file').attr('disabled', true);
  });

});


/* Fade out if save_action is 1 */
function ppp_update_ajax_msg(save_action) {
  if (save_action == '1') {
    setTimeout(function() {jQuery('.ppp_ajax_response_div').fadeOut("slow");}, 3000); 
  }
}
