jQuery(document).ready(function($) {

  /* Using a live submit event handler to bind to all current and future commentforms. */
  jQuery('.commentform').live('submit',function(){
	var $respond=jQuery(this).parent();
	var $wpcomments = $respond.closest('.wp-comments');
	var $ppp_timestamp = $wpcomments.parent().find('.timestamp');
	var $commentlist=$wpcomments.find('.commentlist');
	var $message=jQuery('<span class="ppp_comment_message"></span>').appendTo(this);
	var $list=$commentlist.children();
	var totalCom=$list.length;
	var $textarea=$respond.find('.comment').attr('rows','4');


       jQuery.ajax({
         beforeSend:function(xhr){
            xhr.setRequestHeader("If-Modified-Since","0");
            $message.empty().append('...posting...');
         },
         type:'post',
         url:jQuery(this).attr('action'),
         data:jQuery(this).serialize(),
         dataType:'html',
         error:function(xhr){
             if(xhr.status==500){
               $message.empty().append(xhr.responseText.split('<p>')[1].split('</p>')[0]);
             }
             else if(xhr.status=='timeout'){
               $message.empty().append('Oops! The server timed out. Please try again!');
             }
             else{
               $message.empty().append('Oops! The server seems to think you&apos;re posting a little too fast. Please wait a few minutes and try again!');
             }
         },
         success:function(data){

            $message.empty().append('Thank you for your comment!');

            $textarea.val('');

			/* Replace the comments and the timestamp. */
            $newComments=jQuery(data).find('#'+$wpcomments.attr('id'));
			$newTimestamp=jQuery(data).find('#'+$ppp_timestamp.attr('id'));

			$wpcomments.replaceWith($newComments);
			$ppp_timestamp.replaceWith($newTimestamp);
			
			/* If comments are hidden, open them suckers up, we want to see our comment! */
			$newTimestamp.find('.show-comments:visible').trigger('click');
			$newTimestamp.find('.add-comment:visible').trigger('click');
         }
       });//end ajax
      return false;
   });//end submit

});
