<?php

/* Register supported fonts. */
$GLOBALS['ppp_fonts'] = Array(
	'Arial' => 'Arial, "Helvetica Neue", Helvetica, sans-serif',
	'Century Gothic' => '"Century Gothic", "Apple Gothic", sans-serif',
	'Franklin Gothic' => '"Franklin Gothic Medium", "Arial Narrow Bold", Arial, sans-serif',
	'Futura' => 'Futura, "Century Gothic", "Apple Gothic", sans-serif',
	'Geneva' => 'Geneva, Verdana, "Lucida Sans", "Lucida Grande", "Lucida Sans Unicode", sans-serif',
	'GillSans/Calibri' => 'GillSans, Calibri, Trebuchet, sans-serif',
	'Lucida Sans' => '"Lucida Sans", "Lucida Grande", "Lucida Sans Unicode", Arial, "Helvetica Neue", Helvetica, sans-serif',
	'Tahoma' => 'Tahoma, Verdana, Geneva, sans-serif',
	'Trebuchet MS' => '"Trebuchet MS", "Lucida Sans", "Lucida Grande", "Lucida Sans Unicode", Arial, "Helvetica Neue", Helvetica, sans-serif',
	'Verdana' => 'Verdana, Tahoma, Geneva, sans-serif',
	'Corbel/Liberation' => 'corbel, "liberation sans", Tahoma, Geneva, sans-serif',
	'Baskerville' => 'Baskerville, "Baskerville Normal", Times, "Times New Roman", serif',
	'Cambria' => 'Cambria, Georgia, Times, Times New Roman, serif',
	'Copperplate' => 'Copperplate Light, Copperplate Gothic Light, Copperplate, serif',
	'Garamond' => 'Garamond, "Hoefler Text", Palatino, "Palatino Linotype", serif',
	'Georgia' => 'Georgia, "Times New Roman", serif',
	'Palatino' => '"Palatino Linotype", Palatino, "Hoefler Text", Times, "Times New Roman", serif',
	'Times' => 'Times, "Times New Roman", Georgia, serif',
	'Courier' => '"Courier New", Courier, monospace',
	'Consolas' => 'Consolas, monospace'
	);


/* CSS FONTS */

function ppp_fontface($name, $comma=1, $theme_options = false) {
	if (!$theme_options) {
		global $ppp_platinum_settings;
		$theme_options = $ppp_platinum_settings;
	}

	$font_css = '';
	$font_css_n = '';
	if ($theme_options["font_css_$name"] != "") {
		$font_css = PPP_UPLOADS_URL.$theme_options["font_css_$name"];
		$font_css_n = ppp_get_filename_short($theme_options["font_css_$name"]);
		$format='truetype';
		if (ppp_get_fileext($theme_options["font_css_$name"]) == "otf") {
		  $format='opentype';
		}
	}

	$font_css_eot = '';
	$font_css_eot_n = '';
	if ($theme_options["font_css_eot_$name"] != "") {
		$font_css_eot = PPP_UPLOADS_URL.$theme_options["font_css_eot_$name"];
		$font_css_eot_n = ppp_get_filename_short($theme_options["font_css_eot_$name"]);
	}

	
	if ($font_css_eot != '') {
		/* FOR IE */
		echo '
		@font-face {
		  font-family: \''.$font_css_eot_n.'\';
		  src: url(\''.$font_css_eot.'\'); /* IE */
		}';
	}
	
	if ($font_css != '') {
		/* FOR EVERYONE ELSE */
	  echo '
		@font-face {
		  font-family: \''.$font_css_n.'\';
		  src: local(\''.$font_css_n.'\'), url(\''.$font_css.'\') format(\''.$format.'\'); /* non-IE */
		}
	 ';
	}
	
	/* append CSS names if more than one */
	if ($font_css_eot != '') {
		if ($font_css != '') {
			$font_css_n = $font_css_n.','. $font_css_eot_n;
		}
	} else {
	  if ($font_css == '') {
		$font_css_n = $font_css_eot_n;
	  }
	}
	
	
	if ($comma == 1) {
	  if ($font_css_n != '') {
		return $font_css_n . ',';
	  }
	}
	return $font_css_n;
}


?>