<?php


/**

Various Functions

**/

function export_snapshot($snappy, $opts) {
	/* Save file to snapshot.ppp under uploads/photopresspro */

	$snappies = unserialize($opts['snapshots']);
	
	/* Make the directory if it doesn't exist yet. */
	$uploadsBase = (ABSPATH.'wp-content/uploads/');
	if (!file_exists($uploadsBase)) {
		mkdir($uploadsBase);
	}
	if (!file_exists(PPP_UPLOADS_DIR)) {
		mkdir(PPP_UPLOADS_DIR);
	}
	
	/* Grab the snapshot and serialize it. */
	$options = takesnapshot($opts);

	$i=0;
//	while ($i < $options['img_fn_hdr_num']) {
	while ($i < 9999) {
		if ($options["img_hdr".$i] == "" && $options["img_fn_hdr".$i] == "") {
			unset($options["img_hdr".$i]);
			unset($options["img_fn_hdr".$i]);
			unset($options["display_image_hdr".$i]);
			unset($options["image_hdr_seq".$i]);
		}
		$i++;
	}

	$stringData = serialize($options);

	if ($stringData) {
		/* Open, write, and close the .ppp file. */
		$myFile = PPP_UPLOADS_DIR.$snappy.".ppp";
		$fh = fopen($myFile, 'w') or die("can't open file");
		fwrite($fh, $stringData);
		fclose($fh);

		return 'exported successfully. File <a href="'.PPP_UPLOADS_URL.$snappy.".ppp".'">'.PPP_UPLOADS_URL.$snappy.".ppp".'</a> was saved. Right-click and Save As to download';
	}
}

function import_snapshot($opts) {
	$ppp_notify = "";
	$snappies = unserialize($opts['snapshots']);
	if (is_array($snappies) && isset($opts['import_snapshot'])) {

		$snappy_file = $opts['import_snapshot'];
		$opts['import_snapshot'] = "";

		/* .ppp file is located in uploads/photopresspro */

		$myFile = PPP_UPLOADS_DIR.$snappy_file;
		if (!file_exists($myFile)) {
			$ppp_notify .= 'Snapshot was not imported. "<strong>'.PPP_UPLOADS_DIR.$snappy_file.'</strong>" could not be found.';
		}

		$fh = fopen($myFile, 'r');
		$theData = fread($fh, filesize($myFile));
		fclose($fh);

		if ($theData) {
			$theData_array = unserialize($theData);
			if (is_array($theData_array)) {

				/* Grab the snapshot name. */
				$snappy = $theData_array['new_snapshot'];
				if (!$snappy) $snappy = $snappy_file;

				$snappies[$snappy] = $theData_array;
				$opts['snapshots'] = serialize($snappies);
				update_option('ppp_platinum3_settings', $opts);
				$ppp_notify .= 'Snapshot imported successfully. File "'.$myFile.'" was imported and saved as <strong>'.$snappy.'</strong> snapshot';
			}
		} else {
			$ppp_notify .= 'Snapshot was not imported. We\'re not sure why, but email a copy of your snapshot to support@photopresspro.com and we\'ll take a look.';
		}
	} else {
		$ppp_notify .= 'Import FAIL! This is technically a beta feature, you know.';
	}

	if ($ppp_notify != "") $opts["ppp_notify"] = $ppp_notify;
	return $opts;
}


/* Get a snapshot from a file */
function ppp_snapshot_file($snappy_file) {
  $myFile = TEMPLATEPATH . '/code/snapshots/' . $snappy_file . '.ppp';
  if (!file_exists($myFile)) {
	exit;
  }

  $fh = fopen($myFile, 'r');
  $theData = fread($fh, filesize($myFile));
  fclose($fh);

  if ($theData) {
	return unserialize($theData);
  }
}




function ppp_upload_input($name, $prompt, $options) {
	$val = "";
	if (isset($options[$name])) {
		$val = $options[$name];
	}
	echo '
<div class="ppp_upload-input"><p>'.$prompt.'</p>
<input id="cp_'.$name.'_file" type="file" name="cp_'.$name.'_file" /> <span class="submit inline_submit"><input class="ppp_submit_upload" type="submit" value="Upload" name="cp_'.$name.'_submit" /></span>
<span class="submit inline_submit"><input type="submit" value="Delete &raquo;" name="cp_'.$name.'_delete" /></span>
<input id="cp_'.$name.'" type="hidden" name="cp_'.$name.'" value="'.$val.'" />
</div>
';
}

function ppp_radio($name, $id, $value, $current_value, $icon, $txt) {
	echo '
<label class="labelCheckbox" for="'.$id.'">
<input name="cp_'.$name.'" id="'.$id.'" type="radio" class="crirHiddenJS" value="'.$value.'" '.($current_value == $value ? ' checked="checked"' : '').' />
<span style="background-image:url('.get_template_directory_uri().'/images/icons/'.$icon.'); height:61px; width:92px; clear:none; float:left;"></span>
</label>
';
}

function ppp_radio_rss($name, $id, $value, $current_value, $icon, $txt) {
	echo '
<label class="labelCheckbox labelHover" for="'.$id.'">
<input name="cp_'.$name.'" id="'.$id.'" type="radio" class="crirHiddenJS" value="'.$value.'" '.($current_value == $value ? ' checked="checked"' : '').' />
<span style="background-image:url('.get_template_directory_uri().'/images/rss/'.$icon.'); height:32px; width:32px; clear:none; float:left;"></span>
</label>
';
}
function ppp_radio_rss_l($name, $id, $value, $current_value, $icon, $txt) {
	echo '
<label class="labelCheckbox labelHover" for="'.$id.'">
<input name="cp_'.$name.'" id="'.$id.'" type="radio" class="crirHiddenJS" value="'.$value.'" '.($current_value == $value ? ' checked="checked"' : '').' />
<span style="background-image:url('.get_template_directory_uri().'/images/rss/'.$icon.'); height:48px; width:48px; clear:none; float:left;"></span>
</label>
';
}

function ppp_opt_border($prompt, $name, $options) {
	echo '<tr><td>'.$prompt.' ';
	echo '</td><td>';
	ppp_opt_border_input($name, $options);
	echo '</td></tr>';
}

function ppp_opt_border_input($name, $options) {
	echo '<input class="widefat color" style="text-align: right; width: 65px" name="cp_'.$name.'_color" id="cp_'.$name.'_color" type="text" value="'.$options[$name."_color"].'" />
	Width: <input class="widefat" style="text-align: right; width: 65px" name="cp_'.$name.'_size" id="cp_'.$name.'_size" type="text" value="'.$options[$name."_size"].'" /> pixels 
	<select name="cp_'.$name.'_style" id="menu_'.$name.'_style">
<option value="solid" '.($options[$name."_style"] == 'solid' ? ' selected="selected"' : '').'>Solid</option>
<option value="dotted" '.($options[$name."_style"] == 'dotted' ? ' selected="selected"' : '').'>Dotted</option>
<option value="dashed" '.($options[$name."_style"] == 'dashed' ? ' selected="selected"' : '').'>Dashed</option>
</select>';
}



function ppp_opt_align($prompt, $name, $options) {
	echo '<tr><td>'.$prompt;
	echo '</td><td>
	<div>
<label class="labelCheckbox" for="align_'.$name.'_left" >
<input name="cp_align_'.$name.'" id="align_'.$name.'_left" type="radio" class="crirHiddenJS" value="left" '.($options["align_$name"] == 'left' ? ' checked="checked"' : '').' />Left</label>
<label class="labelCheckbox" for="align_'.$name.'_center" >
<input name="cp_align_'.$name.'" id="align_'.$name.'_center" type="radio" class="crirHiddenJS" value="center" '.($options["align_$name"] == 'center' ? ' checked="checked"' : '').' />Center</label>
<label class="labelCheckbox" for="align_'.$name.'_right" >
<input name="cp_align_'.$name.'" id="align_'.$name.'_right" type="radio" class="crirHiddenJS" value="right" '.($options["align_$name"] == 'right' ? ' checked="checked"' : '').' />Right</label>
	</div>
';
	echo '</td></tr>';
}

function ppp_opt_align_lr($prompt, $name, $options) {
	echo '<tr><td>'.$prompt;
	echo '</td><td>
	<div>
<label class="labelCheckbox" for="align_'.$name.'_left" >
<input name="cp_align_'.$name.'" id="align_'.$name.'_left" type="radio" class="crirHiddenJS" value="left" '.($options["align_$name"] == 'left' ? ' checked="checked"' : '').' />Left</label>
<label class="labelCheckbox" for="align_'.$name.'_right" >
<input name="cp_align_'.$name.'" id="align_'.$name.'_right" type="radio" class="crirHiddenJS" value="right" '.($options["align_$name"] == 'right' ? ' checked="checked"' : '').' />Right</label>
	</div>
';
	echo '</td></tr>';
}


function ppp_opt_fonts($name, $options, $font_css_name) {
	$f = $GLOBALS['ppp_fonts'];
	echo '

<div class="ppp_fonts">

<h4>Font Face</h4>
<div class="ppp_font_face_div ppp_open_box">
<div class="ppp_web_fonts">
<span class="ppp_table_prompt">Sans Serif</span>
<div class="ppp_fonts_buttons">
<label class="labelCheckbox" for="font_'.$name.'_sans" style="font-family:'.str_replace('"',"",$f['Arial']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_sans" type="radio" class="crirHiddenJS" value="sans" '.($options["font_$name"] == 'sans' ? ' checked="checked"' : '').' />Arial
</label>
<label class="labelCheckbox" for="font_'.$name.'_cent" style="font-family:'.str_replace('"',"",$f['Century Gothic']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_cent" type="radio" class="crirHiddenJS" value="Century Gothic" '.($options["font_$name"] == 'Century Gothic' ? ' checked="checked"' : '').' />Century Gothic
</label>
<label class="labelCheckbox" for="font_'.$name.'_corbel" style="font-family:'.str_replace('"',"",$f['Corbel/Liberation']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_corbel" type="radio" class="crirHiddenJS" value="Corbel/Liberation" '.($options["font_$name"] == 'Corbel/Liberation' ? ' checked="checked"' : '').' />Corbel/Liberation
</label>
<label class="labelCheckbox" for="font_'.$name.'_frank" style="font-family:'.str_replace('"',"",$f['Franklin Gothic']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_frank" type="radio" class="crirHiddenJS" value="Franklin Gothic" '.($options["font_$name"] == 'Franklin Gothic' ? ' checked="checked"' : '').' />Franklin Gothic
</label>
<label class="labelCheckbox" for="font_'.$name.'_futura" style="font-family:'.str_replace('"',"",$f['Futura']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_futura" type="radio" class="crirHiddenJS" value="Futura" '.($options["font_$name"] == 'Futura' ? ' checked="checked"' : '').' />Futura<small>(mac)</small>
</label>
</div>
<div class="ppp_fonts_buttons">
<label class="labelCheckbox" for="font_'.$name.'_geneva" style="font-family:'.str_replace('"',"",$f['Geneva']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_geneva" type="radio" class="crirHiddenJS" value="Geneva" '.($options["font_$name"] == 'Geneva' ? ' checked="checked"' : '').' />Geneva<small>(mac)</small>
</label>
<label class="labelCheckbox" for="font_'.$name.'_gill" style="font-family:'.str_replace('"',"",$f['GillSans/Calibri']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_gill" type="radio" class="crirHiddenJS" value="GillSans/Calibri" '.($options["font_$name"] == 'GillSans/Calibri' ? ' checked="checked"' : '').' />GillSans/Calibri
</label>
<label class="labelCheckbox" for="font_'.$name.'_lucida" style="font-family:'.str_replace('"',"",$f['Lucida Sans']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_lucida" type="radio" class="crirHiddenJS" value="lucida" '.($options["font_$name"] == 'lucida' ? ' checked="checked"' : '').' />Lucida Sans
</label>
<label class="labelCheckbox" for="font_'.$name.'_tahoma" style="font-family:'.str_replace('"',"",$f['Tahoma']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_tahoma" type="radio" class="crirHiddenJS" value="Tahoma" '.($options["font_$name"] == 'Tahoma' ? ' checked="checked"' : '').' />Tahoma
</label>
<label class="labelCheckbox" for="font_'.$name.'_trebuchet" style="font-family:'.str_replace('"',"",$f['Trebuchet MS']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_trebuchet" type="radio" class="crirHiddenJS" value="trebuchet" '.($options["font_$name"] == 'trebuchet' ? ' checked="checked"' : '').' />Trebuchet MS
</label>
<label class="labelCheckbox" for="font_'.$name.'_verdana" style="font-family:'.str_replace('"',"",$f['Verdana']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_verdana" type="radio" class="crirHiddenJS" value="Verdana" '.($options["font_$name"] == 'Verdana' ? ' checked="checked"' : '').' />Verdana
</label>

</div>

<br clear="all" /><span class="ppp_table_prompt">Serif</span>

<div class="ppp_fonts_buttons">

<label class="labelCheckbox" for="font_'.$name.'_baskerville" style="font-family:'.str_replace('"',"",$f['Baskerville']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_baskerville" type="radio" class="crirHiddenJS" value="Baskerville" '.($options["font_$name"] == 'Baskerville' ? ' checked="checked"' : '').' />Baskerville</label>
<label class="labelCheckbox" for="font_'.$name.'_cambria" style="font-family:'.str_replace('"',"",$f['Cambria']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_cambria" type="radio" class="crirHiddenJS" value="Cambria" '.($options["font_$name"] == 'Cambria' ? ' checked="checked"' : '').' />Cambria</label>
<label class="labelCheckbox" for="font_'.$name.'_copperplate" style="font-family:'.str_replace('"',"",$f['Copperplate']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_copperplate" type="radio" class="crirHiddenJS" value="Copperplate" '.($options["font_$name"] == 'Copperplate' ? ' checked="checked"' : '').' />Copperplate</label>
<label class="labelCheckbox" for="font_'.$name.'_garamond" style="font-family:'.str_replace('"',"",$f['Garamond']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_garamond" type="radio" class="crirHiddenJS" value="Garamond" '.($options["font_$name"] == 'Garamond' ? ' checked="checked"' : '').' />Garamond</label>
<label class="labelCheckbox" for="font_'.$name.'_serif" style="font-family:'.str_replace('"',"",$f['Georgia']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_serif" type="radio" class="crirHiddenJS" value="serif" '.($options["font_$name"] == 'serif' ? ' checked="checked"' : '').' />Georgia</label>
<label class="labelCheckbox" for="font_'.$name.'_palatino" style="font-family:'.str_replace('"',"",$f['Palatino']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_palatino" type="radio" class="crirHiddenJS" value="Palatino" '.($options["font_$name"] == 'Palatino' ? ' checked="checked"' : '').' />Palatino</label>
<label class="labelCheckbox" for="font_'.$name.'_times" style="font-family:'.str_replace('"',"",$f['Times']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_times" type="radio" class="crirHiddenJS" value="Times" '.($options["font_$name"] == 'Times' ? ' checked="checked"' : '').' />Times</label>

</div>

<br clear="all" /><span class="ppp_table_prompt">Monospace</span>

<div class="ppp_fonts_buttons">

<label class="labelCheckbox" for="font_'.$name.'_courier" style="font-family:'.str_replace('"',"",$f['Courier']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_courier" type="radio" class="crirHiddenJS" value="Courier" '.($options["font_$name"] == 'Courier' ? ' checked="checked"' : '').' />Courier</label>
<label class="labelCheckbox" for="font_'.$name.'_consolas" style="font-family:'.str_replace('"',"",$f['Consolas']).'">
<input name="cp_font_'.$name.'" id="font_'.$name.'_consolas" type="radio" class="crirHiddenJS" value="Consolas" '.($options["font_$name"] == 'Consolas' ? ' checked="checked"' : '').' />Consolas</label>

</div>

</div><!-- .ppp_web_fonts -->

';

/* CSS FONTS */

	echo '
<div class="ppp_css_fonts">
<span class="ppp_table_prompt">CSS Fonts</span>
<div class="ppp_css_fonts_inner">
<p><small>Upload a TTF or OTF file for viewing in most modern browsers.</small></p>
<input id="cp_font_css_'.$name.'_file" type="file" name="cp_font_css_'.$name.'_file" /> <span class="submit inline_submit"><input class="ppp_submit_upload" type="submit" value="Upload" name="cp_font_css_submit_'.$name.'" /></span>
<span class="submit inline_submit"><input type="submit" value="Delete &raquo;" name="cp_font_css_'.$name.'_delete" /></span><br />
<input id="cp_font_css_'.$name.'" type="hidden" name="cp_font_css_'.$name.'" value="'.$options["font_css_$name"].'" />
';

if ($options["font_css_$name"] != "") {
echo '
<div class="ppp_font_css_preview" style="font-family:'.$font_css_name.'">You are using &quot;'.$options["font_css_$name"].'&quot; for Firefox, Safari, Chrome, and Opera users.</div><br />
';
}

echo '<p><small>Upload an EOT file for viewing in IE6, IE7, and IE8.</small></p>
<input id="cp_font_css_eot_'.$name.'_file" type="file" name="cp_font_css_eot_'.$name.'_file" /> <span class="submit inline_submit"><input class="ppp_submit_upload" type="submit" value="Upload" name="cp_font_css_eot_submit_'.$name.'" /></span>
<span class="submit inline_submit"><input type="submit" value="Delete &raquo;" name="cp_font_css_eot_'.$name.'_delete" /></span><br />
<input id="cp_font_css_eot_'.$name.'" type="hidden" name="cp_font_css_eot_'.$name.'" value="'.$options["font_css_eot_$name"].'" />
';

if ($options["font_css_eot_$name"] != "") {
echo '
<div class="ppp_font_css_preview" style="font-family:'.$font_css_name.'">You are using &quot;'.$options["font_css_eot_$name"].'&quot; for Internet Explorer users.</div><br />
';
}

	echo '
	</div><!-- .ppp_css_fonts_inner -->
	</div><!-- .ppp_css_fonts -->
</div><!-- .ppp_font_face_div -->

	';

	echo '<h4>Font Style</h4>';

	echo '
<div class="ppp_font_style_div ppp_open_box">

<div class="ppp_fonts_buttons">
<span class="ppp_table_prompt">Size</span>
<div style="float:left">
<label class="labelCheckbox" for="fontsize_'.$name.'_small" >
<input name="cp_fontsize_'.$name.'" id="fontsize_'.$name.'_small" type="radio" class="crirHiddenJS" value="small" '.($options["fontsize_$name"] == 'small' ? ' checked="checked"' : '').' />Small</label>
<label class="labelCheckbox" for="fontsize_'.$name.'_normal" >
<input name="cp_fontsize_'.$name.'" id="fontsize_'.$name.'_normal" type="radio" class="crirHiddenJS" value="normal" '.($options["fontsize_$name"] == 'normal' ? ' checked="checked"' : '').' />Normal</label>
<label class="labelCheckbox" for="fontsize_'.$name.'_large" >
<input name="cp_fontsize_'.$name.'" id="fontsize_'.$name.'_large" type="radio" class="crirHiddenJS" value="large" '.($options["fontsize_$name"] == 'large' ? ' checked="checked"' : '').' />Large</label>
<label class="labelCheckbox" for="fontsize_'.$name.'_custom" >
<input name="cp_fontsize_'.$name.'" id="fontsize_'.$name.'_custom" type="radio" class="crirHiddenJS" value="custom" '.($options["fontsize_$name"] == 'custom' ? ' checked="checked"' : '').' />Custom &raquo;</label>
</div>
';
	echo '<input class="labelCheckbox crirInput" name="cp_fontsize_'.$name.'_user" id="cp_fontsize_'.$name.'_user" type="text" value="'.$options["fontsize_".$name."_user"].'" /> pixels
</div>
	';

	echo '

<div class="ppp_fonts_buttons_small">
<span class="ppp_table_prompt">Alignment</span>
<div>
<label class="labelCheckbox" for="align_'.$name.'_left" >
<input name="cp_align_'.$name.'" id="align_'.$name.'_left" type="radio" class="crirHiddenJS" value="left" '.($options["align_$name"] == 'left' ? ' checked="checked"' : '').' />Left</label>
<label class="labelCheckbox" for="align_'.$name.'_center" >
<input name="cp_align_'.$name.'" id="align_'.$name.'_center" type="radio" class="crirHiddenJS" value="center" '.($options["align_$name"] == 'center' ? ' checked="checked"' : '').' />Center</label>
<label class="labelCheckbox" for="align_'.$name.'_right" >
<input name="cp_align_'.$name.'" id="align_'.$name.'_right" type="radio" class="crirHiddenJS" value="right" '.($options["align_$name"] == 'right' ? ' checked="checked"' : '').' />Right</label>
</div>
</div>
';

	echo '
<br clear="all" />
<div class="ppp_fonts_buttons">
<span class="ppp_table_prompt">Text case</span>
<div>
<label class="labelCheckbox" for="'.$name.'_text_style_normal" >
<input name="cp_'.$name.'_text_style" id="'.$name.'_text_style_normal" type="radio" class="crirHiddenJS" value="normal" '.($options[($name."_text_style")] == 'normal' ? ' checked="checked"' : '').' />Normal</label>
<label class="labelCheckbox" for="'.$name.'_text_style_lower" >
<input name="cp_'.$name.'_text_style" id="'.$name.'_text_style_lower" type="radio" class="crirHiddenJS" value="lower" '.($options[($name."_text_style")] == 'lower' ? ' checked="checked"' : '').' />Lowercase</label>
<label class="labelCheckbox" for="'.$name.'_text_style_upper" >
<input name="cp_'.$name.'_text_style" id="'.$name.'_text_style_upper" type="radio" class="crirHiddenJS" value="upper" '.($options[($name."_text_style")] == 'upper' ? ' checked="checked"' : '').' />Uppercase</label>
<label class="labelCheckbox" for="'.$name.'_text_style_smallcaps" >
<input name="cp_'.$name.'_text_style" id="'.$name.'_text_style_smallcaps" type="radio" class="crirHiddenJS" value="smallcaps" '.($options[($name."_text_style")] == 'smallcaps' ? ' checked="checked"' : '').' />Small Caps</label>
</div></div>';

	echo '

<div class="ppp_fonts_buttons_small">
<span class="ppp_table_prompt">Style</span>
<div>
<label class="labelCheckbox" for="cp_'.$name.'_bold">
<input type="checkbox" name="cp_'.$name.'_bold" id="cp_'.$name.'_bold"'.($options[($name."_bold")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />
<strong>Bold?</strong>
</label>
<label class="labelCheckbox" for="cp_'.$name.'_ital">
<input type="checkbox" name="cp_'.$name.'_ital" id="cp_'.$name.'_ital"'.($options[($name."_ital")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />
<em>Italic?</em>
</label>
</div>
</div>

<br clear="all" />

<div class="ppp_fonts_buttons">
<span class="ppp_table_prompt">Text Shadows</span>
<div>
<label class="labelCheckbox" for="'.$name.'_text_shadow_none" >
<input name="cp_'.$name.'_text_shadow" id="'.$name.'_text_shadow_none" type="radio" class="crirHiddenJS" value="none" '.((!isset($options[($name."_text_shadow")]) || $options[($name."_text_shadow")] == 'none') ? ' checked="checked"' : '').' />None</label>
<label class="labelCheckbox ppp_softshadow" for="'.$name.'_text_shadow_soft" >
<input name="cp_'.$name.'_text_shadow" id="'.$name.'_text_shadow_soft" type="radio" class="crirHiddenJS" value="soft" '.($options[($name."_text_shadow")] == 'soft' ? ' checked="checked"' : '').' />Soft Shadow</label>
<label class="labelCheckbox ppp_dropshadow" for="'.$name.'_text_shadow_drop" >
<input name="cp_'.$name.'_text_shadow" id="'.$name.'_text_shadow_drop" type="radio" class="crirHiddenJS" value="drop" '.($options[($name."_text_shadow")] == 'drop' ? ' checked="checked"' : '').' />Drop Shadow</label>
<label class="labelCheckbox ppp_letterpress" for="'.$name.'_text_shadow_letter" >
<input name="cp_'.$name.'_text_shadow" id="'.$name.'_text_shadow_letter" type="radio" class="crirHiddenJS" value="letter" '.($options[($name."_text_shadow")] == 'letter' ? ' checked="checked"' : '').' />Letterpress Light</label>
<label class="labelCheckbox ppp_letterpress" for="'.$name.'_text_shadow_letterdk" >
<input name="cp_'.$name.'_text_shadow" id="'.$name.'_text_shadow_letterdk" type="radio" class="crirHiddenJS" value="letterdk" '.($options[($name."_text_shadow")] == 'letterdk' ? ' checked="checked"' : '').' />Letterpress Dark</label>
</div>
</div>


</div><!-- .ppp_font_style_div -->

</div><!-- .ppp_fonts_div -->';
}

/**
  Convert new lines to paragraphs for display.
  */
function nls2p($str)
{
  return str_replace('<p></p>', '', '<p>'
        . preg_replace('#([\r\n]\s*?[\r\n]){2,}#', '</p>$0<p>', $str)
        . '</p>');
}

/**
  Echo an <img> or <div> that contains a smaller image and a link to view full-size.
  i.e. <img class="ppp_cp_img" style=" max-width:436px;" src="'.$this->options["img_bg"].'" alt="Background image" />
  */
function ppp_get_cp_img($uploadsDirectory, $img_fn, $img_url, $alt_text, $min_width, $fieldname) {
	$str ='<input type="text" style="display:none" value="'.$img_fn.'" name="cp_img_fn_'.$fieldname.'" />';
	return '<img class="ppp_cp_img" src="'.$img_url.'" alt="'.$alt_text.'" />'.$str;
}

/**
  Save uploaded image.
  */
function save_uploaded_image($fieldname, $uploadsDirectory) {

	//filename strip code from http://snipplr.com/view/3670/regular-expressions-filename-replace/
	$filename = preg_replace("/[^a-zA-Z0-9s.]/", "_", $_FILES[$fieldname]['name']);

	/* Update background image */
  if (($_FILES[$fieldname]['error'] == 0) &&
	  (@is_uploaded_file($_FILES[$fieldname]['tmp_name']))) {

	/* Get the url to use in HTML */
	$uploadFilename = $uploadsDirectory.$filename;
	if (file_exists($uploadFilename)) {

		// make a unique filename for the uploaded file and check it is 
		// not taken... if it is keep trying until we find a vacant one
		$now = time();
		$filename = $now.'-'.$filename;
		while(file_exists($uploadFilename = $uploadsDirectory.$filename))
		{
			$now++;
			$filename = $now.'-'.$filename;
		}
	}

	// now let's move the file to its final and allocate it with the new filename
	@move_uploaded_file($_FILES[$fieldname]['tmp_name'], $uploadFilename);

	/* Get the url to use in HTML */
	return $filename;

  }
}

/**
  Save uploaded image.
  */
function save_uploaded_file($fieldname, $uploadsDirectory) {

	//filename strip code from http://snipplr.com/view/3670/regular-expressions-filename-replace/
	$filename = preg_replace("/[^a-zA-Z0-9s.]/", "_", $_FILES[$fieldname]['name']);

	/* Update background image */
  if (($_FILES[$fieldname]['error'] == 0) &&
	  (@is_uploaded_file($_FILES[$fieldname]['tmp_name']))) {

	// now let's move the file to its final and allocate it with the new filename
	@move_uploaded_file($_FILES[$fieldname]['tmp_name'], $uploadsDirectory.$filename);

	/* Get the url to use in HTML */
	return $filename;
  }
}

function ppp_get_filename($url) {
	//filename strip code from http://snipplr.com/view/3670/regular-expressions-filename-replace/
	return preg_replace("/[^a-zA-Z0-9s.]/", "_", $url);
}

function ppp_get_filename_short($url) {
	//filename strip code from http://snipplr.com/view/3670/regular-expressions-filename-replace/
	$url = preg_replace("/[^a-zA-Z0-9s.]/", "_", $url);
	return substr($url, 0, strpos($url, '.'));
}

function ppp_get_fileext($filename) {
$filename = strtolower($filename);
$exts = split("[/\\.]", $filename);
$n = count($exts)-1;
$exts = $exts[$n];
return $exts;
}

/**
  get image height
  */
function ppp_getimgheight($file) {

	list($width,$height)=getimagesize($file);
	if (isset($height)) {
	  return $height;
	}

	/* Fallback if no webserver support. */
	$data = ppp_getimginfo($file);
	if (isset($data) && is_array($data)) {
		return $data['height'];
	} else {
		return imagesy($file);
	}
}

/**
  get image height
  */
function ppp_getimgwidth($file) {
	list($width,$height)=getimagesize($file);
	if (isset($width)) {
	  return $width;
	}

	/* Fallback if no webserver support. */
	$data = ppp_getimginfo($file);
	if (isset($data) && is_array($data)) {
		return $data['width'];
	} else {
		return imagesx($file);
	}
}

/**
 Borrowed from a drupal forum from days past. Thanks FOSS.
*/
function ppp_getimginfo($file) {

  if (!is_file($file)) {
    return FALSE;
  }

  $details = FALSE;
  $data = @getimagesize($file);
  $file_size = @filesize($file);

  if (isset($data) && is_array($data)) {
    $extensions = array('1' => 'gif', '2' => 'jpg', '3' => 'png');
    $extension = array_key_exists($data[2], $extensions) ?  $extensions[$data[2]] : '';
    $details = array('width'     => $data[0],
                     'height'    => $data[1],
                     'extension' => $extension,
                     'file_size' => $file_size,
                     'mime_type' => $data['mime']);
  }

  return $details;

}

/**
  Remove "snapshots" from an array and return the array.
  */
function takesnapshot($array) {
	unset($array['snapshots']);
	return $array;
}

/**
  Image methods for the CP.
  */
function check_and_delete_img($fieldName, $displayText, $uploadsDirectory, $options) {
	$ppp_notify = "";
	if (isset($_POST['cp_delete_img_'.$fieldName])) {

		/* Don't delete file. May be used in another snapshot. */
/*		@unlink($uploadsDirectory . $options["img_fn_".$fieldName]);*/

		if (isset($_POST["cp_img_".$fieldName])) unset($_POST["cp_img_".$fieldName]);
		if (isset($_POST["cp_img_fn_".$fieldName])) unset($_POST["cp_img_fn_".$fieldName]);
		if (isset($_POST['cp_delete_img_'.$fieldName])) unset($_POST['cp_delete_img_'.$fieldName]);
		if (isset($options["img_".$fieldName])) unset($options["img_".$fieldName]);
		if (isset($options["img_fn_".$fieldName])) unset($options["img_fn_".$fieldName]);
		if (isset($options["display_image_".$fieldName])) unset($options["display_image_".$fieldName]);

		$ppp_notify .= '<p class="ppp_notify">'.$displayText.' image deleted.</p>';
	}
	if ($ppp_notify != "") {
		if (isset($options["ppp_notify"])) $ppp_notify .= $options["ppp_notify"];
		$options["ppp_notify"] = $ppp_notify;
	}

	return $options;
}

/**
  Image methods for the CP.
  */
function check_and_delete_file($fieldName, $displayText, $uploadsDirectory, $options) {
	$ppp_notify = "";
	if (isset($_POST['cp_'.$fieldName.'_delete'])) {
		unset($_POST['cp_'.$fieldName.'_delete']);
		unset($_POST['cp_'.$fieldName]);
		unset($options[$fieldName]);
		$ppp_notify = '<p class="ppp_notify">'.$displayText.' image deleted.</p>';
	}
	if ($ppp_notify != "") {
		if (isset($options["ppp_notify"])) $ppp_notify .= $options["ppp_notify"];
		$options["ppp_notify"] = $ppp_notify;
	}
	return $options;
}



/**
  Echo linked image tag.
*/
function ppp_img_tag($fieldname, $options, $class, $alt_text) {
	echo '<a href="'.ppp_get_img_url($fieldname, $options).'" target="_blank"><img src="'.ppp_get_img_url($fieldname, $options).'" alt="'.$alt_text.'" title="'.$alt_text.' - Click to open in a new window" class="'.$class.'" /></a>';
}


/**
  Return the URL of an image.
*/
function ppp_get_img_url($fieldName, $options){
	/* First look for a saved filename. This is cleared when a new URL is manually entered.
	   If present, prepend the uploads url and return it.  */
	if (isset($options['img_fn_'.$fieldName])) {
	$img_fn = $options['img_fn_'.$fieldName];
	if ($img_fn) {
	  if (file_exists(PPP_UPLOADS_DIR.$img_fn)) return PPP_UPLOADS_URL.$img_fn;

	/* Fallback on theme images directory */
	  if (file_exists(PPP_IMAGES_DIR.'headers/'.$img_fn)) return PPP_IMAGES_URL.'headers/'.$img_fn;
	}
	}

	/* Then look for a saved URL. If present, return it. */
	if (isset($options['img_'.$fieldName])) {
	$img_url = $options['img_'.$fieldName];
	if ($img_url) return $img_url;
	}
}
function ppp_img_url($fieldName, $options){
	echo ppp_get_img_url($fieldName, $options);
}


function ppp_upload_img($fieldName, $displayText, $options) {
	$ppp_notify = "";

	/* If a URL is present, save it. */
	$tmp_url = "";
	if (isset($_POST['cp_img_'.$fieldName])) {
		$tmp_url = stripslashes($_POST['cp_img_'.$fieldName]);
		if ($tmp_url != "") {
			if (isset($options["img_".$fieldName]) && $options["img_".$fieldName] != $tmp_url) {
				/* Check if the URL is a built-in one. If so, don't save it, silly. */
				$pos = strpos($tmp_url, 'ppp_platinum3');
				if ($pos === false) {
					/* If this is a new, external image URL. Clear the field name so everybody's straight.*/
					$options["display_image_".$fieldName] = 1;
					if (isset($options["img_fn_".$fieldName])) unset($options["img_fn_".$fieldName]);
					if (isset($_POST['cp_img_fn_'.$fieldName])) unset($options["img_fn_".$fieldName]);
					$ppp_notify .= '<p class="ppp_notify">'.$displayText.' image URL saved.</p>';
				}
			}
		}
$options["img_".$fieldName] = $tmp_url;
	} else {
if (isset($options["img_".$fieldName])) unset($options["img_".$fieldName]);
	}


	/* If a cp_img_fn is present, this is a previously uploaded image. Save it. */
	$tmp_fn = "";
	if (isset($_POST['cp_img_fn_'.$fieldName])) {
		$tmp_fn = stripslashes($_POST['cp_img_fn_'.$fieldName]);
$options["img_fn_".$fieldName] = $tmp_fn;
	} else {
if (isset($options["img_fn_".$fieldName])) unset($options["img_fn_".$fieldName]);
	}

	/* If an image is uploaded, save it. */
	if (isset($_FILES['cp_upload_image_'.$fieldName]['tmp_name']) && @is_uploaded_file($_FILES['cp_upload_image_'.$fieldName]['tmp_name'])) {

		/* Make the directory if it doesn't exist yet. */
	    $uploadsBase = (ABSPATH.'wp-content/uploads/');
		if (!file_exists($uploadsBase)) {
			mkdir($uploadsBase);
		}
		if (!file_exists(PPP_UPLOADS_DIR)) {
			mkdir(PPP_UPLOADS_DIR);
		}
		$new_filename = save_uploaded_image('cp_upload_image_'.$fieldName, PPP_UPLOADS_DIR);
		if ($new_filename != "" ) {
			$options["img_fn_".$fieldName] = $new_filename;
			/* This is a new, uploaded image. Save the URL so everybody's straight. */
			$options["img_".$fieldName] = PPP_UPLOADS_URL . $new_filename;
			$options["display_image_".$fieldName] = 1;
			/* Save image height/width for css adjustments. */
			if ($fieldName == 'pb' && ($options["pb_image_height"] == "")) {
				$tmp_h = ppp_getimgheight(PPP_UPLOADS_DIR . $new_filename);
				$options["pb_image_height"] = $tmp_h;
				$ppp_notify .= '<p class="ppp_notify">'.$displayText.' image height changed to '.$tmp_h.' pixels.</p>';
			}
			if ($fieldName == 'bio' || $fieldName == 'thumb') {
				if ($options[$fieldName."_image_height"] == "") {
					$tmp_h = ppp_getimgheight(PPP_UPLOADS_DIR . $new_filename);
					$options[$fieldName."_image_height"] = $tmp_h;
					$ppp_notify .= '<p class="ppp_notify">'.$displayText.' image height changed to '.$tmp_h.' pixels.</p>';
				}
				if ($options[$fieldName."_image_width"] == "") {
					$tmp_w = ppp_getimgwidth(PPP_UPLOADS_DIR . $new_filename);
					$options[$fieldName."_image_width"] = $tmp_w;
					$ppp_notify .= '<p class="ppp_notify">'.$displayText.' image width changed to '.$tmp_w.' pixels.</p>';
				}
			}
			$ppp_notify .= '<p class="ppp_notify">'.$displayText.' image uploaded.</p>';
		}
	} else {

		/* Show an error. */
		if (isset($_POST['cp_upload_image_submit_'.$fieldName])) {

			$ppp_notify .= '<p class="ppp_notify">';
			if (!isset($_FILES['cp_upload_image_'.$fieldName]['error'])) {
				$ppp_notify .= "There was a problem with your upload. Ask your webhost to increase your PHP max_upload_size and max_file_uploads to the maximum values.";
			} else {
				switch($_FILES['cp_upload_image_'.$fieldName]['error']){
					case 0: //no error; possible file attack!
					  $ppp_notify .= "There was a problem with your upload. error 0";
					  break;
					case 1: //uploaded file exceeds the upload_max_filesize directive in php.ini
					  $ppp_notify .= "The file you are trying to upload is too big. error 1";
					  break;
					case 2: //uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the html form
					  $ppp_notify .= "The file you are trying to upload is too big. error 2";
					  break;
					case 3: //uploaded file was only partially uploaded
					  $ppp_notify .= "The file you are trying upload was only partially uploaded. error 3";
					  break;
					case 4: //no file was uploaded
					  $ppp_notify .= "You must select an image for upload. error 4";
					  break;
					default: //a default error, just in case!  :)
					  $ppp_notify .= "There was a problem with your upload. error default";
					  break;
				}
			}
			$ppp_notify .= '</p>';
		}
	}
	
	if ($ppp_notify != "") {
		if (isset($options["ppp_notify"])) $ppp_notify .= $options["ppp_notify"];
		$options["ppp_notify"] = $ppp_notify;
	}
	
	return $options;
}


function ppp_upload_file($fieldName, $displayText, $uploadsDirectory, $upload_dir_url, $options, $uploading_only) {
	$ppp_notify = "";
	if (isset($_FILES['cp_'.$fieldName.'_file']['tmp_name']) && @is_uploaded_file($_FILES['cp_'.$fieldName.'_file']['tmp_name'])) {
		/* Make the directory if it doesn't exist yet. */
	    $uploadsBase = (ABSPATH.'wp-content/uploads/');
		if (!file_exists($uploadsBase)) {
			mkdir($uploadsBase);
		}
		if (!file_exists($uploadsDirectory)) {
			mkdir($uploadsDirectory);
		}
		$new_filename = save_uploaded_file('cp_'.$fieldName.'_file', $uploadsDirectory);
		if ($new_filename != "" ) {
			$options[$fieldName] = $new_filename;
			$ppp_notify = '<p class="ppp_notify">'.$displayText.' file uploaded.</p>';
		}
	} else {
		/* If uploaded earlier, hold on to it. */
		$tmp_fn = $_POST['cp_'.$fieldName];
		if ($tmp_fn != "") {
			$options[$fieldName] = $tmp_fn;
		} else {
			$options[$fieldName] = "";
		}
	}
	if ($ppp_notify != "") $options["ppp_notify"] = $ppp_notify;

	return $options;
}


/*
Bulk Image Posting
*/

/* Insert content into the post editor. */
function ppp_insert_to_editor($html) {
?>
<script type="text/javascript">
/* <![CDATA[ */
var win = window.dialogArguments || opener || parent || top;
win.send_to_editor('<?php echo str_replace('\\\n','\\n',addslashes($html)); ?>');
/* ]]> */
</script>
  <?php
  exit;
}

/* Insert the [ppp_slideshow] shortcode. */
function ppp_insert_slide_handler() {
  global $post_ID, $temp_ID;
  $post_id = (int) (0 == $post_ID ? $temp_ID : $post_ID);
  check_admin_referer('media-form');

  if ( !empty($_POST['attachments']) ) {
    $result = '\\n[ppp_slideshow]\\n';
    return ppp_insert_to_editor($result);
  }

  return $errors;
}


/* Insert all images directly into the post. */
function ppp_insert_form_handler() {
  global $post_ID, $temp_ID;
  $post_id = (int) (0 == $post_ID ? $temp_ID : $post_ID);
  check_admin_referer('media-form');

  $betweenStr = '';
  $blankLines = 2;

  if ( !empty($_POST['attachments']) ) {
	$result = '';
	foreach ( $_POST['attachments'] as $attachment_id => $attachment ) {
		$attachment = stripslashes_deep( $attachment );

		$html = $attachment['post_title'];
		if ( !empty($attachment['url']) ) {
		  if ( strpos($attachment['url'], 'attachment_id') || false !== strpos($attachment['url'], get_permalink($post_id)) )
			$rel = " rel='attachment wp-att-".attribute_escape($attachment_id)."'";
			$html = "<a href='{$attachment['url']}'$rel>$html</a>";
		}
		$html = apply_filters('media_send_to_editor', $html, $attachment_id, $attachment);

		$result .= $html.str_repeat("\\n".$betweenStr."\\n",$blankLines);
	}
	return ppp_insert_to_editor($result);
  }

  return $errors;
}

//filter for media_upload_gallery, recognize pppinsertall request.
function ppp_insert_media_upload_gallery() {
  if ( isset($_POST['pppinsertslide']) ) {
    $return = ppp_insert_slide_handler();
    
    if ( is_string($return) )
      return $return;
    if ( is_array($return) )
      $errors = $return;
  }
  if ( isset($_POST['pppinsertall']) ) {
    $return = ppp_insert_form_handler();
    
    if ( is_string($return) )
      return $return;
    if ( is_array($return) )
      $errors = $return;
  }
}

//filter for media_upload_image, recognize pppinsertall request.
function ppp_insert_media_upload_image() {
  if ( isset($_POST['pppinsertslide']) ) {
    $return = ppp_insert_slide_handler();
    
    if ( is_string($return) )
      return $return;
    if ( is_array($return) )
      $errors = $return;
  }
  if ( isset($_POST['pppinsertall']) ) {
    $return = ppp_insert_form_handler();
    
    if ( is_string($return) )
      return $return;
    if ( is_array($return) )
      $errors = $return;
  }
}

//filter for media_upload_library, recognize pppinsertall request.
function ppp_insert_media_upload_library() {
  if ( isset($_POST['pppinsertslide']) ) {
    $return = ppp_insert_slide_handler();
    
    if ( is_string($return) )
      return $return;
    if ( is_array($return) )
      $errors = $return;
  }
  if ( isset($_POST['pppinsertall']) ) {
    $return = ppp_insert_form_handler();
    
    if ( is_string($return) )
      return $return;
    if ( is_array($return) )
      $errors = $return;
  }
}

add_filter('media_upload_gallery', 'ppp_insert_media_upload_gallery');
add_filter('media_upload_library', 'ppp_insert_media_upload_library');
add_filter('media_upload_image', 'ppp_insert_media_upload_image');

?>