<?php

class ControlPanel {
  var $default_settings;

  function ControlPanel() {

	$this->default_settings = ppp_snapshot_file('2011');

	/* Save AJAX settings and get out. */
/*	$ppp_ajax_submit=false;
	if ($_POST['pppAjaxSubmit'] == '1') {
		$_POST['pppAjaxSubmit'] = '';
		$ppp_ajax_submit=true;
		include(TEMPLATEPATH . '/code/cp_save.php');
		exit;
	}*/


	/* Create the control panel */
    add_action('admin_menu', array(&$this, 'admin_menu'));

	/* Check restore_defaults and do it. */
	/* If no options are found, save the defaults. */
	if (isset($_POST['confirm_restore_defaults']) || !is_array(get_option('ppp_platinum3_settings'))) {

	  $snaps = serialize(Array('2011 [Platinum3]' => $this->default_settings));

	  $this->default_settings['snapshots'] = $snaps;

	  update_option('ppp_platinum3_settings', $this->default_settings);
	}

	$this->options = get_option('ppp_platinum3_settings');
  }

  function admin_menu() {
	/* Create the settings page, and load the scripts it needs. */
	$icon_url = get_template_directory_uri() . '/images/menuicon.png';
    $page = add_theme_page('PPP Platinum3 Control Panel', '<img src="'.$icon_url.'" alt="" style="float:left;display:inline;margin-right:4px;height:36px;width:22px;border:0"/>PPP Platinum3 Control Panel', 'edit_themes', "platinum3", array(&$this, 'optionsmenu'));

	add_action( "load-{$page}", array(&$this, 'ppp_admin_enqueue_script') );
	add_action( "load-{$page}", array(&$this, 'ppp_admin_enqueue_style') );
	
  }

  function ppp_admin_enqueue_script() {
	$ppp_dir = get_template_directory_uri();

	wp_enqueue_script( 'ppp-crir-js', $ppp_dir . '/code/js/crir/crir.js' );

	wp_enqueue_script( 'jquery' );
	wp_enqueue_script( 'ppp-toggle', $ppp_dir . '/code/js/toggle.js' );
	wp_enqueue_script( 'ppp-jscolor-js', $ppp_dir . '/code/js/jscolor/jscolor.js' );
	wp_enqueue_script( 'ppp-controlpanel-js', $ppp_dir . '/code/js/controlpanel.js' );
	wp_enqueue_script( 'ppp-idTabs-js', $ppp_dir . '/code/js/jquery.idTabs.min.js' );

/* Uncomment for Ajax saving

wp_enqueue_script( 'jquery-form' );

// embed the javascript file that makes the AJAX request
wp_enqueue_script( 'ppp-ajax-request', $ppp_dir . '/code/js/ajax.js', array( 'jquery' ) );
wp_localize_script( 'ppp-ajax-request', 'pppajax', array(
	// URL to wp-admin/admin-ajax.php to process the request
	'ajaxurl'          => admin_url( 'admin-ajax.php' ),

	// generate a nonce with a unique ID "pppajax-controlpanel-nonce"
	// so that you can check it later when an AJAX request is sent
	'pppControlPanelNonce' => wp_create_nonce( 'pppajax-controlpanel-nonce' ),
	)
);
*/

  }

  function ppp_admin_enqueue_style() {
	wp_enqueue_style( 'ppp-crir-css', get_template_directory_uri() . '/code/js/crir/crir.css' );
	wp_enqueue_style( 'ppp-controlpanel-css', get_template_directory_uri() . '/code/controlpanel.css' );
	wp_enqueue_style( 'ppp-sexybuttons-css', get_template_directory_uri() . '/code/css/SexyButtons/sexybuttons.css' );
  }


	/*
	The Main Method.
	*/
  function optionsmenu() {

	/*
		IMPORT OLD SETTINGS
	*/
	if (is_array(get_option('ppp_platinum2_settings')) || is_array(get_option('ppp_platinum_settings')) || is_array(get_option('ppp_settings')) ) {

	  /* If not dismissed and have ppp_settings, show the welcome message. */
	  if (isset($_POST['import_stop']) || isset($_POST['cp_import'])) {
		update_option('ppp3_show_welcome', 'hide');
	  }

	  $hide = get_option('ppp3_show_welcome');
	  if ($hide != 'hide') {
		echo '<div class="ppp_ajax_response_div">
		<p>Thank you for using <strong>PhotoPressPro Platinum3</strong>!</p><br />
		<p>We\'ve found some settings from an old version of the theme. Would you like to import them now?</p>
		<form action="" method="post" id="ppp_panel_import">
		<input style="width:100px;" class="button" id="import" type="submit" value="Yes" name="cp_import" />
		<input class="button" id="import_stop" type="submit" value="No, and stop asking" name="import_stop" />
		</form>
		</div>';
	  }

	  if (isset($_POST['cp_import'])) {
		$old_options = get_option('ppp_platinum2_settings');
		if (!is_array($old_options)) {
			$old_options = get_option('ppp_platinum_settings');
		}
		if (!is_array($old_options)) {
			$old_options = get_option('ppp_settings');
		}

		/* Add new Snapshots to old Snapshots. */
		$old_snappies = unserialize($old_options['snapshots']);
		$curr_snappies = unserialize($this->options['snapshots']);

		/* Concat snapshots array. */
		if (is_array($old_snappies) && is_array($curr_snappies)) {
			$old_snappies = $old_snappies  + $curr_snappies;
		}

		$old_options['snapshots'] = serialize($old_snappies);

		/* Add old options to the new options. */
		$this->options = $old_options + $this->options;

		/* Dont save over the current saved snapshot. */
		$this->options['cp_new_snapshot'] = '';
		$this->options['new_snapshot'] = '';

		update_option("ppp3_show_welcome", 'hide');
		update_option('ppp_platinum3_settings', $this->options);

		echo '<div class="ppp_ajax_response_div">
		<p><strong>Previous settings have been imported.</strong></p>
		<p>Many options have been added, and many have changed, so be sure to review all options and <strong>Save Changes</strong>.</p>
		</div>';
	  }

	}


include(TEMPLATEPATH . '/code/cp_save.php');



$ppp_breadcrumb_sep = "&raquo;";


	/* Check this value and clear it so we dont save it. */
/*	$ppp_ajax_submit=false;
	if ($_POST['ppp_ajax_submit'] == 'true') {
		$_POST['ppp_ajax_submit'] = '';
		$ppp_ajax_submit=true;
	}*/

	/* If we don't have any snapshots, dummy up a default. */
    if (!is_array(unserialize($this->options['snapshots']))) {

	  $snaps = serialize(Array('2011 [Platinum3]' => $this->default_settings));

	  $this->options['snapshots'] = $snaps;
	}

/*	if ($ppp_ajax_submit && $ppp_notify != '') {
		echo '<input type="hidden" id="ppp_ajax_response" name="ppp_ajax_response" value="'.htmlspecialchars($ppp_notify).'" />';
	}
	if ($ppp_ajax_submit) {
		return;
	}*/

	/*
	  Start Control Panel form
	*/

	echo '<form action="" method="post" enctype="multipart/form-data" id="ppp_panel">';
	echo '<input type="hidden" id="ppp_action" name="ppp_action" value="save" />';

//	echo '<input type="hidden" id="ppp_ajax_save_url" name="ppp_ajax_save_url" value="'.get_template_directory_uri().'/code/cp_save_ajax.php" />';
	echo '<input type="hidden" id="ppp_ajax_submit" name="ppp_ajax_submit" value="" />';
	echo '<input type="hidden" id="action" name="action" value="" />';
	
	/* Save the last tabs */
	echo '<input type="hidden" id="ppp_last_tab" name="ppp_last_tab" value="'.$this->options["ppp_last_tab"].'" />';
	echo '<input type="hidden" id="ppp_last_tab_fonts" name="ppp_last_tab_fonts" value="'.$this->options["ppp_last_tab_fonts"].'" />';
	echo '<input type="hidden" id="ppp_last_tab_layout" name="ppp_last_tab_layout" value="'.$this->options["ppp_last_tab_layout"].'" />';
	echo '<input type="hidden" id="ppp_last_tab_colors" name="ppp_last_tab_colors" value="'.$this->options["ppp_last_tab_colors"].'" />';
	echo '<input type="hidden" id="ppp_last_tab_images" name="ppp_last_tab_images" value="'.$this->options["ppp_last_tab_images"].'" />';
	echo '<input type="hidden" id="ppp_last_tab_other" name="ppp_last_tab_other" value="'.$this->options["ppp_last_tab_other"].'" />';
	echo '<input type="hidden" id="ppp_last_tab_slideshow" name="ppp_last_tab_slideshow" value="'.$this->options["ppp_last_tab_slideshow"].'" />';
	echo '<input type="hidden" id="ppp_last_tab_sub_comments" name="ppp_last_tab_sub_comments" value="'.$this->options["ppp_last_tab_sub_comments"].'" />';

	echo '<div class="wrap">';

	echo '<h2>PhotoPressPro Platinum3 Control Panel</h2>';


		/* SAVE / ERROR MESSAGE */
if ($ppp_notify != "") {
	echo '
	<div id="ppp_ajax_msg"><!-- Use for AJAX -->
	<div class="ppp_ajax_response_div">'.$ppp_notify.'</div></div>';

	echo '
	<script type="text/javascript">
	jQuery(document).ready( function() {
	ppp_update_ajax_msg("'.$saving.'");
	});
	</script>';
}

	/* Put the Save and Snapshots boxes on the top right. */
	echo '<div id="ppp_panel_sidebar">';

	echo '<div id="submitdiv" class="">';

	echo ' <input id="ppp_save_changes" type="submit" value="Save Changes" name="cp_save" class="sexybutton sexysimple sexyxxxl" />';

	echo '</div><!-- submitdiv -->';

	echo '<div id="draftdiv" class="ppp_panel_side_blank">';
	echo ' <input class="button sexybutton sexysimple sexysmall sexyorange button_l" id="save_draft" type="submit" value="Save Draft" name="cp_draft" />';
	if (isset($_POST['cp_new_snapshot']) && $_POST['cp_new_snapshot'] == 'Preview') {
	    echo ' <input class="button sexybutton sexysimple sexysmall sexyyellow button_r" id="preview" type="button" value="Preview" name="cp_preview" onclick="window.open(\''.home_url().'?snap=Preview\');return true;" />';
	}
	echo '</div><!-- draftdiv -->';


		/* SNAPSHOTS */
	
	echo '<div id="snapshotsdiv" class="ppp_panel_side">';
	echo '<h4>Snapshots</h4>';
	echo '<div class="inside ppp_open_box">';

		/* New snapshot */
	echo '  <p>Enter a name to save a snapshot:<br />';
	echo '  <input class="ppp_input_wide" name="cp_new_snapshot" id="cp_new_snapshot" type="text" value="'.$this->options['new_snapshot'].'" />';
	echo '  </p>';

	echo '  <p>Load or delete a saved snapshot:<br />';
	echo '  <select class="widefat" name="cp_snapshot" id="cp_snapshot" onchange="document.getElementById(\'cp_load_snapshot_submit\').bgColor=\'F26101\'">';
	echo '  <option value="" ></option>';
	foreach (unserialize($this->options['snapshots']) as $key => $settings) {
		echo '  <option value="'.$key.'" >'.$key.'</option>';
	}
	echo '  </select> ';
	echo '  <span style="border:0;" ><input class="button sexybutton sexysimple sexyorange button_l" type="submit" value="Load" name="cp_load_snapshot_submit" id="cp_load_snapshot_submit" /></span> <span style="text-align:right; border:0;" ><input class="button sexybutton sexysimple sexyred button_r" type="submit" value="Delete &raquo;" name="cp_delete_snapshot_submit"/></span>';


	echo '  </p>';

	/* IMPORT / EXPORT. Just for me for now. */
	if (get_option('admin_email') == "luke@weesedesigns.com") {
	echo '<div id="iodiv">';
	echo '<h4>Import/Export Snapshots</h4>';
	ppp_upload_input('import_snapshot', '', $this->options);
	echo '<div><input class="button sexybutton sexysimple sexyorange button_l" type="submit" value="Export Snapshot" name="cp_export_snapshot_submit"/></div>';
	echo '</div><!-- iodiv -->';
	}
	echo '</div><!-- inside -->';
	echo '</div><!-- snapshotsdiv -->';


	/* Help link */
	echo '<div id="helpdiv" class="ppp_panel_side" style="text-align:center;">';
	echo '<p>Need help? <a target="_blank" href="http://photopresspro.com/support/">Check our support pages!</a></p>';
	echo '</div><!-- helpdiv -->';

	/* RESTORE DEFAULTS */

	echo '<div id="defaultsdiv" class="ppp_panel_side" style="text-align:center;">';
	echo '<p><a id="toggle_restore_defaults" class="tgl">[restore defaults]</a></p>';
	echo '<div class="inside">';
	echo '<table><tbody>';

	echo '<tr><td>';
	echo '</td><td><div id="restore_defaults" style="display:none">Are you sure? Check this box and click Save Changes.<input type="checkbox" name="cp_restore_defaults" id="cp_restore_defaults" /></div>';
	echo '</td></tr>';

	echo '</tbody></table>';
	echo '</div><!-- inside -->';
	echo '</div><!-- defaultsdiv -->';
	
	echo '</div><!-- ppp_panel_sidebar -->';


	/* Top Menu */

	echo '<div id="ppp_panel_menu">';

	/* Thanks http://www.sunsean.com/idTabs/ */
	echo '<ul class="idTabs">
	<li><a id="layoutdiv-tab" href="#layoutdiv">Layout</a></li>
	<li><a id="colorsdiv-tab" href="#colorsdiv">Colors</a></li>
	<li><a id="fontsdiv-tab" href="#fontsdiv">Fonts</a></li>
	<li><a id="imagesdiv-tab" href="#imagesdiv">Images</a></li>
	<li><a id="otherdiv-tab" href="#otherdiv">Other</a></li>
	<li><a id="slideshowdiv-tab" href="#slideshowdiv">Slideshow</a></li>
	</ul></div>';


	/* The Body */

	echo '<div id="ppp_panel_body">';


	/* LAYOUT */

	echo '<div id="layoutdiv" class="ppp_panel_inner" style="display:none;">';

	/* Tabbed layout panels*/
	echo '<div id="ppp_layout_tab" class="ppp_panel_tabs"><ul class="idTabs">
	<li><a href="#layout_hdr">Header</a></li>
	<li><a href="#layout_menu">Menu</a></li>
	<li><a href="#layout_body">Body</a></li>
	<li><a href="#layout_pages">Pages</a></li>
	<li><a href="#layout_footer">Footer</a></li>
	<li><a href="#layout_timestamp">Timestamp</a></li>
	<li><a href="#layout_comments">Comments</a></li>
	<li><a href="#layout_about">About Me</a></li>
	</ul></div>';

	echo '<div class="ppp_tab_inside">';

	echo '<div id="layout_body" class="inside">';
	echo '<h3>Layout '.$ppp_breadcrumb_sep.' Body</h3>';

	echo '<h4>Borders</h4>';
	echo '<div class="inside ppp_open_box">';
	echo '<table><tbody>';

	ppp_opt_border('Above header', 'border_header_top', $this->options);

	ppp_opt_border('Below footer', 'border_footer_bottom', $this->options);

	echo '<tr><td colspan="2">
	<input type="checkbox" name="cp_side_border_img" id="cp_side_border_img"'.($this->options["side_border_img"] == 1 ? ' checked="checked"' : '').' /> 
	<label for="cp_side_border_img">Show drop shadow?</label>';
	echo '</td></tr>';
	echo '</tbody></table>';
	echo '</div><!-- inside -->';

	echo '<h4>Transparent margins</h4>';
	echo '<div class="inside ppp_open_box">';
	echo '<p>Note: Leave these fields empty to hide the shadow images at the top and bottom of your blog.</p>';
	echo '<table><tbody>';

	echo '<tr><td>Above header border: ';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_hdr_margin" id="cp_hdr_margin" type="text" value="'.$this->options["hdr_margin"].'" /> pixels';
	echo '</td></tr>';

	echo '<tr><td>Below footer border: ';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_ftr_margin" id="cp_ftr_margin" type="text" value="'.$this->options["ftr_margin"].'" /> pixels';
	echo '</td></tr>';

	echo '</tbody></table>';
	echo '</div><!-- inside -->';


	/* Post Images */
	echo '<div id="images_img" class="inside">';
	echo '<h4>Post Images</h4>';
	echo '<div class="ppp_open_box">';
	echo '<table><tbody>';

	echo '<tr><td>Align images in posts:';
	echo '</td><td><select name="cp_post_img_align" id="cp_post_img_align">
<option value="left" '.($this->options["post_img_align"] == 'left' ? ' selected="selected"' : '').'>Left</option>
<option value="center" '.($this->options["post_img_align"] == 'center' ? ' selected="selected"' : '').'>Center</option>
<option value="right" '.($this->options["post_img_align"] == 'right' ? ' selected="selected"' : '').'>Right</option>
</select>';
	echo '</td></tr>';

	echo '<tr><td>Border around images:</td><td>';
	ppp_opt_border_input('post_img_border', $this->options);
	echo ' <a id="toggle_border_note" class="tgl"><small>note &raquo;</small></a><br /></td></tr>';

	echo '<tr><td colspan="2">';
	echo '<div id="border_note" class="note" style="display:none">If you post full-size 960 pixel wide images and use a border,
	                     the image will be resized in the browser to accommodate the border.
						 For example, if you choose a 3 pixel border, your image will be resized
						 to 954 pixels wide, to allow 3 pixels on each side for the border.</div>';
	echo '</td></tr>';

	echo '</tbody></table>';
	echo '</div><!-- ppp_open_box -->';
	echo '</div><!-- images_img -->';



	echo '</div><!-- layout_body -->';


	echo '<div id="layout_hdr" class="inside" style="">';
	echo '<h3>Layout '.$ppp_breadcrumb_sep.' Header</h3>';

	echo '<table><tbody>';
	echo '<tr><td colspan="2"><div id="cp_header_img_flash">';
	echo '
<label class="labelCheckbox" for="header_img_flash_img" >
<input name="cp_header_img_flash" id="header_img_flash_img" type="radio" class="crirHiddenJS" value="img" '.($this->options["header_img_flash"] == 'img' ? ' checked="checked"' : '').' />Header Image</label>
<label class="labelCheckbox" for="header_img_flash_js" >
<input name="cp_header_img_flash" id="header_img_flash_js" type="radio" class="crirHiddenJS" value="js" '.($this->options["header_img_flash"] == 'js' ? ' checked="checked"' : '').' />Slideshow</label>
<label class="labelCheckbox" for="header_img_flash_img_js" >
<input name="cp_header_img_flash" id="header_img_flash_img_js" type="radio" class="crirHiddenJS" value="img_js" '.($this->options["header_img_flash"] == 'img_js' ? ' checked="checked"' : '').' />Header + Slideshow</label>
';
	echo '</div></td></tr>';
	echo '</tbody></table>';

	$hdr_lay_disp = 'display:none;';
	if ($this->options["header_img_flash"] == 'img_js' || $this->options["header_img_flash"] == 'img_flash') {
		$hdr_lay_disp = '';
	}
	echo '<div id="header_layout_div" class="inside" style="'.$hdr_lay_disp.'">';

	echo '<table><tbody>';
	echo '<tr><td colspan="2"><div id="cp_header_layout">';
	ppp_radio('header_layout', 'header_layout_top',    't', $this->options["header_layout"], 'layout_header_img_t.png', 'Header Image on Top');
	ppp_radio('header_layout', 'header_layout_bottom', 'b', $this->options["header_layout"], 'layout_header_img_b.png', 'Header Image on Bottom');
	ppp_radio('header_layout', 'header_layout_left',   'l', $this->options["header_layout"], 'layout_header_img_l.png', 'Header Image on Left');
	ppp_radio('header_layout', 'header_layout_right',  'r', $this->options["header_layout"], 'layout_header_img_r.png', 'Header Image on Right');
	echo '</div></td></tr>';
	echo '</tbody></table>';
	echo '</div><!-- inside -->';

	$hdr_disp = 'display:none;';
	if ($this->options["header_img_flash"] == 'img' || $this->options["header_img_flash"] == 'img_js' || $this->options["header_img_flash"] == 'img_flash') {
		$hdr_disp = '';
	}

	$hdr_h_disp = 'display:none;';
	if (($this->options["header_img_flash"] == 'img') || 
		(($this->options["header_layout"] == 't' || $this->options["header_layout"] == 'b') && ($this->options["header_img_flash"] == 'img_js' || $this->options["header_img_flash"] == 'img_flash'))) {
		$hdr_h_disp = '';
	}

	$hdr_js_disp = 'display:none;';
	if ($this->options["header_img_flash"] == 'img_js' || $this->options["header_img_flash"] == 'js') {
		$hdr_js_disp = '';
	}

	$hdr_tb_disp = 'display:none;';
	$hdr_lr_disp = 'display:none;';
	if (($this->options["header_layout"] == 'l' || $this->options["header_layout"] == 'r') && ($this->options["header_img_flash"] == 'img_js' || $this->options["header_img_flash"] == 'img_flash')) {
		$hdr_lr_disp = '';
	} else {
		$hdr_tb_disp = '';
	}

	echo '<div class="inside">';
	echo '<h4>Settings</h4>';
	echo '<div class="ppp_header_settings ppp_open_box">';
	echo '<p class="hdr_tb_div" style="'.$hdr_tb_disp.'"><small>Header and slideshow images should be <strong>984 pixels wide</strong>.</small></p>';
	echo '<p class="hdr_lr_div" style="'.$hdr_lr_disp.'"><small>Header image should be <strong>328 pixels wide</strong>, and slideshow images should be <strong>656 pixels wide</strong>.</small></p>';

	echo '<table><tbody>';
	echo '<tr class="header_div" id="header_img_height_div" style="'.$hdr_h_disp.'"><td>Header height: ';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_header_img_h" id="cp_header_img_h" type="text" value="'.$this->options["header_img_h"].'" /> pixels';
	echo '</td></tr>';
	echo '<tr class="slide_div" style="'.$hdr_js_disp.'"><td>Slideshow height: ';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_header_img_height" id="cp_header_img_height" type="text" value="'.($this->options["header_img_height"] == '' ? $this->default_settings["header_img_height"] : $this->options["header_img_height"]).'" /> pixels';
	echo '</td></tr>';
	echo '</tbody></table>';
	
		/* HEADER SLIDESHOW */

	echo '<div class="slide_div inside" style="'.$hdr_js_disp.'">';

	echo '<table><tbody>';

	echo '<tr><td>How many seconds to <strong>display</strong> each image? ';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_header_img_time_disp" id="cp_header_img_time_disp" type="text" value="'.($this->options["header_img_time_disp"] == '' ? $this->default_settings["header_img_time_disp"] : $this->options["header_img_time_disp"]).'" /> seconds';
	echo '</td></tr>';

	echo '<tr><td>How many seconds to <strong>fade</strong> between images? ';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_header_img_time_fade" id="cp_header_img_time_fade" type="text" value="'.($this->options["header_img_time_fade"] == '' ? $this->default_settings["header_img_time_fade"] : $this->options["header_img_time_fade"]).'" /> seconds';
	echo '</td></tr>';

	echo '<tr><td><label for="cp_header_img_rnd">Display images in random order? </label>';
	echo '</td><td><input type="checkbox" name="cp_header_img_rnd" id="cp_header_img_rnd"'.($this->options["header_img_rnd"] == 1 ? ' checked="checked"' : '').' />';
	echo '</td></tr>';
	echo '</tbody></table>';

	echo '</div><!-- slide_height_div -->';
	echo '</div><!-- .ppp_header_settings -->';
	echo '</div><!-- inside -->';


	echo '<div class="header_div inside" id="header_img_div" style="'.$hdr_disp.'">';

	echo '<h4>Header Image</h4>';
	echo '<div class="ppp_header_image_div ppp_open_box">';

	echo '<table><tbody>';
	echo '<tr><td>Enter an image URL:';
	echo '</td><td><input class="ppp_input_wide" name="cp_img_header" id="cp_img_header" type="text" value="'.ppp_get_img_url("header",$this->options).'" />';
	echo '</td></tr>';

	echo '<tr><td>Or upload an image:';
	echo '</td><td><input id="cp_upload_image_header" type="file" name="cp_upload_image_header" /> <span class="submit inline_submit"><input class="ppp_submit_upload" type="submit" value="Upload" name="cp_upload_image_submit_header" />';

	if ($this->options["img_fn_header"] == ""
&& $this->options["img_header"] == "") {
		echo '</span></td></tr>';
	} else {
		echo ' <input type="submit" value="Delete &raquo;" name="cp_delete_img_header" /></span></td></tr>';

		echo '<tr><td>';
		echo '</td><td><label for="cp_display_image_header">Display image? </label><input type="checkbox" name="cp_display_image_header" id="cp_display_image_header"'.($this->options["display_image_header"] == 1 ? ' checked="checked"' : '').' /><br />
<div class="cp_img_wrap"><div class="cp_img_info">
';
		ppp_img_tag("header", $this->options, "ppp_cp_img", "Header");
		echo '</div></div></td></tr>';
	}

	echo '</tbody></table>';
	echo '</div><!-- .ppp_header_image_div -->';
	echo '</div><!-- inside -->';


	echo '<div class="slide_div inside" style="'.$hdr_js_disp.'">';

	echo '<h4>Slideshow Images</h4>';
	echo '<div class="ppp_header_slide_div ppp_open_box">';
	echo '<p>Note: When changing the sequence of images, make sure you update each image number, or you may get unexpected results.</p>';

    $img_hdr_num = ($this->options["img_fn_hdr_num"] != '') ? intval($this->options["img_fn_hdr_num"]) : 1;
	$this->options["img_fn_hdr_num"] = $img_hdr_num;

	/* Make an array and sort it by the sequence number. */
	$ids = ppp_sort_header_ids($this->options, $img_hdr_num, false);

	$next_img_hdr_num = $img_hdr_num+1;

	echo '<div class="cp_slide_imgs">';

	$valid_count=1;
	$nextid=1;
	foreach ($ids as $i => $v) {
		// if an image exists, offer an upload new button.
		$valid_image = (isset($ids[$i]) && 
						((isset($this->options["img_fn_hdr".$ids[$i]]) && $this->options["img_fn_hdr".$ids[$i]] != "") || 
						 (isset($this->options["img_hdr".$ids[$i]]) && $this->options["img_hdr".$ids[$i]] != "") ));
		if ($valid_image) {
		echo '<div class="cp_img_wrap"><div class="cp_img_info">';
		echo '# <input type="text" style="width:25px;" value="'.$valid_count.'" id="cp_image_hdr_seq'.$ids[$i].'" name="cp_image_hdr_seq'.$ids[$i].'" />';
		echo '<input id="cp_upload_image_hdr'.$ids[$i].'" type="file" name="cp_upload_image_hdr'.$ids[$i].'" />';
		echo '<span class="submit inline_submit">';
		echo '<input type="submit" class="ppp_submit_upload" value="Upload New" name="cp_upload_image_submit_hdr'.$ids[$i].'" /><br />';
		echo 'Or, enter URL: <input class="ppp_img_url" name="cp_img_hdr'.$ids[$i].'" id="cp_img_hdr'.$ids[$i].'" type="text" value="'.ppp_get_img_url("hdr".$ids[$i],$this->options).'" /> ';
		echo 'Or, <input type="submit" value="Delete &raquo;" name="cp_delete_img_hdr'.$ids[$i].'" /></span>';
		// Hidden checkbox - always true.
		echo '<input type="hidden" name="cp_display_image_hdr'.$ids[$i].'" id="cp_display_image_hdr'.$ids[$i].'" value="1" />';
		echo '</div><!-- .cp_img_info -->';

		ppp_img_tag("hdr".$ids[$i], $this->options, "ppp_cp_img", "Header Slideshow image");

		echo '</div> <!-- .cp_img_wrap -->';
		$valid_count++;
		}
		$nextid=$i+1;
	}
	echo '<div class="cp_img_wrap"><div class="cp_img_info">';
	echo '# '.$valid_count;
	echo '<input type="hidden" value="'.$valid_count.'" id="cp_image_hdr_seq'.$nextid.'" name="cp_image_hdr_seq'.$nextid.'" />';
	echo '<input id="cp_upload_image_hdr'.$nextid.'" type="file" name="cp_upload_image_hdr'.$nextid.'" />';
	echo '<span class="submit inline_submit">';
	echo '<input type="submit" class="ppp_submit_upload" value="Upload" name="cp_upload_image_submit_hdr'.$nextid.'" /><br />';
	echo 'Or, enter URL: <input class="ppp_img_url" name="cp_img_hdr'.$nextid.'" id="cp_img_hdr'.$nextid.'" type="text" value="" /> ';
	echo '</span>';
	echo '</div><!-- .cp_img_info -->';
	echo '</div> <!-- .cp_img_wrap -->';


	echo '</div><!-- .cp_slide_imgs -->';

	/* Save next header number */
	echo '<input type="hidden" id="cp_img_fn_hdr_num" name="cp_img_fn_hdr_num" value="'.$next_img_hdr_num.'" />';

	echo '</div><!-- .ppp_header_slide_div -->';

	echo '</div><!-- images_slide -->';

	echo '</div><!-- layout_hdr -->';


	echo '<div id="layout_menu" class="inside" style="">';
	echo '<h3>Layout '.$ppp_breadcrumb_sep.' Menu</h3>';

		echo '<div id="cp_menu_src">
<label class="labelCheckbox" for="menu_src_wp" id="menu_src_wp_lbl">
<input name="cp_menu_src" id="menu_src_wp" type="radio" class="crirHiddenJS" value="wp" '.($this->options["menu_src"] == 'wp' ? ' checked="checked"' : '').' />WordPress Menu</label>
<label class="labelCheckbox" for="menu_src_widget" id="menu_src_widget_lbl">
<input name="cp_menu_src" id="menu_src_widget" type="radio" class="crirHiddenJS" value="widget" '.(($this->options["menu_src"] == 'widget' || $this->options["menu_src"] == '')? ' checked="checked"' : '').' />Widgets</label>
<label class="labelCheckbox" for="menu_src_default" id="menu_src_default_lbl">
<input name="cp_menu_src" id="menu_src_default" type="radio" class="crirHiddenJS" value="default" '.($this->options["menu_src"] == 'default' ? ' checked="checked"' : '').' />Default</label>
</div><br clear="all" />';

		$note_wp = '';
		if ($this->options["menu_src"] != 'wp') {
			$note_wp = 'display:none;';
		}
		$note_widget = '';
		if ($this->options["menu_src"] != 'widget') {
			$note_widget = 'display:none;';
		}
		$note_default = '';
		if ($this->options["menu_src"] != 'default') {
			$note_default = 'display:none;';
		}

		echo '<div class="ppp_tip" id="menu_src_wp_note" style="'.$note_wp.'"><div class="ppp_tip_arrow" id="menu_src_wp_arrow"></div><p>Starting with WordPress 3.0, you can create your own navigation menus on the <a href="nav-menus.php">Menus</a> admin page. Create a menu and assign it to the &quot;<strong>PPP Navigation Menu</strong>&quot; theme location, and add all the posts, pages, categories, and custom URLs you wish. Create drop-down menus and re-order links by dragging and dropping.</p></div>';
		echo '<div class="ppp_tip" id="menu_src_widget_note" style="'.$note_widget.'"><div class="ppp_tip_arrow" id="menu_src_widget_arrow"></div><p>This is the most flexible option. To add menu items, go to the <a href="widgets.php">Widgets page</a> and drag some widgets from the left side into the box on the right side called &quot;Drop down Menu&quot;. Each widget creates a new drop-down menu. Starting with WordPress 3.0, you can add &quot;Custom Menu&quot; widgets. Create as many menus as you wish on the <a href="nav-menus.php">Menus</a> admin page, and use Custom Menu widgets to make each one a new drop-down menu.</p></div>';
		echo '<div class="ppp_tip" id="menu_src_default_note" style="'.$note_default.'"><div class="ppp_tip_arrow" id="menu_src_default_arrow"></div><p>Show the default navigation menu. This consists of Pages, Categories, Calendar, Links, and Meta drop-down menus.</p></div>';

		echo '<h4>Height &amp; Placement</h4>';
		echo '<div class="ppp_menu_height_div ppp_open_box">';

		echo '<table><tbody>';

		echo '<tr><td>Menu height: ';
		echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_menu_height" id="cp_menu_height" type="text" value="'.$this->options["menu_height"].'" /> pixels <small>(This is the height of the menu bar. Set this to twice the menu item height for 2 rows of menus.)</small>';
		echo '</td></tr>';
		echo '<tr><td>Menu Item height: ';
		echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_menu_item_height" id="cp_menu_item_height" type="text" value="'.$this->options["menu_item_height"].'" /> pixels <small>(This is the height of the rollover menu items. Leave blank to take the same height as the menu bar.)</small>';
		echo '</td></tr>';

		echo '<tr><td>Placement:';
		echo '</td><td><select name="cp_menu_place" id="cp_menu_place">
	<option value="top" '.($this->options["menu_place"] == 'top' ? ' selected="selected"' : '').'>Above Header</option>';
	echo '<option value="bottom" '.(($this->options["menu_place"] == '' || $this->options["menu_place"] == 'bottom') ? ' selected="selected"' : '').'>Below Header</option>';
	echo '<option value="inbetween" '.($this->options["menu_place"] == 'inbetween' ? ' selected="selected"' : '').'>Between Header and Slideshow</option>';
	echo '</select>';
		echo '</td></tr>';
	
		echo '<tr><td>Alignment:';
		echo '</td><td><select name="cp_menu_align" id="cp_menu_align">
	<option value="left" '.($this->options["menu_align"] == 'left' ? ' selected="selected"' : '').'>Left</option>
	<option value="center" '.($this->options["menu_align"] == 'center' ? ' selected="selected"' : '').'>Center</option>
	<option value="right" '.($this->options["menu_align"] == 'right' ? ' selected="selected"' : '').'>Right</option>
	<option value="right_w_link" '.(($this->options["menu_align"] == 'right_w_link' || $this->options["menu_align"] == '') ? ' selected="selected"' : '').'>Right w/ left Home link</option>
	</select>';
		echo '</td></tr>';
		echo '</tbody></table>';
		echo '</div><!-- .ppp_menu_height_div -->';

		echo '<h4>Separator between menu items</h4>';
		echo '<div class="ppp_menu_separator_div ppp_open_box">';

		echo '<table><tbody>';
		echo '<tr><td class="sublevel">Choose a character:</td>';
		echo '<td><select name="cp_menu_separator" id="cp_menu_separator">
	<option value="" '.($this->options["menu_separator"] == '' ? ' selected="selected"' : '').'></option>
	<option value="bullet" '.($this->options["menu_separator"] == 'bullet' ? ' selected="selected"' : '').'>&bull;</option>
	<option value="bullet_s" '.($this->options["menu_separator"] == 'bullet_s' ? ' selected="selected"' : '').'>&middot;</option>
	<option value="dash" '.($this->options["menu_separator"] == 'dash' ? ' selected="selected"' : '').'>&mdash;</option>
	<option value="-" '.($this->options["menu_separator"] == '-' ? ' selected="selected"' : '').'>-</option>
	<option value=":" '.($this->options["menu_separator"] == ':' ? ' selected="selected"' : '').'>:</option>
	<option value="|" '.($this->options["menu_separator"] == '|' ? ' selected="selected"' : '').'>|</option>
	</select></td></tr>';
	

		echo '<tr><td>Or enter an image URL:';
		echo '</td><td><input class="ppp_input_wide" name="cp_img_sep" id="cp_img_sep" type="text" value="'.ppp_get_img_url("sep",$this->options).'" />';
		echo '</td></tr>';
		
		echo '<tr><td>Or upload an image:';
		echo '</td><td><input id="cp_upload_image_sep" type="file" name="cp_upload_image_sep" /> <span class="submit inline_submit"><input class="ppp_submit_upload" type="submit" value="Upload" name="cp_upload_image_submit_sep" />';
		
		if ($this->options["img_fn_sep"] == ""
		&& $this->options["img_sep"] == "") {
			echo '</span></td></tr>';
		} else {
			echo ' <input type="submit" value="Delete &raquo;" name="cp_delete_img_sep" /></span></td></tr>';
		
			echo '<tr><td>';
			echo '</td><td><label for="cp_display_image_sep">Display image? </label><input type="checkbox" name="cp_display_image_sep" id="cp_display_image_sep"'.($this->options["display_image_sep"] == 1 ? ' checked="checked"' : '').' /> <br />';
		
			ppp_img_tag("sep", $this->options, "ppp_cp_img", "Menu separator image");
		
			echo '</td></tr>';
		}

		echo '</tbody></table>';
		echo '</div><!-- .ppp_menu_separator_div -->';

		echo '<h4>Subscribe link</h4>';
		echo '<div class="ppp_menu_subscribe_div ppp_open_box">';
		echo '<p>Choose whether to display an RSS link as your last menu item.</p>';

		echo '<div>
		<label class="labelCheckbox" for="rss_show" >
		<input name="cp_rss_when" id="rss_show" type="radio" class="crirHiddenJS" value="show" '.(($this->options["rss_when"] == 'show' || $this->options["rss_when"] == '') ? ' checked="checked"' : '').' />Show Link</label>

		<label class="labelCheckbox" for="rss_hide" >
		<input name="cp_rss_when" id="rss_hide" type="radio" class="crirHiddenJS" value="hide" '.($this->options["rss_when"] == 'hide' ? ' checked="checked"' : '').' />Hide Link</label>
		</div>
		<br clear="all" />';

		$disp_rss = '';
		if ($this->options["rss_when"] != 'show') {
			$disp_rss = 'style="display:none;"';
		}
		
		echo '<table><tbody>';

		echo '<tr id="rss_icon_div" '.$disp_rss.'><td colspan="2"><p>Display a text link, or an RSS icon.</p>';
		echo '<table>
			  <tr><td><div>
			  <label class="labelCheckbox" for="rss_icon_txt"><input type="radio" id="rss_icon_txt" name="cp_rss_icon" class="crirHiddenJS" value="text" '.($this->options["rss_icon"] == 'text' ? ' checked="checked"' : '').'/>Text Link &raquo;</label></div>
			  </td>
			  <td><input name="cp_rss_txt" class="ppp_input_wide" id="cp_rss_txt" type="text" value="'.$this->options["rss_txt"].'" /><p><span style="font-size:80%;line-height:1.2">This is also the tooltip text for your icon.</span></p>
			  </td></tr>';
		echo '</table>';

		echo '<div class="ppp_cp_rss_icons"><div class="ppp_icon_l">';
		ppp_radio_rss_l('rss_icon', 'rss', 'rss', $this->options["rss_icon"], 'rss.png', 'The Standard');
		ppp_radio_rss_l('rss_icon', 'rss_icon_03', 'onebit_03', $this->options["rss_icon"], 'onebit_03.png', 'Big, Orange');
		echo '</div>';
		echo '<div>';
		ppp_radio_rss('rss_icon', 'rss_icon_009', '009', $this->options["rss_icon"], '009.png', 'Orange');
		ppp_radio_rss('rss_icon', 'rss_icon_010', '010', $this->options["rss_icon"], '010.png', 'Green');
		ppp_radio_rss('rss_icon', 'rss_icon_011', '011', $this->options["rss_icon"], '011.png', 'Blue');
		ppp_radio_rss('rss_icon', 'rss_icon_012', '012', $this->options["rss_icon"], '012.png', 'Grey');
		echo '</div>';
		echo '<br clear="right" />';
		echo '<div>';
		ppp_radio_rss('rss_icon', 'rss_icon_017', '017', $this->options["rss_icon"], '017.png', 'Curvy Orange');
		ppp_radio_rss('rss_icon', 'rss_icon_018', '018', $this->options["rss_icon"], '018.png', 'Curvy Green');
		ppp_radio_rss('rss_icon', 'rss_icon_019', '019', $this->options["rss_icon"], '019.png', 'Curvy Blue');
		ppp_radio_rss('rss_icon', 'rss_icon_020', '020', $this->options["rss_icon"], '020.png', 'Curvy Grey');
		echo '</div>';
		echo '</div>';
	
		echo '<p><br clear="all" /><small>Icons courtesy of <a href="http://www.icojoy.com/">Icojoy</a> and <a href="http://www.addictedtocoffee.de/">Oliver Twardowski</a>.</small></p>';
		echo '</td></tr>';
		
		echo '</tbody></table>';
		echo '</div><!-- .ppp_menu_subscribe_div -->';
	echo '</div><!-- layout_menu -->';


	echo '<div id="layout_timestamp" class="inside" style="">';
	echo '<h3>Layout '.$ppp_breadcrumb_sep.' Timestamp</h3>';

	echo '<p>Choose exactly what information to show beneath each post title, or after each post.</p>';

		echo '<h4>Subtitles</h4>';
		echo '<div class="ppp_timestamp_sub_div ppp_open_box">';
		/*
     - Subtitles
      - author, date, time, cats, tags
		*/
		echo '
		<label class="labelCheckbox" for="cp_ts_sub_author">
		<input type="checkbox" name="cp_ts_sub_author" id="cp_ts_sub_author"'.($this->options[("ts_sub_author")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Author</label>
		<label class="labelCheckbox" for="cp_ts_sub_date">
		<input type="checkbox" name="cp_ts_sub_date" id="cp_ts_sub_date"'.($this->options[("ts_sub_date")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Date</label>
		<label class="labelCheckbox" for="cp_ts_sub_time">
		<input type="checkbox" name="cp_ts_sub_time" id="cp_ts_sub_time"'.($this->options[("ts_sub_time")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Time</label>
		<label class="labelCheckbox" for="cp_ts_sub_cats">
		<input type="checkbox" name="cp_ts_sub_cats" id="cp_ts_sub_cats"'.($this->options[("ts_sub_cats")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Categories</label>
		<label class="labelCheckbox" for="cp_ts_sub_tags">
		<input type="checkbox" name="cp_ts_sub_tags" id="cp_ts_sub_tags"'.($this->options[("ts_sub_tags")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Tags</label>
		<br clear="all"/>
		<label class="labelCheckbox" for="cp_ts_sub_onpage">
		<input type="checkbox" name="cp_ts_sub_onpage" id="cp_ts_sub_onpage"'.($this->options[("ts_sub_onpage")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Show on Pages?</label>
		<br clear="all"/>';
		echo '</div><!-- .ppp_timestamp_sub_div -->';

		echo '<h4>After Post</h4>';
		echo '<div class="ppp_timestamp_post_div ppp_open_box">';
		/*
    - Post Footer
      - title, author, date, time, catgs, tags		
		*/
		echo '
		<label class="labelCheckbox" for="cp_ts_foot_title">
		<input type="checkbox" name="cp_ts_foot_title" id="cp_ts_foot_title"'.($this->options[("ts_foot_title")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Title</label>
		<label class="labelCheckbox" for="cp_ts_foot_author">
		<input type="checkbox" name="cp_ts_foot_author" id="cp_ts_foot_author"'.($this->options[("ts_foot_author")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Author</label>
		<label class="labelCheckbox" for="cp_ts_foot_date">
		<input type="checkbox" name="cp_ts_foot_date" id="cp_ts_foot_date"'.($this->options[("ts_foot_date")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Date</label>
		<label class="labelCheckbox" for="cp_ts_foot_time">
		<input type="checkbox" name="cp_ts_foot_time" id="cp_ts_foot_time"'.($this->options[("ts_foot_time")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Time</label>
		<label class="labelCheckbox" for="cp_ts_foot_cats">
		<input type="checkbox" name="cp_ts_foot_cats" id="cp_ts_foot_cats"'.($this->options[("ts_foot_cats")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Categories</label>
		<label class="labelCheckbox" for="cp_ts_foot_tags">
		<input type="checkbox" name="cp_ts_foot_tags" id="cp_ts_foot_tags"'.($this->options[("ts_foot_tags")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Tags</label>
		<br clear="all"/>
		<label class="labelCheckbox" for="cp_ts_foot_onpage">
		<input type="checkbox" name="cp_ts_foot_onpage" id="cp_ts_foot_onpage"'.($this->options[("ts_foot_onpage")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Show on Pages?</label>
		<br clear="all"/>';
		echo '</div><!-- .ppp_timestamp_post_div -->';
	echo '</div><!-- layout_timestamp -->';


	echo '<div id="layout_comments" class="inside" style="">';
	echo '<h3>Layout '.$ppp_breadcrumb_sep.' Comments <span class="info-link-floater"><a class="more-info-link" href="#pppnote_comments_ajax">i</a></span></h3>';
	echo '<div class="ppp_tip" id="pppnote_comments_ajax">
        <a class="more-info-link-x" href="#pppnote_comments_ajax">X</a>
        <p>AJAX commenting is now built-in, and the AjaxedWordPress plugin is no longer recommended. Please <a href="http://photopresspro.com/support">contact us</a> if AJAX commenting does not work after deactivating the AjaxedWordPress plugin.
        </p></div><!-- ppp_tip -->';

		echo '<h4>Inline Comments</h4>';
		echo '<div class="ppp_comments_inline_div ppp_open_box">';

		echo '<label for="cp_comments_inline"><input onclick="ppptoggle(\'inline_comments_opt\')" type="checkbox" name="cp_comments_inline" id="cp_comments_inline"'.($this->options["comments_inline"] == 1 ? ' checked="checked"' : '').' /> Display inline comments on home page?</label><br />';
		echo '<label for="cp_comments_noajax"><input type="checkbox" name="cp_comments_noajax" id="cp_comments_noajax"'.($this->options["comments_noajax"] == 1 ? ' checked="checked"' : '').' /> Disable AJAX commenting?</label> <small>(Check if you have issues with built-in AJAX comment posting.)</small><br />';

		$inline_comment_opt_disp = '';
		if ($this->options["comments_inline"] != 1) {
			$inline_comment_opt_disp = 'display:none;';
		}
		echo '<div id="inline_comments_opt" style="'.$inline_comment_opt_disp.'">';
		echo '<table><tbody>';
		echo '<tr><td style="width:162px;">Show or hide comments: ';
		echo '</td><td><select style="width:200px;" name="cp_comments_open" id="cp_comments_open">
	<option value="always" '.($this->options["comments_open"] == 'always' ? ' selected="selected"' : '').'>Show Always</option>
	<option value="hidden" '.($this->options["comments_open"] == 'hidden' ? ' selected="selected"' : '').'>Click to Show Comments</option>
	<option value="show" '.($this->options["comments_open"] == 'show' ? ' selected="selected"' : '').'>Click to Hide Comments</option>
	</select>';
		echo '</td></tr>';
	
		$comment_form_tr_disp = '';
		if ($this->options["comment_form_placement"] != '' && $this->options["comment_form_placement"] != 'below') {
			$comment_form_tr_disp = 'display:none;';
		}
		echo '<tr id="comment_form_tr" style="'.$comment_form_tr_disp.'"><td>Show/hide comment form: ';
		echo '</td><td><select style="width: 200px" name="cp_comments_add_open" id="cp_comments_add_open">
	<option value="always" '.($this->options["comments_add_open"] == 'always' ? ' selected="selected"' : '').'>Show Always</option>
	<option value="hidden" '.($this->options["comments_add_open"] == 'hidden' ? ' selected="selected"' : '').'>Click to Show Comment Form</option>
	<option value="show" '.($this->options["comments_add_open"] == 'show' ? ' selected="selected"' : '').'>Click to Hide Comment Form</option>
	</select>';
		echo '</td></tr>';
		echo '</tbody></table>';
		echo '</div>';
		echo '</div><!-- .ppp_comments_inline_div -->';


		echo '<h4>Comment Box</h4>';
		echo '<div class="ppp_comment_box_div ppp_open_box">';

		echo '<table><tbody>';

		echo '<tr id="ppp_comment_box_width" style="'.$comment_form_tr_disp.'"><td>Comment box width:';
		echo '</td><td><label for="cp_comments_width"><input class="widefat" style="text-align: right; width: 65px" name="cp_comments_width" id="cp_comments_width" type="text" value="'.$this->options["comments_width"].'" /> pixels (960 or less)</label></td></tr>';

		echo '<tr><td>Comment box height: ';
		echo '</td><td><label for="cp_comments_height"><input class="widefat" style="text-align: right; width: 65px" name="cp_comments_height" id="cp_comments_height" type="text" value="'.$this->options["comments_height"].'" /> pixels </label></td></tr>';

		echo '</tbody></table>';

		echo '<label for="cp_comments_show_avatar"><input type="checkbox" name="cp_comments_show_avatar" id="cp_comments_show_avatar"'.($this->options["comments_show_avatar"] == 1 ? ' checked="checked"' : '').' /> Display avatar?</label><br />';
		echo '<label for="cp_comments_hide_default_avatar"><input type="checkbox" name="cp_comments_hide_default_avatar" id="cp_comments_hide_default_avatar"'.($this->options["comments_hide_default_avatar"] == 1 ? ' checked="checked"' : '').' /> - Hide default avatar? (overrides WP settings)</label><br />';
		echo '</div><!-- .ppp_comment_box_div -->';


		echo '<h4>Comment Form</h4>';
		echo '<div class="ppp_comment_form_div ppp_open_box">';

		echo '<table><tbody>';

		echo '<tr><td>Placement:';

		echo '</td><td><select style="width: 208px" name="cp_comment_form_placement" id="cp_comment_form_placement">
		<option value="below" '.($this->options["comment_form_placement"] == 'below' ? ' selected="selected"' : '').'>Comments on Top, Form Below</option>
		<option value="left" '.($this->options["comment_form_placement"] == 'left' ? ' selected="selected"' : '').'>Comment Form on Left</option>
		<option value="right" '.($this->options["comment_form_placement"] == 'right' ? ' selected="selected"' : '').'>Comment Form on Right</option>
		</select>';

		echo '</td></tr>';

		echo '<tr><td>Comment form height: ';
		echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_comment_form_height" id="cp_comment_form_height" type="text" value="'.$this->options["comment_form_height"].'" /> pixels';
		echo '</td></tr>';

		echo '</tbody></table>';

		echo '<label for="cp_comments_name"><input type="checkbox" name="cp_comments_name" id="cp_comments_name"'.(($this->options["comments_name"] == 1 || get_option('require_name_email') == 1) ? ' checked="checked"' : '').(get_option('require_name_email') == 1 ? ' disabled="disabled"' : '').' /> Show name field?</label><br />';
		echo '<label for="cp_comments_email"><input type="checkbox" name="cp_comments_email" id="cp_comments_email"'.(($this->options["comments_email"] == 1 || get_option('require_name_email') == 1) ? ' checked="checked"' : '').(get_option('require_name_email') == 1 ? ' disabled="disabled"' : '').' /> Show email field?</label><br />';
		echo '<label for="cp_comments_www"><input type="checkbox" name="cp_comments_www" id="cp_comments_www"'.($this->options["comments_www"] == 1 ? ' checked="checked"' : '').' /> Show website field?</label><br />';

		echo '</div><!-- .ppp_comment_form_div -->';

	echo '</div><!-- layout_comments -->';


	echo '<div id="layout_about" class="inside" style="">';
	echo '<h3>Layout '.$ppp_breadcrumb_sep.' About Me</h3>';

		echo '<h4>Placement</h4>';
		echo '<div class="ppp_about_placement_div ppp_open_box">';
		echo '<p>Where would you like to see your &quot;About Me&quot; section?</p>';
		echo '<div><label class="labelCheckbox" for="bio_placement_hidden" >
		<input name="cp_bio_placement" id="bio_placement_hidden" type="radio" class="crirHiddenJS" value="" '.($this->options["bio_placement"] == '' ? ' checked="checked"' : '').' />Not Displayed</label>
		
		<label class="labelCheckbox" for="bio_placement_below_hdr" >
		<input name="cp_bio_placement" id="bio_placement_below_hdr" type="radio" class="crirHiddenJS" value="below_hdr" '.($this->options["bio_placement"] == 'below_hdr' ? ' checked="checked"' : '').' />Before Posts on Home Page</label>
		
		<label class="labelCheckbox" for="bio_placement_above_ftr" >
		<input name="cp_bio_placement" id="bio_placement_above_ftr" type="radio" class="crirHiddenJS" value="above_ftr" '.($this->options["bio_placement"] == 'above_ftr' ? ' checked="checked"' : '').' />Footer Top</label>
		
		<label class="labelCheckbox" for="bio_placement_below_ftr" >
		<input name="cp_bio_placement" id="bio_placement_below_ftr" type="radio" class="crirHiddenJS" value="below_ftr" '.($this->options["bio_placement"] == 'below_ftr' ? ' checked="checked"' : '').' />Footer Bottom</label>
		</div>
		<br clear="all" />';
		echo '</div><!-- .ppp_about_placement_div -->';

		echo '<h4>&quot;About Me&quot; Text</h4>';
		echo '<div class="ppp_about_text_div ppp_open_box">';

		echo '<p>Enter a title.</p>';
		echo '<input name="cp_about_title" class="ppp_input_wide" id="cp_about_title" type="text" value="'.$this->options["about_title"].'" />';

		echo '<p>Enter a few lines of text to describe yourself. Basic <a href="http://www.w3schools.com/tags/default.asp" target="_blank">HTML</a> is allowed.</p>';
		echo '<textarea class="widefat" name="cp_about_text" id="cp_about_text" rows="8" cols="60">'.htmlspecialchars($this->options["about_text"]).'</textarea>';
		echo '</div><!-- .ppp_about_text_div -->';

	echo '</div><!-- layout_about -->';


	echo '<div id="layout_footer" class="inside" style="">';
	echo '<h3>Layout '.$ppp_breadcrumb_sep.' Footer</h3>';

		echo '<h4>Hide Footer</h4>';
		echo '<div class="ppp_hide_footer_div ppp_open_box">';

		echo '<p>Would you like to hide your blog footer widget areas completely?</p>';
		echo '<div><label class="labelCheckbox" for="footer_hide" >
		<input name="cp_footer_hide_show" id="footer_hide" type="radio" class="crirHiddenJS" value="hide" '.($this->options["footer_hide_show"] == 'hide' ? ' checked="checked"' : '').' />Hide Footer</label>
		
		<label class="labelCheckbox" for="footer_show" >
		<input name="cp_footer_hide_show" id="footer_show" type="radio" class="crirHiddenJS" value="show" '.(($this->options["footer_hide_show"] == 'show' || $this->options["footer_hide_show"] == '') ? ' checked="checked"' : '').' />Show Footer</label>
		</div>
		<br clear="all" />';
		echo '</div><!-- .ppp_hide_footer_div -->';

	echo '</div><!-- layout_footer -->';


	echo '<div id="layout_pages" class="inside" style="">';
	echo '<h3>Layout '.$ppp_breadcrumb_sep.' Pages</h3>';

	echo '<h4>Sidebars</h4>';
	echo '<div class="ppp_layout_sidebar_div ppp_open_box">';
	echo '<p>Choose to show a 2-column layout including a widget Sidebar on all posts and pages. Or, create individual 2-column pages by choosing the &quot;Page with Sidebar&quot; or &quot;Posts Page with Sidebar&quot; page template when creating a new Page.</p>';

	echo '<div>
	<label class="labelCheckbox" for="sidebar_show" >
	<input name="cp_sidebar_hide_show" id="sidebar_show" type="radio" class="crirHiddenJS" value="show" '.(($this->options["sidebar_hide_show"] == 'show') ? ' checked="checked"' : '').' />Always Show Sidebar</label>

	<label class="labelCheckbox" for="sidebar_hide" >
	<input name="cp_sidebar_hide_show" id="sidebar_hide" type="radio" class="crirHiddenJS" value="hide" '.(($this->options["sidebar_hide_show"] == 'hide'  || $this->options["sidebar_hide_show"] == '' )? ' checked="checked"' : '').' />Only on 2-column Pages</label>
	</div>
	<br clear="all" />';
	echo '</div><!-- .ppp_layout_sidebar_div -->';

	echo '<h4>Archives Page</h4>';
	echo '<div class="ppp_layout_archives_div ppp_open_box">';
	echo '<p>Choose the blocks to show on your Archives page. Create an Archives page by choosing the &quot;Archives&quot; page template when creating a new Page.</p>';

	echo '
	<label class="labelCheckbox" for="archives_search">
	<input type="checkbox" name="archives_search" id="archives_search"'.($this->options[("archives_search")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Search</label>
	<label class="labelCheckbox" for="archives_category">
	<input type="checkbox" name="archives_category" id="archives_category"'.($this->options[("archives_category")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Categories</label>
	<label class="labelCheckbox" for="archives_tag">
	<input type="checkbox" name="archives_tag" id="archives_tag"'.($this->options[("archives_tag")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Tags</label>
	<label class="labelCheckbox" for="archives_month">
	<input type="checkbox" name="archives_month" id="archives_month"'.($this->options[("archives_month")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Monthly</label>
	<label class="labelCheckbox" for="archives_year">
	<input type="checkbox" name="archives_year" id="archives_year"'.($this->options[("archives_year")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Yearly</label>
	<label class="labelCheckbox" for="archives_posts">
	<input type="checkbox" name="archives_posts" id="archives_posts"'.($this->options[("archives_posts")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />All Posts</label>
	<label class="labelCheckbox" for="archives_pages">
	<input type="checkbox" name="archives_pages" id="archives_pages"'.($this->options[("archives_pages")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />All Pages</label>
	<br clear="all"/>';
	echo '</div><!-- .ppp_layout_archives_div -->';

	echo '</div><!-- layout_footer -->';

	echo '</div><!-- ppp_tab_inside -->';

	echo '</div><!-- layoutdiv -->';


	/* COLORS */


	echo '<div id="colorsdiv" class="ppp_panel_inner" style="display:none;">';

	echo '<div id="ppp_colors_tab" class="ppp_panel_tabs"><ul class="idTabs">
	<li><a href="#colors_body">Body</a></li>
	<li><a href="#colors_menu">Menu</a></li>
	<li><a href="#colors_sidebar">Sidebar</a></li>
	<li><a href="#colors_comments">Comments</a></li>
	<li><a href="#colors_about">About Me</a></li>
	<li><a href="#colors_footer">Footer</a></li>
	</ul></div>';

	echo '<div class="ppp_tab_inside">';

	echo '<div id="colors_body" class="inside" style="">';
	echo '<h3>Colors '.$ppp_breadcrumb_sep.' Body</h3>';
	echo '<table><tbody>';

	echo '<tr><td>Background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_bg_color" id="cp_bg_color" type="text" value="'.$this->options["bg_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Content background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_content_bg_color" id="cp_content_bg_color" type="text" value="'.$this->options["content_bg_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Post Titles: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_h1_color" id="cp_h1_color" type="text" value="'.$this->options["h1_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Subtitles: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_sub_color" id="cp_sub_color" type="text" value="'.$this->options["sub_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Links: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_a_color" id="cp_a_color" type="text" value="'.$this->options["a_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Content text: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_content_color" id="cp_content_color" type="text" value="'.$this->options["content_color"].'" />';
	echo '</td></tr>';

	echo '</tbody></table>';
	echo '</div><!-- colors_body -->';

	/* MENU */

	echo '<div id="colors_menu" class="inside" style="display:none;">';
	echo '<h3>Colors '.$ppp_breadcrumb_sep.' Menu</h3>';
	echo '<table><tbody>';

	echo '<tr><td>Text color: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_menutext_color" id="cp_menutext_color" type="text" value="'.$this->options["menutext_color"].'" />';
	echo '</td></tr>';
	echo '</tbody></table>';

	echo '<h4>Background colors</h4>';
	echo '<div class="ppp_colors_menu_bg_div ppp_open_box">';

	echo '<table><tbody>';
	echo '<tr><td>Menu bar: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_menu1_bg_color" id="cp_menu1_bg_color" type="text" value="'.$this->options["menu1_bg_color"].'" /> <a id="toggle_note_menu_1" class="tgl"><small>what is this?</small></a>';
	echo '</td></tr>';
	echo '<tr><td colspan="2"><div id="note_menu_1" class="note" style="display:none">This is the background color of the menu bar.</div>';
	echo '</td></tr>';

	echo '<tr><td>Dropdown menus: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_menu2_bg_color" id="cp_menu2_bg_color" type="text" value="'.$this->options["menu2_bg_color"].'" /> <a id="toggle_note_menu_2" class="tgl"><small>what is this?</small></a>';
	echo '</td></tr>';
	echo '<tr><td colspan="2"><div id="note_menu_2" class="note" style="display:none">This is the hover color for the menu bar, the background color of the dropdown menus, AND the border color of the PPP Search for Menu Bar widget.</div>';
	echo '</td></tr>';

	echo '<tr><td>Dropdown menu items: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_menu3_bg_color" id="cp_menu3_bg_color" type="text" value="'.$this->options["menu3_bg_color"].'" /> <a id="toggle_note_menu_3" class="tgl"><small>what is this?</small></a>';
	echo '</td></tr>';
	echo '<tr><td colspan="2"><div id="note_menu_3" class="note" style="display:none">This is the hover color on the dropdown menu items, and the background of the next level of menus, such as sub-pages or sub-categories.</div>';
	echo '</td></tr>';

	echo '<tr><td>Dropdown submenus: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_menu4_bg_color" id="cp_menu4_bg_color" type="text" value="'.$this->options["menu4_bg_color"].'" /> <a id="toggle_note_menu_4" class="tgl"><small>what is this?</small></a>';
	echo '</td></tr>';
	echo '<tr><td colspan="2"><div id="note_menu_4" class="note" style="display:none">This is the hover color of the sub-menus, and the background color of sub-sub-menus, and any more sub-s you may have.</div>';
	echo '</td></tr>';
	echo '</tbody></table>';
	echo '</div><!-- .ppp_colors_menu_bg_div -->';

	echo '<h4>Opacity</h4>';
	echo '<div class="ppp_colors_menu_opacity_div ppp_open_box">';

	echo '<table><tbody>';
	echo '<tr><td colspan="2">Set the percentage of opacity on your menu, up to 100. (For non-IE browsers only)';
	echo '</td></tr>';

	echo '<tr><td>Percent:';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_menu_opacity" id="cp_menu_opacity" type="text" value="'.$this->options["menu_opacity"].'" /> %';
	echo '</td></tr>';


	echo '</tbody></table>';
	echo '</div><!-- .ppp_colors_menu_opacity_div -->';
	echo '</div><!-- colors_menu -->';

	/* SIDEBAR */
	echo '<div id="colors_sidebar" class="inside" style="">';
	echo '<h3>Colors '.$ppp_breadcrumb_sep.' Sidebar</h3>';
	echo '<table><tbody>';

	echo '<tr><td>Background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_sidebar_bg_color" id="cp_sidebar_bg_color" type="text" value="'.$this->options["sidebar_bg_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Titles: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_sidebar_h1_color" id="cp_sidebar_h1_color" type="text" value="'.$this->options["sidebar_h1_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Text: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_sidebar_color" id="cp_sidebar_color" type="text" value="'.$this->options["sidebar_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Links: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_sidebar_a_color" id="cp_sidebar_a_color" type="text" value="'.$this->options["sidebar_a_color"].'" />';
	echo '</td></tr>';

	ppp_opt_border('Inner Border:', 'border_sidebar', $this->options);

	echo '</tbody></table>';
	echo '</div><!-- colors_body -->';


	/* COMMENTS */

	echo '<div id="colors_comments" class="inside" style="display:none;">';
	echo '<h3>Colors '.$ppp_breadcrumb_sep.' Comments</h3>';

	echo '<p class="inside">Choose the background color and border for the comment form and comments, or leave blank to keep the same background color as the content.</p>';
	echo '<p><small>Note: If you use the AJAXedWordPress plugin for inline comments, make sure &quot;Use your theme\'s default comment template&quot; setting is checked, or these settings may not work.</small></p>';


	echo '<h4>Comment Form</h4>';
	echo '<div class="ppp_colors_comment_form_div ppp_open_box">';
	echo '<p><small>This is the form that your reader fills out to leave a comment.</small></p>';

	echo '<table><tbody>';

	echo '<tr><td>Background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_commentform_bg_color" id="cp_commentform_bg_color" type="text" value="'.$this->options["commentform_bg_color"].'" />';
	echo '</td></tr>';
	echo '<tr><td>Text: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_commentform_color" id="cp_commentform_color" type="text" value="'.$this->options["commentform_color"].'" />';
	echo '</td></tr>';

	ppp_opt_border('Border:', 'border_commentform', $this->options);

	echo '</tbody></table>';
	echo '</div><!-- .ppp_colors_comment_form_div -->';


	echo '<h4>Comment Box</h4>';

	echo '<div class="ppp_colors_comment_box_div ppp_open_box">';

	echo '<table><tbody>';

	echo '<tr><td>Background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comments_bg_color" id="cp_comments_bg_color" type="text" value="'.$this->options["comments_bg_color"].'" />';
	echo '</td></tr>';

	ppp_opt_border('Border:', 'border_comments', $this->options);

	echo '</tbody></table>';

	echo '</div><!-- .ppp_colors_comment_box_div -->';

	echo '<h4>Individual Comments</h4>';
	echo '<div class="ppp_colors_comments_ind_div ppp_open_box">';
	echo '<p class="inside">Choose colors for All Comments, then choose different colors for every other comment, or author comments, if you wish.</p>';

	/* Tabbed comment variants */

	echo '<div id="ppp_comments_tab" class="ppp_panel_tabs"><ul class="idTabs">
	<li><a href="#comments_all">All Comments</a></li>
	<li><a href="#comments_odd">Alternating Comments</a></li>
	<li><a href="#comments_author">Author Comments</a></li>
	</ul></div>';

	echo '<div class="ppp_tab_inside">';

	echo '<div id="comments_all" class="inside">';
	echo '<table><tbody>';

	echo '<tr><td>Background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_bg_color" id="cp_comment_bg_color" type="text" value="'.$this->options["comment_bg_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Text: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_content_color" id="cp_comment_content_color" type="text" value="'.$this->options["comment_content_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Links: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_a_color" id="cp_comment_a_color" type="text" value="'.$this->options["comment_a_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Link mouseover: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_a_hover" id="cp_comment_a_hover" type="text" value="'.$this->options["comment_a_hover"].'" />';
	echo '</td></tr>';

	ppp_opt_border('Border:', 'border_comment', $this->options);

	echo '</tbody></table>';
	echo '</div><!-- inside -->';


	echo '<div id="comments_odd" class="inside" style="display:none;">';
	echo '<table><tbody>';

	echo '<tr><td>Background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_odd_bg_color" id="cp_comment_odd_bg_color" type="text" value="'.$this->options["comment_odd_bg_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Text: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_odd_content_color" id="cp_comment_odd_content_color" type="text" value="'.$this->options["comment_odd_content_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Links: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_odd_a_color" id="cp_comment_odd_a_color" type="text" value="'.$this->options["comment_odd_a_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Link mouseover: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_odd_a_hover" id="cp_comment_odd_a_hover" type="text" value="'.$this->options["comment_odd_a_hover"].'" />';
	echo '</td></tr>';

	ppp_opt_border('Border:', 'border_odd_comments', $this->options);

	echo '</tbody></table>';
	echo '</div><!-- inside -->';

	echo '<div id="comments_author" class="inside">';
	echo '<table><tbody>';

	echo '<tr><td>Background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_author_bg_color" id="cp_comment_author_bg_color" type="text" value="'.$this->options["comment_author_bg_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Text: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_author_content_color" id="cp_comment_author_content_color" type="text" value="'.$this->options["comment_author_content_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Links: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_author_a_color" id="cp_comment_author_a_color" type="text" value="'.$this->options["comment_author_a_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Link mouseover: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_author_a_hover" id="cp_comment_author_a_hover" type="text" value="'.$this->options["comment_author_a_hover"].'" />';
	echo '</td></tr>';

	ppp_opt_border('Border:', 'border_author_comments', $this->options);

	echo '</tbody></table>';
	echo '</div><!-- comments_author -->';

	echo '</div><!-- .ppp_colors_comments_ind_div -->';

	echo '</div><!-- ppp_tab_inside -->';

	echo '</div><!-- colors_comments -->';


	echo '<div id="colors_footer" class="inside" style="display:none;">';
	echo '<h3>Colors '.$ppp_breadcrumb_sep.' Footer</h3>';
	echo '<table><tbody>';

	echo '<tr><td>Footer background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_footer_bg_color" id="cp_footer_bg_color" type="text" value="'.($this->options["footer_bg_color"] != '' ? $this->options["footer_bg_color"] : $this->options["content_bg_color"]).'" />';
	echo '</td></tr>';

	echo '<tr><td>Footer titles: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_footer_h1_color" id="cp_footer_h1_color" type="text" value="'.$this->options["footer_h1_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Footer text: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_footer_color" id="cp_footer_color" type="text" value="'.$this->options["footer_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Footer links: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_footer_link_color" id="cp_footer_link_color" type="text" value="'.$this->options["footer_link_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Footer link background hover: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_footer_link_bg_hover" id="cp_footer_link_bg_hover" type="text" value="'.$this->options["footer_link_bg_hover"].'" />';
	echo '</td></tr>';

	ppp_opt_border('Footer item border:', 'border_footitem', $this->options);

	echo '</tbody></table>';
	echo '</div><!-- colors_footer -->';


	echo '<div id="colors_about" class="inside" style="display:none;">';
	echo '<h3>Colors '.$ppp_breadcrumb_sep.' About Me</h3>';
	echo '<table><tbody>';

	echo '<tr><td>Background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_about_bg_color" id="cp_about_bg_color" type="text" value="'.$this->options["about_bg_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Text: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_about_color" id="cp_about_color" type="text" value="'.$this->options["about_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Links: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_about_link_color" id="cp_about_link_color" type="text" value="'.$this->options["about_link_color"].'" />';
	echo '</td></tr>';

	ppp_opt_border('Border: ', 'border_about', $this->options);

	echo '</tbody></table>';
	echo '</div><!-- colors_about -->';

	echo '</div><!-- ppp_tab_inside -->';

	echo '</div><!-- colorsdiv -->';


	/* FONTS */


	echo '<div id="fontsdiv" class="ppp_panel_inner" style="display:none;">';

	/* CSS FONTS */

	echo '<style type="text/css"><!--';
	$font_css_h1_c=ppp_fontface('h1', 0, $this->options);
	$font_css_sub_c=ppp_fontface('sub', 0, $this->options);
	$font_css_content_c=ppp_fontface('content', 0, $this->options);
	$font_css_menu_c=ppp_fontface('menu', 0, $this->options);
	$font_css_footer_c=ppp_fontface('footer', 0, $this->options);
	$font_css_slideshow_content=ppp_fontface('slideshow_content', 0, $this->options);
	$font_css_sidebar_h1=ppp_fontface('sidebar_h1', 0, $this->options);
	$font_css_sidebar_text=ppp_fontface('sidebar_text', 0, $this->options);
	$font_css_footer_h1=ppp_fontface('footer_h1', 0, $this->options);

	echo '--></style>';

	/* tabs */

	echo '<div id="ppp_fonts_tab" class="ppp_panel_tabs"><ul class="idTabs">
	<li><a href="#fonts_menu">Menu</a></li>
	<li><a href="#fonts_title">Post Titles</a></li>
	<li><a href="#fonts_subtitle">Subtitles</a></li>
	<li><a href="#fonts_content">Post Text</a></li>
	<li><a href="#fonts_footer_h1">Footer Titles</a></li>
	<li><a href="#fonts_footer">Footer Text</a></li>
	<li><a href="#fonts_sidebar_h1">Sidebar Titles</a></li>
	<li><a href="#fonts_sidebar_text">Sidebar Text</a></li>
	</ul></div>';

	echo '<div class="ppp_tab_inside">';

	echo '<div id="fonts_title" class="inside">';
	echo '<h3>Fonts '.$ppp_breadcrumb_sep.' Post Titles</h3>';
	ppp_opt_fonts("h1", $this->options, $font_css_h1_c);
	echo '</div><!-- fonts_title inside -->';

	echo '<div id="fonts_subtitle" class="inside">';
	echo '<h3>Fonts '.$ppp_breadcrumb_sep.' Subtitles</h3>';
	ppp_opt_fonts("sub", $this->options, $font_css_sub_c);
	echo '</div><!-- fonts_subtitle inside -->';

	echo '<div id="fonts_menu" class="inside">';
	echo '<h3>Fonts '.$ppp_breadcrumb_sep.' Menu</h3>';
	ppp_opt_fonts("menu", $this->options, $font_css_menu_c);
	echo '</div><!-- fonts_menu inside -->';

	echo '<div id="fonts_content" class="inside">';
	echo '<h3>Fonts '.$ppp_breadcrumb_sep.' Content</h3>';
	ppp_opt_fonts("content", $this->options, $font_css_content_c);
	echo '</div><!-- fonts_content inside -->';

	echo '<div id="fonts_footer" class="inside">';
	echo '<h3>Fonts '.$ppp_breadcrumb_sep.' Footer</h3>';
	ppp_opt_fonts("footer", $this->options, $font_css_footer_c);
	echo '</div><!-- fonts_footer inside -->';

	echo '<div id="fonts_sidebar_h1" class="inside">';
	echo '<h3>Fonts '.$ppp_breadcrumb_sep.' Sidebar Titles</h3>';
	ppp_opt_fonts("sidebar_h1", $this->options, $font_css_sidebar_h1);
	echo '</div><!-- fonts_sidebar_h1 inside -->';

	echo '<div id="fonts_sidebar_text" class="inside">';
	echo '<h3>Fonts '.$ppp_breadcrumb_sep.' Sidebar Text</h3>';
	ppp_opt_fonts("sidebar_text", $this->options, $font_css_sidebar_text);
	echo '</div><!-- fonts_sidebar_text inside -->';

	echo '<div id="fonts_footer_h1" class="inside">';
	echo '<h3>Fonts '.$ppp_breadcrumb_sep.' Footer Titles</h3>';
	ppp_opt_fonts("footer_h1", $this->options, $font_css_footer_h1);
	echo '</div><!-- fonts_footer_h1 inside -->';



	echo '</div><!-- ppp_tab_inside -->';

	echo '</div><!-- fontsdiv -->';


	/* IMAGES*/


	echo '<div id="imagesdiv" class="ppp_panel_inner" style="display:none;">';

	/* Image tabs */
	echo '<div id="ppp_images_tab" class="ppp_panel_tabs"><ul class="idTabs">
	<li><a href="#images_bg">Background</a></li>
	<li><a href="#images_thumb">Post Thumbnails</a></li>
	<li><a href="#images_break">Post Break</a></li>
	<li><a href="#images_ico">Favicon</a></li>
	<li><a href="#images_bio">About Me</a></li>
	</ul></div>';

	echo '<div class="ppp_tab_inside">';

	echo '<div id="images_bg" class="inside" style="">';
	echo '<h3>Images '.$ppp_breadcrumb_sep.' Background</h3>';
	echo '<p>Upload a background image for your blog. Anchor the image to the center or any corner of the browser, and choose to repeat the image for a tiled look.</p>';
	echo '<table><tbody>';

	echo '<tr><td>Alignment:';
	echo '</td><td><select name="cp_bg_img_align" id="cp_bg_img_align">
<option value="left" '.($this->options["bg_img_align"] == 'left' ? ' selected="selected"' : '').'>Left</option>
<option value="center" '.($this->options["bg_img_align"] == 'center' ? ' selected="selected"' : '').'>Center</option>
<option value="right" '.($this->options["bg_img_align"] == 'right' ? ' selected="selected"' : '').'>Right</option>
</select>';
	echo '</td></tr>';

	echo '<tr><td>Vertical alignment:';
	echo '</td><td><select name="cp_bg_img_valign" id="cp_bg_img_valign">
<option value="top" '.($this->options["bg_img_valign"] == 'top' ? ' selected="selected"' : '').'>Top</option>
<option value="bottom" '.($this->options["bg_img_valign"] == 'bottom' ? ' selected="selected"' : '').'>Bottom</option>
</select>';
	echo '</td></tr>';

	echo '<tr><td>Repeat?';
	echo '</td><td><select name="cp_bg_img_repeat" id="cp_bg_img_repeat">
<option value="repeat" '.($this->options["bg_img_repeat"] == 'repeat' ? ' selected="selected"' : '').'>Repeat All</option>
<option value="repeat-x" '.($this->options["bg_img_repeat"] == 'repeat-x' ? ' selected="selected"' : '').'>Repeat Horizontal</option>
<option value="repeat-y" '.($this->options["bg_img_repeat"] == 'repeat-y' ? ' selected="selected"' : '').'>Repeat Vertical</option>
<option value="no-repeat" '.($this->options["bg_img_repeat"] == 'no-repeat' ? ' selected="selected"' : '').'>No Repeat</option>
</select>';
	echo '</td></tr>';

	echo '<tr><td><label for="cp_bg_img_fixed">Fixed?</label>';
	echo '</td><td><input type="checkbox" name="cp_bg_img_fixed" id="cp_bg_img_fixed"'.($this->options["bg_img_fixed"] == 1 ? ' checked="checked"' : '').' />';
	echo '</td></tr>';

	echo '<tr><td>Enter an image URL:';
	echo '</td><td><input class="ppp_input_wide" name="cp_img_bg" id="cp_img_bg" type="text" value="'.ppp_get_img_url("bg",$this->options).'" />';
	echo '</td></tr>';

	echo '<tr><td>Or upload an image:';
	echo '</td><td><input id="cp_upload_image_bg" type="file" name="cp_upload_image_bg" /> <span class="submit inline_submit"><input class="ppp_submit_upload" type="submit" value="Upload" name="cp_upload_image_submit_bg" />';

	if ($this->options["img_fn_bg"] == "" && $this->options["img_bg"] == "") {
		echo '</span></td></tr>';
	} else {
		echo ' <input type="submit" value="Delete &raquo;" name="cp_delete_img_bg" /></span></td></tr>';

		echo '<tr><td>';
		echo '</td><td><label for="cp_display_image_bg">Display image? <input type="checkbox" name="cp_display_image_bg" id="cp_display_image_bg"'.($this->options["display_image_bg"] == 1 ? ' checked="checked"' : '').' /></label> <br />';

		ppp_img_tag("bg", $this->options, "ppp_cp_img", "Background image");

		echo '</td></tr>';
	}

	echo '</tbody></table>';
	echo '</div><!-- images_bg -->';


	echo '<div id="images_bio" class="inside" style="">';
	echo '<h3>Images '.$ppp_breadcrumb_sep.' About Me</h3>';
	echo '<table><tbody>';

	echo '<tr><td>Alignment:';
	echo '</td><td><select name="cp_bio_img_align" id="cp_bio_img_align">
<option value="left" '.($this->options["bio_img_align"] == 'left' ? ' selected="selected"' : '').'>Left</option>
<option value="right" '.($this->options["bio_img_align"] == 'right' ? ' selected="selected"' : '').'>Right</option>
</select>';
	echo '</td></tr>';

	echo '<tr><td>Height:';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_bio_image_height" id="cp_bio_image_height" type="text" value="'.$this->options["bio_image_height"].'" /> pixels';
	echo '</td></tr>';

	echo '<tr><td>Width:';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_bio_image_width" id="cp_bio_image_width" type="text" value="'.$this->options["bio_image_width"].'" /> pixels';
	echo '</td></tr>';

	echo '<tr><td>Enter an image URL:';
	echo '</td><td><input class="ppp_input_wide" name="cp_img_bio" id="cp_img_bio" type="text" value="'.ppp_get_img_url("bio",$this->options).'" />';
	echo '</td></tr>';

	echo '<tr><td>Or upload an image:';
	echo '</td><td><input id="cp_upload_image_bio" type="file" name="cp_upload_image_bio" /> <span class="submit inline_submit"><input class="ppp_submit_upload" type="submit" value="Upload" name="cp_upload_image_submit_bio" />';

	if ($this->options["img_fn_bio"] == "" && $this->options["img_bio"] == "") {
		echo '</span></td></tr>';
	} else {
		echo ' <input type="submit" value="Delete &raquo;" name="cp_delete_img_bio" /></span></td></tr>';

		echo '<tr><td>';
		echo '</td><td><label for="cp_display_image_bio">Display image? </label><input type="checkbox" name="cp_display_image_bio" id="cp_display_image_bio"'.($this->options["display_image_bio"] == 1 ? ' checked="checked"' : '').' /> <br />';
		ppp_img_tag("bio", $this->options, "ppp_cp_img", "Bio image");
		echo '</td></tr>';
	}

	echo '</tbody></table>';
	echo '</div><!-- images_bio -->';

		/* Post thumbnails */

	echo '<div id="images_thumb" class="inside" style="">';
	echo '<h3>Images '.$ppp_breadcrumb_sep.' Post Thumbnails</h3>';
	echo '<table><tbody>';

	echo '<tr><td>Alignment:';
	echo '</td><td><select name="cp_img_thumb_align" id="cp_img_thumb_align">
<option value="left" '.($this->options["img_thumb_align"] == 'left' ? ' selected="selected"' : '').'>Left</option>
<option value="right" '.($this->options["img_thumb_align"] == 'right' ? ' selected="selected"' : '').'>Right</option>
</select>';
	echo '</td></tr>';

	echo '<tr><td>Height:';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_thumb_image_height" id="cp_thumb_image_height" type="text" value="'.$this->options["thumb_image_height"].'" /> pixels';
	echo '</td></tr>';

	echo '<tr><td>Width:';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_thumb_image_width" id="cp_thumb_image_width" type="text" value="'.$this->options["thumb_image_width"].'" /> pixels';
	echo '</td></tr>';

	echo '<tr><td>Enter an image URL:';
	echo '</td><td><input class="ppp_input_wide" name="cp_img_thumb" id="cp_img_thumb" type="text" value="'.ppp_get_img_url("thumb",$this->options).'" />';
	echo '</td></tr>';

	echo '<tr><td>Or upload an image:';
	echo '</td><td><input id="cp_upload_image_thumb" type="file" name="cp_upload_image_thumb" /> <span class="submit inline_submit"><input class="ppp_submit_upload" type="submit" value="Upload" name="cp_upload_image_submit_thumb" />';

	if ($this->options["img_fn_thumb"] == "" && $this->options["img_thumb"] == "") {
		echo '</span></td></tr>';
	} else {
		echo ' <input type="submit" value="Delete &raquo;" name="cp_delete_img_thumb" /></span></td></tr>';

		echo '<tr><td>';
		echo '</td><td><label for="cp_display_image_thumb">Display image? </label><input type="checkbox" name="cp_display_image_thumb" id="cp_display_image_thumb"'.($this->options["display_image_thumb"] == 1 ? ' checked="checked"' : '').' /> <br />';

		ppp_img_tag("thumb", $this->options, "ppp_cp_img", "Post Thumbnail image");

		echo '</td></tr>';
	}


	echo '</tbody></table>';
	echo '</div><!-- images_thumb -->';



		/* Post break */

	echo '<div id="images_break" class="inside" style="">';
	echo '<h3>Images '.$ppp_breadcrumb_sep.' Post Break</h3>';

	echo '<h4>Post Break Image</h4>';
	echo '<div class="ppp_images_post_break_div ppp_open_box">';
	echo '<p><small>The Post Break image is placed below each post. Images must be 960 pixels wide or less, but can be of any height.</small></p>';

	echo '<table><tbody>';

	echo '<tr><td>Enter an image URL:';
	echo '</td><td><input class="ppp_input_wide" name="cp_img_pb" id="cp_img_pb" type="text" value="'.ppp_get_img_url("pb",$this->options).'" />';
	echo '</td></tr>';

	echo '<tr><td>Or upload an image';
	echo '</td><td><input id="cp_upload_image_pb" type="file" name="cp_upload_image_pb" /> <span class="submit inline_submit"><input class="ppp_submit_upload" type="submit" value="Upload" name="cp_upload_image_submit_pb" />';

	if ($this->options["img_fn_pb"] == "" && $this->options["img_pb"] == "") {
		echo '</span></td></tr>';
	} else {
		echo ' <input type="submit" value="Delete &raquo;" name="cp_delete_img_pb" /></span></td></tr>';

		echo '<tr><td>';
		echo '</td><td><label for="cp_display_image_pb">Display image? </label><input type="checkbox" name="cp_display_image_pb" id="cp_display_image_pb"'.($this->options["display_image_pb"] == 1 ? ' checked="checked"' : '').' /> <br />';
		ppp_img_tag("pb", $this->options, "ppp_cp_img", "Postbreak image");
		echo '</td></tr>';

		echo '<tr><td class="sublevel">Height:';
		echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_pb_image_height" id="cp_pb_image_height" type="text" value="'.$this->options["pb_image_height"].'" /> pixels <small>(Usually the height of your image, but you can add more pixels for more space above the image.)</small>';
		echo '</td></tr>';
	}
	echo '</tbody></table>';
	echo '</div><!-- .ppp_images_post_break_div -->';

	echo '<h4>Or, choose a horizontal line</h4>';
	echo '<div class="ppp_images_post_break_line_div ppp_open_box">';

	echo '<table><tbody>';
	echo '<tr><td class="sublevel">Size (pixels):';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_pb_border_size" id="cp_pb_border_size" type="text" value="'.$this->options["pb_border_size"].'" />';
	echo '</td></tr>';

	echo '<tr><td class="sublevel">Color:';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_pb_border_color" id="cp_pb_border_color" type="text" value="'.$this->options["pb_border_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td class="sublevel">Style:';
	echo '</td><td><select name="cp_pb_border_style" id="pb_border_style">
<option value="" '.($this->options["pb_border_style"] == '' ? ' selected="selected"' : '').'></option>
<option value="solid" '.($this->options["pb_border_style"] == 'solid' ? ' selected="selected"' : '').'>Solid</option>
<option value="dotted" '.($this->options["pb_border_style"] == 'dotted' ? ' selected="selected"' : '').'>Dotted</option>
<option value="dashed" '.($this->options["pb_border_style"] == 'dashed' ? ' selected="selected"' : '').'>Dashed</option>
</select>';
	echo '</td></tr>';

	echo '</tbody></table>';
	echo '</div><!-- .ppp_images_post_break_line_div -->';
	echo '</div><!-- images_break -->';


	/* Favicon */
	echo '<div id="images_ico" class="inside" style="">';
	echo '<h3>Images '.$ppp_breadcrumb_sep.' Favicon</h3>';
	echo '<h4>Upload an image</h4>';
	echo '<div class="ppp_images_favicon_div ppp_open_box">';

	echo '<p><small>Use a <strong>16 x 16</strong> image in <strong>.ico</strong> format for best browser compatibility. </small></p>';

	echo '<table><tbody>';

	echo '<tr><td>Enter an image URL:';
	echo '</td><td><input class="ppp_input_wide" name="cp_img_ico" id="cp_img_ico" type="text" value="'.ppp_get_img_url("ico",$this->options).'" />';
	echo '</td></tr>';

	echo '<tr><td>Or upload an image:';
	echo '</td><td><input id="cp_upload_image_ico" type="file" name="cp_upload_image_ico" /> <span class="submit inline_submit"><input class="ppp_submit_upload" type="submit" value="Upload" name="cp_upload_image_submit_ico" />';

	if ($this->options["img_fn_ico"] == "" && $this->options["img_ico"] == "") {
		echo '</span></td></tr>';
	} else {
		echo ' <input type="submit" value="Delete &raquo;" name="cp_delete_img_ico" /></span></td></tr>';

		echo '<tr><td>';
		echo '</td><td><label for="cp_display_image_ico">Display image? </label><input type="checkbox" name="cp_display_image_ico" id="cp_display_image_ico"'.($this->options["display_image_ico"] == 1 ? ' checked="checked"' : '').' /> <br />';
		ppp_img_tag("ico", $this->options, "ppp_cp_img", "Favicon");
		echo '</td></tr>';
	}

	echo '</tbody></table>';
	echo '</div><!-- .ppp_images_favicon_div -->';
	echo '</div><!-- images_ico -->';

	echo '</div><!-- ppp_tab_inside -->';

	echo '</div><!-- imagesdiv -->';


	/* OTHER */

	echo '<div id="otherdiv" class="ppp_panel_inner" style="display:none;">';

	/* Other tabs */
	echo '<div id="ppp_other_tab" class="ppp_panel_tabs"><ul class="idTabs">
	<li><a href="#other_float">Floating Icons</a></li>
	<li><a href="#other_seo">SEO</a></li>
	<li><a href="#other_stats">Stats</a></li>
	<li><a href="#other_css">Custom CSS</a></li>
	<li><a href="#other_misc">Other</a></li>
	</ul></div>';

	echo '<div class="ppp_tab_inside">';




	echo '<div id="other_float" class="inside" style="">';
	echo '<h3>Other Options '.$ppp_breadcrumb_sep.' Floating Icons</h3>';

	echo '<h4>Floating Icons and my.php</h4>';

	echo '<div class="ppp_other_float ppp_open_box">';

	echo '<p>Several icons for social networking and bookmarking sites are included with Platinum3. This feature will take a little extra work to customize the links to your own social profiles.</p><p><code>my.php</code> is located in the Platinum3 theme directory, and it contains the code for the floating icons. You can edit the file in the WordPress Theme Editor, under Appearance &gt; Editor, and add your own URLs, or delete any icons you wish.</p>';

	echo '<div class="ppp_floating_bookmarks">
	<label class="labelCheckbox" for="cp_floating_bookmarks">
	<input type="checkbox" name="cp_floating_bookmarks" id="cp_floating_bookmarks"'.( $this->options[("floating_bookmarks")] == 1 ? ' checked="checked"' : '').' class="crirHiddenJS" />Enable Floating Icons in my.php</label>
	<br clear="all"/>';
	echo '</div><!-- .ppp_floating_bookmarks -->';
	
	echo '</div><!-- .ppp_other_float -->';
	echo '</div> <!-- other_float -->';



	echo '<div id="other_seo" class="inside" style="">';
	echo '<h3>Other Options '.$ppp_breadcrumb_sep.' SEO</h3>';

	echo '<h4>SEO (Search Engine Optimization)</h4>';

	echo '<div class="ppp_custom_seo ppp_open_box">';

	echo '<p>Clever keywords and a good site description (sometimes called "meta tags") are 2 ways you can help search engines find your blog. Beware, some plugins such as the All-In-One SEO Pack may override your entries.</p>';

	echo '<h6>Keywords</h6>';
	echo '<p>Enter some general terms, but it\'s a good idea to include descriptive keywords about you and your work. Enter a comma between keywords.</p>';
	echo '<input class="ppp_input_wide" name="cp_meta_keywords" id="cp_meta_keywords" type="text" value="'.$this->options["meta_keywords"].'" /><br />';

	echo '<h6>Description</h6>';
	echo '<p>Enter a sentence or short paragraph about your blog. This is used in addition to your WordPress blog title and description. Be sure to use descriptive keywords.</p>';
	echo '<textarea class="widefat" name="cp_meta_desc" id="cp_meta_desc" rows="4" cols="30">'.$this->options["meta_desc"].'</textarea>';
	echo '</div><!-- .ppp_custom_seo -->';
	echo '</div> <!-- other_seo -->';


	echo '<div id="other_stats" class="inside" style="">';
	echo '<h3>Other Options '.$ppp_breadcrumb_sep.' Stats</h3>';
	echo '<h4>Web Statistics Code</h4>';
	echo '<div class="ppp_custom_stats ppp_open_box">';
	echo '<p>Web stats services such as Google Analytics require some JavaScript code to be added to your site. Paste the code below, and it will be inserted in the footer, just above the &lt;/body&gt; tag.</p>';
	echo '<textarea class="widefat" name="cp_stats_code" id="cp_stats_code" rows="8" cols="60">'.stripslashes($this->options["stats_code"]).'</textarea>';
	echo '</div><!-- .ppp_custom_stats -->';
	echo '</div> <!-- other_stats -->';


	echo '<div id="other_css" class="inside" style="">';
	echo '<h3>Other Options '.$ppp_breadcrumb_sep.' Custom CSS</h3>';

	echo '<h4>Custom CSS Code (Cascading Style Sheets)</h4>';

	echo '<div class="ppp_custom_css ppp_open_box">';

	echo '<p>Need to tweak something and a little CSS is the only way?  Enter it in the box below.  Sometimes you just gotta design, baby!</p>';

	echo '<textarea class="widefat" name="cp_css" id="cp_css" rows="16" cols="30">'.$this->options["css"].'</textarea>';
	
	echo '<p>If you want to use custom PHP code, add it to a file called <strong><tt>my.php</tt></strong> in the Platinum3 theme directory. You can also use <strong><tt>my.css</tt></strong> for custom CSS code that applies to all Snapshots.<br />
	<small>BONUS: Rename the included "my.php.sample" and "my.css.sample" to <tt>my.php</tt> and <tt>my.css</tt> to enable a floating social bookmark sidebar!</small></p>';
	
	echo '</div><!-- .ppp_custom_css -->';
	echo '</div> <!-- other_css -->';


	echo '<div id="other_misc" class="inside" style="">';
	echo '<h3>Other Options</h3>';
	echo '<table><tbody>';

	echo '<tr><td><input type="checkbox" name="cp_stop_thief" id="cp_stop_thief" '.($this->options["stop_thief"] == 1 ? ' checked="checked"' : '').' />';
	echo '</td><td><label for="cp_stop_thief"> Disable right-click functionality?</label>';
	echo '</td></tr>';

	echo '<tr><td></td><td><small>Enter the text to be displayed in the warning dialog box. Leave blank to suppress the warning box.</small>';
	echo '</td></tr>';

	echo '<tr><td></td><td><input class="ppp_input_wide" style="width: 420px" name="cp_rt_clk_text" id="cp_rt_clk_text" type="text" value="'.$this->options["rt_clk_text"].'" />';
	echo '</td></tr>';

	echo '<tr><td><input type="checkbox" name="cp_add_favorites_link" id="cp_add_favorites_link" '.($this->options["add_favorites_link"] == 1 ? ' checked="checked"' : '').' />';
	echo '</td><td><label for="cp_add_favorites_link"> Add Control Panel link to Favorites dropdown (WordPress 2.7+ only)?</label>';
	echo '</td></tr>';

	echo '</tbody></table>';
	echo '</div> <!-- other_misc -->';


	echo '</div><!-- inside -->';
	echo '</div><!-- otherdiv -->';



	/* SLIDESHOW */
	echo '<div id="slideshowdiv" class="ppp_panel_inner" style="display:none;">';

	/* Slideshow tabs */
	echo '<div id="ppp_slideshow_tab" class="ppp_panel_tabs"><ul class="idTabs">
	<li><a href="#slideshow_options">Options</a></li>
	<li><a href="#slideshow_colors">Colors</a></li>
	<li><a href="#slideshow_fonts">Fonts</a></li>
	</ul></div>';

	echo '<div class="ppp_tab_inside">';

	/* Get the slideshow options, then echo the inputs. */
	ppp_slideshow_get_options($this->options["ppp_slideshow_options"]);
	ppp_slideshow_options();


	echo '<div id="slideshow_colors" class="inside" style="">';
	echo '<h3>Slideshow '.$ppp_breadcrumb_sep.' Colors</h3>';
  
	echo '<h4>Slideshow</h4>';
	echo '<div class="ppp_slideshow_options_div ppp_open_box">';
	echo '<table><tbody>';
	echo '<tr><td>Background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_slideshow_bg_color" id="cp_slideshow_bg_color" type="text" value="'.$this->options["slideshow_bg_color"].'" />';
	echo '</td></tr>';

	ppp_opt_border('Border:', 'border_slideshow', $this->options);

	echo '</tbody></table>';
	echo '</div><!-- .ppp_slideshow_options_div -->';

	echo '<h4>Thumbnails</h4>';
	echo '<div class="ppp_slideshow_thumbs_div ppp_open_box">';
	echo '<table><tbody>';
	echo '<tr><td>Background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_slideshow_thumbs_bg_color" id="cp_slideshow_thumbs_bg_color" type="text" value="'.$this->options["slideshow_thumbs_bg_color"].'" />';
	echo '</td></tr>';

	ppp_opt_border('Border:', 'border_slideshow_thumbs', $this->options);

	echo '</tbody></table>';

echo '
		<label class="labelCheckbox" for="cp_slideshow_thumb_shadow">
		<input type="checkbox" name="cp_slideshow_thumb_shadow" id="cp_slideshow_thumb_shadow" value="true" class="crirHiddenJS" '.($this->options["slideshow_thumb_shadow"] == 1 ? ' checked="checked"' : '').' />Drop shadow around thumbnails? (No effect on IE)</label><br clear="all" />
';
	echo '</div><!-- .ppp_slideshow_thumbs_div -->';


	echo '<h4>Text</h4>';
	echo '<div class="ppp_slideshow_txt_div ppp_open_box">';

	echo '<table><tbody>';
	echo '<tr><td>Background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_slideshow_content_bg_color" id="cp_slideshow_content_bg_color" type="text" value="'.$this->options["slideshow_content_bg_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Text color: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_slideshow_content_color" id="cp_slideshow_content_color" type="text" value="'.$this->options["slideshow_content_color"].'" />';
	echo '</td></tr>';

	echo '</tbody></table>';

	echo '</div><!-- .ppp_slideshow_txt_div -->';

	echo '</div> <!-- slideshow_colors -->';



	echo '<div id="slideshow_fonts" class="inside" style="">';
	echo '<h3>Slideshow '.$ppp_breadcrumb_sep.' Fonts</h3>';

	ppp_opt_fonts("slideshow_content", $this->options, $font_css_slideshow_content);
	
	echo '</div> <!-- slideshow_fonts -->';




	echo '</div><!-- ppp_tab_inside -->';
	echo '</div><!-- slideshowdiv -->';







	echo '</div><!-- id="ppp_panel_body" -->';

	echo '</div><!-- id="wrap" -->';

	echo '</form>';

  }
}

?>