<?php

define('PPP_COMMENT_SEP', ppp_get_text_separator());

/* Filter cancel_comment_reply_link and give back a proper hash. */
add_filter('cancel_comment_reply_link', 'ppp_cancel_comment_reply_link', 10, 3);
function ppp_cancel_comment_reply_link($args, $link, $text) {
global $post;
$style = isset($_GET['replytocom']) ? '' : ' style="display:none;"';
$link = esc_html( remove_query_arg('replytocom') ) . '#commentsection-' . $post->ID;
return '<a rel="nofollow" id="cancel-comment-reply-link-'.$post->ID.'" class="cancel-comment-reply-link" href="' . $link . '"' . $style . '>' . $text . '</a>';
}

/* 
Custom callback to list comments in the photopresspro_platinum style 
*/
function custom_comments($comment, $args, $depth) {
  $GLOBALS['comment'] = $comment;
	$GLOBALS['comment_depth'] = $depth;
  ?>
  	<li id="comment-<?php comment_ID() ?>" <?php comment_class() ?>>
  		<div class="comment-author vcard"><?php commenter_link(); echo PPP_COMMENT_SEP; ?>
  		<span class="comment-meta"><?php printf(__('Posted %1$s at %2$s'.PPP_COMMENT_SEP.'<a href="%3$s" title="Link to this comment">Link</a>', 'photopresspro_platinum'),
  					get_comment_date(),
  					get_comment_time(),
  					'#comment-' . get_comment_ID() );
  					edit_comment_link(__('Edit', 'photopresspro_platinum'), PPP_COMMENT_SEP.'<span class="edit-link">', '</span>'); ?>
					<?php custom_comment_reply_link($args, $depth, get_comment_ID()); ?>
        </span>
        </div>
  <?php if ($comment->comment_approved == '0') _e("\t\t\t\t\t<span class='unapproved'>Your comment is awaiting moderation.</span>\n", 'photopresspro_platinum') ?>
          <div class="comment-content">
      		<?php comment_text() ?>
  		</div>
<?php } // end custom_comments


function custom_comment_reply_link($args, $depth, $comment_ID) {
global $id;
// echo the comment reply link
if($args['type'] == 'all' || get_comment_type() == 'comment') :
	comment_reply_link(array_merge($args, array(
		'reply_text' => __('Reply','photopresspro_platinum'), 
		'login_text' => __('Log in to reply.','photopresspro_platinum'),
		'depth' => $depth,
		'before' => PPP_COMMENT_SEP.'<span class="comment-reply-link">', 
		'after' => '</span>',
		'respond_id' => 'commentsection-'.$id
	)), $comment_ID, $id);
endif;
}


/* 
Custom callback to list pings 
*/
function custom_pings($comment, $args, $depth) {
       $GLOBALS['comment'] = $comment;
        ?>
    		<li id="comment-<?php comment_ID() ?>" <?php comment_class() ?>>
    			<div class="comment-author"><?php printf(__('By %1$s on %2$s at %3$s', 'photopresspro_platinum'),
    					get_comment_author_link(),
    					get_comment_date(),
    					get_comment_time() );
    					edit_comment_link(__('Edit', 'photopresspro_platinum'), PPP_COMMENT_SEP.'<span class="edit-link">', '</span>'); ?></div>
    <?php if ($comment->comment_approved == '0') _e('\t\t\t\t\t<span class="unapproved">Your trackback is awaiting moderation.</span>\n', 'photopresspro_platinum') ?>
            <div class="comment-content">
    			<?php comment_text() ?>
			</div>
<?php } // end custom_pings

/* 
Produces an avatar image with the hCard-compliant photo class 
*/
function commenter_link() {
	$commenter = get_comment_author_link();
	if ( ereg( '<a[^>]* class=[^>]+>', $commenter ) ) {
		$commenter = ereg_replace( '(<a[^>]* class=[\'"]?)', '\\1url ' , $commenter );
	} else {
		$commenter = ereg_replace( '(<a )/', '\\1class="url "' , $commenter );
	}
	$avatar_email = get_comment_author_email();
	$avatar = str_replace( "class='avatar", "class='photo avatar", get_avatar( $avatar_email, 38 ) );
	echo $avatar . ' <span class="fn n">' . $commenter . '</span>';
} // end commenter_link


/* 
Called from comments.php theme file 
*/

/*
Hide the comment if we should.
*/
function comments_display() {
  if (!is_singular() && ppp_get_option("comments_inline") == 1 && ppp_get_option("comments_open") == "hidden") { 
?> 
style="display:none" 
<?php 
 } else {
?> 
style="display:block" 
<?php 
 }
}

/* 
Hide the comment form if we should.
*/
function comment_add_display() {
  if (!is_singular() && 
      ppp_get_option("comments_inline") == 1 && 
	  (ppp_get_option("comments_add_open") == "hidden" && ppp_get_option("comment_form_placement") == 'below' || 
	   ppp_get_option("comments_open") == "hidden" && ppp_get_option("comment_form_placement") != 'below')) { 
?> 
style="display:none" 
<?php 
 } else {
?> 
style="display:block" 
<?php 
 }
}


/*
Show a link to the built-in inline comments, AjaxWP comments, or normal comments; in that order.
*/
function custom_comments_link($sep_start = 1) {
	if (!comments_open()) return;
	if (is_singular()) return;
	
	$theme_options = ppp_get_options();
	if ($theme_options["comments_inline"] == 1) {
	
	  /* Inline comments from PPP */
	  custom_comment_link($sep_start);
	
	} else if (has_action('awp_comments_link')) { 
	
	  /* Inline comments from AjaxedWP */
	  if ($sep_start == 1) echo PPP_COMMENT_SEP;
	  ?>
	  <?php do_action('awp_comments_link');?>
	  <?php ppp_awp_commentform_link();
	  global $awpall;
	  if($awpall['comment_template'] != 2) {
	  ?>
	  <?php echo '</div><!-- timestamp --><div><h3 id="comments">'; ?>
	  <?php comments_number('No Comments', 'One Comment', '% Comments'); ?>
	  <?php echo '</h3>';
	  } ?>
	  <?php do_action('awp_comments'); ?>
	  <?php do_action('awp_commentform'); ?>
	  <?php 
	} else {
	
	  /* Normal comments */
	  if ($sep_start == 1) echo PPP_COMMENT_SEP;
	  comments_popup_link( 'No comments', '1 comment', '% comments', '', '');
	}
}

function ppp_awp_commentform_link() {
  global $awpall;
  if($awpall['comment_template'] == 2){
	return;
  }
  echo PPP_COMMENT_SEP;
  do_action('awp_commentform_link');
}

/**
If do_action returns something, echo it after the prefix.
*/
function do_action_pre($id, $prefix) {
  $txt = do_action($id, 'return=true');
  if ($txt != "") {
	echo $prefix+$txt;
  }
}

function custom_comment_link($sep_start = 1) {
  global $withcomments, $post;
  if (!$withcomments) return;
  $theme_options = ppp_get_options();
  if (!is_singular() && $theme_options["comments_inline"] == 1) {

    if ($theme_options["comments_open"] != "always") {

	  /* Only show comments link if > 0 comments, or toggling both comments and the form. */
	  $show_link = 0;
	  if ($theme_options["comment_form_placement"] != 'below') {
		$show_link = 1;
	  }

	  if ($show_link == 0) {
		$ccnt=get_comments_number($post->ID);
		if ($ccnt>0) {
		  $show_link = 1;
		}
	  }

	  if ($show_link == 1) {
		$show = '';
		$hide = '';
		if ($theme_options["comments_open"] == "hidden") {
		$hide = 'none';
		} else {
		$show = 'none';
		}

		/* Toggle both comments and form if side-by-side. */
		$tgl="";
		$msg_add="";
		$msg_cancel="";
		if ($theme_options["comment_form_placement"] != 'below') {
			$tgl="toggleBlock('commentsection-".$post->ID."'); ";
			$msg_add=PPP_COMMENT_SEP."Add Comment";
			$msg_cancel=PPP_COMMENT_SEP."Cancel Comment";
		}

		if ($sep_start == 1 && $show_link == 1) {
			echo PPP_COMMENT_SEP;
		} else if ($sep_start == 0 && $show_link == 1) {
			$sep_start = 1;
		}

?>
    <a id="wp-commentlist-show-<?php echo $post->ID; ?>" class="show-comments" href="#show-comments" style="display:<?php echo $show; ?>" 
    onclick="<?php echo $tgl; ?>toggleBlock('wp-commentlist-<?php echo $post->ID; ?>'); ppptoggle('wp-commentlist-show-<?php echo $post->ID; ?>'); ppptoggle('wp-commentlist-hide-<?php echo $post->ID; ?>'); return false"><?php comments_number('No Comments'.$msg_add, 'Show 1 Comment'.$msg_add, 'Show % Comments'.$msg_add ); ?></a>

    <a id="wp-commentlist-hide-<?php echo $post->ID; ?>" class="hide-comments" href="#hide-comments" style="display:<?php echo $hide; ?>" 
    onclick="<?php echo $tgl; ?>toggleBlock('wp-commentlist-<?php echo $post->ID; ?>'); ppptoggle('wp-commentlist-hide-<?php echo $post->ID; ?>'); ppptoggle('wp-commentlist-show-<?php echo $post->ID; ?>'); return false"><?php comments_number('No Comments'.$msg_cancel, 'Hide 1 Comment'.$msg_cancel, 'Hide % Comments'.$msg_cancel ); ?></a>
<?php 
	  }
    }
  }
  custom_comment_add_link($sep_start);
}


function custom_comment_add_link($sep_start = 1) {
  global $post;
  $theme_options = ppp_get_options();
	/* Only show link if inline, not always shown, and below the comments. */
  if (!is_singular() && $theme_options["comments_inline"] == 1
   && $theme_options["comments_add_open"] != "always"
   && $theme_options["comment_form_placement"] == 'below') { 

    $show = '';
    $hide = '';
    if ($theme_options["comments_add_open"] == "hidden") {
	  $hide = 'none';
    } else {
	  $show = 'none';
    }

	if ($sep_start == 1) echo PPP_COMMENT_SEP;

?>
    <a id="commentsection-show-<?php echo $post->ID; ?>" class="add-comment" href="#add-comment" style="display:<?php echo $show; ?>" 
    onclick="toggleBlock('commentsection-<?php echo $post->ID; ?>'); ppptoggle('commentsection-show-<?php echo $post->ID; ?>'); ppptoggle('commentsection-hide-<?php echo $post->ID; ?>'); return false"
    >Add Comment</a>
    <a id="commentsection-hide-<?php echo $post->ID; ?>" class="close-comment" href="#close-comment" style="display:<?php echo $hide; ?>" 
    onclick="toggleBlock('commentsection-<?php echo $post->ID; ?>'); ppptoggle('commentsection-hide-<?php echo $post->ID; ?>'); ppptoggle('commentsection-show-<?php echo $post->ID; ?>'); return false"
    >Cancel Comment</a>
<?php 
  }
}



/**
 * PPP custom function to echo previous comments on archive pages. 
 * Called by ppp_get_previous_comments_link if !is_singular.
 *
 * Return the previous comments page link.
 *
 * @param string $label Optional. Label for comments link text.
 * @return string|null
 */
function ppp_get_previous_comments_link( $label = '' ) {
	if (!get_option('page_comments') )
		return;

	$page = get_comment_pages_count();

	if ( intval($page) <= 1 )
		return;

	$prevpage = intval($page) - 1;

	if ( empty($label) )
		$label = __('&laquo; Older Comments');

	return '<a href="' . esc_url( get_comments_pagenum_link( $prevpage ) ) . '" ' . apply_filters( 'previous_comments_link_attributes', '' ) . '>' . preg_replace('/&([^#])(?![a-z]{1,8};)/', '&#038;$1', $label) .'</a>';
}

/**
 * PPP custom function to enable previous comments on archive pages. 
 * Calls default get_previous_comments_link if is_singular.
 *
 * Display the previous comments page link.
 *
 * @param string $label Optional. Label for comments link text.
 */
function ppp_previous_comments_link( $label = '' ) {
	if (is_singular()) {
		echo get_previous_comments_link( $label );
	} else {
		echo ppp_get_previous_comments_link( $label );
	}

}


/*
Put the tags in a comma-separated list
*/
function custom_tags_link($comma_start = 1) {
$posttags = get_the_tags();
if ($posttags) {
	foreach($posttags as $tag) {
		/* Should be 0 or 1 to start, so only print after first tag. */
		if ($comma_start == -1) {
			echo ", ";
		}
		/* If first tag, add a comma if directed. */
		if ($comma_start == 1) {
			echo ", ";
		}
		/* After first tag, all commas print. */
		if ($comma_start != -1) {
			$comma_start = -1;
		}
		echo "<a href=\"";
		echo home_url();
		echo "/?tag=";
		echo $tag->slug;
		echo "\" ";
		echo "rel=\"tag\" ";
		echo "title=\"View posts tagged ";
		echo $tag->name;
		echo "\">";
		echo $tag->name;
		echo "</a>";
	}
  }
}

?>
