<?php
/*
Template Name: Archives
*/
?>

<?php get_header(); ?>

<div id="content">


<div class="container">

<div <?php ppp_content_class(); ?>>



<div class="contenttext">

<?php the_content(); ?>

<?php if (ppp_get_option('archives_search') == 1) { ?>
<div class="container">
	<h2>Search the Archives</h2>
<?php include (TEMPLATEPATH . '/searchform.php'); ?>
</div>
<?php } ?>

<div class="container">

<?php if (ppp_get_option('archives_category') == 1) { ?>
<div class="half-2">
	<h2>Archives by Category</h2>
	<ul>
		<?php wp_list_categories('title_li=&show_post_count=1'); ?>
	</ul>
</div>
<?php } ?>


<?php if (ppp_get_option('archives_tag') == 1) { ?>
<div class="half-2">
	<h2>Archives by Tag</h2>
	<ul>
		<?php wp_tag_cloud(); ?>
	</ul>
</div>
<?php } ?>

<?php if (ppp_get_option('archives_month') == 1) { ?>
<div class="half-2">
	<h2>Archives by Month</h2>
	<ul>
		<?php wp_get_archives('type=monthly&show_post_count=1'); ?>
	</ul>
</div>
<?php } ?>

<?php if (ppp_get_option('archives_year') == 1) { ?>
<div class="half-2">
	<h2>Archives by Year</h2>
	<ul>
		<?php wp_get_archives('type=yearly&show_post_count=1'); ?>
	</ul>
</div>
<?php } ?>

<?php if (ppp_get_option('archives_posts') == 1) { ?>
<div class="half-2">
	<h2>All Posts</h2>
	<ul>
		<?php wp_get_archives('type=postbypost'); ?>
	</ul>
</div>
<?php } ?>

<?php if (ppp_get_option('archives_pages') == 1) { ?>
<div class="half-2">
	<h2>All Pages</h2>
	<ul>
		<?php wp_list_pages(); ?>
	</ul>
</div>
<?php } ?>

</div>

</div><!-- .conttenttext -->



</div><!-- .two-columns-content -->

<?php if (ppp_get_option("sidebar_hide_show")=='show') { ?>

<div class="two-columns-sidebar">

<div id="index-sidebar">

<?php get_template_part( 'sidebar', '2columns' ); ?>

</div>

</div><!-- .two-columns-sidebar -->

<?php } ?>

</div><!-- .container -->



</div><!-- #content -->

<?php get_sidebar(); ?>

<?php get_footer(); ?>

<?php



?>

