<?php

if ( function_exists('register_sidebar') )
{
	register_sidebar(array('name' => 'Drop-down menu',
		'before_widget' => '<li class="LargeMenu %s %s">',
		'after_widget' => '</li>',
		'before_title' => '<span class="ppp_widget">',
		'after_title' => '</span>'));
	register_sidebar(array('name' => 'Footer left', 
		'before_widget' => '<li class="ppp_widget">',
		'after_widget' => '</li>',
		'before_title' => '<h2>',
		'after_title' => '</h2>'));
	register_sidebar(array('name' => 'Footer center', 
		'before_widget' => '<li class="ppp_widget">',
		'after_widget' => '</li>',
		'before_title' => '<h2>',
		'after_title' => '</h2>'));
	register_sidebar(array('name' => 'Footer right', 
		'before_widget' => '<li class="ppp_widget">',
		'after_widget' => '</li>',
		'before_title' => '<h2>',
		'after_title' => '</h2>'));
}

define('PPP_UPLOADS_URL', get_bloginfo('wpurl').'/wp-content/uploads/photopresspro/');
define('PPP_UPLOADS_DIR', ABSPATH.'wp-content/uploads/photopresspro/');

/* Register current PPP options. */
$GLOBALS['ppp_platinum_settings'] = ppp_get_options();
global $ppp_platinum_settings;

/* Register the content width so WP doesn't resize images. */
$GLOBALS['content_width'] = 960;

/* Custom image header */
if ( function_exists('add_custom_image_header') ) {
	add_custom_image_header('ppp_header_style', 'ppp_admin_header_style');
}

/* Custom functions */
include(TEMPLATEPATH . '/code/theme_functions.php');

/* JQuery header slideshow */
wp_enqueue_script( 'jquery' );
require_once(TEMPLATEPATH . '/code/slideshow.php');

/* Custom comment templates */
include(TEMPLATEPATH . '/code/comments.php');

/* Font definitions */
include(TEMPLATEPATH . '/code/fonts.php');

/* Add support for 2.9 Post Thumbnails */
if ( function_exists('add_theme_support') )
  add_theme_support('post-thumbnails');

/* Custom Header Image Settings */
$hdr_w = 984;
$hdr_h = 250;
if ($ppp_platinum_settings['header_img_h'] != "") {
    $hdr_h = intval($ppp_platinum_settings['header_img_h']);
}
if ($ppp_platinum_settings['header_img_flash'] == "img_js" || $ppp_platinum_settings['header_img_flash'] == "img_flash") {
  if ($ppp_platinum_settings['header_layout'] == "l" || $ppp_platinum_settings['header_layout'] == "r") {
    $hdr_w = 328;

	if ($ppp_platinum_settings['header_img_flash'] == "img_flash") {
	  /* Open flashfader data file and populate $data with unserialized data */
	  $data = unserialize(file_get_contents(ABSPATH.'wp-content/flashfader/data.txt'));	
	  $hdr_h = $data['lynkff_height'];
	} else {
	  /* Take slideshow height. */
	  $hdr_h = $ppp_platinum_settings["header_img_height"];
	}
  }
}


define('HEADER_IMAGE', '%s/images/ppp_header.png'); // %s is theme dir uri
define('HEADER_IMAGE_WIDTH', $hdr_w);
define('HEADER_IMAGE_HEIGHT', $hdr_h);
define('HEADER_TEXTCOLOR', 'FFFFFF');

function ppp_admin_header_style() {
?>
<style type="text/css">
#headimg {
	margin: 7px 9px 0;
	height: <?php echo HEADER_IMAGE_HEIGHT; ?>px;
	width: <?php echo HEADER_IMAGE_WIDTH; ?>px;
	background: url(<?php header_image() ?>) no-repeat;
}

#headimg h1 a, #desc, #headimg h1 a:hover, #headimg h1 a:visited {
	color:#<?php header_textcolor() ?>;
}

#headimg h1 {
	padding-top: 25px;
	}

#headimg h1, #headimg h1, #headimg h1 a, #headimg h1 a:hover, #headimg h1 a:visited{
	text-decoration: none;
	font-size: 40px;
	text-align: center;
	font-family: 'Trebuchet MS', 'Lucida Grande', Verdana, Arial, Sans-Serif;
	}

#desc {
	font-size: 16px;
	text-align: center;
	}

</style>
<?php
}
function ppp_header_style() {
?>
<style type="text/css">
#headerimg {
	background: url(<?php header_image() ?>) no-repeat;
}

#headerimg h1 a, .description, #headerimg h1 a:hover, #headerimg h1 a:visited {
	color:#<?php header_textcolor() ?>;
}

#headerimg h1, .description {
	padding-top: 25px;
}

#headerimg h1,#headerimg h1 a, .description, #headerimg h1 a:hover, #headerimg h1 a:visited {
	color:#<?php header_textcolor() ?>;
	text-decoration: none;
	font-size: 46px;
	text-align: center;
}

.description {
font-size: 16px;
text-align: center;
}

<?php if ( 'blank' == get_header_textcolor() ) { ?>

#headerimg h1, .description {
	display: none;
}

<?php } ?>

</style>
<?php
}


include(TEMPLATEPATH . '/code/cp_functions.php');


/**
Called from sidebar.php in lieu of standard dynamic_sidebar.
To insert a separator character or image in between menu bar entries.
*/
function ppp_dynamic_sidebar_menubar($index = 1) {
	global $wp_registered_sidebars, $wp_registered_widgets;

	if ( is_int($index) ) {
		$index = "sidebar-$index";
	} else {
		$index = sanitize_title($index);
		foreach ( $wp_registered_sidebars as $key => $value ) {
			if ( sanitize_title($value['name']) == $index ) {
				$index = $key;
				break;
			}
		}
	}

	$sidebars_widgets = wp_get_sidebars_widgets();

	if ( empty($wp_registered_sidebars[$index]) || !array_key_exists($index, $sidebars_widgets) || !is_array($sidebars_widgets[$index]) || empty($sidebars_widgets[$index]) )
		return false;

	$sidebar = $wp_registered_sidebars[$index];

	//PPP menu

	$separator = ppp_get_separator_code();

	$first = true;
	//end PPP menu
	$did_one = false;
	foreach ( $sidebars_widgets[$index] as $id ) {
		$params = array_merge(
			array( array_merge( $sidebar, array('widget_id' => $id, 'widget_name' => $wp_registered_widgets[$id]['name']) ) ),
			(array) $wp_registered_widgets[$id]['params']
		);

		// Substitute HTML id and class attributes into before_widget.
		$classname_ = '';
		foreach ( (array) $wp_registered_widgets[$id]['classname'] as $cn ) {
			if ( is_string($cn) )
				$classname_ .= '_' . $cn;
			elseif ( is_object($cn) )
				$classname_ .= '_' . get_class($cn);
		}
		$classname_ = ltrim($classname_, '_');

		//PPP - append menu_align class name to the menu item.
		$params[0]['before_widget'] = sprintf($params[0]['before_widget'], $id, $menu_align, $classname_);

		//PPP menu
		// If not the first widget, insert the separator before the widget.
		if ($separator != '') {
			if (!$first) {
				$params[0]['before_widget'] = $separator . $params[0]['before_widget'];
			} else {
				$first = false;
			}
		}
		//end PPP menu

		$params = apply_filters( 'dynamic_sidebar_params', $params );

		$callback = $wp_registered_widgets[$id]['callback'];

		if ( is_callable($callback) ) {
			call_user_func_array($callback, $params);
			$did_one = true;
		}
	}

	return $did_one;
}

function ppp_get_separator_code() {
	global $ppp_separator_code;

	if (isset($ppp_separator_code)) {
		return $ppp_separator_code;
	}

	global $ppp_platinum_settings;

	/* Apply Control Panel Settings. */
	$theme_options = $ppp_platinum_settings;

	// Separator
	$sep_char = '';
	$sep_char = $theme_options['menu_separator'];

	// Menu alignment
	$menu_align = '';
	$menu_align = $theme_options['menu_align'];
	if ($menu_align != '') $menu_align = 'menu_' . $menu_align;

	if ($sep_char != '') {
		if ($sep_char == 'bullet') $sep_char = '&bull;';
		if ($sep_char == 'bullet_s') $sep_char = '&middot;';
		if ($sep_char == 'dash') $sep_char = '&mdash;';
		$ppp_separator_code = '<li class="menu_separator '.$menu_align.'">&nbsp;'.$sep_char.'&nbsp;</li>';
	}
	if (($theme_options["img_sep"] != "") && ($theme_options["display_image_sep"] == 1)) {
		$ppp_separator_code = '<li class="menu_separator '.$menu_align.'"><img src="'.$theme_options["img_sep"].'" alt=" " /></li>';
	}
	return $ppp_separator_code;
}

/* Return the current theme options, or those of the selected snapshot. */
function ppp_get_options($setcookie = 0) {
	$theme_options = get_option('ppp_platinum_settings');

	/* Check for Snapshot Chooser cookie or selection */
	if (($_GET['snap'] != '') || ($_COOKIE['ppp_snapshot_pref']!='')) {
		if ($_GET['snap'] != '') {
			$snap = $_GET['snap'];
		} else {
			$snap = $_COOKIE['ppp_snapshot_pref'];
		}
		$snaps = unserialize($theme_options['snapshots']);
		if (is_array($snaps[$snap])) {
			$theme_options = $snaps[$snap];
			if ($setcookie == 1) {
				setcookie("ppp_snapshot_pref", $snap, time()+3600, COOKIEPATH, COOKIE_DOMAIN);
			}
		}
	}
	return $theme_options;
}

/* Get a single PPP option */
function ppp_get_option($option) {
	global $ppp_platinum_settings;
	return $ppp_platinum_settings[$option];
}



/* Add a Control Panel link to the Favorites dropdown (2.7+). Activated by Control Panel option "add_favorites_link */

function add_to_favorites( $favorites_array ) {
	$favorites_array['themes.php?page=ppp_platinum_settings'] = array('PPP Control Panel', 'edit_themes');
	return $favorites_array;
}
if ($ppp_platinum_settings["add_favorites_link"] == 1) {
	add_filter('favorite_actions', 'add_to_favorites');
}


/* PhotoPressPro Platinum Theme Control Panel */
require_once(TEMPLATEPATH . '/code/controlpanel.php');
$cpanel = new ControlPanel();

require_once(TEMPLATEPATH . '/code/widgets.php');

?>