<?php
if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
	die ('Please do not load this page directly. Thanks!');
if ( post_password_required() ) {
	echo 'This post is password protected. Enter the password to view comments.';
	return;
}
?>

<!--  NEW COMMENTS LOOP! -->

<div class="wp-comments">

<?php if ( have_comments() ) : ?>

<div id="wp-commentlist-<?php echo $post->ID; ?>" class="wp-commentlist" <?php comments_display() ?> >
<h2 id="comments"><?php comments_number('No Comments', 'One Comment', '% Comments' ); ?></h2>
<ul class="commentlist">
<?php 
  if (is_singular()) {
    wp_list_comments('callback=custom_comments');
  } else {
	/* TODO -FIX- Paged comments only work on 1st post. */
    wp_list_comments('per_page=0&callback=custom_comments');
  }
?>
</ul>

  <?php $total_pages = get_comment_pages_count(); if ( $total_pages > 1 ) : ?>
    <div class="navigation">
    <div class="alignleft"><?php ppp_previous_comments_link() ?></div>
    <div class="alignright"><?php next_comments_link() ?></div>
    </div>
  <?php endif; ?>					

</div>

<?php else : // this is displayed if there are no comments so far ?>
	<?php if ('open' == $post->comment_status) :
		// If comments are open, but there are no comments.
	else : // comments are closed
	endif;
endif;
?>
 

<!-- COMMENT FORM -->

<?php if ( comments_open() ) : ?>

<div id="commentsection">

<div class="commentsection" id="commentsection-<?php echo $post->ID; ?>" <?php comment_add_display() ?> >

<h3 id="respond_head"><?php comment_form_title('Write a Comment', 'Reply to Comment by %s'); ?></h3>

<div id="respond">

<?php if ( get_option('comment_registration') && !$user_ID ) : ?>
<p>You must be <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php echo urlencode(get_permalink()); ?>">logged in</a> to post a comment.</p>
<?php else : ?>

<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">

<div id="comment_form_inside">

<input type="hidden" name="redirect_to" value="<?php echo wp_specialchars($_SERVER['REQUEST_URI']); ?>" />

<?php if ( $user_ID ) : ?>

<p>Logged in as <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a><?php ppp_text_separator() ?><a href="<?php echo wp_logout_url(get_permalink()); ?>" title="Log out of this account">Log out &raquo;</a> <span id="cancel-comment-reply"><?php cancel_comment_reply_link('(cancel reply)') ?></span></p>

<?php else : ?>

<span id="cancel-comment-reply"><?php cancel_comment_reply_link('(cancel reply)') ?></span>
 
<p class="comment_author"><input type="text" name="author" id="author" class="textarea" value="<?php echo $comment_author; ?>" size="28" tabindex="<?php echo $post->ID; ?>1" /><input type="hidden" name="comment_post_ID" value="<?php echo $post->ID; ?>" /> <label for="author">Name </label><span class="comment_author_req">*</span></p>

<p class="comment_email"><input type="text" name="email" id="email" value="<?php echo $comment_author_email; ?>" size="28" tabindex="<?php echo $post->ID; ?>2" /> <label for="email">Email </label><span class="comment_email_req">*</span></p>

<p class="comment_www"><input type="text" name="url" id="url" value="<?php echo $comment_author_url; ?>" size="28" tabindex="<?php echo $post->ID; ?>3" /> <label for="url">Website</label></p>

<?php endif; ?>

<p class="comment_comment"><label style="display:none" for="comment">Comment</label>

<textarea name="comment" id="comment" cols="66" rows="7" tabindex="<?php echo $post->ID; ?>4"></textarea></p>

<p><input name="submit" id="submit" type="submit" tabindex="<?php echo $post->ID; ?>5" value="Submit" /></p>

<?php comment_id_fields(); ?>

</div><!-- id="comment_form_inside"-->

</form>

<?php endif; // If registration required and not logged in ?>

</div>

</div>

</div>


<?php else : // Comments are closed ?>

<?php endif; ?>

</div><!-- wp-comments -->
