<?php

/*
PhotoPressPro Platinum widgets for WP 2.8+
*/

if (class_exists(WP_Widget)) {

/**
 * PPPSearchWidget Class
 */
class PPPSearchWidget extends WP_Widget {
    /** constructor */
    function PPPSearchWidget() {
          $widget_ops = array( 'description' => __( "Simple search form designed for the PhotoPressPro Platinum Navigation Menu Bar.") );
          $this->WP_Widget('widget_ppp_search', __('PPP Simple Search'), $widget_ops);
    }

    /** @see WP_Widget::widget */
    function widget($args, $instance) {		
        extract( $args );
		echo $before_widget;
		echo $before_title
              . $instance['title']
              . $after_title; ?>
        <form class="head_search" method="get" action="<?php echo $_SERVER['PHP_SELF']; ?>">
            <input type="text" value="<?php if (get_search_query() != '') : the_search_query(); else : echo $instance['def']; endif; ?>" name="s" id="s" size="14" onfocus="this.value=''" />
            <input type="hidden" id="searchsubmit" value="Search" />
        </form>
      <?php echo $after_widget;
    }

    /** @see WP_Widget::update */
    function update($new_instance, $old_instance) {				
        return $new_instance;
    }

    /** @see WP_Widget::form */
    function form($instance) {				
        $title = esc_attr($instance['title']);
        $def = esc_attr($instance['def']);
        ?>
            <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?> <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>
            <p><label for="<?php echo $this->get_field_id('def'); ?>"><?php _e('Text inside search box:'); ?> <input class="widefat" id="<?php echo $this->get_field_id('def'); ?>" name="<?php echo $this->get_field_name('def'); ?>" type="text" value="<?php echo $def; ?>" /></label></p>
        <?php 
    }

} // class PPPSearchWidget



/**
 * PPPLinkWidget Class
 */
class PPPLinkWidget extends WP_Widget {
    /** constructor */
    function PPPLinkWidget() {
          $widget_ops = array( 'description' => __( "Simple link to any URL you wish.") );
          $this->WP_Widget('widget_ppp_link', __('PPP Simple Link'), $widget_ops);

    }

    /** @see WP_Widget::widget */
    function widget($args, $instance) {		
        extract( $args );

		$target = '';
		if ($instance['new_window']==1) {
			$target = 'target="_blank"';
		}

		echo $before_widget; ?>
        <a class="widget_ppp_link" <?php echo $target; ?> href="<?php echo $instance['link']; ?>"><?php echo $before_title . $instance['title'] . $after_title; ?></a>
      <?php echo $after_widget;
    }

    /** @see WP_Widget::update */
    function update($new_instance, $old_instance) {				
		/* Handle checkbox. */
		$instance = $new_instance;
	    $instance['new_window'] = $new_instance['new_window'] ? 1 : 0;
        return $instance;
    }

    /** @see WP_Widget::form */
    function form($instance) {				
        $title = esc_attr($instance['title']);
        $link = esc_attr($instance['link']);
        $new_window = $instance['new_window'];
        ?>
            <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Link text:'); ?> <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>
            <p><label for="<?php echo $this->get_field_id('link'); ?>"><?php _e('URL (web address):'); ?> <input class="widefat" id="<?php echo $this->get_field_id('link'); ?>" name="<?php echo $this->get_field_name('link'); ?>" type="text" value="<?php if ($link=='') {?>http://<?php } echo $link; ?>" /></label></p>
            <p><label for="<?php echo $this->get_field_id('new_window'); ?>"><input id="<?php echo $this->get_field_id('new_window'); ?>" name="<?php echo $this->get_field_name('new_window'); ?>" type="checkbox" <?php if ($new_window==1){ echo"checked='checked'";} ?> /> <?php _e('Open link in a new window?'); ?> </label></p>

        <?php 
    }

} // class PPPLinkWidget




/* Register Widgets */

//add_action('widgets_init', create_function('', 'return register_widget("PPPSearchWidget");'));
add_action('widgets_init', 'ppp_register_widgets');

function ppp_register_widgets() {
  register_widget("PPPSearchWidget");
  register_widget("PPPLinkWidget");
}

} /*if (class_exists(WP_Widget)) {*/


/**
*
* DIRTY WIDGETS FOR 2.7 AND PRIOR
*
**/


/* Widgets */

function widget_ppp_search($args) {
	extract($args);
?>
<?php echo $before_widget; ?><?php echo $before_title; _e('Search'); echo $after_title; ?>
<ul><li><?php include (TEMPLATEPATH . "/searchform.php"); ?>
</li></ul>
<?php echo $after_widget; ?>
<?php
}

function widget_ppp_menu_search($args) {
	extract($args);
?>
<?php echo $before_widget; ?><?php echo $before_title; _e('Search'); echo $after_title; ?>:
	<form class="head_search" method="get" action="<?php echo $_SERVER['PHP_SELF']; ?>">
		<input type="text" value="<?php echo wp_specialchars($s, 1); ?>" name="s" id="s" size="14" />
		<input type="hidden" id="searchsubmit" value="Search" />
	</form>
<?php echo $after_widget; ?>
<?php
}

function widget_ppp_link($args, $number = 1) {
	extract($args);
	$options = get_option('widget_ppp_link');
	$title = $options[$number]['title'];
	if ( empty($title) )
		$title = '&nbsp;';
	$link = $options[$number]['link'];

	$target = '';
	if ($options[$number]['new_window']==1) {
		$target = 'target="_blank"';
	}
?>
<?php echo $before_widget; ?><a class="widget_ppp_link" <?php echo $target ?> href="<?php echo $link ?>"><?php $title ? print($before_title . $title . $after_title) : null; ?></a><?php echo $after_widget; ?>
<?php
}

function widget_ppp_link_control($number) {
	$options = $newoptions = get_option('widget_ppp_link');
	if ( !is_array($options) )
		$options = $newoptions = array();
	if ( $_POST["link-submit-$number"] ) {
		$newoptions[$number]['title'] = strip_tags(stripslashes($_POST["link-title-$number"]));
		$newoptions[$number]['link'] = stripslashes($_POST["link-link-$number"]);
		$newoptions[$number]['new_window'] = isset($_POST["link-new_window-$number"]);
		if ( !current_user_can('unfiltered_html') )
			$newoptions[$number]['link'] = stripslashes(wp_filter_post_kses($newoptions[$number]['link']));
	}
	if ( $options != $newoptions ) {
		$options = $newoptions;
		update_option('widget_ppp_link', $options);
	}
	$title = htmlspecialchars($options[$number]['title'], ENT_QUOTES);
	$link = htmlspecialchars($options[$number]['link'], ENT_QUOTES);
	$new_window = $options[$number]['new_window'];
?>
    <p>Link text:<br />
    <input style="width: 224px;" id="link-title-<?php echo "$number"; ?>" name="link-title-<?php echo "$number"; ?>" type="text" value="<?php echo $title; ?>" /><br />
    URL (web address):<br />
    <input style="width: 224px;" id="link-link-<?php echo "$number"; ?>" name="link-link-<?php echo "$number"; ?>" type="text" value="<?php echo $link; ?>" /><br />
    Open link in a new window? 
    <input id="link-new_window-<?php echo "$number"; ?>" name="link-new_window-<?php echo "$number"; ?>" type="checkbox" <?php if ($new_window==1){ echo"checked='checked'";} ?> />
    <input type="hidden" id="link-submit-<?php echo "$number"; ?>" name="link-submit-<?php echo "$number"; ?>" value="1" /></p>
<?php
}

function widget_ppp_link_setup() {
	$options = $newoptions = get_option('widget_ppp_link');
	if ( isset($_POST['link-number-submit']) ) {
		$number = (int) $_POST['link-number'];
		if ( $number > 9 ) $number = 9;
		if ( $number < 1 ) $number = 1;
		$newoptions['number'] = $number;
	}
	if ( $options != $newoptions ) {
		$options = $newoptions;
		update_option('widget_ppp_link', $options);
		widget_ppp_link_register($options['number']);
	}
}

function widget_ppp_link_page() {
	/* Doesn't work in 2.8, so don't bother. */
	if (!class_exists(WP_Widget)) {
	$options = $newoptions = get_option('widget_ppp_link');
?>
	<div class="wrap">
		<form method="POST">
			<h2><?php _e('Link Widgets', 'widgets'); ?></h2>
			<p style="line-height: 30px;"><?php _e('How many link widgets would you like?', 'widgets'); ?>
			<select id="link-number" name="link-number" value="<?php echo $options['number']; ?>">
<?php for ( $i = 1; $i < 10; ++$i ) echo "<option value='$i' ".($options['number']==$i ? "selected='selected'" : '').">$i</option>"; ?>
			</select>
			<span class="submit"><input type="submit" name="link-number-submit" id="link-number-submit" value="<?php _e('Save'); ?>" /></span></p>
		</form>
	</div>
<?php
	}
}

function widget_ppp_link_register() {
	$options = get_option('widget_ppp_link');
	$number = $options['number'];
	if ( $number < 1 ) $number = 1;
	if ( $number > 9 ) $number = 9;
	for ($i = 1; $i <= 9; $i++) {
		$name = array('PPP Link %s', 'widgets', $i);
		register_sidebar_widget($name, $i <= $number ? 'widget_ppp_link' : /* unregister */ '', $i);
		register_widget_control($name, $i <= $number ? 'widget_ppp_link_control' : /* unregister */ '', 240, 350, $i);
	}
	add_action('sidebar_admin_setup', 'widget_ppp_link_setup');
	add_action('sidebar_admin_page', 'widget_ppp_link_page');
}

function widget_ppp_calendar($args) {
	extract($args);
?>
<?php echo $before_widget; ?>
<?php 
	// PPP fix - get the title from the calendar widget options
	$options = get_option('widget_calendar'); 
	$title = $options['title'];
	if ( empty($title) )
		$title = 'Calendar';

	echo $before_title . $title . $after_title; ?>
	<ul>
		<li class="ppp_calendar">
		<?php get_calendar(); ?>
		</li>
	</ul>
<?php echo $after_widget; ?>
<?php
}

function widget_ppp_categories($args) {
	extract($args);
?>
<?php echo $before_widget; ?>
<?php echo $before_title . __('Categories') . $after_title;?>
	<ul>
	<?php wp_list_categories('title_li='); ?>
	</ul>
<?php echo $after_widget; ?>
<?php
}

function widget_ppp_gsearch($args) {

	// $args is an array of strings that help widgets to conform to
	// the active theme: before_widget, before_title, after_widget,
	// and after_title are the array keys. Default tags: li and h2.
	extract($args);

	// Each widget can store its own options. We keep strings here.
	$options = get_option('widget_gsearch');
	$title = $options['title'];
	$buttontext = $options['buttontext'];

	// These lines generate our output. Widgets can be very complex
	// but as you can see here, they can also be very, very simple.
	echo '<li class="LargeMenu">'.$before_title .__('Search'). $after_title.'<ul><li>';
	$url_parts = parse_url(get_bloginfo('home'));
	echo '<form id="searchform" action="http://www.google.com/search" method="get" onsubmit="this.q.value=\'site:'.$url_parts['host'].' \'+this.rawq.value"><input name="rawq" size="20" /><input type="hidden" name="q" value="" /><input value="'.$buttontext.'" name="submit" type="submit" /></form>';
	echo '</li></ul>'.$after_widget;
}

function widget_text_ppp($args, $widget_args = 1) {
	if (get_bloginfo('version')<'2.5') {
		$number=$widget_args;
		extract($args);
		$options = get_option('widget_text');
		$title = $options[$number]['title'];
		if ( empty($title) )
			$title = '&nbsp;';
		$text = $options[$number]['text'];
?>
<?php echo $before_widget; ?>
<?php $title ? print($before_title . $title . $after_title) : null; ?>
	<ul>
	<li><?php echo $text; ?></li>
	</ul>
<?php echo $after_widget; ?>

<?php
	} else {
	
		extract( $args, EXTR_SKIP );
		if ( is_numeric($widget_args) )
			$widget_args = array( 'number' => $widget_args );
		$widget_args = wp_parse_args( $widget_args, array( 'number' => -1 ) );
		extract( $widget_args, EXTR_SKIP );
	
		$options = get_option('widget_text');
		if ( !isset($options[$number]) )
			return;
	
		$title = $options[$number]['title'];
		$text = apply_filters( 'widget_text', $options[$number]['text'] );
?>
<?php echo $before_widget; ?>
<?php if ( !empty( $title ) ) { echo $before_title . $title . $after_title; } ?>
<ul>
<li><?php echo $text; ?></li>
</ul>
<?php echo $after_widget; ?>

<?php
	}
}

function widget_text_register_ppp() {

	if (get_bloginfo('version')<'2.5') {
		$options = get_option('widget_text');
		$number = $options['number'];
		if ( $number < 1 ) $number = 1;
		if ( $number > 9 ) $number = 9;
		for ($i = 1; $i <= 9; $i++) {
			$name = array('Text %s', null, $i);
			register_sidebar_widget($name, $i <= $number ? 'widget_text_ppp' : /* unregister */ '', $i);
		}
	} else {
		if ( !$options = get_option('widget_text') )
		$options = array();
		$widget_ops = array('classname' => 'widget_text', 'description' => __('Arbitrary text or HTML'));
		$control_ops = array('width' => 400, 'height' => 350, 'id_base' => 'text');
		$name = __('Text');
	
		$id = false;
		foreach ( array_keys($options) as $o ) {
			// Old widgets can have null values for some reason
			if ( !isset($options[$o]['title']) || !isset($options[$o]['text']) )
				continue;
			$id = "text-$o"; // Never never never translate an id
			wp_register_sidebar_widget($id, $name, 'widget_text_ppp', $widget_ops, array( 'number' => $o ));
		}
	
		// If there are none, we register the widget's existance with a generic template
		if ( !$id ) {
			wp_register_sidebar_widget( 'text-1', $name, 'widget_text_ppp', $widget_ops, array( 'number' => -1 ) );
		}
	}
}

function wp_widget_tag_cloud_ppp($args) {
	extract($args);
	$options = get_option('widget_tag_cloud');
	$title = empty($options['title']) ? __('Tags') : $options['title'];

echo $before_widget;
echo $before_title . $title . $after_title;
echo '<ul><li class="ppp_tag_cloud">';
wp_tag_cloud();
echo '</li></ul>';
echo $after_widget;
}

function widget_ppp_polyglot($args) {
	extract($args);
	$options = get_option('widget_polyglot');
	$title = $options['title'];
	$listtype = $options['listtype'] ? true : false ;

	echo polyglot_list_langs($listtype);
}

function widget_ppp_subpagehierarchy($args) {
	// $args is an array of strings that help widgets to conform to
	// the active theme: before_widget, before_title, after_widget,
	// and after_title are the array keys. Default tags: li and h2.
	extract($args);

	// Each widget can store its own options. We keep strings here.
	$options = get_option('widget_subpagehierarchy');
	$title = $options['title'];
	$headpage = $options['headpage'];
	settype($headpage,"integer");
	// These lines generate our output. Widgets can be very complex
	// but as you can see here, they can also be very, very simple.
echo $before_widget . $before_title . $title . $after_title;
echo '<ul>';
wp_list_pages("sort_column=menu_order&child_of=$headpage&title_li=" );
echo '</ul>';
echo $after_widget;
}

function wp_widget_multi_pages($args, $number = 1) {

	extract($args);
	$options = get_option('widget_multi_pages');

	$sortby = empty( $options[$number]['sortby'] ) ? 'menu_order' : $options[$number]['sortby'];
	$exclude = empty( $options[$number]['exclude'] ) ? '' : '&exclude=' . $options[$number]['exclude'];
	$headpage = empty( $options[$number]['headpage'] ) ? '' : '&child_of=' . $options[$number]['headpage'];;

	if ( $sortby == 'menu_order' ) {
		$sortby = 'menu_order, post_title';
	}

	$title = empty($options[$number]['title']) ? __('Pages') : $options[$number]['title'];

	$out = wp_list_pages( 'title_li=&echo=0&sort_column=' . $sortby . $exclude . $headpage);

	if ( !empty ( $out ) ) {
		$out =  $before_widget . $before_title . $title . $after_title . "<ul>". $out . "</ul>". $after_widget;
	}

	if ( !empty( $out ) ) {
		echo $out;
	}
}

function wp_widget_multi_pages_control($number) {
	$options = $newoptions = get_option('widget_multi_pages');
	if ( !is_array($options) )
		$options = $newoptions = array();

	if ( $_POST["multi-pages-submit-$number"] ) {
		$sortby = stripslashes( $_POST["multi-pages-sortby-$number"] );
		if ( in_array( $sortby, array( 'post_title', 'menu_order', 'ID' ) ) ) {
			$newoptions[$number]['sortby'] = $sortby;
		} else {
			$newoptions[$number]['sortby'] = 'menu_order';
		}
		$newoptions[$number]['exclude'] = strip_tags( stripslashes( $_POST["multi-pages-exclude-$number"] ) );
		$newoptions[$number]['headpage'] = strip_tags( stripslashes( $_POST["multi-pages-headpage-$number"] ) );
		$newoptions[$number]['title'] = strip_tags( stripslashes( $_POST["multi-pages-title-$number"] ) );
	}

	if ( $options != $newoptions ) {
		$options = $newoptions;
		update_option('widget_multi_pages', $options);
	}

	$exclude = attribute_escape( $options[$number]['exclude'] );
	$headpage = attribute_escape( $options[$number]['headpage'] );
	$title = attribute_escape( $options[$number]['title'] );

?>
	<p><?php _e( 'Title :' ); ?>  <input type="text" value="<?php echo $title; ?>" name="multi-pages-title-<?php echo $number; ?>" id="multi-pages-title-<?php echo $number; ?>" style="width: 180px;" /><br />
	<small><?php _e( 'Optional.' ); ?></small></p>
	<p><?php _e( 'Parent:' ); ?> <input type="text" value="<?php echo $headpage; ?>" name="multi-pages-headpage-<?php echo $number; ?>" id="multi-pages-headpage-<?php echo $number; ?>" style="width: 180px;" /><br />
	<small><?php _e( 'Only show children of this parent page ID.' ); ?></small></p>
	<p><?php _e( 'Exclude:' ); ?> <input type="text" value="<?php echo $exclude; ?>" name="multi-pages-exclude-<?php echo $number; ?>" id="multi-pages-exclude-<?php echo $number; ?>" style="width: 180px;" /><br />
	<small><?php _e( 'Page IDs to exclude, separated by commas.' ); ?></small></p>
	<p><?php _e( 'Sort by:' ); ?>
		<select name="multi-pages-sortby-<?php echo $number; ?>" id="multi-pages-sortby-<?php echo $number; ?>">
			<option value="post_title"<?php selected( $options[$number]['sortby'], 'post_title' ); ?>><?php _e('Page title'); ?></option>
			<option value="menu_order"<?php selected( $options[$number]['sortby'], 'menu_order' ); ?>><?php _e('Page order'); ?></option>
			<option value="ID"<?php selected( $options[$number]['sortby'], 'ID' ); ?>><?php _e( 'Page ID' ); ?></option>
		</select></p>
	<input type="hidden" id="multi-pages-submit-<?php echo $number; ?>" name="multi-pages-submit-<?php echo $number; ?>" value="1" />
<?php
}

function wp_widget_multi_pages_setup() {
	$options = $newoptions = get_option('widget_multi_pages');
	if ( isset($_POST['multi-pages-number-submit']) ) {
		$number = (int) $_POST['multi-pages-number'];
		if ( $number > 9 ) $number = 9;
		if ( $number < 1 ) $number = 1;
		$newoptions['number'] = $number;
	}
	if ( $options != $newoptions ) {
		$options = $newoptions;
		update_option('widget_multi_pages', $options);
		wp_widget_multi_pages_register($options['number']);
	}
}

function wp_widget_multi_pages_page() {
	/* Doesn't work in 2.8, so don't bother. */
	if (!class_exists(WP_Widget)) {
	$options = $newoptions = get_option('widget_multi_pages');
?>
	<div class="wrap">
		<form method="POST">
			<h2><?php _e('Multi-pages Widgets'); ?></h2>
			<p style="line-height: 30px;"><?php _e('How many multi-pages widgets would you like?'); ?>
			<select id="multi-pages-number" name="multi-pages-number" value="<?php echo $options['number']; ?>">
<?php for ( $i = 1; $i < 10; ++$i ) echo "<option value='$i' ".($options['number']==$i ? "selected='selected'" : '').">$i</option>"; ?>
			</select>
			<span class="submit"><input type="submit" name="multi-pages-number-submit" id="multi-pages-number-submit" value="<?php echo attribute_escape(__('Save')); ?>" /></span></p>
		</form>
	</div>
<?php
	}
}

function wp_widget_multi_pages_register() {
	$options = get_option('widget_multi_pages');
	$number = $options['number'];
	if ( $number < 1 ) $number = 1;
	if ( $number > 9 ) $number = 9;
	$dims = array('width' => 256, 'height' => 350);
	$class = array('classname' => 'widget_multi_pages');
	for ($i = 1; $i <= 9; $i++) {
		$name = sprintf(__('PPP Multi-pages %d'), $i);
		$id = "multi-pages-$i"; // Never never never translate an id
		wp_register_sidebar_widget($id, $name, $i <= $number ? 'wp_widget_multi_pages' : /* unregister */ '', $class, $i);
		wp_register_widget_control($id, $name, $i <= $number ? 'wp_widget_multi_pages_control' : /* unregister */ '', $dims, $i);
	}
	add_action('sidebar_admin_setup', 'wp_widget_multi_pages_setup');
	add_action('sidebar_admin_page', 'wp_widget_multi_pages_page');
}

if ( function_exists('register_sidebar_widget') ) {

	if ( function_exists('widget_polyglot') )
		register_sidebar_widget('Polyglot', 'widget_ppp_polyglot');
	if ( function_exists('widget_gsearch') )
		register_sidebar_widget('Google Search', 'widget_ppp_gsearch');


    if ( function_exists('wp_register_sidebar_widget')) {
		global $wp_register_widget_defaults;
		$wp_register_widget_defaults = false;

		$dims90 = array('height' => 90, 'width' => 300);
		$dims100 = array('height' => 100, 'width' => 300);
		$dims150 = array('height' => 150, 'width' => 300);

		/* Custom Widgets */
		$class['classname'] = 'widget_search';
		wp_register_sidebar_widget('menu_search', 'PPP Search for Menu Bar', 'widget_ppp_menu_search', $class);

		widget_ppp_link_register();

		wp_widget_multi_pages_register();

		wp_register_sidebar_widget('ppp_categories', __('PPP Simple Categories'), 'widget_ppp_categories');

		/* 2.7 and below - replace Standard Widgets */
		if (!class_exists(WP_Widget)) {
			widget_text_register_ppp();
	
			$class['classname'] = 'widget_calendar';
			wp_register_sidebar_widget('calendar', __('Calendar'), 'widget_ppp_calendar', $class);
	
			$class['classname'] = 'widget_search';
			wp_register_sidebar_widget('search', __('Search'), 'widget_ppp_search', $class);
	
			wp_register_sidebar_widget('tag_cloud', __('Tag Cloud'), 'wp_widget_tag_cloud_ppp', $class);
		}


	} else {

		/* Custom Widgets */
		register_sidebar_widget('PPP Search for Menu Bar', 'widget_ppp_menu_search');

		widget_ppp_link_register();

		/* 2.7 and below - replace Standard Widgets */
		if (!class_exists(WP_Widget)) {
			widget_text_register_ppp();
    		register_sidebar_widget('Calendar', 'widget_ppp_calendar');
    		register_sidebar_widget(__('Search'), 'widget_ppp_search');
			register_sidebar_widget(__('Tag Cloud'), 'wp_widget_tag_cloud_ppp');
		}

		register_sidebar_widget('PPP Simple Categories', 'widget_ppp_categories');

	}
}

?>
