<?php

/* Return a dot, dash, umlaut, whatever you want. */
function ppp_get_text_separator() {
	return ' <span class="meta-sep">&middot;</span> ';
}

/* Custom functions for use by the PPP theme. */
function ppp_about_box($placement) {
  $theme_options = ppp_get_options();
  if ($theme_options["bio_placement"] == $placement) {
?>
	<div id="ppp_about" class="about">

<?php if ($placement == "below_hdr") { ?>
<?php } ?>

<?php 
		if ($theme_options["about_title"] != "") {
		  echo '<h2>'.$theme_options["about_title"].'</h2>';
		}
?>
	    <div class="contenttext">
		<div id="biopic"></div>
		<div id="biotxt">
<?php 
		if ($theme_options["about_text"] != "") {
		  echo wpautop($theme_options["about_text"]);
		}
?>
        </div>

      </div>
<?php if ($placement == "below_hdr") { ?>
<?php } ?>

	</div>
	<div class="clearer"></div>
<?php 
  }
}

/* Echo the afore-mentioned. */
function ppp_text_separator() {
	echo ppp_get_text_separator();
}

/* Echo a cobbled-together post title. */
function ppp_get_title() {
  global $post;

  $theme_options = ppp_get_options();
  $h = $theme_options["thumb_image_height"];
  $w = $theme_options["thumb_image_width"];

  $title = '<div class="entry-title-wrap">';
  $title .= '<div class="entry-title-subtitle">';

  if (function_exists('has_post_thumbnail') && has_post_thumbnail() ) {
	$title .= '<div class="ppp-img-thumb">';
	$title .= get_the_post_thumbnail($post->ID, array($w, $h));
	$title .= '</div>';
  } elseif (($theme_options["img_thumb"] != "") && ($theme_options["display_image_thumb"] == 1)) {
	$title .= '<div class="ppp-img-thumb"><img src="'.$theme_options["img_thumb"].'" alt="'.get_the_title().' Image" title="'.get_the_title().' Image" /></div>';
  } 

  if ( is_attachment() ) {
	/* Post Title > attachment title */
	$title .= the_title( '<h1 class="attachment-title entry-title"><a href="' . get_permalink($post->post_parent) . '" title="' . get_the_title($post->post_parent) . '" rel="bookmark">' . get_the_title($post->post_parent) . '</a> &raquo; <a href="' . get_permalink() . '" title="' . the_title_attribute( 'echo=0' ) . '" rel="attachment">', '</a><span class="2"></span></h1>', false );
	}
	elseif( is_front_page() && !is_home() )
		$title .= the_title( '<h2 class="page-title entry-title"><a href="' . get_permalink() . '" title="' . the_title_attribute( 'echo=0' ) . '" rel="bookmark">', '</a></h2><div class="t2"></div>', false );

	elseif ( is_page() )
		$title .= the_title( '<h1 class="page-title entry-title"><a href="' . get_permalink() . '" title="' . the_title_attribute( 'echo=0' ) . '" rel="bookmark">', '</a></h1>', false );

	elseif ( is_single() )
		$title .= the_title( '<h1 class="single-title entry-title"><a href="' . get_permalink() . '" title="' . the_title_attribute( 'echo=0' ) . '" rel="bookmark">', '</a></h1>', false );

	elseif ( 'link_category' == get_query_var( 'taxonomy' ) )
		$title = false;

	else
		$title .= the_title( '<h2 class="post-title entry-title"><a href="' . get_permalink() . '" title="' . the_title_attribute( 'echo=0' ) . '" rel="bookmark">', '</a></h2>', false );

	echo $title;
	
	ppp_subtitle();
	
	echo '</div></div>';
}

/* Return a cobbled-together subtitle. */
function ppp_get_subtitle() {
}
/* Echo a cobbled-together subtitle. */
function ppp_subtitle() {
  $opts = ppp_get_options();

	/* Check for page preference */
  if (is_page() && $opts["ts_sub_onpage"] != 1) {
	return;
  }

	/* Don't show separator if no tags or categories */
  if (!get_the_tags() || is_page()) $opts["ts_sub_tags"] = 0;
  if (!get_the_category() || is_page()) $opts["ts_sub_cats"] = 0;


  if ($opts["ts_sub_author"] == 1 || $opts["ts_sub_date"] == 1 || $opts["ts_sub_time"] == 1 || $opts["ts_sub_cats"] == 1 || $opts["ts_sub_tags"] == 1) { ?>

  <p class="subtitle">
	<?php if ($opts["ts_sub_author"] == 1) {
		the_author_posts_link();
		if ($opts["ts_sub_date"] == 1 || $opts["ts_sub_time"] == 1 || $opts["ts_sub_cats"] == 1 || $opts["ts_sub_tags"] == 1) {
		  ppp_text_separator();
        }
	} 
	?>
	<?php if ($opts["ts_sub_date"] == 1) {
		the_date();
		if ($opts["ts_sub_time"] == 1 || $opts["ts_sub_cats"] == 1 || $opts["ts_sub_tags"] == 1) {
		  ppp_text_separator();
        }
	}
	?>
	<?php if ($opts["ts_sub_time"] == 1) {
		the_time();
		if ($opts["ts_sub_cats"] == 1 || $opts["ts_sub_tags"] == 1) {
		  ppp_text_separator();
        }
	}
	?>
	<?php if ($opts["ts_sub_cats"] == 1) {
		if (the_category(', ')) the_category();
		if ($opts["ts_sub_tags"] == 1) {
			echo ', ';
        }
	}
	if ($opts["ts_sub_tags"] == 1 && !is_page()) custom_tags_link(0);?>
  </p>
<?php }

}

/* Return a cobbled-together postfooter. */
function ppp_get_postfooter() {
  $opts = ppp_get_options();

	/* Check for page preference */
  if (is_page() && $opts["ts_foot_onpage"] != 1) {
	return;
  }

	/* Don't show separator if no tags or categories */
  if (!get_the_tags() || is_page()) $opts["ts_foot_tags"] = 0;
  if (!get_the_category() || is_page()) $opts["ts_foot_cats"] = 0;
?>
  <div class="timestamp">
<?php
  if ($opts["ts_foot_title"] == 1 || $opts["ts_foot_author"] == 1 || $opts["ts_foot_date"] == 1 || $opts["ts_foot_time"] == 1 || $opts["ts_foot_cats"] == 1 || $opts["ts_foot_tags"] == 1) { ?>

	<?php if ($opts["ts_foot_title"] == 1) { ?>
	<a href="<?php the_permalink() ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a><?php edit_post_link('[edit]',' ',''); ?>
	<?php
		if ($opts["ts_foot_author"] == 1 || $opts["ts_foot_date"] == 1 || $opts["ts_foot_time"] == 1 || $opts["ts_foot_cats"] == 1 || $opts["ts_foot_tags"] == 1) {
		  ppp_text_separator();
        }
	} 
	?>
	<?php if ($opts["ts_foot_author"] == 1) {
		the_author_posts_link();
		if ($opts["ts_foot_date"] == 1 || $opts["ts_foot_time"] == 1 || $opts["ts_foot_cats"] == 1 || $opts["ts_foot_tags"] == 1) {
		  ppp_text_separator();
        }
	} 
	?>
	<?php if ($opts["ts_foot_date"] == 1) {
		the_time(get_option('date_format'));
		if ($opts["ts_foot_time"] == 1 || $opts["ts_foot_cats"] == 1 || $opts["ts_foot_tags"] == 1) {
		  ppp_text_separator();
        }
	}
	?>
	<?php if ($opts["ts_foot_time"] == 1) {
		the_time();
		if ($opts["ts_foot_cats"] == 1 || $opts["ts_foot_tags"] == 1) {
		  ppp_text_separator();
        }
	}
	?>
	<?php if ($opts["ts_foot_cats"] == 1) {
		if (the_category(', ')) the_category();
		if ($opts["ts_foot_tags"] == 1) {
			echo ', ';
		}
	}
	if ($opts["ts_foot_tags"] == 1) custom_tags_link(0);
	/* Always show comments links */
    custom_comments_link();
  } else {
    custom_comments_link(0);
  } 
?>
  </div>
<?php
}


?>
