<?php

function ppp_get_header_images($options) {
	return ppp_get_slideshow_markup($options, "hdr");
}

function ppp_get_header_images_css($height) {
	return ppp_get_slideshow_css("hdr", $height);
}


function ppp_get_slideshow_markup($theme_options, $name) {

	$img_hdr_num = ($theme_options['img_fn_'.$name.'_num'] != '') ? intval($theme_options['img_fn_'.$name.'_num']) : 1;

	$ids = ppp_sort_header_ids($theme_options, $img_hdr_num);

	$out = '<div id="slideshow" class="ppp_slideshow_'.$name.' img_hdr_num_'.$img_hdr_num.'">';
	$active = ' class="active"';

	for ($i=1; $i<=$img_hdr_num; $i++) {
		if ($theme_options['img_'.$name.$ids[$i]] != '') {
			$out .= '<div'.$active.'><a href="'.get_bloginfo('url').'"><img src="'.$theme_options['img_'.$name.$ids[$i]].'" alt="" /></a></div>';
			$active = '';
		}
	}
	$out .= '</div>';

	return $out;
}


function ppp_get_slideshow_css($name, $height) {
	echo '<style type="text/css">';
	echo '
#slideshow {
    position:relative;
    height:'.$height.'px;
}

#slideshow DIV {
    position:absolute;
    top:0;
    left:0;
    z-index:8;
    opacity:0.0;
}

#slideshow DIV.active {
    z-index:10;
    opacity:1.0;
}

#slideshow DIV.last-active {
    z-index:9;
}';
	echo '</style>';
}

/**
    DO NOT USE - might use for future development of a plugin.
	Save a slideshow.
	$name - name of slideshow
	$args - array of image urls
*/
function ppp_save_slideshow($name, $args) {
	$theme_options = ppp_get_options();

	$slide_options = $theme_options['ppp_slideshow_'.$name];

	if (is_array($slide_options) && is_array(unserialize($slide_options['divs']))) {
		$divs = unserialize($slide_options['divs']);
	} else {
		$divs = $args;
	}

	/* Put all divs back. */
	$slide_options['divs'] = serialize($divs);

	update_option('ppp_slideshow_'.$name, $slide_options);
}

/**
  Sort the header image ids by the sequence number.
  Probably 912 better ways to do this.
  @since 1.2
*/
function ppp_sort_header_ids($options, $img_hdr_num) {
	$ids = Array();
	$seqs = Array();

	for ($x=1; $x<=$img_hdr_num; $x++) {
		if ($options["image_hdr_seq".$x] != '') {
			$seqs[$x] = $options["image_hdr_seq".$x];
			$ids[$x] = $x;
		}
	}
	for ($x=1; $x<=$img_hdr_num; $x++) {
	  for($y=1; $y<=$img_hdr_num; $y++) {
		if($seqs[$ids[$x]] != '' && $seqs[$ids[$y]] != '') {
		  if(intval($seqs[$ids[$x]]) < intval($seqs[$ids[$y]])) {
			$hold = $ids[$x];
			$ids[$x] = $ids[$y];
			$ids[$y] = $hold;		  
		  }
		}
	  }
	}
	return $ids;
}

?>
