/*** 
    Simple jQuery Slideshow Script
    Released by Jon Raasch (jonraasch.com) under FreeBSD license: free to use or modify, not responsible for anything, etc.  Please link out to me if you like it :)

	Modified by Luke Weese (lukeweese.com).
	- document.ready method moved to header.php to allow for arguments and
	  configurable display time.
	- fade_seconds and randomize args were added to slideSwitch for control.
***/

function slideSwitch(fade_seconds,randomize) {

    var $active = jQuery('#slideshow DIV.active');

    if ( $active.length == 0 ) $active = jQuery('#slideshow DIV:last');

    if (randomize == '1') {
		// pull the images in random order
		var $sibs  = $active.siblings();
		var rndNum = Math.floor(Math.random() * $sibs.length );
		var $next  = jQuery( $sibs[ rndNum ] );
	} else {
		// use this to pull the images in the order they appear in the markup
		var $next =  $active.next().length ? $active.next()
			: jQuery('#slideshow DIV:first');
	}

    $active.addClass('last-active');

    $next.css({opacity: 0.0})
        .addClass('active')
        .animate({opacity: 1.0}, (fade_seconds*1000), function() {
            $active.removeClass('active last-active');
        });
}
/**
jQuery(document).ready( function() {
  // Every five seconds execute the slideSwitch() function
    setInterval( "slideSwitch()", 5000 );
}
**/
