<?php

class ControlPanel {
  var $default_settings = Array(
	'bg_color' => 'F7F7F7',
	'content_bg_color' => 'FFFFFF',
	'h1_color' => '303D42',
	'a_color' => '8AA8B0',
	'content_color' => '303D42',
	'footer_color' => '303D42',
	'footer_link_color' => '303D42',
	'footer_link_bg_hover' => 'EBEBEB',
	'sub_color' => '303D42',
	'display_image_bio' => 0,
	'upload_image_bio' => '',
	'display_image_bg' => 0,
	'upload_image_bg' => '',
	'display_image_pb' => 0,
	'upload_image_pb' => '',
	'display_image_sep' => 0,
	'upload_image_sep' => '',
	'pb_image_height' => '0',
	'pb_border_size' => '1',
	'pb_border_color' => 'EBEBEB',
	'pb_border_style' => 'solid',
	'about_text' => 'This is the &quot;about you&quot; text that you can edit in the Control Panel. Basic html is allowed, so feel free to link to your about page, your flickr account, or your main website.<br />You can also upload a bio image for this section in the Control Panel.',
	'post_img_align' => 'center',
	'post_img_border_size' => '0',
	'post_img_border_color' => '',
	'post_img_border_style' => '',
	'menutext_color' => '303D42',
	'menu1_bg_color' => 'F7F7F7',
	'menu2_bg_color' => 'FFFFFF',
	'menu3_bg_color' => 'F7F7F7',
	'menu4_bg_color' => 'FFFFFF',
	'header_img_flash' => 'img',
	'stop_thief' => 1,
	'menu_align' => 'center',
	'menu_separator' => '',
	'menu_text_hover_color' => '',
	'bg_img_align' => 'left',
	'bg_img_valign' => 'top',
	'bg_img_repeat' => 'repeat',
	'bg_img_fixed' => 0,
	'add_favorites_link' => 1,
	'img_fn_hdr_num' => '1',
	'header_img_height' => '250',
	'header_img_time_disp' => '7',
	'header_img_time_fade' => '3',
	'header_img_rnd' => 0,
	'meta_keywords' => '',
	'meta_desc' => '',
	'stats_code' => '',
	'footer_bg_color' => 'F7F7F7',
	'hdr_margin' => '0',
	'ftr_margin' => '0',
	'border_header_top_size' => '20',
	'border_header_top_color' => 'F7F7F7',
	'border_header_top_style' => 'solid',
	'border_footer_bottom_size' => '20',
	'border_footer_bottom_color' => 'E0E0E0',
	'border_footer_bottom_style' => 'solid',
	'menu_height' => '28',
	'side_border_img' => '1',
	'rt_clk_text' => 'Right click has been disabled.',
	'comments_inline' => '1',
	'comments_open' => 'hidden',
	'comments_add_open' => 'hidden',
	'comments_bg_color' => 'F7F7F7',
	'comments_height' => '250',
	'border_comments_size' => '1',
	'border_comments_color' => 'EBEBEB',
	'border_comments_style' => 'solid',
	'comment_bg_color' => 'F7F7F7',
	'comment_content_color' => '',
	'comment_a_color' => '',
	'comment_a_hover' => '',
	'comment_odd_bg_color' => 'FFFFFF',
	'comment_odd_content_color' => '',
	'comment_odd_a_color' => '',
	'comment_odd_a_hover' => '',
	'comment_author_bg_color' => '',
	'comment_author_content_color' => '',
	'comment_author_a_color' => '',
	'comment_author_a_hover' => '',
	'comment_form_height' => '200',
	'comment_form_placement' => 'below',
	'border_comment_size' => '',
	'border_comment_color' => '',
	'border_comment_style' => '',
	'border_odd_comments_size' => '',
	'border_odd_comments_color' => '',
	'border_odd_comments_style' => '',
	'border_author_comments_size' => '',
	'border_author_comments_color' => '',
	'border_author_comments_style' => '',
	'comments_show_avatar' => '1',
	'comments_hide_default_avatar' => '1',
	'comments_name' => '1',
	'comments_email' => '1',
	'comments_www' => '1',
	'bio_placement' => 'below_hdr',
	'bio_img_align' => 'left',
	'bio_image_height' => '252',
	'bio_image_width' => '180',
	'menu_place' => 'bottom',
	'header_layout' => '',
	'header_img_h' => '250',
	'about_bg_color' => 'F7F7F7',
	'about_color' => '',
	'about_link_color' => '',
	'border_about_size' => '1',
	'border_about_color' => 'EBEBEB',
	'border_about_style' => 'solid',
	'about_title' => 'About Me',
	'footer_h1_color' => '303D42',
	'ts_sub_author' => '0',
	'ts_sub_date' => '1',
	'ts_sub_time' => '0',
	'ts_sub_cats' => '0',
	'ts_sub_tags' => '0',
	'ts_foot_title' => '1',
	'ts_foot_author' => '0',
	'ts_foot_date' => '1',
	'ts_foot_time' => '1',
	'ts_foot_cats' => '1',
	'ts_foot_tags' => '1',
	'font_h1' => 'sans',
	'fontsize_h1' => 'normal',
	'fontsize_h1_user' => '',
	'h1_bold' => '0',
	'h1_ital' => '1',
	'align_h1' => 'center',
	'h1_text_style' => 'normal',	
	'font_css_h1' => '',
	'font_css_eot_h1' => '',
	'font_sub' => 'sans',
	'fontsize_sub' => 'small',
	'fontsize_sub_user' => '',
	'sub_bold' => '0',
	'sub_ital' => '0',
	'align_sub' => 'center',
	'sub_text_style' => 'upper',	
	'font_css_sub' => '',
	'font_css_eot_sub' => '',
	'font_content' => 'sans',
	'fontsize_content' => 'normal',
	'fontsize_content_user' => '',
	'align_content' => 'left',
	'content_bold' => '0',
	'content_ital' => '0',
	'content_text_style' => 'normal',
	'font_css_content' => '',
	'font_css_eot_content' => '',
	'font_menu' => 'sans',
	'fontsize_menu' => 'normal',
	'fontsize_menu_user' => '',
	'align_menu' => 'center',
	'menu_bold' => '0',
	'menu_ital' => '0',
	'menu_text_style' => 'normal',
	'font_css_menu' => '',
	'font_css_eot_menu' => '',
	'font_footer' => 'sans',
	'fontsize_footer' => 'normal',
	'fontsize_footer_user' => '',
	'align_footer' => 'center',
	'footer_bold' => '0',
	'footer_ital' => '0',
	'footer_text_style' => 'normal',
	'border_footitem_size' => '1',
	'border_footitem_color' => 'BCBAAC',
	'border_footitem_style' => 'dashed',
	'font_css_footer' => '',
	'font_css_eot_footer' => '',
	'menu_opacity' => '98',
	'img_thumb' => '',
	'display_image_thumb' => 0,
	'thumb_image_height' => '32',
	'thumb_image_width' => '32',
	'img_thumb_align' => 'left',
	'ts_sub_onpage' => '0',
	'ts_foot_onpage' => '0'
);

  function ControlPanel() {

	/* jquery is probably already queued, but just in case. */
	wp_enqueue_script( 'jquery' );

	wp_enqueue_script( 'ppp-toggle', get_bloginfo('template_directory') . '/code/toggle.js' );

    add_action('admin_menu', array(&$this, 'admin_menu'));
    add_action('admin_head', array(&$this, 'admin_head'));
  
	/* Check restore_defaults and do it. */
	if (isset($_POST['confirm_restore_defaults'])) {
	  update_option('ppp_platinum_settings', $this->default_settings);
	}
	/* If no options are found, save the defaults. */
	if (!is_array(get_option('ppp_platinum_settings'))) {
	  update_option('ppp_platinum_settings', $this->default_settings);
	}
	$this->options = get_option('ppp_platinum_settings');

  }

  function admin_menu() {
    add_theme_page('PPP Platinum Control Panel', 'PPP Platinum<br />Control Panel', 'edit_themes', "ppp_platinum_settings", array(&$this, 'optionsmenu'));
  }
 
  function admin_head() {
    echo '<link rel="stylesheet" href="'.get_bloginfo('template_url').'/code/controlpanel.css" type="text/css" media="screen" />';
    echo '<link href="'.get_bloginfo('template_url').'/code/crir/crir.css" rel="stylesheet" type="text/css" />';
    echo '<script src="'.get_bloginfo('template_url').'/code/jscolor/jscolor.js" type="text/javascript"></script>';
	echo '<script src="'.get_bloginfo('template_url').'/code/controlpanel.js" type="text/javascript"></script>';
	echo '<script src="'.get_bloginfo('template_url').'/code/jquery.idTabs.min.js" type="text/javascript"></script>';
	echo '<script src="'.get_bloginfo('template_url').'/code/crir/crir.js" type="text/javascript"></script>';
  }
 
	/*
	The Main Method.
	*/
  function optionsmenu() {

	/*
		IMPORT OLD SETTINGS
	*/
	if (is_array(get_option('ppp_settings'))) {

	  /* If not dismissed and have ppp_settings, show the welcome message. */
	  if (isset($_POST['import_stop']) || isset($_POST['cp_import'])) {
		update_option('ppp_show_welcome', 'hide');
	  }

	  $hide = get_option('ppp_show_welcome');
	  if ($hide != 'hide') {
		echo '<div class="updated fade" id="message" style="background-color: rgb(255, 251, 204);">
		<p>Thank you for using <strong>PhotoPressPro Platinum</strong>!</p><br />
		<p>We\'ve found some settings for version 1 of the theme. Would you like to import them now?</p>';
		echo '<form action="" method="post" id="ppp_panel_import">';
		echo ' <input style="width:100px;" class="button" id="import" type="submit" value="Yes" name="cp_import" />';
		echo ' <input class="button" id="import_stop" type="submit" value="No, and stop asking" name="import_stop" />';
		echo '</form>';
		echo '</div>';
	  }

	  if (isset($_POST['cp_import'])) {
		$old_options = get_option('ppp_settings');

		/* Add new Snapshots to old Snapshots. */
		$old_snappies = unserialize($old_options['snapshots']);
		if (is_array($old_snappies) && !is_array($old_snappies['Platinum(Default)'])) {
			$old_snappies['Platinum(Default)'] = $this->default_settings;
		}

		$curr_snappies = unserialize($this->options['snapshots']);

		/* Concat snapshots array. */
		if (is_array($old_snappies) && is_array($curr_snappies)) {
			$old_snappies = $old_snappies  + $curr_snappies;
		}

		$old_options['snapshots'] = serialize($old_snappies);

		/* Add old options to the new options. */
		$this->options = $old_options + $this->options;

		update_option("ppp_show_welcome", 'hide');
		update_option('ppp_platinum_settings', $this->options);

		echo '<div class="updated fade" id="message" style="background-color: rgb(255, 251, 204);">
		<p><strong>Version 1 settings have been imported.</strong></p>
		<p>Many options have been added, and many have changed, so be sure to review all options and <strong>Save Changes</strong>.</p>';
		echo '</div>';
	  }

	}

	/* If we restore_defaults, let the user know. */
	if (isset($_POST['confirm_restore_defaults'])) {
	  echo '<div class="updated fade" id="message" style="background-color: rgb(255, 251, 204);"><p><strong>Defaults restored. That is what you wanted, right?</strong></p></div>';
	}

    $uploadsDirectory = PPP_UPLOADS_DIR;
    $upload_dir_url = PPP_UPLOADS_URL;

	/*DEBUG*/
//	echo '<p>Options:'.print_r($this->options).'</p>';

	$snapshot_action = (isset($_POST['cp_load_snapshot_submit']) || isset($_POST['cp_delete_snapshot_submit']) || isset($_POST['confirm_delete_snapshot_submit']));
	$save_or_preview_action = ($_POST['ppp_action'] == 'save' || isset($_POST['cp_draft']));
	$save_action = ($save_or_preview_action && !$snapshot_action);
	
	/* 
	First, are we loading or deleting a snapshot?
	*/
	if ($snapshot_action) {

	  $snappy = $_POST['cp_snapshot'];

	  if (isset($_POST['cp_load_snapshot_submit'])) {

			/* Load a saved snapshot. */

		  $snappies = unserialize($this->options['snapshots']);
	
		  if (is_array($snappies) && is_array($snappies[$snappy])) {
				/* Set current options. */
			$this->options = $snappies[$snappy];


				/* Delete current "cp_img" options. */
			$_POST['cp_img_fn_bio'] = "";
			$_POST['cp_img_fn_bg'] = "";
			$_POST['cp_img_fn_pb'] = "";
			$_POST['cp_img_fn_sep'] = "";
			$_POST['cp_img_thumb'] = "";
			$this->options["cp_img_fn_bio"] = "";
			$this->options["cp_img_fn_bg"] = "";
			$this->options["cp_img_fn_pb"] = "";
			$this->options["cp_img_fn_sep"] = "";
			$this->options["cp_img_thumb"] = "";
				/* Up to img_fn_hdr_num times */
		    $img_hdr_num = ($this->options["img_fn_hdr_num"] != '') ? intval($this->options["img_fn_hdr_num"]) : 1;
			for ($i=1; $i<=$img_hdr_num; $i++) {
				$_POST['cp_img_fn_hdr'.$i] = "";
				$this->options['cp_img_fn_hdr'.$i] = "";
			}

				/* Reset snapshots to old value. */
			$this->options['snapshots'] = serialize($snappies);
	
				/* Reset "Save As" to loaded snapshot name. */
			$_POST['cp_new_snapshot'] = $snappy;

			  echo '<div class="updated fade" id="message" style="background-color: rgb(255, 251, 204);"><p>Snapshot <strong>'.$snappy.'</strong> loaded.</p><p><strong>Be sure to save your changes to apply the snapshot to your blog.</strong></p></div>';
		  } else if ($snappy == 'Platinum(Default)'){

				/* Should only happen the very first time we try to load defaults. */
			  $this->options = $this->default_settings;
				/* Reset snapshots to old value. */
			  $this->options['snapshots'] = serialize(Array('Platinum(Default)' => $this->default_settings));
	
			  echo '<div class="updated fade" id="message" style="background-color: rgb(255, 251, 204);"><p>Snapshot <strong>Platinum(Default)</strong> loaded.</p><p><strong>Be sure to save your changes to apply the snapshot to your blog.</strong></p></div>';
		  } else {
			  echo '<div class="updated fade" id="message" style="background-color: rgb(255, 251, 204);"><p><strong>Whoops!</strong> You might need to try again. If it still doesn\'t work, contact us at support@photopresspro.com.</p></div>';
		  }
	  } else if (isset($_POST['cp_delete_snapshot_submit']) && $snappy != "") {

		/* Get delete confirmation. */

		echo '<div class="updated fade" id="message" style="background-color: rgb(255, 251, 204);">';
		echo '<form action="" method="post" id="ppp_panel">';
		echo '<input type="hidden" id="ppp_action" name="ppp_action" value="snapshot">';
		echo '<input type="hidden" id="cp_snapshot" name="cp_snapshot" value="'.$snappy.'">';
		echo '<label for="confirm_delete_snapshot_submit">Are you <strong>sure</strong> you want to delete the '.$snappy.' snapshot? This cannot be undone.</label>';
		echo '<p class="submit"><input type="submit" value="Yes" name="confirm_delete_snapshot_submit"/><input type="submit" value="No" name="cancel_delete_snapshot"/>';
		echo '</form>';
		echo '</div>';
		return;

	  } else if (isset($_POST['confirm_delete_snapshot_submit'])) {

		/* Delete confirmed, follow thru. */
		$snappies = unserialize($this->options['snapshots']);
	
		if (is_array($snappies) && is_array($snappies[$snappy])) {
			/* Remove the snapshot. */
		  unset($snappies[$snappy]);
			/* Put the other snapshots back. */
		  $this->options['snapshots'] = serialize($snappies);
			/* Now save everything. */
		  update_option('ppp_platinum_settings', $this->options);

		  echo '<div class="updated fade" id="message" style="background-color: rgb(255, 251, 204);"><p>Snapshot <strong>"'.$snappy.'"</strong> deleted.</p></div>';
		} else {
		  echo '<div class="updated fade" id="message" style="background-color: rgb(255, 251, 204);"><p>Could not find snapshot <strong>"'.$snappy.'"</strong>, so it was not deleted.</p></div>';
		}
	  }
	}

	/*
	Now, are we saving?
	*/
	if ($save_action) {

		/*
		Are we sure we want to restore to default settings?
		*/
	  if (isset($_POST['cp_restore_defaults'])) {
		echo '<div class="updated fade" id="message" style="background-color: rgb(255, 251, 204);">';
		echo '<form action="" method="post" id="ppp_panel">';
		echo '<label for="confirm_restore_defaults">Sorry, I just wanted to make sure one more time. Are you <strong>sure</strong> you want to restore the default settings? All current options and snapshots will be deleted, and this really cannot be undone. Obviously I cannot stress that enough, so I have to ask you to check one more box, and click Submit.</label><br /> <input type="checkbox" name="confirm_restore_defaults" id="confirm_restore_defaults" /> <strong>Okay already.</strong>';
		echo '<p class="submit"><input type="submit" value="Submit" name="cp_save"/></p>';
		echo '</form>';
		echo '</div>';
		return;
	  }

		/*
		If snapshot is selected, no new snapshot chosen, and saving changes,
		ask if they meant to load the snapshot.
		*/
	  if ($_POST['cp_snapshot'] != '' && $_POST['cp_new_snapshot'] == '') {
		echo '<div class="updated fade" id="message" style="background-color: rgb(255, 251, 204);">';
		echo '<p>Did you want to load the <strong>'.$_POST['cp_snapshot'].'</strong> snapshot?</p><p>If so, select it again and click the <strong>Load</strong> button below the list.</p>';
		echo '</div>';
	  }


		/* Previous snapshot. */
	  $snapshot_previous = takesnapshot($this->options);

		/* Get the current header image number. */
	  $this->options["img_fn_hdr_num"] = $_POST['cp_img_fn_hdr_num'];
	  $img_hdr_num = ($this->options["img_fn_hdr_num"] != '') ? intval($this->options["img_fn_hdr_num"]) : 1;


		/*
		Check if we are only uploading an image, and not saving.
		*/
	  $uploading_only = (isset($_POST['cp_upload_image_submit_bio'])
	   || isset($_POST['cp_upload_image_submit_bg'])
	   || isset($_POST['cp_upload_image_submit_pb'])
	   || isset($_POST['cp_upload_image_submit_sep'])
	   || isset($_POST['cp_upload_image_submit_thumb'])
	   || isset($_POST['cp_font_css_submit_h1'])
	   || isset($_POST['cp_font_css_eot_submit_h1'])
	   || isset($_POST['cp_font_css_submit_sub'])
	   || isset($_POST['cp_font_css_eot_submit_sub'])
	   || isset($_POST['cp_font_css_submit_menu'])
	   || isset($_POST['cp_font_css_eot_submit_menu'])
	   || isset($_POST['cp_font_css_submit_content'])
	   || isset($_POST['cp_font_css_eot_submit_content'])
	   || isset($_POST['cp_font_css_submit_footer'])
	   || isset($_POST['cp_font_css_eot_submit_footer'])
	   );
	  if (!$uploading_only) {
		for ($i=1; $i<=$img_hdr_num; $i++) {
		  if (isset($_POST['cp_upload_image_submit_hdr'.$i])) {
			$uploading_only = true;
			break;
		  }
		}
	  }


		/* 
		Save these settings!
		*/

		// Checkboxes
	  $this->options["display_image_bio"] = isset($_POST['cp_display_image_bio']) ? 1 : 0;
	  $this->options["display_image_bg"] = isset($_POST['cp_display_image_bg']) ? 1 : 0;
	  $this->options["display_image_pb"] = isset($_POST['cp_display_image_pb']) ? 1 : 0;
	  $this->options["display_image_sep"] = isset($_POST['cp_display_image_sep']) ? 1 : 0;
	  $this->options["display_image_thumb"] = isset($_POST['cp_display_image_thumb']) ? 1 : 0;
		/* Up to img_fn_hdr_num times */
	  for ($i=1; $i<=$img_hdr_num; $i++) {
		$this->options["display_image_hdr".$i] = isset($_POST['cp_display_image_hdr'.$i]) ? 1 : 0;
	  }

	  $this->options["stop_thief"] = isset($_POST['cp_stop_thief']) ? 1 : 0;
	  $this->options["add_favorites_link"] = isset($_POST['cp_add_favorites_link']) ? 1 : 0;
	  $this->options["header_img_rnd"] = isset($_POST['cp_header_img_rnd']) ? 1 : 0;
	  $this->options["bg_img_fixed"] = isset($_POST['cp_bg_img_fixed']) ? 1 : 0;
	  $this->options["side_border_img"] = isset($_POST['cp_side_border_img']) ? 1 : 0;
	  $this->options["comments_inline"] = isset($_POST['cp_comments_inline']) ? 1 : 0;
	  $this->options["comments_name"] = isset($_POST['cp_comments_name']) ? 1 : 0;
	  $this->options["comments_email"] = isset($_POST['cp_comments_email']) ? 1 : 0;
	  $this->options["comments_www"] = isset($_POST['cp_comments_www']) ? 1 : 0;
	  $this->options["comments_show_avatar"] = isset($_POST['cp_comments_show_avatar']) ? 1 : 0;
	  $this->options["comments_hide_default_avatar"] = isset($_POST['cp_comments_hide_default_avatar']) ? 1 : 0;
		/* Fonts */
	  $this->options["h1_bold"] = isset($_POST['cp_h1_bold']) ? 1 : 0;
	  $this->options["h1_ital"] = isset($_POST['cp_h1_ital']) ? 1 : 0;
	  $this->options["sub_bold"] = isset($_POST['cp_sub_bold']) ? 1 : 0;
	  $this->options["sub_ital"] = isset($_POST['cp_sub_ital']) ? 1 : 0;
	  $this->options["content_bold"] = isset($_POST['cp_content_bold']) ? 1 : 0;
	  $this->options["content_ital"] = isset($_POST['cp_content_ital']) ? 1 : 0;
	  $this->options["footer_bold"] = isset($_POST['cp_footer_bold']) ? 1 : 0;
	  $this->options["footer_ital"] = isset($_POST['cp_footer_ital']) ? 1 : 0;
	  $this->options["menu_bold"] = isset($_POST['cp_menu_bold']) ? 1 : 0;
	  $this->options["menu_ital"] = isset($_POST['cp_menu_ital']) ? 1 : 0;

	  $this->options["ts_sub_author"] = isset($_POST['cp_ts_sub_author']) ? 1 : 0;
	  $this->options["ts_sub_date"] = isset($_POST['cp_ts_sub_date']) ? 1 : 0;
	  $this->options["ts_sub_time"] = isset($_POST['cp_ts_sub_time']) ? 1 : 0;
	  $this->options["ts_sub_cats"] = isset($_POST['cp_ts_sub_cats']) ? 1 : 0;
	  $this->options["ts_sub_tags"] = isset($_POST['cp_ts_sub_tags']) ? 1 : 0;
	  $this->options["ts_foot_title"] = isset($_POST['cp_ts_foot_title']) ? 1 : 0;
	  $this->options["ts_foot_author"] = isset($_POST['cp_ts_foot_author']) ? 1 : 0;
	  $this->options["ts_foot_date"] = isset($_POST['cp_ts_foot_date']) ? 1 : 0;
	  $this->options["ts_foot_time"] = isset($_POST['cp_ts_foot_time']) ? 1 : 0;
	  $this->options["ts_foot_cats"] = isset($_POST['cp_ts_foot_cats']) ? 1 : 0;
	  $this->options["ts_foot_tags"] = isset($_POST['cp_ts_foot_tags']) ? 1 : 0;
	  $this->options["ts_sub_onpage"] = isset($_POST['cp_ts_sub_onpage']) ? 1 : 0;
	  $this->options["ts_foot_onpage"] = isset($_POST['cp_ts_foot_onpage']) ? 1 : 0;

		// Other values
	  $this->options["bg_color"] = $_POST['cp_bg_color'];
	  $this->options["content_bg_color"] = $_POST['cp_content_bg_color'];
	  $this->options["footer_bg_color"] = $_POST['cp_footer_bg_color'];
	  $this->options["h1_color"] = $_POST['cp_h1_color'];
	  $this->options["a_color"] = $_POST['cp_a_color'];
	  $this->options["sub_color"] = $_POST['cp_sub_color'];

		/* Fonts */
	  $this->options["font_h1"] = $_POST['cp_font_h1'];
	  $this->options["fontsize_h1"] = $_POST['cp_fontsize_h1'];
	  $this->options["fontsize_h1_user"] = $_POST['cp_fontsize_h1_user'];
	  $this->options["align_h1"] = $_POST['cp_align_h1'];
	  $this->options["h1_text_style"] = $_POST['cp_h1_text_style'];

	  $this->options["font_sub"] = $_POST['cp_font_sub'];
	  $this->options["fontsize_sub"] = $_POST['cp_fontsize_sub'];
	  $this->options["fontsize_sub_user"] = $_POST['cp_fontsize_sub_user'];
	  $this->options["align_sub"] = $_POST['cp_align_sub'];
	  $this->options["sub_text_style"] = $_POST['cp_sub_text_style'];

	  $this->options["font_menu"] = $_POST['cp_font_menu'];
	  $this->options["fontsize_menu"] = $_POST['cp_fontsize_menu'];
	  $this->options["fontsize_menu_user"] = $_POST['cp_fontsize_menu_user'];
	  $this->options["align_menu"] = $_POST['cp_align_menu'];
	  $this->options["menu_text_style"] = $_POST['cp_menu_text_style'];

	  $this->options["font_content"] = $_POST['cp_font_content'];
	  $this->options["fontsize_content"] = $_POST['cp_fontsize_content'];
	  $this->options["fontsize_content_user"] = $_POST['cp_fontsize_content_user'];
	  $this->options["align_content"] = $_POST['cp_align_content'];
	  $this->options["content_text_style"] = $_POST['cp_content_text_style'];

	  $this->options["font_footer"] = $_POST['cp_font_footer'];
	  $this->options["fontsize_footer"] = $_POST['cp_fontsize_footer'];
	  $this->options["fontsize_footer_user"] = $_POST['cp_fontsize_footer_user'];
	  $this->options["align_footer"] = $_POST['cp_align_footer'];
	  $this->options["footer_text_style"] = $_POST['cp_footer_text_style'];


	  $this->options["content_color"] = $_POST['cp_content_color'];
	  $this->options["footer_color"] = $_POST['cp_footer_color'];
	  $this->options["footer_link_color"] = $_POST['cp_footer_link_color'];
	  $this->options["footer_link_bg_hover"] = $_POST['cp_footer_link_bg_hover'];
	  $this->options["post_img_align"] = $_POST['cp_post_img_align'];
	  $this->options["post_img_border_size"] = $_POST['cp_post_img_border_size'];
	  $this->options["post_img_border_color"] = $_POST['cp_post_img_border_color'];
	  $this->options["post_img_border_style"] = $_POST['cp_post_img_border_style'];
	  $this->options["about_text"] = stripslashes($_POST['cp_about_text']);
	  $this->options["pb_border_size"] = $_POST['cp_pb_border_size'];
	  $this->options["pb_border_color"] = $_POST['cp_pb_border_color'];
	  $this->options["pb_border_style"] = $_POST['cp_pb_border_style'];
	  $this->options["menutext_color"] = $_POST['cp_menutext_color'];
	  $this->options["menu1_bg_color"] = $_POST['cp_menu1_bg_color'];
	  $this->options["menu2_bg_color"] = $_POST['cp_menu2_bg_color'];
	  $this->options["menu3_bg_color"] = $_POST['cp_menu3_bg_color'];
	  $this->options["menu4_bg_color"] = $_POST['cp_menu4_bg_color'];
	  $this->options["header_img_flash"] = $_POST['cp_header_img_flash'];
	  $this->options["menu_align"] = $_POST['cp_menu_align'];
	  $this->options["menu_separator"] = $_POST['cp_menu_separator'];
	  $this->options["menu_text_hover_color"] = $_POST['cp_menu_text_hover_color'];
	  $this->options["bg_img_align"] = $_POST['cp_bg_img_align'];
	  $this->options["bg_img_valign"] = $_POST['cp_bg_img_valign'];
	  $this->options["bg_img_repeat"] = $_POST['cp_bg_img_repeat'];
	  $this->options["header_img_height"] = $_POST['cp_header_img_height'];
	  $this->options["header_img_time_disp"] = $_POST['cp_header_img_time_disp'];
	  $this->options["header_img_time_fade"] = $_POST['cp_header_img_time_fade'];
	  $this->options["meta_keywords"] = stripslashes($_POST['cp_meta_keywords']);
	  $this->options["meta_desc"] = stripslashes($_POST['cp_meta_desc']);
	  $this->options["stats_code"] = stripslashes($_POST['cp_stats_code']);
	  $this->options["rt_clk_text"] = stripslashes($_POST['cp_rt_clk_text']);
	  $this->options["hdr_margin"] = $_POST['cp_hdr_margin'];
	  $this->options["ftr_margin"] = $_POST['cp_ftr_margin'];
	  $this->options["border_header_top_size"] = $_POST['cp_border_header_top_size'];
	  $this->options["border_header_top_color"] = $_POST['cp_border_header_top_color'];
	  $this->options["border_header_top_style"] = $_POST['cp_border_header_top_style'];
	  $this->options["border_footer_bottom_size"] = $_POST['cp_border_footer_bottom_size'];
	  $this->options["border_footer_bottom_color"] = $_POST['cp_border_footer_bottom_color'];
	  $this->options["border_footer_bottom_style"] = $_POST['cp_border_footer_bottom_style'];
	  $this->options["menu_height"] = $_POST['cp_menu_height'];
	  $this->options["comments_open"] = $_POST['cp_comments_open'];
	  $this->options["comments_add_open"] = $_POST['cp_comments_add_open'];
	  $this->options["comments_bg_color"] = $_POST['cp_comments_bg_color'];
	  $this->options["comment_bg_color"] = $_POST['cp_comment_bg_color'];
	  $this->options["comment_odd_bg_color"] = $_POST['cp_comment_odd_bg_color'];
	  $this->options["comment_author_bg_color"] = $_POST['cp_comment_author_bg_color'];
	  $this->options["comment_content_color"] = $_POST['cp_comment_content_color'];
	  $this->options["comment_a_color"] = $_POST['cp_comment_a_color'];
	  $this->options["comment_a_hover"] = $_POST['cp_comment_a_hover'];
	  $this->options["comments_height"] = $_POST['cp_comments_height'];
	  $this->options["comment_odd_bg_color"] = $_POST['cp_comment_odd_bg_color'];
	  $this->options["comment_odd_content_color"] = $_POST['cp_comment_odd_content_color'];
	  $this->options["comment_odd_a_color"] = $_POST['cp_comment_odd_a_color'];
	  $this->options["comment_odd_a_hover"] = $_POST['cp_comment_odd_a_hover'];
	  $this->options["comment_author_bg_color"] = $_POST['cp_comment_author_bg_color'];
	  $this->options["comment_author_content_color"] = $_POST['cp_comment_author_content_color'];
	  $this->options["comment_author_a_color"] = $_POST['cp_comment_author_a_color'];
	  $this->options["comment_author_a_hover"] = $_POST['cp_comment_author_a_hover'];
	  $this->options["border_comments_size"] = $_POST['cp_border_comments_size'];
	  $this->options["border_comments_color"] = $_POST['cp_border_comments_color'];
	  $this->options["border_comments_style"] = $_POST['cp_border_comments_style'];
	  $this->options["border_comment_size"] = $_POST['cp_border_comment_size'];
	  $this->options["border_comment_color"] = $_POST['cp_border_comment_color'];
	  $this->options["border_comment_style"] = $_POST['cp_border_comment_style'];
	  $this->options["border_odd_comments_size"] = $_POST['cp_border_odd_comments_size'];
	  $this->options["border_odd_comments_color"] = $_POST['cp_border_odd_comments_color'];
	  $this->options["border_odd_comments_style"] = $_POST['cp_border_odd_comments_style'];
	  $this->options["border_author_comments_size"] = $_POST['cp_border_author_comments_size'];
	  $this->options["border_author_comments_color"] = $_POST['cp_border_author_comments_color'];
	  $this->options["border_author_comments_style"] = $_POST['cp_border_author_comments_style'];
	  $this->options["comment_form_height"] = $_POST['cp_comment_form_height'];
	  $this->options["comment_form_placement"] = $_POST['cp_comment_form_placement'];
	  $this->options["bio_placement"] = $_POST['cp_bio_placement'];
	  $this->options["bio_img_align"] = $_POST['cp_bio_img_align'];
	  $this->options["menu_place"] = $_POST['cp_menu_place'];
	  $this->options["header_layout"] = $_POST['cp_header_layout'];
	  $this->options["header_img_h"] = $_POST['cp_header_img_h'];
	  $this->options["about_bg_color"] = $_POST['cp_about_bg_color'];
	  $this->options["about_color"] = $_POST['cp_about_color'];
	  $this->options["about_link_color"] = $_POST['cp_about_link_color'];
	  $this->options["border_about_size"] = $_POST['cp_border_about_size'];
	  $this->options["border_about_color"] = $_POST['cp_border_about_color'];
	  $this->options["border_about_style"] = $_POST['cp_border_about_style'];
	  $this->options["about_title"] = stripslashes($_POST['cp_about_title']);
	  $this->options["footer_h1_color"] = $_POST['cp_footer_h1_color'];
	  $this->options["border_footitem_size"] = $_POST['cp_border_footitem_size'];
	  $this->options["border_footitem_color"] = $_POST['cp_border_footitem_color'];
	  $this->options["border_footitem_style"] = $_POST['cp_border_footitem_style'];

	  $this->options["font_css_h1"] = $_POST['cp_font_css_h1'];
	  $this->options["font_css_eot_h1"] = $_POST['cp_font_css_eot_h1'];
	  $this->options["font_css_sub"] = $_POST['cp_font_css_sub'];
	  $this->options["font_css_eot_sub"] = $_POST['cp_font_css_eot_sub'];
	  $this->options["font_css_content"] = $_POST['cp_font_css_content'];
	  $this->options["font_css_eot_content"] = $_POST['cp_font_css_eot_content'];
	  $this->options["font_css_menu"] = $_POST['cp_font_css_menu'];
	  $this->options["font_css_eot_menu"] = $_POST['cp_font_css_eot_menu'];
	  $this->options["font_css_footer"] = $_POST['cp_font_css_footer'];
	  $this->options["font_css_eot_footer"] = $_POST['cp_font_css_eot_footer'];
	  $this->options["menu_opacity"] = $_POST['cp_menu_opacity'];

	  $this->options["thumb_image_height"] = $_POST['cp_thumb_image_height'];
	  $this->options["thumb_image_width"] = $_POST['cp_thumb_image_width'];
	  $this->options["img_thumb_align"] = $_POST['cp_img_thumb_align'];

		/*
		Are we deleting an image? 
		*/
	  $deleting = (isset($_POST['cp_delete_img_bio']) || isset($_POST['cp_delete_img_bg']) || isset($_POST['cp_delete_img_pb']) || isset($_POST['cp_delete_img_sep']) || isset($_POST['cp_delete_img_thumb']));

	  if ($deleting) {

			/* Delete images */
		$this->options = check_and_delete_img('bio', 'Bio', $uploadsDirectory, $this->options);
		$this->options = check_and_delete_img('bg', 'Background', $uploadsDirectory, $this->options);
		$this->options = check_and_delete_img('pb', 'Post break', $uploadsDirectory, $this->options);
		$this->options = check_and_delete_img('sep', 'Menu separator', $uploadsDirectory, $this->options);
		$this->options = check_and_delete_img('thumb', 'Post thumbnail', $uploadsDirectory, $this->options);
	  } 

	  	/* 
		Are we uploading? 
		*/

		/* Upload images */
	  $this->options = upload_img('bio', 'Bio', $uploadsDirectory, $upload_dir_url, $this->options, $uploading_only);
	  $this->options = upload_img('bg', 'Background', $uploadsDirectory, $upload_dir_url, $this->options, $uploading_only);
	  $this->options = upload_img('pb', 'Post break', $uploadsDirectory, $upload_dir_url, $this->options, $uploading_only);
	  $this->options = upload_img('sep', 'Menu separator ', $uploadsDirectory, $upload_dir_url, $this->options, $uploading_only);
	  $this->options = upload_img('thumb', 'Post thumbnail ', $uploadsDirectory, $upload_dir_url, $this->options, $uploading_only);

	/* UPLOAD/DELETE FONTS */
	  $this->options = ppp_upload_file('font_css_h1', 'Post Title CSS Font File ', $uploadsDirectory, $upload_dir_url, $this->options, $uploading_only);
	  $this->options = ppp_upload_file('font_css_eot_h1', 'Post Title CSS Font File (EOT) ', $uploadsDirectory, $upload_dir_url, $this->options, $uploading_only);
	  $this->options = ppp_upload_file('font_css_sub', 'Post Subtitle CSS Font File ', $uploadsDirectory, $upload_dir_url, $this->options, $uploading_only);
	  $this->options = ppp_upload_file('font_css_eot_sub', 'Post Subtitle CSS Font File (EOT) ', $uploadsDirectory, $upload_dir_url, $this->options, $uploading_only);
	  $this->options = ppp_upload_file('font_css_content', 'Content CSS Font File ', $uploadsDirectory, $upload_dir_url, $this->options, $uploading_only);
	  $this->options = ppp_upload_file('font_css_eot_content', 'Content CSS Font File (EOT) ', $uploadsDirectory, $upload_dir_url, $this->options, $uploading_only);
	  $this->options = ppp_upload_file('font_css_menu', 'Menu CSS Font File ', $uploadsDirectory, $upload_dir_url, $this->options, $uploading_only);
	  $this->options = ppp_upload_file('font_css_eot_menu', 'Menu CSS Font File (EOT) ', $uploadsDirectory, $upload_dir_url, $this->options, $uploading_only);
	  $this->options = ppp_upload_file('font_css_footer', 'Footer CSS Font File ', $uploadsDirectory, $upload_dir_url, $this->options, $uploading_only);
	  $this->options = ppp_upload_file('font_css_eot_footer', 'Footer CSS Font File (EOT) ', $uploadsDirectory, $upload_dir_url, $this->options, $uploading_only);

		/*
		Are we deleting a file? 
		*/
	  $deleting_font = (isset($_POST['cp_font_css_h1_delete']) || 
		isset($_POST['cp_font_css_eot_h1_delete']) || 
		isset($_POST['cp_font_css_sub_delete']) || 
		isset($_POST['cp_font_css_eot_sub_delete']) || 
		isset($_POST['cp_font_css_content_delete']) || 
		isset($_POST['cp_font_css_eot_content_delete']) || 
		isset($_POST['cp_font_css_menu_delete']) || 
		isset($_POST['cp_font_css_eot_menu_delete']) || 
		isset($_POST['cp_font_css_footer_delete']) || 
		isset($_POST['cp_font_css_eot_footer_delete'])
		);
	  if (!$deleting && $deleting_font) {
		$deleting = $deleting_font;
	  } 
	  if ($deleting_font) {
			/* Delete Fonts */
		$this->options = check_and_delete_file('font_css_h1', 'Post Title CSS Font File ', $uploadsDirectory, $this->options);
		$this->options = check_and_delete_file('font_css_eot_h1', 'Post Title CSS Font File (EOT) ', $uploadsDirectory, $this->options);
		$this->options = check_and_delete_file('font_css_sub', 'Post Subtitle CSS Font File ', $uploadsDirectory, $this->options);
		$this->options = check_and_delete_file('font_css_eot_sub', 'Post Subtitle CSS Font File (EOT) ', $uploadsDirectory, $this->options);
		$this->options = check_and_delete_file('font_css_content', 'Content CSS Font File ', $uploadsDirectory, $this->options);
		$this->options = check_and_delete_file('font_css_eot_content', 'Content CSS Font File (EOT) ', $uploadsDirectory, $this->options);
		$this->options = check_and_delete_file('font_css_menu', 'Menu CSS Font File ', $uploadsDirectory, $this->options);
		$this->options = check_and_delete_file('font_css_eot_menu', 'Menu CSS Font File (EOT) ', $uploadsDirectory, $this->options);
		$this->options = check_and_delete_file('font_css_footer', 'Footer CSS Font File ', $uploadsDirectory, $this->options);
		$this->options = check_and_delete_file('font_css_eot_footer', 'Footer CSS Font File (EOT) ', $uploadsDirectory, $this->options);

	  } 



	  /* Slideshow upload and delete */	  

	  $next_hdr_img = $img_hdr_num;
		/* Are we deleting an image? */
	  for ($i=1; $i<=$img_hdr_num; $i++) {
		if (isset($_POST['cp_delete_img_hdr'.$i])) {
			$deleting_hdrimg = isset($_POST['cp_delete_img_hdr'.$i]);
			$next_hdr_img--;
			$this->options = check_and_delete_img('hdr'.$i, 'Header', $uploadsDirectory, $this->options);
		}
	  }
	  $this->options["img_fn_hdr_num"] = $next_hdr_img;

	  /* Update each uploaded image */
	  for ($i=1; $i<=$img_hdr_num; $i++) {
		$this->options = upload_img('hdr'.$i, 'Header', $uploadsDirectory, $upload_dir_url, $this->options, $uploading_only);
	  }
		
	  /* Set deleting if not set and needs to be. */
	  if (!$deleting && $deleting_hdrimg) {
		$deleting = 1;
	  }

	  /* Save header sequence numbers. */
	  for ($i=1; $i<=$img_hdr_num; $i++) {
		if ($_POST['cp_image_hdr_seq'.$i] != '') {
			$this->options["image_hdr_seq".$i] = $_POST['cp_image_hdr_seq'.$i];

			/* Safeguard against too large seq number. */
			if (intval($this->options["image_hdr_seq".$i]) > intval($img_hdr_num)) {
				$this->options["image_hdr_seq".$i] = $img_hdr_num;
			}
		}
	  }

		/* 
		Save all snapshots. 
		*/
	  if (is_array(unserialize($this->options['snapshots']))) {
		  $snapshots = unserialize($this->options['snapshots']);
	  } else {
		  $snapshots = Array('Platinum(Default)' => $this->default_settings);
	  }

		/* Only save previous and named snapshots if we are actually saving. */
	  $saving = (!$deleting && !$uploading_only && !isset($_POST['cp_draft']));



		/* Save the Preview snapshot and revert current settings to previous */
	  if (!$saving) {

			/* Give the draft snapshot its name and save it. */
		  $_POST['cp_new_snapshot'] = 'Preview';
		  $snapshots[$_POST['cp_new_snapshot']] = takesnapshot($this->options);

			/* Put current snapshots on the so-called-previous snapshot. */
		  $snapshot_previous['snapshots'] = serialize($snapshots);
	
			/* Update the current settings with those grabbed from the screen, plus the Preview snapshot. */
		  update_option('ppp_platinum_settings', $snapshot_previous);

		  echo '<div class="updated fade" id="message" style="background-color: rgb(255, 251, 204);"><p>Current settings are saved in <strong>Preview</strong> mode and can only be viewed using the url <a target="wp-preview" href="'.get_bloginfo('url').'?snap=Preview">'.get_bloginfo('url').'?snap=Preview</a>.</p><p>Press the <strong>Save Changes</strong> button to commit the current settings.</p></div>';

	  } else { 

			/* Add the previous snapshot.  */
		  $snapshots['Previous'] = $snapshot_previous;
	
			/* Save the current, if told. */
		  if ($_POST['cp_new_snapshot'] != "") {
			  $snapshots[$_POST['cp_new_snapshot']] = takesnapshot($this->options);
		  }

  	  }


		/* Put all snapshots back. */
	  $this->options['snapshots'] = serialize($snapshots);
	
	  if ($saving) { 

		  update_option('ppp_platinum_settings', $this->options);

		  if ($_POST['cp_new_snapshot'] != "") {
			echo '<div class="updated fade" id="message" style="background-color: rgb(255, 251, 204);"><p>Settings saved as <strong>'.$_POST['cp_new_snapshot'].'</strong> snapshot.</p></div>';
		  }	else {
			echo '<div class="updated fade" id="message" style="background-color: rgb(255, 251, 204);"><p>Settings <strong>saved</strong>.</p></div>';
		  }
  	  }

	}

	/* If we don't have any snapshots, dummy up a default. */
    if (!is_array(unserialize($this->options['snapshots']))) {
		$this->options['snapshots'] = serialize(Array('Platinum(Default)' => $this->default_settings));
	}

	echo '<form action="" method="post" enctype="multipart/form-data" id="ppp_panel">';
	echo '<input type="hidden" id="ppp_action" name="ppp_action" value="save" />';

	echo '<div class="wrap">';

	echo '<h2>PhotoPressPro Platinum Control Panel</h2>';

	/* Put the Save and Snapshots boxes on the top right. */
	echo '<div id="ppp_panel_sidebar">';

	echo '<div id="submitdiv" class="">';

	echo '<div id="save_button" class="">';
	echo ' <input id="save" type="submit" value="Save Changes" name="cp_save" />';
	echo ' <div id="save_button_top"></div>';
	echo ' <div id="save_button_middle1"></div>';
	echo ' <div id="save_button_middle2"></div>';
	echo ' <div id="save_button_middle3"></div>';
	echo ' <div id="save_button_bottom"></div>';
	echo '</div><!-- save_button -->';

	echo '</div><!-- submitdiv -->';


	echo '<div id="draftdiv" class="ppp_panel_side">';
	echo ' <input class="button" id="save_draft" type="submit" value="Save Draft" name="cp_draft" />';
	if ($_POST['cp_new_snapshot'] == 'Preview') {
	    echo ' <input class="preview button" id="preview" type="button" value="Preview" name="cp_preview" onclick="window.open(\''.get_bloginfo('url').'?snap=Preview\');return true;" />';
	}
	echo '</div><!-- draftdiv -->';


		/* SNAPSHOTS */
	
	echo '<div id="snapshotsdiv" class="ppp_panel_side">';
	echo '<h3>Snapshots</h3>';
	echo '<div class="inside">';

		/* New snapshot */
	echo '  <p>Enter a name to add a snapshot, or save an existing snapshot:<br />';
	echo '  <input class="widefat" name="cp_new_snapshot" id="cp_new_snapshot" type="text" value="'.$_POST['cp_new_snapshot'].'" />';
	echo '  </p><br />';

	echo '  <p>Load or delete a saved snapshot:<br />';
	echo '  <select class="widefat" name="cp_snapshot" id="cp_snapshot" onchange="document.getElementById(\'cp_load_snapshot_submit\').bgColor=\'F26101\'">';
	echo '  <option value="" ></option>';
	foreach (unserialize($this->options['snapshots']) as $key => $settings) {
		echo '  <option value="'.$key.'" >'.$key.'</option>';
	}
	echo '  </select> ';
	echo '  <span style="border:0;" ><input style="width:120px;" class="button" type="submit" value="Load" name="cp_load_snapshot_submit" id="cp_load_snapshot_submit" /></span> <span style="text-align:right; border:0;" ><input style="float:right; clear:right;" class="button" type="submit" value="Delete &raquo;" name="cp_delete_snapshot_submit"/></span>';
	echo '  </p>';

	echo '</div><!-- inside -->';
	echo '</div><!-- snapshotsdiv -->';
	

	/* RESTORE DEFAULTS */

	echo '<div id="defaultsdiv" class="ppp_panel_side" style="text-align:center;">';
	echo '<a id="toggle_restore_defaults" class="tgl">Restore Defaults?</a>';
	echo '<div class="inside">';
	echo '<table><tbody>';

	echo '<tr><td>';
	echo '</td><td><div id="restore_defaults" style="display:none">Are you sure? Check the box and click the Save button, cowboy.<input type="checkbox" name="cp_restore_defaults" id="cp_restore_defaults" /></div>';
	echo '</td></tr>';

	echo '</tbody></table>';
	echo '</div><!-- inside -->';
	echo '</div><!-- defaultsdiv -->';
	
	echo '</div><!-- ppp_panel_sidebar -->';


	/* Top Menu */

	echo '<div id="ppp_panel_menu">';

	/* Thanks http://www.sunsean.com/idTabs/ */
	echo '<ul class="idTabs">
	<li><a href="#colorsdiv">Colors</a></li>
	<li><a href="#layoutdiv">Layout</a></li>
	<li><a href="#fontsdiv">Fonts</a></li>
	<li><a href="#imagesdiv">Images</a></li>
	<li><a href="#headerdiv">Header Slideshow</a></li>
	<li><a href="#otherdiv">Other</a></li>
	<li style="float:right; margin-right:7px;"><a target="_blank" href="http://photopresspro.com/support/customize">Help &raquo;</a></li>
	</ul></div>';


	/* The Body */

	echo '<div id="ppp_panel_body">';


	/* COLORS */

	echo '<div id="colorsdiv" class="ppp_panel_inner" style="display:block;">';
	echo '<h3>Colors</h3>';


	echo '<div id="ppp_colors_tab" class="ppp_panel_tabs"><ul class="idTabs">
	<li><a href="#colors_body">Body &amp; Content</a></li>
	<li><a href="#colors_menu">Menu</a></li>
	<li><a href="#colors_comments">Comments</a></li>
	<li><a href="#colors_footer">Footer</a></li>
	<li><a href="#colors_about">About Me</a></li>
	</ul></div>';


	echo '<div id="colors_body" class="inside ppp_tab_inside" style="display:block;">';
	echo '<table><tbody>';

	echo '<tr><td>Background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_bg_color" id="cp_bg_color" type="text" value="'.$this->options["bg_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Content background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_content_bg_color" id="cp_content_bg_color" type="text" value="'.$this->options["content_bg_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Post Titles: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_h1_color" id="cp_h1_color" type="text" value="'.$this->options["h1_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Subtitles: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_sub_color" id="cp_sub_color" type="text" value="'.$this->options["sub_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Links: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_a_color" id="cp_a_color" type="text" value="'.$this->options["a_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Content text: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_content_color" id="cp_content_color" type="text" value="'.$this->options["content_color"].'" />';
	echo '</td></tr>';

	echo '</tbody></table>';
	echo '</div><!-- colors_body -->';

	/* MENU */

	echo '<div id="colors_menu" class="inside ppp_tab_inside" style="display:none;">';
	echo '<table><tbody>';

	echo '<tr><td>Text color: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_menutext_color" id="cp_menutext_color" type="text" value="'.$this->options["menutext_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td colspan="2"><h4>Background colors</h4>';
	echo '</td></tr>';

	echo '<tr><td>Main level: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_menu1_bg_color" id="cp_menu1_bg_color" type="text" value="'.$this->options["menu1_bg_color"].'" /> <a id="toggle_note_menu_1" class="tgl"><small>what is this?</small></a>';
	echo '</td></tr>';
	echo '<tr><td colspan="2"><div id="note_menu_1" class="note" style="display:none">This is the background color of the menu bar.</div>';
	echo '</td></tr>';

	echo '<tr><td>Level 2: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_menu2_bg_color" id="cp_menu2_bg_color" type="text" value="'.$this->options["menu2_bg_color"].'" /> <a id="toggle_note_menu_2" class="tgl"><small>what is this?</small></a>';
	echo '</td></tr>';
	echo '<tr><td colspan="2"><div id="note_menu_2" class="note" style="display:none">This is the hover color for the menu bar, the background color of the dropdown menus, AND the border color of the PPP Search for Menu Bar widget.</div>';
	echo '</td></tr>';

	echo '<tr><td>Level 3: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_menu3_bg_color" id="cp_menu3_bg_color" type="text" value="'.$this->options["menu3_bg_color"].'" /> <a id="toggle_note_menu_3" class="tgl"><small>what is this?</small></a>';
	echo '</td></tr>';
	echo '<tr><td colspan="2"><div id="note_menu_3" class="note" style="display:none">This is the hover color on the dropdown menu items, and the background of the next level of menus, such as sub-pages or sub-categories.</div>';
	echo '</td></tr>';

	echo '<tr><td>Level 4: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_menu4_bg_color" id="cp_menu4_bg_color" type="text" value="'.$this->options["menu4_bg_color"].'" /> <a id="toggle_note_menu_4" class="tgl"><small>what is this?</small></a>';
	echo '</td></tr>';
	echo '<tr><td colspan="2"><div id="note_menu_4" class="note" style="display:none">This is the hover color of the sub-menus, and the background color of sub-sub-menus, and any more sub-s you may have.</div>';
	echo '</td></tr>';

	echo '<tr><td colspan="2"><h4>Opacity</h4>';
	echo '</td></tr>';

	echo '<tr><td colspan="2">Set the percentage of opacity on your menu, up to 100. (For non-IE browsers only)';
	echo '</td></tr>';

	echo '<tr><td>Percent:';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_menu_opacity" id="cp_menu_opacity" type="text" value="'.$this->options["menu_opacity"].'" /> %';
	echo '</td></tr>';


	echo '</tbody></table>';
	echo '</div><!-- colors_menu -->';


	echo '<div id="colors_comments" class="inside ppp_tab_inside" style="display:none;">';

	echo '<p class="inside">Choose the background color and border for the comment box, or leave blank to keep the same background color as the content.</p>';
	echo '<p><small>Note: If you use the AJAXedWordPress plugin for inline comments, make sure &quot;Use your theme\'s default comment template&quot; setting is checked, or these settings may not work.</small></p>';

	echo '<table><tbody>';

	echo '<tr><td>Background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comments_bg_color" id="cp_comments_bg_color" type="text" value="'.$this->options["comments_bg_color"].'" />';
	echo '</td></tr>';

	ppp_opt_border('Border:', 'border_comments', $this->options);

	echo '</tbody></table>';


	echo '<h4>Individual Comments</h4>';
	echo '<p class="inside">Choose colors for All Comments, then choose different colors for every other comment, or author comments, if you wish.</p>';

	/* Tabbed comment variants */

	echo '<div id="ppp_comments_tab" class="ppp_panel_tabs"><ul class="idTabs">
	<li><a href="#comments_all">All Comments</a></li>
	<li><a href="#comments_odd">Alternating Comments</a></li>
	<li><a href="#comments_author">Author Comments</a></li>
	</ul></div>';

	echo '<div id="comments_all" class="inside ppp_tab_inside">';
	echo '<table><tbody>';

	echo '<tr><td>Background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_bg_color" id="cp_comment_bg_color" type="text" value="'.$this->options["comment_bg_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Text: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_content_color" id="cp_comment_content_color" type="text" value="'.$this->options["comment_content_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Links: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_a_color" id="cp_comment_a_color" type="text" value="'.$this->options["comment_a_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Link mouseover: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_a_hover" id="cp_comment_a_hover" type="text" value="'.$this->options["comment_a_hover"].'" />';
	echo '</td></tr>';

	ppp_opt_border('Border:', 'border_comment', $this->options);

	echo '</tbody></table>';
	echo '</div><!-- inside -->';


	echo '<div id="comments_odd" class="inside ppp_tab_inside" style="display:none;">';
	echo '<table><tbody>';

	echo '<tr><td>Background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_odd_bg_color" id="cp_comment_odd_bg_color" type="text" value="'.$this->options["comment_odd_bg_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Text: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_odd_content_color" id="cp_comment_odd_content_color" type="text" value="'.$this->options["comment_odd_content_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Links: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_odd_a_color" id="cp_comment_odd_a_color" type="text" value="'.$this->options["comment_odd_a_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Link mouseover: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_odd_a_hover" id="cp_comment_odd_a_hover" type="text" value="'.$this->options["comment_odd_a_hover"].'" />';
	echo '</td></tr>';

	ppp_opt_border('Border:', 'border_odd_comments', $this->options);

	echo '</tbody></table>';
	echo '</div><!-- inside -->';

	echo '<div id="comments_author" class="inside ppp_tab_inside">';
	echo '<table><tbody>';

	echo '<tr><td>Background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_author_bg_color" id="cp_comment_author_bg_color" type="text" value="'.$this->options["comment_author_bg_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Text: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_author_content_color" id="cp_comment_author_content_color" type="text" value="'.$this->options["comment_author_content_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Links: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_author_a_color" id="cp_comment_author_a_color" type="text" value="'.$this->options["comment_author_a_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Link mouseover: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_comment_author_a_hover" id="cp_comment_author_a_hover" type="text" value="'.$this->options["comment_author_a_hover"].'" />';
	echo '</td></tr>';

	ppp_opt_border('Border:', 'border_author_comments', $this->options);

	echo '</tbody></table>';
	echo '</div><!-- comments_author -->';

	echo '</div><!-- colors_comments -->';


	echo '<div id="colors_footer" class="inside ppp_tab_inside" style="display:none;">';
	echo '<table><tbody>';

	echo '<tr><td>Footer background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_footer_bg_color" id="cp_footer_bg_color" type="text" value="'.($this->options["footer_bg_color"] != '' ? $this->options["footer_bg_color"] : $this->options["content_bg_color"]).'" />';
	echo '</td></tr>';

	echo '<tr><td>Footer titles: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_footer_h1_color" id="cp_footer_h1_color" type="text" value="'.$this->options["footer_h1_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Footer text: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_footer_color" id="cp_footer_color" type="text" value="'.$this->options["footer_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Footer links: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_footer_link_color" id="cp_footer_link_color" type="text" value="'.$this->options["footer_link_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Footer link background hover: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_footer_link_bg_hover" id="cp_footer_link_bg_hover" type="text" value="'.$this->options["footer_link_bg_hover"].'" />';
	echo '</td></tr>';

	ppp_opt_border('Footer item border:', 'border_footitem', $this->options);

	echo '</tbody></table>';
	echo '</div><!-- colors_footer -->';


	echo '<div id="colors_about" class="inside ppp_tab_inside" style="display:none;">';
	echo '<table><tbody>';

	echo '<tr><td>Background: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_about_bg_color" id="cp_about_bg_color" type="text" value="'.$this->options["about_bg_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Text: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_about_color" id="cp_about_color" type="text" value="'.$this->options["about_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td>Links: ';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_about_link_color" id="cp_about_link_color" type="text" value="'.$this->options["about_link_color"].'" />';
	echo '</td></tr>';

	ppp_opt_border('Border: ', 'border_about', $this->options);

	echo '</tbody></table>';
	echo '</div><!-- colors_footer -->';

	echo '</div><!-- colorsdiv -->';


	/* LAYOUT */

	echo '<div id="layoutdiv" class="ppp_panel_inner" style="display:none;">';
	echo '<h3>Layout</h3>';

	/* Tabbed layout panels*/
	echo '<div id="ppp_layout_tab" class="ppp_panel_tabs"><ul class="idTabs">
	<li><a href="#layout_body">Body</a></li>
	<li><a href="#layout_hdr">Header</a></li>
	<li><a href="#layout_timestamp">Timestamp</a></li>
	<li><a href="#layout_menu">Menu</a></li>
	<li><a href="#layout_comments">Comments</a></li>
	<li><a href="#layout_about">About Me</a></li>
	</ul></div>';
	
	echo '<div id="layout_body" class="inside ppp_tab_inside" style="display:block;">';
	echo '<h4>Borders</h4>';
	echo '<div class="inside">';
	echo '<table><tbody>';

	ppp_opt_border('Header top border', 'border_header_top', $this->options);

	ppp_opt_border('Footer bottom border', 'border_footer_bottom', $this->options);

	echo '<tr><td><label for="cp_side_border_img">Use default &quot;drop shadow&quot;<br /> image on the side border?</label>';
	echo '</td><td><input type="checkbox" name="cp_side_border_img" id="cp_side_border_img"'.($this->options["side_border_img"] == 1 ? ' checked="checked"' : '').' />';
	echo '</td></tr>';
	echo '</tbody></table>';
	echo '</div><!-- inside -->';

	echo '<h4>Whitespace (margins)</h4>';
	echo '<div class="inside">';
	echo '<table><tbody>';

	echo '<tr><td>Whitespace above header: ';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_hdr_margin" id="cp_hdr_margin" type="text" value="'.$this->options["hdr_margin"].'" /> pixels';
	echo '</td></tr>';

	echo '<tr><td>Whitespace below footer: ';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_ftr_margin" id="cp_ftr_margin" type="text" value="'.$this->options["ftr_margin"].'" /> pixels';
	echo '</td></tr>';

	echo '</tbody></table>';
	echo '</div><!-- inside -->';

	echo '</div><!-- layout_body -->';


	echo '<div id="layout_hdr" class="inside ppp_tab_inside" style="display:block;">';

	echo '<p>Configure your header with a custom header image, a slideshow, or both.<br />
	<small>The built-in slideshow is configured on the Header Slideshow page. Custom Header image setup is in the Appearance menu, and Flashfader is in the Posts menu (if installed).</small></p>';
	echo '<table><tbody>';
	echo '<tr><td>Choose:';


	echo '</td><td><select name="cp_header_img_flash" id="cp_header_img_flash">
<option onclick="toggleOff(\'header_layout_div\'); toggleOff(\'header_img_height_div\')" value="js" '.($this->options["header_img_flash"] == 'js' ? ' selected="selected"' : '').'>Simple Slideshow</option>
<option onclick="toggleOff(\'header_layout_div\'); toggleOn(\'header_img_height_div\')" value="img" '.($this->options["header_img_flash"] == 'img' ? ' selected="selected"' : '').'>Custom Header</option>
<option onclick="toggleOff(\'header_layout_div\'); toggleOff(\'header_img_height_div\')" value="flash" '.($this->options["header_img_flash"] == 'flash' ? ' selected="selected"' : '').'>Flashfader</option>
<option onclick="toggleOn(\'header_layout_div\'); toggleOn(\'header_img_height_div\')" value="img_js" '.($this->options["header_img_flash"] == 'img_js' ? ' selected="selected"' : '').'>Custom Header + Slideshow</option>
<option onclick="toggleOn(\'header_layout_div\'); toggleOn(\'header_img_height_div\')" value="img_flash" '.($this->options["header_img_flash"] == 'img_flash' ? ' selected="selected"' : '').'>Custom Header + Flashfader</option>
</select>';

	echo '</td></tr>';
	echo '</tbody></table>';


	$hdr_lay_disp = 'display:none;';
	if ($this->options["header_img_flash"] == 'img_js' || $this->options["header_img_flash"] == 'img_flash') {
		$hdr_lay_disp = '';
	}
	echo '<div id="header_layout_div" class="inside" style="'.$hdr_lay_disp.'">';
	echo '<p>Choose the layout of your header.<br />
	<small>If you choose to show the logo image on the left or right, your header image should be <strong>328 </strong>pixels wide, and your slideshow images <strong>656 </strong>pixels wide. Otherwise all header images should be <strong>984 </strong>pixels wide.</small></p>';
	echo '<table><tbody>';
	echo '<tr><td>Choose:';
	echo '</td><td><select name="cp_header_layout" id="cp_header_layout">
<option onclick="toggleOn(\'header_img_height_div\')" value="t" '.($this->options["header_layout"] == 't' ? ' selected="selected"' : '').'>Image on Top</option>
<option onclick="toggleOn(\'header_img_height_div\')" value="b" '.($this->options["header_layout"] == 'b' ? ' selected="selected"' : '').'>Image on Bottom</option>
<option onclick="toggleOff(\'header_img_height_div\')" value="l" '.($this->options["header_layout"] == 'l' ? ' selected="selected"' : '').'>Image on Left</option>
<option onclick="toggleOff(\'header_img_height_div\')" value="r" '.($this->options["header_layout"] == 'r' ? ' selected="selected"' : '').'>Image on Right</option>
</select>';
	echo '</td></tr>';
	echo '</tbody></table>';
	echo '</div><!-- inside -->';


	$hdr_h_disp = 'display:none;';
	if ($this->options["header_img_flash"] == 'img' || 
		($this->options["header_layout"] == 't' || $this->options["header_layout"] == 'b') && ($this->options["header_img_flash"] == 'img_js' || $this->options["header_img_flash"] == 'img_flash')) {
		$hdr_h_disp = '';
	}
	echo '<div class="inside" id="header_img_height_div" style="'.$hdr_h_disp.'">';
	echo '<p>Enter the height of your header image. Default is 250 pixels.</p>';
	echo '<table><tbody>';

	echo '<tr><td>Height: ';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_header_img_h" id="cp_header_img_h" type="text" value="'.$this->options["header_img_h"].'" /> pixels';
	echo '</td></tr>';
	echo '</tbody></table>';
	echo '</div><!-- inside -->';

	echo '</div><!-- layout_hdr -->';


	echo '<div id="layout_timestamp" class="inside ppp_tab_inside" style="display:block;">';

	echo '<p>Choose exactly what information to show beneath each post title, or after each post.</p>';

		echo '<h4>Subtitles</h4>';
		/*
    - Subtitles
      - author, date, time, cats, tags
		*/
		echo '
		<label class="labelCheckbox" for="cp_ts_sub_author">
		<input type="checkbox" name="cp_ts_sub_author" id="cp_ts_sub_author"'.($this->options[("ts_sub_author")] == 1 ? ' checked' : '').' class="crirHiddenJS" />Author</label>
		<label class="labelCheckbox" for="cp_ts_sub_date">
		<input type="checkbox" name="cp_ts_sub_date" id="cp_ts_sub_date"'.($this->options[("ts_sub_date")] == 1 ? ' checked' : '').' class="crirHiddenJS" />Date</label>
		<label class="labelCheckbox" for="cp_ts_sub_time">
		<input type="checkbox" name="cp_ts_sub_time" id="cp_ts_sub_time"'.($this->options[("ts_sub_time")] == 1 ? ' checked' : '').' class="crirHiddenJS" />Time</label>
		<label class="labelCheckbox" for="cp_ts_sub_cats">
		<input type="checkbox" name="cp_ts_sub_cats" id="cp_ts_sub_cats"'.($this->options[("ts_sub_cats")] == 1 ? ' checked' : '').' class="crirHiddenJS" />Categories</label>
		<label class="labelCheckbox" for="cp_ts_sub_tags">
		<input type="checkbox" name="cp_ts_sub_tags" id="cp_ts_sub_tags"'.($this->options[("ts_sub_tags")] == 1 ? ' checked' : '').' class="crirHiddenJS" />Tags</label>
		<br clear="all"/>
		<label class="labelCheckbox" for="cp_ts_sub_onpage">
		<input type="checkbox" name="cp_ts_sub_onpage" id="cp_ts_sub_onpage"'.($this->options[("ts_sub_onpage")] == 1 ? ' checked' : '').' class="crirHiddenJS" />Show on Pages?</label>
		<br clear="all"/>';

		echo '<h4>After Post</h4>';
		/*
    - Post Footer
      - title, author, date, time, catgs, tags		
		*/
		echo '
		<label class="labelCheckbox" for="cp_ts_foot_title">
		<input type="checkbox" name="cp_ts_foot_title" id="cp_ts_foot_title"'.($this->options[("ts_foot_title")] == 1 ? ' checked' : '').' class="crirHiddenJS" />Title</label>
		<label class="labelCheckbox" for="cp_ts_foot_author">
		<input type="checkbox" name="cp_ts_foot_author" id="cp_ts_foot_author"'.($this->options[("ts_foot_author")] == 1 ? ' checked' : '').' class="crirHiddenJS" />Author</label>
		<label class="labelCheckbox" for="cp_ts_foot_date">
		<input type="checkbox" name="cp_ts_foot_date" id="cp_ts_foot_date"'.($this->options[("ts_foot_date")] == 1 ? ' checked' : '').' class="crirHiddenJS" />Date</label>
		<label class="labelCheckbox" for="cp_ts_foot_time">
		<input type="checkbox" name="cp_ts_foot_time" id="cp_ts_foot_time"'.($this->options[("ts_foot_time")] == 1 ? ' checked' : '').' class="crirHiddenJS" />Time</label>
		<label class="labelCheckbox" for="cp_ts_foot_cats">
		<input type="checkbox" name="cp_ts_foot_cats" id="cp_ts_foot_cats"'.($this->options[("ts_foot_cats")] == 1 ? ' checked' : '').' class="crirHiddenJS" />Categories</label>
		<label class="labelCheckbox" for="cp_ts_foot_tags">
		<input type="checkbox" name="cp_ts_foot_tags" id="cp_ts_foot_tags"'.($this->options[("ts_foot_tags")] == 1 ? ' checked' : '').' class="crirHiddenJS" />Tags</label>
		<br clear="all"/>
		<label class="labelCheckbox" for="cp_ts_foot_onpage">
		<input type="checkbox" name="cp_ts_foot_onpage" id="cp_ts_foot_onpage"'.($this->options[("ts_foot_onpage")] == 1 ? ' checked' : '').' class="crirHiddenJS" />Show on Pages?</label>
		<br clear="all"/>';
	echo '</div><!-- layout_timestamp -->';


	echo '<div id="layout_menu" class="inside ppp_tab_inside" style="display:block;">';

		echo '<p>The navigation menu is widget-ready. To change your menu items, go to the <a href="widgets.php">Widgets page</a> and drag some widgets from the left side into the box on the right side called &quot;Drop down Menu&quot;.  Each widget will make a new menu item.  Keep in mind that adding just 1 widget will totally remove the default menu items, so you&rsquo;ll probably want to add more than one.</p>';
	
		echo '<table><tbody>';
	
		echo '<tr><td>Menu height: ';
		echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_menu_height" id="cp_menu_height" type="text" value="'.$this->options["menu_height"].'" /> pixels';
		echo '</td></tr>';

		echo '<tr><td colspan="2"><h4>Placement</h4>';
		echo '</td></tr>';

		echo '<tr><td>Placement:';
		echo '</td><td><select name="cp_menu_place" id="cp_menu_place">
	<option value="top" '.($this->options["menu_place"] == 'top' ? ' selected="selected"' : '').'>Top</option>';
	echo '<option value="bottom" '.(($this->options["menu_place"] == '' || $this->options["menu_place"] == 'bottom') ? ' selected="selected"' : '').'>Below Header</option>';
	echo '<option value="inbetween" '.($this->options["menu_place"] == 'inbetween' ? ' selected="selected"' : '').'>Between Header Image and Slideshow</option>';
	echo '</select>';
		echo '</td></tr>';
	
		echo '<tr><td>Alignment:';
		echo '</td><td><select name="cp_menu_align" id="cp_menu_align">
	<option value="right_w_link" '.(($this->options["menu_align"] == 'right_w_link' || $this->options["menu_align"] == '') ? ' selected="selected"' : '').'>Right-aligned with left Home link</option>
	<option value="left" '.($this->options["menu_align"] == 'left' ? ' selected="selected"' : '').'>Left</option>
	<option value="center" '.($this->options["menu_align"] == 'center' ? ' selected="selected"' : '').'>Center</option>
	<option value="right" '.($this->options["menu_align"] == 'right' ? ' selected="selected"' : '').'>Right</option>
	</select>';
		echo '</td></tr>';
	
		echo '<tr><td colspan="2"><h4>Separator between menu items</h4>';
		echo '</td></tr>';
		echo '<tr><td class="sublevel">Choose a character:</td>';
		echo '<td><select name="cp_menu_separator" id="cp_menu_separator">
	<option value="" '.($this->options["menu_separator"] == '' ? ' selected="selected"' : '').'></option>
	<option value="bullet" '.($this->options["menu_separator"] == 'bullet' ? ' selected="selected"' : '').'>&bull;</option>
	<option value="bullet_s" '.($this->options["menu_separator"] == 'bullet_s' ? ' selected="selected"' : '').'>&middot;</option>
	<option value="dash" '.($this->options["menu_separator"] == 'dash' ? ' selected="selected"' : '').'>&mdash;</option>
	<option value="-" '.($this->options["menu_separator"] == '-' ? ' selected="selected"' : '').'>-</option>
	<option value=":" '.($this->options["menu_separator"] == ':' ? ' selected="selected"' : '').'>:</option>
	<option value="|" '.($this->options["menu_separator"] == '|' ? ' selected="selected"' : '').'>|</option>
	</select></td></tr>';
		echo '<tr><td class="sublevel">Or, ';
		if ($this->options["img_sep"] == "") {
			echo 'upload an image:<br /><small>(less than 18px tall is best)</small></td>';
		} else {
			echo 'use this image:</td><td>';
			echo ppp_get_cp_img($uploadsDirectory, $this->options["img_fn_sep"], $this->options["img_sep"], "Menu separator image", "", "sep");
			echo '<tr><td colspan="2">
<span class="submit inline_submit"><input type="submit" value="Delete &raquo;" name="cp_delete_img_sep" /></span>
<span style="font-size:80%; color:#999999;">(<label for="cp_display_image_sep">Display image instead of character?</label><input type="checkbox" name="cp_display_image_sep" id="cp_display_image_sep"'.($this->options["display_image_sep"] == 1 ? ' checked="checked"' : '').' />)</span>
			</td>';

			echo '<tr><td class="sublevel">Or, upload a new image: </td>';
		}
		echo '<td><input id="cp_upload_image_sep" type="file" name="cp_upload_image_sep" /> <span class="submit inline_submit"><input type="submit" value="Upload" name="cp_upload_image_submit_sep" /></span>';
		echo '</td></tr>';
		echo '</tbody></table>';
	echo '</div><!-- layout_menu -->';


	echo '<div id="layout_comments" class="inside ppp_tab_inside" style="display:block;">';

		echo '<p><small>Note: If you use the AJAXedWordPress plugin for inline comments, some of these settings may not work.</small></p>';

		echo '<table><tbody>';
		echo '<tr><td>Layout:';
		echo '</td><td><select style="width: 208px" name="cp_comment_form_placement" id="cp_comment_form_placement">
	<option onclick="toggleOn(\'comment_form_tr\')" value="below" '.($this->options["comment_form_placement"] == 'below' ? ' selected="selected"' : '').'>Comments on Top, Form Below</option>
	<option onclick="toggleOff(\'comment_form_tr\')" value="left" '.($this->options["comment_form_placement"] == 'left' ? ' selected="selected"' : '').'>Comment Form on Left</option>
	<option onclick="toggleOff(\'comment_form_tr\')" value="right" '.($this->options["comment_form_placement"] == 'right' ? ' selected="selected"' : '').'>Comment Form on Right</option>
	</select>';
		echo '</td></tr>';
		echo '</tbody></table>';

		echo '<label for="cp_comments_inline"><input onclick="toggle(\'inline_comments_opt\')" type="checkbox" name="cp_comments_inline" id="cp_comments_inline"'.($this->options["comments_inline"] == 1 ? ' checked="checked"' : '').' /> Display inline comments on home page?</label> <small>(Leave unchecked to use AjaxedWP comments.)</small><br />';

		$inline_comment_opt_disp = '';
		if ($this->options["comments_inline"] != 1) {
			$inline_comment_opt_disp = 'display:none;';
		}
		echo '<div id="inline_comments_opt" style="'.$inline_comment_opt_disp.'">';
		echo '<table><tbody>';
		echo '<tr><td style="width:162px;">Show or hide comments: ';
		echo '</td><td><select style="width:200px;" name="cp_comments_open" id="cp_comments_open">
	<option value="always" '.($this->options["comments_open"] == 'always' ? ' selected="selected"' : '').'>Show Always</option>
	<option value="hidden" '.($this->options["comments_open"] == 'hidden' ? ' selected="selected"' : '').'>Click to Show Comments</option>
	<option value="show" '.($this->options["comments_open"] == 'show' ? ' selected="selected"' : '').'>Click to Hide Comments</option>
	</select>';
		echo '</td></tr>';
	
		$comment_form_tr_disp = '';
		if ($this->options["comment_form_placement"] != '' && $this->options["comment_form_placement"] != 'below') {
			$comment_form_tr_disp = 'display:none;';
		}
		echo '<tr id="comment_form_tr" style="'.$comment_form_tr_disp.'"><td>Show/hide comment form: ';
		echo '</td><td><select style="width: 200px" name="cp_comments_add_open" id="cp_comments_add_open">
	<option value="always" '.($this->options["comments_add_open"] == 'always' ? ' selected="selected"' : '').'>Show Always</option>
	<option value="hidden" '.($this->options["comments_add_open"] == 'hidden' ? ' selected="selected"' : '').'>Click to Show Comment Form</option>
	<option value="show" '.($this->options["comments_add_open"] == 'show' ? ' selected="selected"' : '').'>Click to Hide Comment Form</option>
	</select>';
		echo '</td></tr>';
		echo '</tbody></table>';
		echo '</div>';


		echo '<h4>Comment Box</h4>';

		echo 'Comment box height: ';
		echo '<label for="cp_comments_height"><input class="widefat" style="text-align: right; width: 65px" name="cp_comments_height" id="cp_comments_height" type="text" value="'.$this->options["comments_height"].'" /> pixels </label><br />';

		echo '<label for="cp_comments_show_avatar"><input type="checkbox" name="cp_comments_show_avatar" id="cp_comments_show_avatar"'.($this->options["comments_show_avatar"] == 1 ? ' checked="checked"' : '').' /> Display avatar?</label><br />';
		echo '<label for="cp_comments_hide_default_avatar"><input type="checkbox" name="cp_comments_hide_default_avatar" id="cp_comments_hide_default_avatar"'.($this->options["comments_hide_default_avatar"] == 1 ? ' checked="checked"' : '').' /> - Hide default avatar? (overrides WP settings)</label><br />';


		echo '<h4>Comment Form</h4>';

		echo '<table><tbody>';
	
		echo '<tr><td>Comment form height: ';
		echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_comment_form_height" id="cp_comment_form_height" type="text" value="'.$this->options["comment_form_height"].'" /> pixels';
		echo '</td></tr>';
	
		echo '</tbody></table>';
	
		echo '<label for="cp_comments_name"><input type="checkbox" name="cp_comments_name" id="cp_comments_name"'.($this->options["comments_name"] == 1 ? ' checked="checked"' : '').(get_option('require_name_email') == 1 ? ' disabled="disabled"' : '').' /> Show name field?</label><br />';
		echo '<label for="cp_comments_email"><input type="checkbox" name="cp_comments_email" id="cp_comments_email"'.($this->options["comments_email"] == 1 ? ' checked="checked"' : '').(get_option('require_name_email') == 1 ? ' disabled="disabled"' : '').' /> Show email field?</label><br />';
		echo '<label for="cp_comments_www"><input type="checkbox" name="cp_comments_www" id="cp_comments_www"'.($this->options["comments_www"] == 1 ? ' checked="checked"' : '').' /> Show website field?</label><br />';
	

	echo '</div><!-- layout_comments -->';


	echo '<div id="layout_about" class="inside ppp_tab_inside" style="display:block;">';

		echo '<h4>Placement</h4>';
		echo '<p>Where would you like to see your &quot;About '.get_bloginfo('name').'&quot; box?</p>';
		echo '<label class="labelCheckbox" for="bio_placement_hidden" >
		<input name="cp_bio_placement" id="bio_placement_hidden" type="radio" class="crirHiddenJS" value="" '.($this->options["bio_placement"] == '' ? ' checked="checked"' : '').' />Not Displayed</label>
		
		<label class="labelCheckbox" for="bio_placement_below_hdr" >
		<input name="cp_bio_placement" id="bio_placement_below_hdr" type="radio" class="crirHiddenJS" value="below_hdr" '.($this->options["bio_placement"] == 'below_hdr' ? ' checked="checked"' : '').' />Before Posts on Home Page</label>
		
		<label class="labelCheckbox" for="bio_placement_above_ftr" >
		<input name="cp_bio_placement" id="bio_placement_above_ftr" type="radio" class="crirHiddenJS" value="above_ftr" '.($this->options["bio_placement"] == 'above_ftr' ? ' checked="checked"' : '').' />Footer Top</label>
		
		<label class="labelCheckbox" for="bio_placement_below_ftr" >
		<input name="cp_bio_placement" id="bio_placement_below_ftr" type="radio" class="crirHiddenJS" value="below_ftr" '.($this->options["bio_placement"] == 'below_ftr' ? ' checked="checked"' : '').' />Footer Bottom</label>
		<br clear="all" />';

		echo '<h4>&quot;About Me&quot; Text</h4>';

		echo '<p>Enter a title.</p>';
		echo '<input class="widefat" name="cp_about_title" id="cp_about_title" type="text" value="'.$this->options["about_title"].'" />';

		echo '<p>Enter a few lines of text to describe yourself. Basic <a href="http://www.w3schools.com/tags/default.asp" target="_blank">HTML</a> is allowed.</p>';
		echo '<textarea class="widefat" name="cp_about_text" id="cp_about_text" rows="8" cols="60">'.htmlspecialchars($this->options["about_text"]).'</textarea>';

	echo '</div><!-- layout_about -->';

	echo '</div><!-- layoutdiv -->';



	/* FONTS */


	echo '<div id="fontsdiv" class="ppp_panel_inner" style="display:none;">';
	echo '<h3>Fonts</h3>';

	echo '<p>Take control of your typography.</p>';

	/* CSS FONTS */

	echo '<style type="text/css"><!--';
	$font_css_h1_c=ppp_fontface('h1', 0);
	$font_css_sub_c=ppp_fontface('sub', 0);
	$font_css_content_c=ppp_fontface('content', 0);
	$font_css_menu_c=ppp_fontface('menu', 0);
	$font_css_footer_c=ppp_fontface('footer', 0);
	echo '--></style>';

	/* tabs */

	echo '<div id="ppp_fonts_tab" class="ppp_panel_tabs"><ul class="idTabs">
	<li><a href="#fonts_title">Post Titles</a></li>
	<li><a href="#fonts_subtitle">Subtitles</a></li>
	<li><a href="#fonts_menu">Menu</a></li>
	<li><a href="#fonts_content">Content Text</a></li>
	<li><a href="#fonts_footer">Footer</a></li>
	</ul></div>';

	echo '<div id="fonts_title" class="inside ppp_tab_inside">';
	echo '<table><tbody>';

	ppp_opt_fonts("h1", $this->options, $font_css_h1_c);

	echo '</tbody></table>';
	echo '</div><!-- fonts_title inside -->';


	echo '<div id="fonts_subtitle" class="inside ppp_tab_inside">';
	echo '<table><tbody>';

	ppp_opt_fonts("sub", $this->options, $font_css_sub_c);

	echo '</tbody></table>';
	echo '</div><!-- fonts_subtitle inside -->';


	echo '<div id="fonts_menu" class="inside ppp_tab_inside">';
	echo '<table><tbody>';

	ppp_opt_fonts("menu", $this->options, $font_css_menu_c);

	echo '</tbody></table>';
	echo '</div><!-- fonts_menu inside -->';


	echo '<div id="fonts_content" class="inside ppp_tab_inside">';
	echo '<table><tbody>';

	ppp_opt_fonts("content", $this->options, $font_css_content_c);

	echo '</tbody></table>';
	echo '</div><!-- fonts_content inside -->';

	echo '<div id="fonts_footer" class="inside ppp_tab_inside">';
	echo '<table><tbody>';

	ppp_opt_fonts("footer", $this->options, $font_css_footer_c);

	echo '</tbody></table>';
	echo '</div><!-- fonts_footer inside -->';

	echo '</div><!-- fontsdiv -->';



	/* IMAGES*/


	echo '<div id="imagesdiv" class="ppp_panel_inner" style="display:none;">';
	echo '<h3>Images</h3>';

	/* Image tabs */
	echo '<div id="ppp_images_tab" class="ppp_panel_tabs"><ul class="idTabs">
	<li><a href="#images_bg">Background</a></li>
	<li><a href="#images_bio">Bio</a></li>
	<li><a href="#images_img">Post Images</a></li>
	<li><a href="#images_thumb">Post Thumbnail</a></li>
	<li><a href="#images_break">Post Break</a></li>
	</ul></div>';

	echo '<div id="images_bg" class="inside ppp_tab_inside" style="display:block;">';
	echo '<table><tbody>';

	echo '<tr><td>Alignment:';
	echo '</td><td><select name="cp_bg_img_align" id="cp_bg_img_align">
<option value="left" '.($this->options["bg_img_align"] == 'left' ? ' selected="selected"' : '').'>Left</option>
<option value="center" '.($this->options["bg_img_align"] == 'center' ? ' selected="selected"' : '').'>Center</option>
<option value="right" '.($this->options["bg_img_align"] == 'right' ? ' selected="selected"' : '').'>Right</option>
</select>';
	echo '</td></tr>';

	echo '<tr><td>Vertical alignment:';
	echo '</td><td><select name="cp_bg_img_valign" id="cp_bg_img_valign">
<option value="top" '.($this->options["bg_img_valign"] == 'top' ? ' selected="selected"' : '').'>Top</option>
<option value="bottom" '.($this->options["bg_img_valign"] == 'bottom' ? ' selected="selected"' : '').'>Bottom</option>
</select>';
	echo '</td></tr>';

	echo '<tr><td>Repeat?';
	echo '</td><td><select name="cp_bg_img_repeat" id="cp_bg_img_repeat">
<option value="repeat" '.($this->options["bg_img_repeat"] == 'repeat' ? ' selected="selected"' : '').'>Repeat All</option>
<option value="repeat-x" '.($this->options["bg_img_repeat"] == 'repeat-x' ? ' selected="selected"' : '').'>Repeat Horizontal</option>
<option value="repeat-y" '.($this->options["bg_img_repeat"] == 'repeat-y' ? ' selected="selected"' : '').'>Repeat Vertical</option>
<option value="no-repeat" '.($this->options["bg_img_repeat"] == 'no-repeat' ? ' selected="selected"' : '').'>No Repeat</option>
</select>';
	echo '</td></tr>';

	echo '<tr><td><label for="cp_bg_img_fixed">Fixed?</label>';
	echo '</td><td><input type="checkbox" name="cp_bg_img_fixed" id="cp_bg_img_fixed"'.($this->options["bg_img_fixed"] == 1 ? ' checked="checked"' : '').' />';
	echo '</td></tr>';


	echo '<tr><td>Upload';
	echo '</td><td><input id="cp_upload_image_bg" type="file" name="cp_upload_image_bg" /> <span class="submit inline_submit"><input type="submit" value="Upload" name="cp_upload_image_submit_bg" />';

	if ($this->options["img_fn_bg"] == "") {
		echo '</span></td></tr>';
	} else {
		echo ' <input type="submit" value="Delete &raquo;" name="cp_delete_img_bg" /></span></td></tr>';

		echo '<tr><td>';
		echo '</td><td><label for="cp_display_image_bg">Display image? <input type="checkbox" name="cp_display_image_bg" id="cp_display_image_bg"'.($this->options["display_image_bg"] == 1 ? ' checked="checked"' : '').' /></label> <br />';
		echo ppp_get_cp_img($uploadsDirectory, $this->options["img_fn_bg"], $this->options["img_bg"], "Background image", "436", "bg");
		echo '</td></tr>';
	}

	echo '</tbody></table>';
	echo '</div><!-- images_bg -->';


	echo '<div id="images_bio" class="inside ppp_tab_inside" style="display:block;">';
	echo '<table><tbody>';

	echo '<tr><td>Alignment:';
	echo '</td><td><select name="cp_bio_img_align" id="cp_bio_img_align">
<option value="left" '.($this->options["bio_img_align"] == 'left' ? ' selected="selected"' : '').'>Left</option>
<option value="right" '.($this->options["bio_img_align"] == 'right' ? ' selected="selected"' : '').'>Right</option>
</select>';
	echo '</td></tr>';

	echo '<tr><td>Upload an image:';
	echo '</td><td><input id="cp_upload_image_bio" type="file" name="cp_upload_image_bio" /> <span class="submit inline_submit"><input type="submit" value="Upload" name="cp_upload_image_submit_bio" />';

	if ($this->options["img_fn_bio"] == "") {
		echo '</span></td></tr>';
	} else {
		echo ' <input type="submit" value="Delete &raquo;" name="cp_delete_img_bio" /></span></td></tr>';

		echo '<tr><td>';
		echo '</td><td><label for="cp_display_image_bio">Display image? </label><input type="checkbox" name="cp_display_image_bio" id="cp_display_image_bio"'.($this->options["display_image_bio"] == 1 ? ' checked="checked"' : '').' /> <br />';
		echo ppp_get_cp_img($uploadsDirectory, $this->options["img_fn_bio"], $this->options["img_bio"], "Bio image", "436", "bio");
		echo '</td></tr>';
	}


	echo '</tbody></table>';
	echo '</div><!-- images_bio -->';


	echo '<div id="images_img" class="inside ppp_tab_inside" style="display:block;">';
	echo '<table><tbody>';

	echo '<tr><td>Align images in posts:';
	echo '</td><td><select name="cp_post_img_align" id="cp_post_img_align">
<option value="left" '.($this->options["post_img_align"] == 'left' ? ' selected="selected"' : '').'>Left</option>
<option value="center" '.($this->options["post_img_align"] == 'center' ? ' selected="selected"' : '').'>Center</option>
<option value="right" '.($this->options["post_img_align"] == 'right' ? ' selected="selected"' : '').'>Right</option>
</select>';
	echo '</td></tr>';

	echo '<tr><td>Border around images:</td>
	      <td><a id="toggle_border_note" class="tgl"><small>note &raquo;</small></a>';
	echo '</td></tr>';
	echo '<tr><td colspan="2"><div id="border_note" class="note" style="display:none"><small>If you post full-size 960 pixel wide images and use a border,
	                     the image will be resized in the browser to accommodate the border.
						 For example, if you choose a 3-pixel border, your image will be resized
						 to 954 pixels wide, to allow 3 pixels on each side for the border.</small></div>';
	echo '</td></tr>';

	echo '<tr><td class="sublevel">Size (pixels):';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_post_img_border_size" id="cp_post_img_border_size" type="text" value="'.$this->options["post_img_border_size"].'" />';
	echo '</td></tr>';

	echo '<tr><td class="sublevel">Color:';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_post_img_border_color" id="cp_post_img_border_color" type="text" value="'.$this->options["post_img_border_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td class="sublevel">Style:';
	echo '</td><td><select name="cp_post_img_border_style" id="post_img_border_style">
<option value="" '.($this->options["post_img_border_style"] == '' ? ' selected="selected"' : '').'></option>
<option value="solid" '.($this->options["post_img_border_style"] == 'solid' ? ' selected="selected"' : '').'>Solid</option>
<option value="dotted" '.($this->options["post_img_border_style"] == 'dotted' ? ' selected="selected"' : '').'>Dotted</option>
<option value="dashed" '.($this->options["post_img_border_style"] == 'dashed' ? ' selected="selected"' : '').'>Dashed</option>
</select>';
	echo '</td></tr>';

	echo '</tbody></table>';
	echo '</div><!-- images_img -->';


		/* Post thumbnails */

	echo '<div id="images_thumb" class="inside ppp_tab_inside" style="display:block;">';
	echo '<table><tbody>';

	echo '<tr><td>Alignment:';
	echo '</td><td><select name="cp_img_thumb_align" id="cp_img_thumb_align">
<option value="left" '.($this->options["img_thumb_align"] == 'left' ? ' selected="selected"' : '').'>Left</option>
<option value="right" '.($this->options["img_thumb_align"] == 'right' ? ' selected="selected"' : '').'>Right</option>
</select>';
	echo '</td></tr>';

	echo '<tr><td>Upload an image:';
	echo '</td><td><input id="cp_upload_image_thumb" type="file" name="cp_upload_image_thumb" /> <span class="submit inline_submit"><input type="submit" value="Upload" name="cp_upload_image_submit_thumb" />';

	if ($this->options["img_fn_thumb"] == "") {
		echo '</span></td></tr>';
	} else {
		echo ' <input type="submit" value="Delete &raquo;" name="cp_delete_img_thumb" /></span></td></tr>';

		echo '<tr><td>';
		echo '</td><td><label for="cp_display_image_thumb">Display image? </label><input type="checkbox" name="cp_display_image_thumb" id="cp_display_image_thumb"'.($this->options["display_image_thumb"] == 1 ? ' checked="checked"' : '').' /> <br />';
		echo ppp_get_cp_img($uploadsDirectory, $this->options["img_fn_thumb"], $this->options["img_thumb"], "Post Thumbnail image", "436", "thumb");
		echo '</td></tr>';

		echo '<tr><td class="sublevel">Height:';
		echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_thumb_image_height" id="cp_thumb_image_height" type="text" value="'.$this->options["thumb_image_height"].'" /> pixels';
		echo '</td></tr>';

		echo '<tr><td class="sublevel">Width:';
		echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_thumb_image_width" id="cp_thumb_image_width" type="text" value="'.$this->options["thumb_image_width"].'" /> pixels';
		echo '</td></tr>';
	}


	echo '</tbody></table>';
	echo '</div><!-- images_thumb -->';



		/* Post break */

	echo '<div id="images_break" class="inside ppp_tab_inside" style="display:block;">';
	echo '<table><tbody>';

	echo '<tr><td>Upload an image:<br /><small>(984 pixels wide or less)</small>';
	echo '</td><td><input id="cp_upload_image_pb" type="file" name="cp_upload_image_pb" /> <span class="submit inline_submit"><input type="submit" value="Upload" name="cp_upload_image_submit_pb" />';

	if ($this->options["img_fn_pb"] == "") {
		echo '</span></td></tr>';
	} else {
		echo ' <input type="submit" value="Delete &raquo;" name="cp_delete_img_pb" /></span></td></tr>';

		echo '<tr><td>';
		echo '</td><td><label for="cp_display_image_pb">Display image? </label><input type="checkbox" name="cp_display_image_pb" id="cp_display_image_pb"'.($this->options["display_image_pb"] == 1 ? ' checked="checked"' : '').' /> <br />';
		echo ppp_get_cp_img($uploadsDirectory, $this->options["img_fn_pb"], $this->options["img_pb"], "Postbreak image", "436", "pb");
		echo '</td></tr>';
	}

	echo '<tr><td>Or, choose a horizontal line:';
	echo '</td></tr>';

	echo '<tr><td class="sublevel">Size (pixels):';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_pb_border_size" id="cp_pb_border_size" type="text" value="'.$this->options["pb_border_size"].'" />';
	echo '</td></tr>';

	echo '<tr><td class="sublevel">Color:';
	echo '</td><td><input class="widefat color" style="text-align: right; width: 65px" name="cp_pb_border_color" id="cp_pb_border_color" type="text" value="'.$this->options["pb_border_color"].'" />';
	echo '</td></tr>';

	echo '<tr><td class="sublevel">Style:';
	echo '</td><td><select name="cp_pb_border_style" id="pb_border_style">
<option value="" '.($this->options["pb_border_style"] == '' ? ' selected="selected"' : '').'></option>
<option value="solid" '.($this->options["pb_border_style"] == 'solid' ? ' selected="selected"' : '').'>Solid</option>
<option value="dotted" '.($this->options["pb_border_style"] == 'dotted' ? ' selected="selected"' : '').'>Dotted</option>
<option value="dashed" '.($this->options["pb_border_style"] == 'dashed' ? ' selected="selected"' : '').'>Dashed</option>
</select>';
	echo '</td></tr>';

	echo '</tbody></table>';
	echo '</div><!-- images_break -->';

	echo '</div><!-- imagesdiv -->';


	/* HEADER */

	echo '<div id="headerdiv" class="ppp_panel_inner" style="display:none;">';

	/* HEADER SLIDESHOW */

	echo '<div id="slidediv">';
	echo '<h3>Header Slideshow</h3>';
	echo '<div class="inside">';


	$h_img_w = "984";
	if ($this->options["header_img_flash"] == 'img_js' || $this->options["header_img_flash"] == 'img_flash') {
	  if ($this->options["header_layout"] == "l" || $this->options["header_layout"] == "r") {
		$h_img_w = "656";
	  }
	}
	echo '<p>Upload images and configure your header slideshow. Images must be exactly <strong>'.$h_img_w.'</strong> pixels wide and the height you enter below. Each image will display for the number of "display" seconds, and the transition between images is controlled by the "fade" seconds.</p>';

	echo '<table><tbody>';

	echo '<tr><td>Header height: ';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_header_img_height" id="cp_header_img_height" type="text" value="'.($this->options["header_img_height"] == '' ? $this->default_settings["header_img_height"] : $this->options["header_img_height"]).'" /> pixels';
	echo '</td></tr>';

	echo '<tr><td>How many seconds to <strong>display</strong> each image? ';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_header_img_time_disp" id="cp_header_img_time_disp" type="text" value="'.($this->options["header_img_time_disp"] == '' ? $this->default_settings["header_img_time_disp"] : $this->options["header_img_time_disp"]).'" /> seconds';
	echo '</td></tr>';

	echo '<tr><td>How many seconds to <strong>fade</strong> between images? ';
	echo '</td><td><input class="widefat" style="text-align: right; width: 65px" name="cp_header_img_time_fade" id="cp_header_img_time_fade" type="text" value="'.($this->options["header_img_time_fade"] == '' ? $this->default_settings["header_img_time_fade"] : $this->options["header_img_time_fade"]).'" /> seconds';
	echo '</td></tr>';

	echo '<tr><td><label for="cp_header_img_rnd">Display images in random order? </label>';
	echo '</td><td><input type="checkbox" name="cp_header_img_rnd" id="cp_header_img_rnd"'.($this->options["header_img_rnd"] == 1 ? ' checked="checked"' : '').' />';
	echo '</td></tr>';
	echo '</tbody></table>';

	echo '<h4>Slideshow Images</h4>';
	echo '<p>Note: When changing the sequence of images, make sure you update each image number, or you may get unexpected results.</p>';


    $img_hdr_num = ($this->options["img_fn_hdr_num"] != '') ? intval($this->options["img_fn_hdr_num"]) : 1;
	$this->options["img_fn_hdr_num"] = $img_hdr_num;

	/* Make an array and sort it by the sequence number. */
	$ids = ppp_sort_header_ids($this->options, $img_hdr_num);

	$next_img_hdr_num = $img_hdr_num+1;

	echo '<table><tbody>';

	$valid_count=1;
	for ($i=1; $i<=$next_img_hdr_num; $i++) {

		/* if this is the last image slot, or an image exists, offer an upload. */
		if ($next_img_hdr_num == $i || $this->options["img_fn_hdr".$ids[$i]] != "") {
			echo '<tr><td colspan="2" style="background:#f1f1f1;padding-left:4px;">';
			if ($next_img_hdr_num == $i) {
				echo '# '.$valid_count;
				echo '<input type="hidden" value="'.$valid_count.'" id="cp_image_hdr_seq'.$i.'" name="cp_image_hdr_seq'.$i.'" />';
				echo ' <input id="cp_upload_image_hdr'.$i.'" type="file" name="cp_upload_image_hdr'.$i.'" />';
			} else {
				echo '# <input type="text" style="width:25px;" value="'.$valid_count.'" id="cp_image_hdr_seq'.$ids[$i].'" name="cp_image_hdr_seq'.$ids[$i].'" />';
				echo ' <input id="cp_upload_image_hdr'.$ids[$i].'" type="file" name="cp_upload_image_hdr'.$ids[$i].'" />';
			}
//debug
//			echo '# <input type="text" style="width:25px;" value="'.$i.','.$seqs[$ids[$i]].'" id="cp_image_hdr_seq'.$i.'" name="cp_image_hdr_seq'.$i.'" />';
			echo '<span class="submit inline_submit">';
		} 	

		if ($next_img_hdr_num == $i) {
			/* only show on the last one */
			echo '<input type="submit" value="Upload" name="cp_upload_image_submit_hdr'.$i.'" />';
			echo '</span></td></tr>';
		} else if ($this->options["img_fn_hdr".$ids[$i]] != "") {
			echo '<input type="submit" value="Upload New" name="cp_upload_image_submit_hdr'.$ids[$i].'" />';
			echo ' <input type="submit" value="Delete &raquo;" name="cp_delete_img_hdr'.$ids[$i].'" /></span>';
			echo '</td></tr>';
	
			/* Hidden checkbox - always true. */
			echo '<tr><td colspan="2"><input type="hidden" name="cp_display_image_hdr'.$ids[$i].'" id="cp_display_image_hdr'.$ids[$i].'" value="1" />';
			echo ppp_get_cp_img($uploadsDirectory, $this->options["img_fn_hdr".$ids[$i]], $this->options["img_hdr".$ids[$i]], "Header image ".$valid_count, "436", "hdr".$ids[$i]);
			echo '</td></tr>';

			$valid_count++;
		}
	}

	echo '</tbody></table>';

	/* Save next header number */
	echo '<input type="hidden" id="cp_img_fn_hdr_num" name="cp_img_fn_hdr_num" value="'.$next_img_hdr_num.'" />';

	echo '</div><!-- inside -->';
	echo '</div><!-- slidediv -->';

	echo '</div><!-- headerdiv -->';


	/* OTHER */

	echo '<div id="otherdiv" class="ppp_panel_inner" style="display:none;">';
	echo '<h3>Other Options</h3>';
	echo '<div class="inside">';

		/* KEYWORDS and STATS */

	echo '<table><tbody>';

	echo '<tr><td><input type="checkbox" name="cp_stop_thief" id="cp_stop_thief" '.($this->options["stop_thief"] == 1 ? ' checked="checked"' : '').' />';
	echo '</td><td><label for="cp_stop_thief"> Disable right-click functionality?</label>';
	echo '</td></tr>';

	echo '<tr><td></td><td><small>Enter the text to be displayed in the warning dialog box. Leave blank to suppress the warning box.</small>';
	echo '</td></tr>';

	echo '<tr><td></td><td><input class="widefat" style="width: 420px" name="cp_rt_clk_text" id="cp_rt_clk_text" type="text" value="'.$this->options["rt_clk_text"].'" />';
	echo '</td></tr>';

	echo '<tr><td><input type="checkbox" name="cp_add_favorites_link" id="cp_add_favorites_link" '.($this->options["add_favorites_link"] == 1 ? ' checked="checked"' : '').' />';
	echo '</td><td><label for="cp_add_favorites_link"> Add Control Panel link to Favorites dropdown (WordPress 2.7+ only)?</label>';
	echo '</td></tr>';

	echo '</tbody></table>';

	echo '<h4>SEO (Search Engine Optimization)</h4>';

	echo '<p>Clever keywords and a good site description (sometimes called "meta tags") are 2 ways you can help search engines find your blog. Beware, some plugins such as the All-In-One SEO Pack may override your entries.</p>';

	echo '<h6>Keywords</h6>';
	echo '<p>Enter some general terms, but it\'s a good idea to include descriptive keywords about you and your work. Enter a comma between keywords.</p>';
	echo '<input class="widefat" name="cp_meta_keywords" id="cp_meta_keywords" type="text" value="'.$this->options["meta_keywords"].'" /><br />';

	echo '<h6>Description</h6>';
	echo '<p>Enter a sentence or short paragraph about your blog. This is used in addition to your WordPress blog title and description. Be sure to use descriptive keywords.</p>';
	echo '<textarea class="widefat" name="cp_meta_desc" id="cp_meta_desc" rows="4" cols="30">'.$this->options["meta_desc"].'</textarea>';

	echo '<h4>Web Statistics Code</h4>';
	echo '<p>Web stats services such as Google Analytics require some JavaScript code to be added to your site. Paste the code below, and it will be inserted in the footer, just above the &lt;/body&gt; tag.</p>';

	echo '<textarea class="widefat" name="cp_stats_code" id="cp_stats_code" rows="8" cols="60">'.stripslashes($this->options["stats_code"]).'</textarea>';

	echo '</div><!-- inside -->';
	echo '</div><!-- otherdiv -->';

	echo '</div><!-- id="ppp_panel_body" -->';

	echo '</div><!-- id="wrap" -->';

	echo '</form>';

  }
}

?>